/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.SASLMechanismHandlerCfgDefn;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.admin.std.server.SASLMechanismHandlerCfg;
import org.opends.server.api.SASLMechanismHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SASLConfigManager
implements ConfigurationChangeListener<SASLMechanismHandlerCfg>,
ConfigurationAddListener<SASLMechanismHandlerCfg>,
ConfigurationDeleteListener<SASLMechanismHandlerCfg> {
    private ConcurrentHashMap<DN, SASLMechanismHandler> handlers = new ConcurrentHashMap();

    public void initializeSASLMechanismHandlers() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addSASLMechanismHandlerAddListener(this);
        rootConfiguration.addSASLMechanismHandlerDeleteListener(this);
        for (String handlerName : rootConfiguration.listSASLMechanismHandlers()) {
            SASLMechanismHandlerCfg handlerConfiguration = rootConfiguration.getSASLMechanismHandler(handlerName);
            handlerConfiguration.addChangeListener(this);
            if (!handlerConfiguration.isEnabled()) continue;
            String className = handlerConfiguration.getHandlerClass();
            try {
                SASLMechanismHandler handler = this.loadHandler(className, handlerConfiguration, true);
                this.handlers.put(handlerConfiguration.dn(), handler);
            }
            catch (InitializationException ie) {
                ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, ie.getMessage(), ie.getMessageID());
            }
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(SASLMechanismHandlerCfg configuration, List<String> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getHandlerClass();
            try {
                this.loadHandler(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessage());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(SASLMechanismHandlerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        configuration.addChangeListener(this);
        if (!configuration.isEnabled()) {
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        SASLMechanismHandler handler = null;
        String className = configuration.getHandlerClass();
        try {
            handler = this.loadHandler(className, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessage());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.handlers.put(configuration.dn(), handler);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(SASLMechanismHandlerCfg configuration, List<String> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(SASLMechanismHandlerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        SASLMechanismHandler handler = this.handlers.remove(configuration.dn());
        if (handler != null) {
            handler.finalizeSASLMechanismHandler();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(SASLMechanismHandlerCfg configuration, List<String> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getHandlerClass();
            try {
                this.loadHandler(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessage());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(SASLMechanismHandlerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        SASLMechanismHandler existingHandler = this.handlers.get(configuration.dn());
        if (!configuration.isEnabled()) {
            SASLMechanismHandler handler;
            if (existingHandler != null && (handler = this.handlers.remove(configuration.dn())) != null) {
                handler.finalizeSASLMechanismHandler();
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        String className = configuration.getHandlerClass();
        if (existingHandler != null) {
            if (!className.equals(existingHandler.getClass().getName())) {
                adminActionRequired = true;
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        SASLMechanismHandler handler = null;
        try {
            handler = this.loadHandler(className, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessage());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.handlers.put(configuration.dn(), handler);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private SASLMechanismHandler loadHandler(String className, SASLMechanismHandlerCfg configuration, boolean initialize) throws InitializationException {
        try {
            SASLMechanismHandlerCfgDefn definition = SASLMechanismHandlerCfgDefn.getInstance();
            ClassPropertyDefinition propertyDefinition = definition.getHandlerClassPropertyDefinition();
            Class<SASLMechanismHandler> handlerClass = propertyDefinition.loadClass(className, SASLMechanismHandler.class);
            SASLMechanismHandler handler = handlerClass.newInstance();
            if (initialize) {
                Method method = handler.getClass().getMethod("initializeSASLMechanismHandler", configuration.definition().getServerConfigurationClass());
                method.invoke((Object)handler, configuration);
            } else {
                Method method = handler.getClass().getMethod("isConfigurationAcceptable", SASLMechanismHandlerCfg.class, List.class);
                ArrayList unacceptableReasons = new ArrayList();
                Boolean acceptable = (Boolean)method.invoke((Object)handler, configuration, unacceptableReasons);
                if (!acceptable.booleanValue()) {
                    StringBuilder buffer = new StringBuilder();
                    if (!unacceptableReasons.isEmpty()) {
                        Iterator iterator = unacceptableReasons.iterator();
                        buffer.append((String)iterator.next());
                        while (iterator.hasNext()) {
                            buffer.append(".  ");
                            buffer.append((String)iterator.next());
                        }
                    }
                    int msgID = 3343029;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(configuration.dn()), buffer.toString());
                    throw new InitializationException(msgID, message);
                }
            }
            return handler;
        }
        catch (Exception e) {
            int msgID = 3342613;
            String message = MessageHandler.getMessage(msgID, className, String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(msgID, message, e);
        }
    }
}

