/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.RootDNCfgDefn;
import org.opends.server.admin.std.server.RootDNCfg;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootPrivilegeChangeListener
implements ConfigurationChangeListener<RootDNCfg> {
    private Set<Privilege> defaultRootPrivileges = Privilege.getDefaultRootPrivileges();

    @Override
    public boolean isConfigurationChangeAcceptable(RootDNCfg configuration, List<String> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(RootDNCfg configuration) {
        this.setDefaultRootPrivileges(configuration);
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    public Set<Privilege> getDefaultRootPrivileges() {
        return this.defaultRootPrivileges;
    }

    void setDefaultRootPrivileges(RootDNCfg configuration) {
        SortedSet<RootDNCfgDefn.DefaultRootPrivilegeName> configPrivSet = configuration.getDefaultRootPrivilegeName();
        HashSet<Privilege> privSet = new HashSet<Privilege>(configPrivSet.size());
        for (RootDNCfgDefn.DefaultRootPrivilegeName p : configPrivSet) {
            switch (p) {
                case BYPASS_ACL: {
                    privSet.add(Privilege.BYPASS_ACL);
                    break;
                }
                case MODIFY_ACL: {
                    privSet.add(Privilege.MODIFY_ACL);
                    break;
                }
                case CONFIG_READ: {
                    privSet.add(Privilege.CONFIG_READ);
                    break;
                }
                case CONFIG_WRITE: {
                    privSet.add(Privilege.CONFIG_WRITE);
                    break;
                }
                case JMX_READ: {
                    privSet.add(Privilege.JMX_READ);
                    break;
                }
                case JMX_WRITE: {
                    privSet.add(Privilege.JMX_WRITE);
                    break;
                }
                case JMX_NOTIFY: {
                    privSet.add(Privilege.JMX_NOTIFY);
                    break;
                }
                case LDIF_IMPORT: {
                    privSet.add(Privilege.LDIF_IMPORT);
                    break;
                }
                case LDIF_EXPORT: {
                    privSet.add(Privilege.LDIF_EXPORT);
                    break;
                }
                case BACKEND_BACKUP: {
                    privSet.add(Privilege.BACKEND_BACKUP);
                    break;
                }
                case BACKEND_RESTORE: {
                    privSet.add(Privilege.BACKEND_RESTORE);
                    break;
                }
                case SERVER_SHUTDOWN: {
                    privSet.add(Privilege.SERVER_SHUTDOWN);
                    break;
                }
                case SERVER_RESTART: {
                    privSet.add(Privilege.SERVER_RESTART);
                    break;
                }
                case PROXIED_AUTH: {
                    privSet.add(Privilege.PROXIED_AUTH);
                    break;
                }
                case DISCONNECT_CLIENT: {
                    privSet.add(Privilege.DISCONNECT_CLIENT);
                    break;
                }
                case CANCEL_REQUEST: {
                    privSet.add(Privilege.CANCEL_REQUEST);
                    break;
                }
                case PASSWORD_RESET: {
                    privSet.add(Privilege.PASSWORD_RESET);
                    break;
                }
                case DATA_SYNC: {
                    privSet.add(Privilege.DATA_SYNC);
                    break;
                }
                case UPDATE_SCHEMA: {
                    privSet.add(Privilege.UPDATE_SCHEMA);
                    break;
                }
                case PRIVILEGE_CHANGE: {
                    privSet.add(Privilege.PRIVILEGE_CHANGE);
                    break;
                }
                case UNINDEXED_SEARCH: {
                    privSet.add(Privilege.UNINDEXED_SEARCH);
                }
            }
        }
        this.defaultRootPrivileges = privSet;
    }
}

