/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.InputMismatchException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.SimpleSubtreeSpecification;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RFC3672SubtreeSpecification
extends SimpleSubtreeSpecification {
    private DN rootDN;
    private DN relativeBaseDN;
    private Refinement refinements;

    public static RFC3672SubtreeSpecification valueOf(DN rootDN, String s) throws DirectoryException {
        DN relativeBaseDN = null;
        int minimum = -1;
        int maximum = -1;
        HashSet<DN> chopBefore = new HashSet<DN>();
        HashSet<DN> chopAfter = new HashSet<DN>();
        Refinement refinement = null;
        SimpleSubtreeSpecification.Parser parser = new SimpleSubtreeSpecification.Parser(s);
        boolean isValid = true;
        try {
            block20: {
                parser.skipLeftBrace();
                boolean isFirst = true;
                while (true) {
                    if (parser.hasNextRightBrace()) {
                        parser.skipRightBrace();
                        if (parser.hasNext()) {
                            throw new InputMismatchException();
                        }
                        break block20;
                    }
                    if (!isFirst) {
                        parser.skipSeparator();
                    } else {
                        isFirst = false;
                    }
                    String key = parser.nextKey();
                    if (key.equals("base")) {
                        if (relativeBaseDN != null) {
                            throw new InputMismatchException();
                        }
                        relativeBaseDN = DN.decode(parser.nextStringValue());
                        continue;
                    }
                    if (key.equals("minimum")) {
                        if (minimum != -1) {
                            throw new InputMismatchException();
                        }
                        minimum = parser.nextInt();
                        continue;
                    }
                    if (key.equals("maximum")) {
                        if (maximum != -1) {
                            throw new InputMismatchException();
                        }
                        maximum = parser.nextInt();
                        continue;
                    }
                    if (key.equals("specificationfilter")) {
                        if (refinement != null) {
                            throw new InputMismatchException();
                        }
                        refinement = RFC3672SubtreeSpecification.parseRefinement(parser);
                        continue;
                    }
                    if (!key.equals("specificexclusions")) break;
                    if (!chopBefore.isEmpty() || !chopAfter.isEmpty()) {
                        throw new InputMismatchException();
                    }
                    parser.nextSpecificExclusions(chopBefore, chopAfter);
                }
                throw new InputMismatchException();
            }
            if (minimum < 0) {
                minimum = 0;
            }
            if (maximum >= 0 && maximum < minimum) {
                isValid = false;
            }
        }
        catch (InputMismatchException e) {
            isValid = false;
        }
        catch (NoSuchElementException e) {
            isValid = false;
        }
        if (isValid) {
            return new RFC3672SubtreeSpecification(rootDN, relativeBaseDN, minimum, maximum, chopBefore, chopAfter, refinement);
        }
        int msgID = 6488321;
        String message = MessageHandler.getMessage(msgID, s);
        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
    }

    private static Refinement parseRefinement(SimpleSubtreeSpecification.Parser parser) throws InputMismatchException, NoSuchElementException {
        String type = StaticUtils.toLowerCase(parser.nextName());
        parser.skipColon();
        if (type.equals("item")) {
            return new ItemRefinement(parser.nextName());
        }
        if (type.equals("not")) {
            Refinement refinement = RFC3672SubtreeSpecification.parseRefinement(parser);
            return new NotRefinement(refinement);
        }
        if (type.equals("and")) {
            ArrayList<Refinement> refinements = RFC3672SubtreeSpecification.parseRefinementSet(parser);
            return new AndRefinement(refinements);
        }
        if (type.equals("or")) {
            ArrayList<Refinement> refinements = RFC3672SubtreeSpecification.parseRefinementSet(parser);
            return new OrRefinement(refinements);
        }
        throw new InputMismatchException();
    }

    private static ArrayList<Refinement> parseRefinementSet(SimpleSubtreeSpecification.Parser parser) throws InputMismatchException, NoSuchElementException {
        ArrayList<Refinement> refinements = new ArrayList<Refinement>();
        parser.skipLeftBrace();
        boolean isFirstValue = true;
        while (true) {
            if (parser.hasNextRightBrace()) break;
            if (!isFirstValue) {
                parser.skipSeparator();
            } else {
                isFirstValue = false;
            }
            Refinement refinement = RFC3672SubtreeSpecification.parseRefinement(parser);
            refinements.add(refinement);
        }
        parser.skipRightBrace();
        return refinements;
    }

    public RFC3672SubtreeSpecification(DN rootDN, DN relativeBaseDN, int minimumDepth, int maximumDepth, Iterable<DN> chopBefore, Iterable<DN> chopAfter, Refinement refinements) {
        super(relativeBaseDN == null ? rootDN : rootDN.concat(relativeBaseDN), minimumDepth, maximumDepth, chopBefore, chopAfter);
        this.rootDN = rootDN;
        this.relativeBaseDN = relativeBaseDN;
        this.refinements = refinements;
    }

    public DN getRootDN() {
        return this.rootDN;
    }

    public DN getRelativeBaseDN() {
        return this.relativeBaseDN;
    }

    public Refinement getRefinements() {
        return this.refinements;
    }

    @Override
    public boolean isWithinScope(Entry entry) {
        if (this.isDNWithinScope(entry.getDN())) {
            if (this.refinements != null) {
                return this.refinements.matches(entry);
            }
            return true;
        }
        return false;
    }

    @Override
    public StringBuilder toString(StringBuilder builder) {
        boolean isFirstElement = true;
        builder.append("{");
        if (this.relativeBaseDN != null && !this.relativeBaseDN.isNullDN()) {
            builder.append(" base ");
            StaticUtils.toRFC3641StringValue(builder, this.relativeBaseDN.toString());
            isFirstElement = false;
        }
        Iterable<DN> chopBefore = this.getChopBefore();
        Iterable<DN> chopAfter = this.getChopAfter();
        if (chopBefore != null && chopBefore.iterator().hasNext() || chopAfter != null && chopAfter.iterator().hasNext()) {
            if (!isFirstElement) {
                builder.append(",");
            } else {
                isFirstElement = false;
            }
            builder.append(" specificExclusions { ");
            boolean isFirst = true;
            if (chopBefore != null) {
                for (DN dn : chopBefore) {
                    if (!isFirst) {
                        builder.append(", chopBefore:");
                    } else {
                        builder.append("chopBefore:");
                        isFirst = false;
                    }
                    StaticUtils.toRFC3641StringValue(builder, dn.toString());
                }
            }
            if (chopAfter != null) {
                for (DN dn : chopAfter) {
                    if (!isFirst) {
                        builder.append(", chopAfter:");
                    } else {
                        builder.append("chopAfter:");
                        isFirst = false;
                    }
                    StaticUtils.toRFC3641StringValue(builder, dn.toString());
                }
            }
            builder.append(" }");
        }
        if (this.getMinimumDepth() > 0) {
            if (!isFirstElement) {
                builder.append(",");
            } else {
                isFirstElement = false;
            }
            builder.append(" minimum ");
            builder.append(this.getMinimumDepth());
        }
        if (this.getMaximumDepth() >= 0) {
            if (!isFirstElement) {
                builder.append(",");
            } else {
                isFirstElement = false;
            }
            builder.append(" maximum ");
            builder.append(this.getMaximumDepth());
        }
        if (this.refinements != null) {
            if (!isFirstElement) {
                builder.append(",");
            } else {
                isFirstElement = false;
            }
            builder.append(" specificationFilter ");
            this.refinements.toString(builder);
        }
        builder.append(" }");
        return builder;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RFC3672SubtreeSpecification) {
            RFC3672SubtreeSpecification other = (RFC3672SubtreeSpecification)obj;
            if (!this.commonComponentsEquals(other)) {
                return false;
            }
            if (!this.getBaseDN().equals(other.getBaseDN())) {
                return false;
            }
            if (this.refinements != null) {
                return this.refinements.equals(other.refinements);
            }
            return this.refinements == other.refinements;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = this.commonComponentsHashCode();
        hash = hash * 31 + this.getBaseDN().hashCode();
        if (this.refinements != null) {
            hash = hash * 31 + this.refinements.hashCode();
        }
        return hash;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OrRefinement
    extends Refinement {
        private Collection<Refinement> refinementSet;

        public OrRefinement(Collection<Refinement> refinementSet) {
            this.refinementSet = refinementSet;
        }

        @Override
        public boolean matches(Entry entry) {
            for (Refinement refinement : this.refinementSet) {
                if (!refinement.matches(entry)) continue;
                return true;
            }
            return false;
        }

        @Override
        public StringBuilder toString(StringBuilder builder) {
            switch (this.refinementSet.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.refinementSet.iterator().next().toString(builder);
                    break;
                }
                default: {
                    builder.append("or:{");
                    Iterator<Refinement> iterator = this.refinementSet.iterator();
                    iterator.next().toString(builder);
                    while (iterator.hasNext()) {
                        builder.append(", ");
                        iterator.next().toString(builder);
                    }
                    builder.append("}");
                }
            }
            return builder;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof AndRefinement) {
                AndRefinement other = (AndRefinement)obj;
                return ((Object)this.refinementSet).equals(other.refinementSet);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return ((Object)this.refinementSet).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AndRefinement
    extends Refinement {
        private Collection<Refinement> refinementSet;

        public AndRefinement(Collection<Refinement> refinementSet) {
            this.refinementSet = refinementSet;
        }

        @Override
        public boolean matches(Entry entry) {
            for (Refinement refinement : this.refinementSet) {
                if (refinement.matches(entry)) continue;
                return false;
            }
            return true;
        }

        @Override
        public StringBuilder toString(StringBuilder builder) {
            switch (this.refinementSet.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.refinementSet.iterator().next().toString(builder);
                    break;
                }
                default: {
                    builder.append("and:{");
                    Iterator<Refinement> iterator = this.refinementSet.iterator();
                    iterator.next().toString(builder);
                    while (iterator.hasNext()) {
                        builder.append(", ");
                        iterator.next().toString(builder);
                    }
                    builder.append("}");
                }
            }
            return builder;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof AndRefinement) {
                AndRefinement other = (AndRefinement)obj;
                return ((Object)this.refinementSet).equals(other.refinementSet);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return ((Object)this.refinementSet).hashCode();
        }
    }

    public static final class NotRefinement
    extends Refinement {
        private Refinement refinement;

        public NotRefinement(Refinement refinement) {
            this.refinement = refinement;
        }

        public boolean matches(Entry entry) {
            return !this.refinement.matches(entry);
        }

        public StringBuilder toString(StringBuilder builder) {
            builder.append("not:");
            return this.refinement.toString(builder);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof NotRefinement) {
                NotRefinement other = (NotRefinement)obj;
                return this.refinement.equals(other.refinement);
            }
            return false;
        }

        public int hashCode() {
            return this.refinement.hashCode();
        }
    }

    public static final class ItemRefinement
    extends Refinement {
        private String objectClass;
        private String normalizedObjectClass;

        public ItemRefinement(String objectClass) {
            this.objectClass = objectClass;
            this.normalizedObjectClass = StaticUtils.toLowerCase(objectClass.trim());
        }

        public boolean matches(Entry entry) {
            ObjectClass oc = DirectoryServer.getObjectClass(this.normalizedObjectClass);
            if (oc == null) {
                return false;
            }
            return entry.hasObjectClass(oc);
        }

        public StringBuilder toString(StringBuilder builder) {
            builder.append("item:");
            builder.append(this.objectClass);
            return builder;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ItemRefinement) {
                ItemRefinement other = (ItemRefinement)obj;
                return this.normalizedObjectClass.equals(other.normalizedObjectClass);
            }
            return false;
        }

        public int hashCode() {
            return this.normalizedObjectClass.hashCode();
        }
    }

    public static abstract class Refinement {
        protected Refinement() {
        }

        public abstract boolean matches(Entry var1);

        public final String toString() {
            StringBuilder builder = new StringBuilder();
            return this.toString(builder).toString();
        }

        public abstract StringBuilder toString(StringBuilder var1);

        public abstract boolean equals(Object var1);

        public abstract int hashCode();
    }
}

