/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.PasswordValidatorCfgDefn;
import org.opends.server.admin.std.server.PasswordValidatorCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.PasswordValidator;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordValidatorConfigManager
implements ConfigurationChangeListener<PasswordValidatorCfg>,
ConfigurationAddListener<PasswordValidatorCfg>,
ConfigurationDeleteListener<PasswordValidatorCfg> {
    private ConcurrentHashMap<DN, PasswordValidator> passwordValidators = new ConcurrentHashMap();

    public void initializePasswordValidators() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addPasswordValidatorAddListener(this);
        rootConfiguration.addPasswordValidatorDeleteListener(this);
        for (String validatorName : rootConfiguration.listPasswordValidators()) {
            PasswordValidatorCfg validatorConfiguration = rootConfiguration.getPasswordValidator(validatorName);
            validatorConfiguration.addChangeListener(this);
            if (!validatorConfiguration.isEnabled()) continue;
            String className = validatorConfiguration.getValidatorClass();
            try {
                PasswordValidator<? extends PasswordValidatorCfg> validator = this.loadValidator(className, validatorConfiguration, true);
                this.passwordValidators.put(validatorConfiguration.dn(), validator);
                DirectoryServer.registerPasswordValidator(validatorConfiguration.dn(), validator);
            }
            catch (InitializationException ie) {
                ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, ie.getMessage(), ie.getMessageID());
            }
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(PasswordValidatorCfg configuration, List<String> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getValidatorClass();
            try {
                this.loadValidator(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessage());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(PasswordValidatorCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        configuration.addChangeListener(this);
        if (!configuration.isEnabled()) {
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        PasswordValidator<? extends PasswordValidatorCfg> passwordValidator = null;
        String className = configuration.getValidatorClass();
        try {
            passwordValidator = this.loadValidator(className, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessage());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.passwordValidators.put(configuration.dn(), passwordValidator);
            DirectoryServer.registerPasswordValidator(configuration.dn(), passwordValidator);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(PasswordValidatorCfg configuration, List<String> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(PasswordValidatorCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        DirectoryServer.deregisterPasswordValidator(configuration.dn());
        PasswordValidator passwordValidator = this.passwordValidators.remove(configuration.dn());
        if (passwordValidator != null) {
            passwordValidator.finalizePasswordValidator();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(PasswordValidatorCfg configuration, List<String> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getValidatorClass();
            try {
                this.loadValidator(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessage());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(PasswordValidatorCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        PasswordValidator existingValidator = this.passwordValidators.get(configuration.dn());
        if (!configuration.isEnabled()) {
            if (existingValidator != null) {
                DirectoryServer.deregisterPasswordValidator(configuration.dn());
                PasswordValidator passwordValidator = this.passwordValidators.remove(configuration.dn());
                if (passwordValidator != null) {
                    passwordValidator.finalizePasswordValidator();
                }
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        String className = configuration.getValidatorClass();
        if (existingValidator != null) {
            if (!className.equals(existingValidator.getClass().getName())) {
                adminActionRequired = true;
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        PasswordValidator<? extends PasswordValidatorCfg> passwordValidator = null;
        try {
            passwordValidator = this.loadValidator(className, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessage());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.passwordValidators.put(configuration.dn(), passwordValidator);
            DirectoryServer.registerPasswordValidator(configuration.dn(), passwordValidator);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private PasswordValidator<? extends PasswordValidatorCfg> loadValidator(String className, PasswordValidatorCfg configuration, boolean initialize) throws InitializationException {
        try {
            PasswordValidatorCfgDefn definition = PasswordValidatorCfgDefn.getInstance();
            ClassPropertyDefinition propertyDefinition = definition.getValidatorClassPropertyDefinition();
            Class<PasswordValidator> validatorClass = propertyDefinition.loadClass(className, PasswordValidator.class);
            PasswordValidator validator = validatorClass.newInstance();
            if (initialize) {
                Method method = validator.getClass().getMethod("initializePasswordValidator", configuration.definition().getServerConfigurationClass());
                method.invoke((Object)validator, configuration);
            } else {
                Method method = validator.getClass().getMethod("isConfigurationAcceptable", PasswordValidatorCfg.class, List.class);
                ArrayList unacceptableReasons = new ArrayList();
                Boolean acceptable = (Boolean)method.invoke((Object)validator, configuration, unacceptableReasons);
                if (!acceptable.booleanValue()) {
                    StringBuilder buffer = new StringBuilder();
                    if (!unacceptableReasons.isEmpty()) {
                        Iterator iterator = unacceptableReasons.iterator();
                        buffer.append((String)iterator.next());
                        while (iterator.hasNext()) {
                            buffer.append(".  ");
                            buffer.append((String)iterator.next());
                        }
                    }
                    int msgID = 3343027;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(configuration.dn()), buffer.toString());
                    throw new InitializationException(msgID, message);
                }
            }
            return validator;
        }
        catch (Exception e) {
            int msgID = 3342825;
            String message = MessageHandler.getMessage(msgID, className, String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(msgID, message, e);
        }
    }
}

