/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.List;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.server.PasswordPolicyCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordPolicy;
import org.opends.server.core.PasswordPolicyConfig;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordPolicyConfigManager
implements ConfigurationAddListener<PasswordPolicyCfg>,
ConfigurationDeleteListener<PasswordPolicyCfg> {
    public void initializePasswordPolicies() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addPasswordPolicyAddListener(this);
        rootConfiguration.addPasswordPolicyDeleteListener(this);
        String[] passwordPoliciesName = rootConfiguration.listPasswordPolicies();
        if (passwordPoliciesName.length == 0) {
            int msgID = 3408386;
            String message = MessageHandler.getMessage(msgID);
            throw new ConfigException(msgID, message);
        }
        if (null == DirectoryServer.getDefaultPasswordPolicyDN()) {
            int msgID = 3408443;
            String message = MessageHandler.getMessage(msgID);
            throw new ConfigException(msgID, message);
        }
        for (String passwordPolicyName : passwordPoliciesName) {
            PasswordPolicyCfg passwordPolicyConfiguration = rootConfiguration.getPasswordPolicy(passwordPolicyName);
            try {
                PasswordPolicy policy = new PasswordPolicy(passwordPolicyConfiguration);
                PasswordPolicyConfig config = new PasswordPolicyConfig(policy);
                DirectoryServer.registerPasswordPolicy(passwordPolicyConfiguration.dn(), config);
                passwordPolicyConfiguration.addChangeListener(config);
            }
            catch (ConfigException ce) {
                int msgID = 3408387;
                String message = MessageHandler.getMessage(msgID, String.valueOf(passwordPolicyConfiguration.dn()), ce.getMessage());
                throw new ConfigException(msgID, message, ce);
            }
            catch (InitializationException ie) {
                int msgID = 3408387;
                String message = MessageHandler.getMessage(msgID, String.valueOf(passwordPolicyConfiguration.dn()), ie.getMessage());
                throw new InitializationException(msgID, message, ie);
            }
            catch (Exception e) {
                int msgID = 3408387;
                String message = MessageHandler.getMessage(msgID, String.valueOf(passwordPolicyConfiguration.dn()), StaticUtils.stackTraceToSingleLineString(e));
                throw new InitializationException(msgID, message, e);
            }
        }
        if (null == DirectoryServer.getDefaultPasswordPolicy()) {
            int msgID = 3408388;
            DN defaultPolicyDN = DirectoryServer.getDefaultPasswordPolicyDN();
            String message = MessageHandler.getMessage(msgID, String.valueOf(defaultPolicyDN));
            throw new ConfigException(msgID, message);
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(PasswordPolicyCfg configuration, List<String> unacceptableReason) {
        try {
            new PasswordPolicy(configuration);
        }
        catch (ConfigException ce) {
            int msgID = 3408387;
            String message = MessageHandler.getMessage(msgID, String.valueOf(configuration.dn()), ce.getMessage());
            unacceptableReason.add(message);
            return false;
        }
        catch (InitializationException ie) {
            int msgID = 3408387;
            String message = MessageHandler.getMessage(msgID, String.valueOf(configuration.dn()), ie.getMessage());
            unacceptableReason.add(message);
            return false;
        }
        catch (Exception e) {
            int msgID = 3408387;
            String message = MessageHandler.getMessage(msgID, String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            unacceptableReason.add(message);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(PasswordPolicyCfg configuration) {
        DN configEntryDN = configuration.dn();
        ArrayList<String> messages = new ArrayList<String>();
        try {
            PasswordPolicy policy = new PasswordPolicy(configuration);
            PasswordPolicyConfig config = new PasswordPolicyConfig(policy);
            DirectoryServer.registerPasswordPolicy(configEntryDN, config);
            configuration.addChangeListener(config);
            return new ConfigChangeResult(ResultCode.SUCCESS, false, messages);
        }
        catch (ConfigException ce) {
            int msgID = 3408387;
            messages.add(MessageHandler.getMessage(msgID, String.valueOf(configuration.dn()), ce.getMessage()));
            return new ConfigChangeResult(ResultCode.CONSTRAINT_VIOLATION, false, messages);
        }
        catch (InitializationException ie) {
            int msgID = 3408387;
            messages.add(MessageHandler.getMessage(msgID, String.valueOf(configuration.dn()), ie.getMessage()));
            return new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), false, messages);
        }
        catch (Exception e) {
            int msgID = 3408387;
            messages.add(MessageHandler.getMessage(msgID, String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e)));
            return new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), false, messages);
        }
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(PasswordPolicyCfg configuration, List<String> unacceptableReason) {
        DN defaultPolicyDN = DirectoryServer.getDefaultPasswordPolicyDN();
        if (defaultPolicyDN != null && defaultPolicyDN.equals(configuration.dn())) {
            int msgID = 3277317;
            String message = MessageHandler.getMessage(msgID, String.valueOf(defaultPolicyDN));
            unacceptableReason.add(message);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(PasswordPolicyCfg configuration) {
        ArrayList<String> messages = new ArrayList<String>(1);
        DN policyDN = configuration.dn();
        DN defaultPolicyDN = DirectoryServer.getDefaultPasswordPolicyDN();
        if (defaultPolicyDN != null && defaultPolicyDN.equals(policyDN)) {
            int msgID = 3277317;
            messages.add(MessageHandler.getMessage(msgID, String.valueOf(defaultPolicyDN)));
            return new ConfigChangeResult(ResultCode.CONSTRAINT_VIOLATION, false, messages);
        }
        DirectoryServer.deregisterPasswordPolicy(policyDN);
        PasswordPolicyConfig config = DirectoryServer.getPasswordPolicyConfig(policyDN);
        if (config != null) {
            configuration.removeChangeListener(config);
        }
        int msgID = 3146246;
        messages.add(MessageHandler.getMessage(msgID, String.valueOf(policyDN)));
        return new ConfigChangeResult(ResultCode.SUCCESS, false, messages);
    }
}

