/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.Iterator;
import org.opends.server.core.NetworkGroupNamingContexts;
import org.opends.server.core.RootDseWorkflowTopology;
import org.opends.server.core.Workflow;
import org.opends.server.core.WorkflowImpl;
import org.opends.server.core.WorkflowTopology;
import org.opends.server.core.WorkflowTopologyNode;
import org.opends.server.types.DN;
import org.opends.server.workflowelement.WorkflowElement;

public class NetworkGroup {
    private ArrayList<WorkflowTopologyNode> registeredWorkflows = new ArrayList();
    private RootDseWorkflowTopology rootDSEWorkflow = null;
    private NetworkGroupNamingContexts namingContexts = new NetworkGroupNamingContexts();
    private static NetworkGroup defaultNetworkGroup = new NetworkGroup("default");
    private static ArrayList<NetworkGroup> networkGroupPool = new ArrayList();
    private String networkGroupName = null;

    public NetworkGroup(String networkGroupName) {
        this.networkGroupName = networkGroupName;
    }

    public static void registerNetworkGroup(NetworkGroup networkGroup) {
        networkGroupPool.add(networkGroup);
    }

    public void registerWorkflow(WorkflowImpl workflow) {
        this.registerWorkflow(workflow, null, null);
    }

    private void registerWorkflow(WorkflowImpl workflow, WorkflowElement[] preWorkflowElements, WorkflowElement[] postWorkflowElements) {
        boolean registered = false;
        DN baseDN = workflow.getBaseDN();
        if (baseDN.isNullDN()) {
            this.rootDSEWorkflow = new RootDseWorkflowTopology(workflow, this.namingContexts);
            registered = true;
        } else if (!this.baseDNAlreadyRegistered(baseDN)) {
            WorkflowTopologyNode workflowTopology = new WorkflowTopologyNode(workflow, preWorkflowElements, postWorkflowElements);
            for (WorkflowTopologyNode curWorkflow : this.registeredWorkflows) {
                if (curWorkflow.insertSubordinate(workflowTopology) || workflowTopology.insertSubordinate(curWorkflow)) break;
            }
            this.registeredWorkflows.add(workflowTopology);
            registered = true;
            this.rebuildNamingContextList();
        }
        if (registered && this != defaultNetworkGroup) {
            defaultNetworkGroup.registerWorkflow(workflow, preWorkflowElements, postWorkflowElements);
        }
    }

    public void deregisterWorkflow(DN baseDN) {
        Workflow workflow = this.getWorkflowCandidate(baseDN);
        if (workflow != null) {
            this.deregisterWorkflow(workflow);
        }
    }

    private void deregisterWorkflow(Workflow workflow) {
        boolean deregistered = false;
        if (workflow == this.rootDSEWorkflow) {
            this.rootDSEWorkflow = null;
            deregistered = true;
        } else {
            WorkflowTopologyNode workflowTopology = (WorkflowTopologyNode)workflow;
            workflowTopology.remove();
            this.registeredWorkflows.remove(workflow);
            deregistered = true;
            this.rebuildNamingContextList();
        }
        if (deregistered && this != defaultNetworkGroup) {
            defaultNetworkGroup.deregisterWorkflow(workflow);
        }
    }

    public Workflow getWorkflowCandidate(DN baseDN) {
        WorkflowTopology workflowCandidate = null;
        if (baseDN.isNullDN()) {
            workflowCandidate = this.rootDSEWorkflow;
        } else {
            WorkflowTopologyNode curWorkflow;
            Iterator<WorkflowTopologyNode> i$ = this.namingContexts.getNamingContexts().iterator();
            while (i$.hasNext() && (workflowCandidate = (curWorkflow = i$.next()).getWorkflowCandidate(baseDN)) == null) {
            }
        }
        return workflowCandidate;
    }

    public static NetworkGroup getDefaultNetworkGroup() {
        return defaultNetworkGroup;
    }

    private void rebuildNamingContextList() {
        this.namingContexts.resetLists();
        for (WorkflowTopologyNode curWorkflow : this.registeredWorkflows) {
            WorkflowTopologyNode parent = curWorkflow.getParent();
            if (parent != null) continue;
            this.namingContexts.addNamingContext(curWorkflow);
        }
    }

    private boolean baseDNAlreadyRegistered(DN baseDN) {
        boolean alreadyRegistered = false;
        for (WorkflowTopologyNode curWorkflow : this.registeredWorkflows) {
            DN curDN = curWorkflow.getBaseDN();
            if (!baseDN.equals(curDN)) continue;
            alreadyRegistered = true;
            break;
        }
        return alreadyRegistered;
    }

    public NetworkGroupNamingContexts getNamingContexts() {
        return this.namingContexts;
    }

    public StringBuffer toString(String leftMargin) {
        StringBuffer sb = new StringBuffer();
        String newMargin = leftMargin + "   ";
        sb.append(leftMargin + "Networkgroup (" + this.networkGroupName + "\n");
        sb.append(leftMargin + "List of registered workflows:\n");
        for (WorkflowTopologyNode w : this.registeredWorkflows) {
            sb.append(w.toString(newMargin));
        }
        this.namingContexts.toString(leftMargin);
        sb.append(leftMargin + "rootDSEWorkflow:\n");
        if (this.rootDSEWorkflow == null) {
            sb.append(newMargin + "null\n");
        } else {
            sb.append(this.rootDSEWorkflow.toString(newMargin));
        }
        return sb;
    }
}

