/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ExtendedOperationHandler;
import org.opends.server.api.plugin.PostOperationPluginResult;
import org.opends.server.api.plugin.PreOperationPluginResult;
import org.opends.server.api.plugin.PreParsePluginResult;
import org.opends.server.core.AccessControlConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.loggers.AccessLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.OperationType;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PostOperationExtendedOperation;
import org.opends.server.types.operation.PostResponseExtendedOperation;
import org.opends.server.types.operation.PreOperationExtendedOperation;
import org.opends.server.types.operation.PreParseExtendedOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedOperationBasis
extends AbstractOperation
implements ExtendedOperation,
PreParseExtendedOperation,
PreOperationExtendedOperation,
PostOperationExtendedOperation,
PostResponseExtendedOperation {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ASN1OctetString requestValue;
    private ASN1OctetString responseValue;
    private boolean responseSent;
    private CancelRequest cancelRequest;
    private List<Control> responseControls;
    private String requestOID;
    private String responseOID;

    public ExtendedOperationBasis(ClientConnection clientConnection, long operationID, int messageID, List<Control> requestControls, String requestOID, ASN1OctetString requestValue) {
        super(clientConnection, operationID, messageID, requestControls);
        this.requestOID = requestOID;
        this.requestValue = requestValue;
        this.responseOID = null;
        this.responseValue = null;
        this.responseControls = new ArrayList<Control>();
        this.cancelRequest = null;
        this.responseSent = false;
    }

    @Override
    public final String getRequestOID() {
        return this.requestOID;
    }

    @Override
    public final void setRequestOID(String requestOID) {
        this.requestOID = requestOID;
    }

    @Override
    public final ASN1OctetString getRequestValue() {
        return this.requestValue;
    }

    @Override
    public final void setRequestValue(ASN1OctetString requestValue) {
        this.requestValue = requestValue;
    }

    @Override
    public final String getResponseOID() {
        return this.responseOID;
    }

    @Override
    public final void setResponseOID(String responseOID) {
        this.responseOID = responseOID;
    }

    @Override
    public final ASN1OctetString getResponseValue() {
        return this.responseValue;
    }

    @Override
    public final void setResponseValue(ASN1OctetString responseValue) {
        this.responseValue = responseValue;
    }

    @Override
    public final OperationType getOperationType() {
        return OperationType.EXTENDED;
    }

    @Override
    public final void disconnectClient(DisconnectReason disconnectReason, boolean sendNotification, String message, int messageID) {
        this.setCancelResult(CancelResult.CANCELED);
        this.clientConnection.disconnect(disconnectReason, sendNotification, message, messageID);
    }

    @Override
    public final String[][] getRequestLogElements() {
        return new String[][]{{"requestOID", this.requestOID}};
    }

    @Override
    public final String[][] getResponseLogElements() {
        String referrals;
        String resultCode = String.valueOf(this.getResultCode().getIntValue());
        StringBuilder errorMessageBuffer = this.getErrorMessage();
        String errorMessage = errorMessageBuffer == null ? null : errorMessageBuffer.toString();
        DN matchedDN = this.getMatchedDN();
        String matchedDNStr = matchedDN == null ? null : matchedDN.toString();
        List<String> referralURLs = this.getReferralURLs();
        if (referralURLs == null || referralURLs.isEmpty()) {
            referrals = null;
        } else {
            StringBuilder buffer = new StringBuilder();
            Iterator<String> iterator = referralURLs.iterator();
            buffer.append(iterator.next());
            while (iterator.hasNext()) {
                buffer.append(", ");
                buffer.append(iterator.next());
            }
            referrals = buffer.toString();
        }
        String processingTime = String.valueOf(this.getProcessingTime());
        return new String[][]{{"resultCode", resultCode}, {"errorMessage", errorMessage}, {"matchedDN", matchedDNStr}, {"referralURLs", referrals}, {"responseOID", this.responseOID}, {"processingTime", processingTime}};
    }

    @Override
    public final List<Control> getResponseControls() {
        return this.responseControls;
    }

    @Override
    public final void addResponseControl(Control control) {
        this.responseControls.add(control);
    }

    @Override
    public final void removeResponseControl(Control control) {
        this.responseControls.remove(control);
    }

    @Override
    public final void run() {
        PostOperationPluginResult postOpResult;
        this.setResultCode(ResultCode.UNDEFINED);
        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
        boolean skipPostOperation = false;
        this.setProcessingStartTime();
        if (this.cancelRequest != null && !this.requestOID.equals("1.3.6.1.1.8") && !this.requestOID.equals("1.3.6.1.4.1.1466.20037")) {
            this.indicateCancelled(this.cancelRequest);
            this.setProcessingStopTime();
            return;
        }
        PreParsePluginResult preParseResult = pluginConfigManager.invokePreParseExtendedPlugins(this);
        if (preParseResult.connectionTerminated()) {
            this.setResultCode(ResultCode.CANCELED);
            int msgID = 262368;
            this.appendErrorMessage(MessageHandler.getMessage(msgID));
            this.setProcessingStopTime();
            AccessLogger.logExtendedRequest(this);
            AccessLogger.logExtendedResponse(this);
            pluginConfigManager.invokePostResponseExtendedPlugins(this);
            return;
        }
        if (preParseResult.sendResponseImmediately()) {
            skipPostOperation = true;
            AccessLogger.logExtendedRequest(this);
        } else if (preParseResult.skipCoreProcessing()) {
            skipPostOperation = false;
        } else {
            AccessLogger.logExtendedRequest(this);
            if (this.cancelRequest != null && !this.requestOID.equals("1.3.6.1.1.8") && !this.requestOID.equals("1.3.6.1.4.1.1466.20037")) {
                this.indicateCancelled(this.cancelRequest);
                this.setProcessingStopTime();
                pluginConfigManager.invokePostResponseExtendedPlugins(this);
                return;
            }
            ExtendedOperationHandler handler = DirectoryServer.getExtendedOperationHandler(this.requestOID);
            if (handler == null) {
                this.setResultCode(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION);
                this.appendErrorMessage(MessageHandler.getMessage(196876, String.valueOf(this.requestOID)));
            } else {
                List<Control> requestControls = this.getRequestControls();
                if (requestControls != null && !requestControls.isEmpty()) {
                    for (Control c : requestControls) {
                        if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(this.getAuthorizationDN(), this, c)) {
                            this.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
                            int msgID = 262755;
                            this.appendErrorMessage(MessageHandler.getMessage(msgID, c.getOID()));
                            skipPostOperation = true;
                        } else {
                            if (!c.isCritical() || handler.supportsControl(c.getOID())) continue;
                            this.setResultCode(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION);
                            int msgID = 197178;
                            this.appendErrorMessage(MessageHandler.getMessage(msgID, String.valueOf(this.requestOID), c.getOID()));
                        }
                        break;
                    }
                } else if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(this)) {
                    this.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
                    int msgID = 262656;
                    this.appendErrorMessage(MessageHandler.getMessage(msgID, String.valueOf(this.requestOID)));
                    skipPostOperation = true;
                } else {
                    PreOperationPluginResult preOpResult = pluginConfigManager.invokePreOperationExtendedPlugins(this);
                    if (preOpResult.connectionTerminated()) {
                        this.setResultCode(ResultCode.CANCELED);
                        int msgID = 262369;
                        this.appendErrorMessage(MessageHandler.getMessage(msgID));
                        this.setProcessingStopTime();
                        AccessLogger.logExtendedResponse(this);
                        pluginConfigManager.invokePostResponseExtendedPlugins(this);
                        return;
                    }
                    if (preOpResult.sendResponseImmediately()) {
                        skipPostOperation = true;
                    } else if (preOpResult.skipCoreProcessing()) {
                        skipPostOperation = false;
                    } else {
                        if (this.cancelRequest != null && !this.requestOID.equals("1.3.6.1.1.8") && !this.requestOID.equals("1.3.6.1.4.1.1466.20037")) {
                            this.indicateCancelled(this.cancelRequest);
                            this.setProcessingStopTime();
                            pluginConfigManager.invokePostResponseExtendedPlugins(this);
                            return;
                        }
                        handler.processExtendedOperation(this);
                    }
                }
            }
        }
        this.setCancelResult(CancelResult.TOO_LATE);
        if (!skipPostOperation && (postOpResult = pluginConfigManager.invokePostOperationExtendedPlugins(this)).connectionTerminated()) {
            this.setResultCode(ResultCode.CANCELED);
            int msgID = 262369;
            this.appendErrorMessage(MessageHandler.getMessage(msgID));
            this.setProcessingStopTime();
            AccessLogger.logExtendedResponse(this);
            pluginConfigManager.invokePostResponseExtendedPlugins(this);
            return;
        }
        this.setProcessingStopTime();
        if (!this.responseSent) {
            this.responseSent = true;
            this.clientConnection.sendResponse(this);
        }
        AccessLogger.logExtendedResponse(this);
        pluginConfigManager.invokePostResponseExtendedPlugins(this);
    }

    public final void sendExtendedResponse() {
        if (!this.responseSent) {
            this.responseSent = true;
            this.clientConnection.sendResponse(this);
        }
    }

    @Override
    public final void setResponseSent() {
        this.responseSent = true;
    }

    @Override
    public final CancelResult cancel(CancelRequest cancelRequest) {
        this.cancelRequest = cancelRequest;
        CancelResult cancelResult = this.getCancelResult();
        long stopWaitingTime = System.currentTimeMillis() + 5000L;
        while (cancelResult == null && System.currentTimeMillis() < stopWaitingTime) {
            block4: {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block4;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            cancelResult = this.getCancelResult();
        }
        if (cancelResult == null) {
            cancelResult = CancelResult.CANNOT_CANCEL;
        }
        return cancelResult;
    }

    @Override
    public final CancelRequest getCancelRequest() {
        return this.cancelRequest;
    }

    @Override
    public boolean setCancelRequest(CancelRequest cancelRequest) {
        this.cancelRequest = cancelRequest;
        return true;
    }

    @Override
    public final void toString(StringBuilder buffer) {
        buffer.append("ExtendedOperation(connID=");
        buffer.append(this.clientConnection.getConnectionID());
        buffer.append(", opID=");
        buffer.append(this.operationID);
        buffer.append(", oid=");
        buffer.append(this.requestOID);
        buffer.append(")");
    }
}

