/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.SortedSet;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.GlobalCfgDefn;
import org.opends.server.admin.std.server.GlobalCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.IdentityMapper;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordPolicy;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AcceptRejectWarn;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;
import org.opends.server.types.WritabilityMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreConfigManager
implements ConfigurationChangeListener<GlobalCfg> {
    public void initializeCoreConfig() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        GlobalCfg globalConfig = rootConfiguration.getGlobalConfiguration();
        globalConfig.addChangeListener(this);
        SortedSet<String> smtpServers = globalConfig.getSMTPServer();
        if (smtpServers != null) {
            for (String server : smtpServers) {
                int colonPos = server.indexOf(58);
                if (colonPos == 0 || colonPos == server.length() - 1) {
                    int msgID = 3408569;
                    String message = MessageHandler.getMessage(msgID, server);
                    throw new ConfigException(msgID, message);
                }
                if (colonPos <= 0) continue;
                try {
                    int port = Integer.parseInt(server.substring(colonPos + 1));
                    if (port >= 1 && port <= 65535) continue;
                    int msgID = 3408569;
                    String message = MessageHandler.getMessage(msgID, server);
                    throw new ConfigException(msgID, message);
                }
                catch (Exception e) {
                    int msgID = 3408569;
                    String message = MessageHandler.getMessage(msgID, server);
                    throw new ConfigException(msgID, message, e);
                }
            }
        }
        CoreConfigManager.applyGlobalConfiguration(globalConfig);
    }

    private static void applyGlobalConfiguration(GlobalCfg globalConfig) {
        DirectoryServer.setCheckSchema(globalConfig.isCheckSchema());
        DirectoryServer.setDefaultPasswordPolicyDN(globalConfig.getDefaultPasswordPolicy());
        DirectoryServer.setAddMissingRDNAttributes(globalConfig.isAddMissingRDNAttributes());
        DirectoryServer.setAllowAttributeNameExceptions(globalConfig.isAllowAttributeNameExceptions());
        switch (globalConfig.getInvalidAttributeSyntaxBehavior()) {
            case ACCEPT: {
                DirectoryServer.setSyntaxEnforcementPolicy(AcceptRejectWarn.ACCEPT);
                break;
            }
            case WARN: {
                DirectoryServer.setSyntaxEnforcementPolicy(AcceptRejectWarn.WARN);
                break;
            }
            default: {
                DirectoryServer.setSyntaxEnforcementPolicy(AcceptRejectWarn.REJECT);
            }
        }
        DirectoryServer.setServerErrorResultCode(ResultCode.valueOf(globalConfig.getServerErrorResultCode()));
        switch (globalConfig.getSingleStructuralObjectclassBehavior()) {
            case ACCEPT: {
                DirectoryServer.setSingleStructuralObjectClassPolicy(AcceptRejectWarn.ACCEPT);
                break;
            }
            case WARN: {
                DirectoryServer.setSingleStructuralObjectClassPolicy(AcceptRejectWarn.WARN);
                break;
            }
            default: {
                DirectoryServer.setSingleStructuralObjectClassPolicy(AcceptRejectWarn.REJECT);
            }
        }
        DirectoryServer.setNotifyAbandonedOperations(globalConfig.isNotifyAbandonedOperations());
        DirectoryServer.setSizeLimit(globalConfig.getSizeLimit());
        DirectoryServer.setTimeLimit((int)globalConfig.getTimeLimit());
        DirectoryServer.setProxiedAuthorizationIdentityMapperDN(globalConfig.getProxiedAuthorizationIdentityMapperDN());
        switch (globalConfig.getWritabilityMode()) {
            case ENABLED: {
                DirectoryServer.setWritabilityMode(WritabilityMode.ENABLED);
                break;
            }
            case INTERNAL_ONLY: {
                DirectoryServer.setWritabilityMode(WritabilityMode.INTERNAL_ONLY);
                break;
            }
            default: {
                DirectoryServer.setWritabilityMode(WritabilityMode.DISABLED);
            }
        }
        DirectoryServer.setRejectUnauthenticatedRequests(globalConfig.isRejectUnauthenticatedRequests());
        DirectoryServer.setBindWithDNRequiresPassword(globalConfig.isBindWithDNRequiresPassword());
        DirectoryServer.setLookthroughLimit(globalConfig.getLookthroughLimit());
        ArrayList<Properties> mailServerProperties = new ArrayList<Properties>();
        SortedSet<String> smtpServers = globalConfig.getSMTPServer();
        if (smtpServers != null && !smtpServers.isEmpty()) {
            for (String smtpServer : smtpServers) {
                int colonPos = smtpServer.indexOf(58);
                if (colonPos > 0) {
                    String smtpHost = smtpServer.substring(0, colonPos);
                    String smtpPort = smtpServer.substring(colonPos + 1);
                    Properties properties = new Properties();
                    properties.setProperty("mail.smtp.host", smtpHost);
                    properties.setProperty("mail.smtp.port", smtpPort);
                    mailServerProperties.add(properties);
                    continue;
                }
                Properties properties = new Properties();
                properties.setProperty("mail.smtp.host", smtpServer);
                mailServerProperties.add(properties);
            }
        }
        DirectoryServer.setMailServerPropertySets(mailServerProperties);
        DirectoryServer.setAllowedTasks(globalConfig.getAllowedTask());
        HashSet<Privilege> disabledPrivileges = new HashSet<Privilege>();
        SortedSet<GlobalCfgDefn.DisabledPrivilege> configuredDisabledPrivs = globalConfig.getDisabledPrivilege();
        if (configuredDisabledPrivs != null) {
            for (GlobalCfgDefn.DisabledPrivilege p : configuredDisabledPrivs) {
                switch (p) {
                    case BACKEND_BACKUP: {
                        disabledPrivileges.add(Privilege.BACKEND_BACKUP);
                        break;
                    }
                    case BACKEND_RESTORE: {
                        disabledPrivileges.add(Privilege.BACKEND_RESTORE);
                        break;
                    }
                    case BYPASS_ACL: {
                        disabledPrivileges.add(Privilege.BYPASS_ACL);
                        break;
                    }
                    case CANCEL_REQUEST: {
                        disabledPrivileges.add(Privilege.CANCEL_REQUEST);
                        break;
                    }
                    case CONFIG_READ: {
                        disabledPrivileges.add(Privilege.CONFIG_READ);
                        break;
                    }
                    case CONFIG_WRITE: {
                        disabledPrivileges.add(Privilege.CONFIG_WRITE);
                        break;
                    }
                    case DATA_SYNC: {
                        disabledPrivileges.add(Privilege.DATA_SYNC);
                        break;
                    }
                    case DISCONNECT_CLIENT: {
                        disabledPrivileges.add(Privilege.DISCONNECT_CLIENT);
                        break;
                    }
                    case JMX_NOTIFY: {
                        disabledPrivileges.add(Privilege.JMX_NOTIFY);
                        break;
                    }
                    case JMX_READ: {
                        disabledPrivileges.add(Privilege.JMX_READ);
                        break;
                    }
                    case JMX_WRITE: {
                        disabledPrivileges.add(Privilege.JMX_WRITE);
                        break;
                    }
                    case LDIF_EXPORT: {
                        disabledPrivileges.add(Privilege.LDIF_EXPORT);
                        break;
                    }
                    case LDIF_IMPORT: {
                        disabledPrivileges.add(Privilege.LDIF_IMPORT);
                        break;
                    }
                    case MODIFY_ACL: {
                        disabledPrivileges.add(Privilege.MODIFY_ACL);
                        break;
                    }
                    case PASSWORD_RESET: {
                        disabledPrivileges.add(Privilege.PASSWORD_RESET);
                        break;
                    }
                    case PRIVILEGE_CHANGE: {
                        disabledPrivileges.add(Privilege.PRIVILEGE_CHANGE);
                        break;
                    }
                    case PROXIED_AUTH: {
                        disabledPrivileges.add(Privilege.PROXIED_AUTH);
                        break;
                    }
                    case SERVER_RESTART: {
                        disabledPrivileges.add(Privilege.SERVER_RESTART);
                        break;
                    }
                    case SERVER_SHUTDOWN: {
                        disabledPrivileges.add(Privilege.SERVER_SHUTDOWN);
                        break;
                    }
                    case UNINDEXED_SEARCH: {
                        disabledPrivileges.add(Privilege.UNINDEXED_SEARCH);
                        break;
                    }
                    case UPDATE_SCHEMA: {
                        disabledPrivileges.add(Privilege.UPDATE_SCHEMA);
                    }
                }
            }
        }
        DirectoryServer.setDisabledPrivileges(disabledPrivileges);
        DirectoryServer.setReturnBindErrorMessages(globalConfig.isReturnBindErrorMessages());
        DirectoryServer.setIdleTimeLimit(globalConfig.getIdleTimeLimit());
    }

    @Override
    public boolean isConfigurationChangeAcceptable(GlobalCfg configuration, List<String> unacceptableReasons) {
        SortedSet<String> smtpServers;
        DN mapperDN;
        IdentityMapper mapper;
        boolean configAcceptable = true;
        DN policyDN = configuration.getDefaultPasswordPolicy();
        PasswordPolicy policy = DirectoryServer.getPasswordPolicy(policyDN);
        if (policy == null) {
            int msgID = 3408383;
            String message = MessageHandler.getMessage(msgID, String.valueOf(policyDN));
            unacceptableReasons.add(message);
            configAcceptable = false;
        }
        if ((mapper = DirectoryServer.getIdentityMapper(mapperDN = configuration.getProxiedAuthorizationIdentityMapperDN())) == null) {
            int msgID = 3408319;
            String message = MessageHandler.getMessage(msgID, String.valueOf(mapperDN), String.valueOf(configuration.dn()));
            unacceptableReasons.add(message);
            configAcceptable = false;
        }
        if ((smtpServers = configuration.getSMTPServer()) != null) {
            for (String server : smtpServers) {
                String message;
                int colonPos = server.indexOf(58);
                if (colonPos == 0 || colonPos == server.length() - 1) {
                    int msgID = 3408569;
                    String message2 = MessageHandler.getMessage(msgID, server);
                    unacceptableReasons.add(message2);
                    configAcceptable = false;
                    continue;
                }
                if (colonPos <= 0) continue;
                try {
                    int port = Integer.parseInt(server.substring(colonPos + 1));
                    if (port >= 1 && port <= 65535) continue;
                    int msgID = 3408569;
                    message = MessageHandler.getMessage(msgID, server);
                    unacceptableReasons.add(message);
                    configAcceptable = false;
                }
                catch (Exception e) {
                    int msgID = 3408569;
                    message = MessageHandler.getMessage(msgID, server);
                    unacceptableReasons.add(message);
                    configAcceptable = false;
                }
            }
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(GlobalCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        CoreConfigManager.applyGlobalConfiguration(configuration);
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

