/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.BackendCfgDefn;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.BackendInitializationListener;
import org.opends.server.api.ConfigHandler;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.WritabilityMode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackendConfigManager
implements ConfigurationChangeListener<BackendCfg>,
ConfigurationAddListener<BackendCfg>,
ConfigurationDeleteListener<BackendCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ConcurrentHashMap<DN, Backend> registeredBackends;

    public void initializeBackendConfig() throws ConfigException, InitializationException {
        ConfigEntry backendRoot;
        this.registeredBackends = new ConcurrentHashMap();
        ServerManagementContext context = ServerManagementContext.getInstance();
        RootCfg root = context.getRootConfiguration();
        root.addBackendAddListener(this);
        root.addBackendDeleteListener(this);
        try {
            DN configEntryDN = DN.decode("cn=Backends,cn=config");
            backendRoot = DirectoryServer.getConfigEntry(configEntryDN);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 3407976;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new ConfigException(msgID, message, e);
        }
        if (backendRoot == null) {
            int msgID = 3407977;
            String message = MessageHandler.getMessage(msgID);
            throw new ConfigException(msgID, message);
        }
        for (String name : root.listBackends()) {
            String message;
            int msgID;
            BackendCfg backendCfg = root.getBackend(name);
            DN backendDN = backendCfg.dn();
            String backendID = backendCfg.getBackendId();
            backendCfg.addChangeListener(this);
            if (backendCfg.isBackendEnabled()) {
                Backend backend;
                String className;
                block29: {
                    if (DirectoryServer.hasBackend(backendCfg.getBackendId())) {
                        msgID = 3277184;
                        message = MessageHandler.getMessage(msgID, backendID, String.valueOf(backendDN));
                        ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                        continue;
                    }
                    className = backendCfg.getBackendClass();
                    try {
                        Class<?> backendClass = DirectoryServer.loadClass(className);
                        backend = (Backend)backendClass.newInstance();
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        int msgID2 = 3407987;
                        String message2 = MessageHandler.getMessage(msgID2, String.valueOf(className), String.valueOf(backendDN), StaticUtils.stackTraceToSingleLineString(e));
                        ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, message2, msgID2);
                        continue;
                    }
                    if (backend instanceof ConfigHandler) continue;
                    WritabilityMode writabilityMode = WritabilityMode.ENABLED;
                    BackendCfgDefn.BackendWritabilityMode bwm = backendCfg.getBackendWritabilityMode();
                    switch (bwm) {
                        case DISABLED: {
                            writabilityMode = WritabilityMode.DISABLED;
                            break;
                        }
                        case ENABLED: {
                            writabilityMode = WritabilityMode.ENABLED;
                            break;
                        }
                        case INTERNAL_ONLY: {
                            writabilityMode = WritabilityMode.INTERNAL_ONLY;
                        }
                    }
                    backend.setBackendID(backendID);
                    backend.setWritabilityMode(writabilityMode);
                    try {
                        String lockFile = LockFileManager.getBackendLockFileName(backend);
                        StringBuilder failureReason = new StringBuilder();
                        if (!LockFileManager.acquireSharedLock(lockFile, failureReason)) {
                            int msgID3 = 3408294;
                            String message3 = MessageHandler.getMessage(msgID3, backendID, String.valueOf(failureReason));
                            ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, message3, msgID3);
                        }
                        break block29;
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        int msgID4 = 3408294;
                        String message4 = MessageHandler.getMessage(msgID4, backendID, StaticUtils.stackTraceToSingleLineString(e));
                        ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, message4, msgID4);
                    }
                    continue;
                }
                try {
                    BackendConfigManager.initializeBackend(backend, backendCfg);
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    int msgID5 = 3407988;
                    String message5 = MessageHandler.getMessage(msgID5, String.valueOf(className), String.valueOf(backendDN), StaticUtils.stackTraceToSingleLineString(e));
                    ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, message5, msgID5);
                    try {
                        String lockFile = LockFileManager.getBackendLockFileName(backend);
                        StringBuilder failureReason = new StringBuilder();
                        if (LockFileManager.releaseLock(lockFile, failureReason)) continue;
                        msgID5 = 3277223;
                        message5 = MessageHandler.getMessage(msgID5, backendID, String.valueOf(failureReason));
                        ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, message5, msgID5);
                    }
                    catch (Exception e2) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                        }
                        msgID5 = 3277223;
                        message5 = MessageHandler.getMessage(msgID5, backendID, StaticUtils.stackTraceToSingleLineString(e2));
                        ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, message5, msgID5);
                    }
                    continue;
                }
                for (BackendInitializationListener listener : DirectoryServer.getBackendInitializationListeners()) {
                    listener.performBackendInitializationProcessing(backend);
                }
                try {
                    DirectoryServer.registerBackend(backend);
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    int msgID6 = 3277372;
                    String message6 = MessageHandler.getMessage(msgID6, backendID, StaticUtils.getExceptionMessage(e));
                    ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, message6, msgID6);
                }
                this.registeredBackends.put(backendDN, backend);
                continue;
            }
            msgID = 3145839;
            message = MessageHandler.getMessage(msgID, String.valueOf(backendDN));
            ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.INFORMATIONAL, message, msgID);
        }
    }

    @Override
    public boolean isConfigurationChangeAcceptable(BackendCfg configEntry, List<String> unacceptableReason) {
        DN backendDN = configEntry.dn();
        SortedSet<DN> baseDNs = configEntry.getBackendBaseDN();
        Backend backend = this.registeredBackends.get(backendDN);
        if (backend != null) {
            LinkedHashSet<DN> removedDNs = new LinkedHashSet<DN>();
            for (DN dn : backend.getBaseDNs()) {
                removedDNs.add(dn);
            }
            LinkedHashSet<DN> addedDNs = new LinkedHashSet<DN>();
            for (DN dn : baseDNs) {
                addedDNs.add(dn);
            }
            Iterator iterator = removedDNs.iterator();
            while (iterator.hasNext()) {
                DN dn = (DN)iterator.next();
                if (!addedDNs.remove(dn)) continue;
                iterator.remove();
            }
            for (DN dn : addedDNs) {
                try {
                    DirectoryServer.registerBaseDN(dn, backend, false, true);
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    unacceptableReason.add(de.getMessage());
                    return false;
                }
            }
            for (DN dn : removedDNs) {
                try {
                    DirectoryServer.deregisterBaseDN(dn, true);
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    unacceptableReason.add(de.getMessage());
                    return false;
                }
            }
        }
        String className = configEntry.getBackendClass();
        try {
            Class<?> backendClass = DirectoryServer.loadClass(className);
            if (!Backend.class.isAssignableFrom(backendClass)) {
                int msgID = 3407989;
                unacceptableReason.add(MessageHandler.getMessage(msgID, String.valueOf(className), String.valueOf(backendDN)));
                return false;
            }
            Backend b = (Backend)backendClass.newInstance();
            if (!b.isConfigurationAcceptable(configEntry, unacceptableReason)) {
                return false;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 3407987;
            unacceptableReason.add(MessageHandler.getMessage(msgID, String.valueOf(className), String.valueOf(backendDN), StaticUtils.stackTraceToSingleLineString(e)));
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(BackendCfg cfg) {
        boolean needToEnable;
        ArrayList<String> messages;
        boolean adminActionRequired;
        ResultCode resultCode;
        Backend backend;
        DN backendDN;
        block40: {
            backendDN = cfg.dn();
            backend = this.registeredBackends.get(backendDN);
            resultCode = ResultCode.SUCCESS;
            adminActionRequired = false;
            messages = new ArrayList<String>();
            needToEnable = false;
            try {
                if (cfg.isBackendEnabled()) {
                    if (backend == null) {
                        needToEnable = true;
                    }
                    break block40;
                }
                if (backend == null) break block40;
                this.registeredBackends.remove(backendDN);
                DirectoryServer.deregisterBackend(backend);
                for (BackendInitializationListener listener : DirectoryServer.getBackendInitializationListeners()) {
                    listener.performBackendFinalizationProcessing(backend);
                }
                backend.finalizeBackend();
                try {
                    String lockFile = LockFileManager.getBackendLockFileName(backend);
                    StringBuilder failureReason = new StringBuilder();
                    if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                        int msgID = 3277223;
                        String message = MessageHandler.getMessage(msgID, backend.getBackendID(), String.valueOf(failureReason));
                        ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                    }
                }
                catch (Exception e2) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                    }
                    int msgID = 3277223;
                    String message = MessageHandler.getMessage(msgID, backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(e2));
                    ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                }
                return new ConfigChangeResult(resultCode, adminActionRequired, messages);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                int msgID = 3407984;
                messages.add(MessageHandler.getMessage(msgID, String.valueOf(backendDN), StaticUtils.stackTraceToSingleLineString(e)));
                resultCode = DirectoryServer.getServerErrorResultCode();
                return new ConfigChangeResult(resultCode, adminActionRequired, messages);
            }
        }
        String backendID = cfg.getBackendId();
        WritabilityMode writabilityMode = WritabilityMode.ENABLED;
        BackendCfgDefn.BackendWritabilityMode bwm = cfg.getBackendWritabilityMode();
        switch (bwm) {
            case DISABLED: {
                writabilityMode = WritabilityMode.DISABLED;
                break;
            }
            case ENABLED: {
                writabilityMode = WritabilityMode.ENABLED;
                break;
            }
            case INTERNAL_ONLY: {
                writabilityMode = WritabilityMode.INTERNAL_ONLY;
            }
        }
        SortedSet<DN> baseList = cfg.getBackendBaseDN();
        DN[] baseDNs = new DN[baseList.size()];
        baseList.toArray(baseDNs);
        String className = cfg.getBackendClass();
        if (backend != null && !className.equals(backend.getClass().getName())) {
            try {
                Class<?> backendClass = DirectoryServer.loadClass(className);
                if (Backend.class.isAssignableFrom(backendClass)) {
                    int msgID = 3604598;
                    messages.add(MessageHandler.getMessage(msgID, String.valueOf(backendDN), backend.getClass().getName(), className));
                    adminActionRequired = true;
                    return new ConfigChangeResult(resultCode, adminActionRequired, messages);
                }
                int msgID = 3407989;
                messages.add(MessageHandler.getMessage(msgID, String.valueOf(className), String.valueOf(backendDN)));
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
                return new ConfigChangeResult(resultCode, adminActionRequired, messages);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                int msgID = 3407987;
                messages.add(MessageHandler.getMessage(msgID, String.valueOf(className), String.valueOf(backendDN), StaticUtils.stackTraceToSingleLineString(e)));
                resultCode = DirectoryServer.getServerErrorResultCode();
                return new ConfigChangeResult(resultCode, adminActionRequired, messages);
            }
        }
        if (needToEnable) {
            try {
                Class<?> backendClass = DirectoryServer.loadClass(className);
                backend = (Backend)backendClass.newInstance();
            }
            catch (Exception e) {
                int msgID = 3407989;
                messages.add(MessageHandler.getMessage(msgID, String.valueOf(className), String.valueOf(backendDN)));
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
                return new ConfigChangeResult(resultCode, adminActionRequired, messages);
            }
            backend.setBackendID(backendID);
            backend.setWritabilityMode(writabilityMode);
            try {
                String lockFile = LockFileManager.getBackendLockFileName(backend);
                StringBuilder failureReason = new StringBuilder();
                if (!LockFileManager.acquireSharedLock(lockFile, failureReason)) {
                    int msgID = 3408294;
                    String message = MessageHandler.getMessage(msgID, backendID, String.valueOf(failureReason));
                    ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                    resultCode = ResultCode.CONSTRAINT_VIOLATION;
                    adminActionRequired = true;
                    messages.add(message);
                    return new ConfigChangeResult(resultCode, adminActionRequired, messages);
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                int msgID = 3408294;
                String message = MessageHandler.getMessage(msgID, backendID, StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
                adminActionRequired = true;
                messages.add(message);
                return new ConfigChangeResult(resultCode, adminActionRequired, messages);
            }
            try {
                BackendConfigManager.initializeBackend(backend, cfg);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                int msgID = 3407988;
                messages.add(MessageHandler.getMessage(msgID, String.valueOf(className), String.valueOf(backendDN), StaticUtils.stackTraceToSingleLineString(e)));
                resultCode = DirectoryServer.getServerErrorResultCode();
                try {
                    String lockFile = LockFileManager.getBackendLockFileName(backend);
                    StringBuilder failureReason = new StringBuilder();
                    if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                        msgID = 3277223;
                        String message = MessageHandler.getMessage(msgID, backendID, String.valueOf(failureReason));
                        ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                    }
                }
                catch (Exception e2) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                    }
                    msgID = 3277223;
                    String message = MessageHandler.getMessage(msgID, backendID, StaticUtils.stackTraceToSingleLineString(e2));
                    ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                }
                return new ConfigChangeResult(resultCode, adminActionRequired, messages);
            }
            for (BackendInitializationListener listener : DirectoryServer.getBackendInitializationListeners()) {
                listener.performBackendInitializationProcessing(backend);
            }
            try {
                DirectoryServer.registerBackend(backend);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                int msgID = 3277372;
                String message = MessageHandler.getMessage(msgID, backendID, StaticUtils.getExceptionMessage(e));
                resultCode = DirectoryServer.getServerErrorResultCode();
                messages.add(message);
                ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                return new ConfigChangeResult(resultCode, adminActionRequired, messages);
            }
            this.registeredBackends.put(backendDN, backend);
        } else if (resultCode == ResultCode.SUCCESS && backend != null && writabilityMode != backend.getWritabilityMode()) {
            backend.setWritabilityMode(writabilityMode);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationAddAcceptable(BackendCfg configEntry, List<String> unacceptableReason) {
        Backend backend;
        DN backendDN = configEntry.dn();
        String backendID = configEntry.getBackendId();
        if (DirectoryServer.hasBackend(backendID)) {
            int msgID = 3277184;
            unacceptableReason.add(MessageHandler.getMessage(msgID, String.valueOf(backendDN)));
            return false;
        }
        SortedSet<DN> baseList = configEntry.getBackendBaseDN();
        DN[] baseDNs = new DN[baseList.size()];
        baseList.toArray(baseDNs);
        String className = configEntry.getBackendClass();
        try {
            Class<?> backendClass = DirectoryServer.loadClass(className);
            backend = (Backend)backendClass.newInstance();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 3407987;
            unacceptableReason.add(MessageHandler.getMessage(msgID, String.valueOf(className), String.valueOf(backendDN), StaticUtils.stackTraceToSingleLineString(e)));
            return false;
        }
        for (DN baseDN : baseDNs) {
            try {
                DirectoryServer.registerBaseDN(baseDN, backend, false, true);
            }
            catch (DirectoryException de) {
                unacceptableReason.add(de.getMessage());
                return false;
            }
            catch (Exception e) {
                unacceptableReason.add(StaticUtils.getExceptionMessage(e));
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(BackendCfg cfg) {
        Backend backend;
        DN backendDN = cfg.dn();
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        cfg.addChangeListener(this);
        if (!cfg.isBackendEnabled()) {
            int msgID = 3145839;
            String message = MessageHandler.getMessage(msgID, String.valueOf(backendDN));
            ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.INFORMATIONAL, message, msgID);
            messages.add(message);
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        String backendID = cfg.getBackendId();
        if (DirectoryServer.hasBackend(backendID)) {
            int msgID = 3277184;
            String message = MessageHandler.getMessage(msgID, String.valueOf(backendDN));
            ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
            messages.add(message);
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        WritabilityMode writabilityMode = WritabilityMode.ENABLED;
        BackendCfgDefn.BackendWritabilityMode bwm = cfg.getBackendWritabilityMode();
        switch (bwm) {
            case DISABLED: {
                writabilityMode = WritabilityMode.DISABLED;
                break;
            }
            case ENABLED: {
                writabilityMode = WritabilityMode.ENABLED;
                break;
            }
            case INTERNAL_ONLY: {
                writabilityMode = WritabilityMode.INTERNAL_ONLY;
            }
        }
        SortedSet<DN> dnList = cfg.getBackendBaseDN();
        DN[] baseDNs = new DN[dnList.size()];
        dnList.toArray(baseDNs);
        String className = cfg.getBackendClass();
        try {
            Class<?> backendClass = DirectoryServer.loadClass(className);
            backend = (Backend)backendClass.newInstance();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 3407987;
            messages.add(MessageHandler.getMessage(msgID, String.valueOf(className), String.valueOf(backendDN), StaticUtils.stackTraceToSingleLineString(e)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        backend.setBackendID(backendID);
        backend.setWritabilityMode(writabilityMode);
        try {
            String lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.acquireSharedLock(lockFile, failureReason)) {
                int msgID = 3408294;
                String message = MessageHandler.getMessage(msgID, backendID, String.valueOf(failureReason));
                ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
                adminActionRequired = true;
                messages.add(message);
                return new ConfigChangeResult(resultCode, adminActionRequired, messages);
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 3408294;
            String message = MessageHandler.getMessage(msgID, backendID, StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
            resultCode = ResultCode.CONSTRAINT_VIOLATION;
            adminActionRequired = true;
            messages.add(message);
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        try {
            BackendConfigManager.initializeBackend(backend, cfg);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 3407988;
            messages.add(MessageHandler.getMessage(msgID, String.valueOf(className), String.valueOf(backendDN), StaticUtils.stackTraceToSingleLineString(e)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            try {
                String lockFile = LockFileManager.getBackendLockFileName(backend);
                StringBuilder failureReason = new StringBuilder();
                if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                    msgID = 3277223;
                    String message = MessageHandler.getMessage(msgID, backendID, String.valueOf(failureReason));
                    ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                }
            }
            catch (Exception e2) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                }
                msgID = 3277223;
                String message = MessageHandler.getMessage(msgID, backendID, StaticUtils.stackTraceToSingleLineString(e2));
                ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        for (BackendInitializationListener listener : DirectoryServer.getBackendInitializationListeners()) {
            listener.performBackendInitializationProcessing(backend);
        }
        try {
            DirectoryServer.registerBackend(backend);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 3277372;
            String message = MessageHandler.getMessage(msgID, backendID, StaticUtils.getExceptionMessage(e));
            resultCode = DirectoryServer.getServerErrorResultCode();
            messages.add(message);
            ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        this.registeredBackends.put(backendDN, backend);
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(BackendCfg configEntry, List<String> unacceptableReason) {
        DN backendDN = configEntry.dn();
        Backend backend = this.registeredBackends.get(backendDN);
        if (backend == null) {
            return true;
        }
        Backend[] subBackends = backend.getSubordinateBackends();
        if (subBackends == null || subBackends.length == 0) {
            return true;
        }
        int msgID = 0x370077;
        unacceptableReason.add(MessageHandler.getMessage(msgID, String.valueOf(backendDN)));
        return false;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(BackendCfg configEntry) {
        DN backendDN = configEntry.dn();
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        Backend backend = this.registeredBackends.get(backendDN);
        if (backend == null) {
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        Backend[] subBackends = backend.getSubordinateBackends();
        if (subBackends == null || subBackends.length == 0) {
            block9: {
                this.registeredBackends.remove(backendDN);
                try {
                    backend.finalizeBackend();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block9;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            for (BackendInitializationListener listener : DirectoryServer.getBackendInitializationListeners()) {
                listener.performBackendFinalizationProcessing(backend);
            }
            DirectoryServer.deregisterBackend(backend);
            configEntry.removeChangeListener(this);
            try {
                String lockFile = LockFileManager.getBackendLockFileName(backend);
                StringBuilder failureReason = new StringBuilder();
                if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                    int msgID = 3277223;
                    String message = MessageHandler.getMessage(msgID, backend.getBackendID(), String.valueOf(failureReason));
                    ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                }
            }
            catch (Exception e2) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                }
                int msgID = 3277223;
                String message = MessageHandler.getMessage(msgID, backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(e2));
                ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        int msgID = 0x370077;
        messages.add(MessageHandler.getMessage(msgID, String.valueOf(backendDN)));
        resultCode = ResultCode.UNWILLING_TO_PERFORM;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private static void initializeBackend(Backend backend, BackendCfg cfg) throws ConfigException, InitializationException {
        backend.configureBackend(cfg);
        backend.initializeBackend();
    }
}

