/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opends.server.api.ChangeNotificationListener;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.DirectoryServer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DN;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.Entry;
import org.opends.server.types.operation.PostResponseAddOperation;
import org.opends.server.types.operation.PostResponseDeleteOperation;
import org.opends.server.types.operation.PostResponseModifyDNOperation;
import org.opends.server.types.operation.PostResponseModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticatedUsers
implements ChangeNotificationListener {
    private ConcurrentHashMap<DN, CopyOnWriteArraySet<ClientConnection>> userMap = new ConcurrentHashMap();

    public AuthenticatedUsers() {
        DirectoryServer.registerChangeNotificationListener(this);
    }

    public synchronized void put(DN userDN, ClientConnection clientConnection) {
        CopyOnWriteArraySet<ClientConnection> connectionSet = this.userMap.get(userDN);
        if (connectionSet == null) {
            connectionSet = new CopyOnWriteArraySet();
            connectionSet.add(clientConnection);
            this.userMap.put(userDN, connectionSet);
        } else {
            connectionSet.add(clientConnection);
        }
    }

    public synchronized void remove(DN userDN, ClientConnection clientConnection) {
        CopyOnWriteArraySet<ClientConnection> connectionSet = this.userMap.get(userDN);
        if (connectionSet != null) {
            connectionSet.remove(clientConnection);
            if (connectionSet.isEmpty()) {
                this.userMap.remove(userDN);
            }
        }
    }

    synchronized CopyOnWriteArraySet<ClientConnection> get(DN userDN) {
        return this.userMap.get(userDN);
    }

    @Override
    public void handleAddOperation(PostResponseAddOperation addOperation, Entry entry) {
    }

    @Override
    public void handleDeleteOperation(PostResponseDeleteOperation deleteOperation, Entry entry) {
        CopyOnWriteArraySet<ClientConnection> connectionSet = this.userMap.remove(entry.getDN());
        if (connectionSet != null) {
            for (ClientConnection conn : connectionSet) {
                int msgID = 66124;
                String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()));
                conn.disconnect(DisconnectReason.OTHER, true, message, msgID);
            }
        }
    }

    @Override
    public void handleModifyOperation(PostResponseModifyOperation modifyOperation, Entry oldEntry, Entry newEntry) {
        CopyOnWriteArraySet<ClientConnection> connectionSet = this.userMap.get(oldEntry.getDN());
        if (connectionSet != null) {
            for (ClientConnection conn : connectionSet) {
                conn.updateAuthenticationInfo(oldEntry, newEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleModifyDNOperation(PostResponseModifyDNOperation modifyDNOperation, Entry oldEntry, Entry newEntry) {
        CopyOnWriteArraySet<ClientConnection> connectionSet = this.userMap.remove(oldEntry.getDN());
        if (connectionSet != null) {
            AuthenticatedUsers authenticatedUsers = this;
            synchronized (authenticatedUsers) {
                CopyOnWriteArraySet<ClientConnection> existingNewSet = this.userMap.get(newEntry.getDN());
                if (existingNewSet == null) {
                    this.userMap.put(newEntry.getDN(), connectionSet);
                } else {
                    existingNewSet.addAll(connectionSet);
                }
            }
            for (ClientConnection conn : connectionSet) {
                conn.updateAuthenticationInfo(oldEntry, newEntry);
            }
        }
    }
}

