/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.AttributeSyntaxCfgDefn;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeSyntaxConfigManager
implements ConfigurationChangeListener<AttributeSyntaxCfg>,
ConfigurationAddListener<AttributeSyntaxCfg>,
ConfigurationDeleteListener<AttributeSyntaxCfg> {
    private ConcurrentHashMap<DN, AttributeSyntax> syntaxes = new ConcurrentHashMap();

    public void initializeAttributeSyntaxes() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addAttributeSyntaxAddListener(this);
        rootConfiguration.addAttributeSyntaxDeleteListener(this);
        for (String name : rootConfiguration.listAttributeSyntaxes()) {
            AttributeSyntaxCfg syntaxConfiguration = rootConfiguration.getAttributeSyntax(name);
            syntaxConfiguration.addChangeListener(this);
            if (!syntaxConfiguration.isEnabled()) continue;
            String className = syntaxConfiguration.getSyntaxClass();
            try {
                AttributeSyntax syntax = this.loadSyntax(className, syntaxConfiguration, true);
                try {
                    DirectoryServer.registerAttributeSyntax(syntax, false);
                    this.syntaxes.put(syntaxConfiguration.dn(), syntax);
                }
                catch (DirectoryException de) {
                    int msgID = 3276987;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(syntaxConfiguration.dn()), de.getErrorMessage());
                    ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                }
            }
            catch (InitializationException ie) {
                ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, ie.getMessage(), ie.getMessageID());
            }
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(AttributeSyntaxCfg configuration, List<String> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getSyntaxClass();
            try {
                this.loadSyntax(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessage());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(AttributeSyntaxCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        configuration.addChangeListener(this);
        if (!configuration.isEnabled()) {
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        AttributeSyntax syntax = null;
        String className = configuration.getSyntaxClass();
        try {
            syntax = this.loadSyntax(className, configuration, true);
            try {
                DirectoryServer.registerAttributeSyntax(syntax, false);
                this.syntaxes.put(configuration.dn(), syntax);
            }
            catch (DirectoryException de) {
                int msgID = 3276987;
                String message = MessageHandler.getMessage(msgID, String.valueOf(configuration.dn()), de.getErrorMessage());
                messages.add(message);
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
            }
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessage());
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(AttributeSyntaxCfg configuration, List<String> unacceptableReasons) {
        boolean configAcceptable = true;
        AttributeSyntax syntax = this.syntaxes.get(configuration.dn());
        if (syntax != null) {
            String oid = syntax.getOID();
            for (AttributeType at : DirectoryServer.getAttributeTypes().values()) {
                if (!oid.equals(at.getSyntaxOID())) continue;
                int msgID = 3277468;
                String message = MessageHandler.getMessage(msgID, syntax.getSyntaxName(), at.getNameOrOID());
                unacceptableReasons.add(message);
                configAcceptable = false;
            }
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(AttributeSyntaxCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        AttributeSyntax syntax = this.syntaxes.remove(configuration.dn());
        if (syntax != null) {
            DirectoryServer.deregisterAttributeSyntax(syntax);
            syntax.finalizeSyntax();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(AttributeSyntaxCfg configuration, List<String> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getSyntaxClass();
            try {
                this.loadSyntax(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessage());
                return false;
            }
        } else {
            AttributeSyntax syntax = this.syntaxes.get(configuration.dn());
            if (syntax != null) {
                String oid = syntax.getOID();
                for (AttributeType at : DirectoryServer.getAttributeTypes().values()) {
                    if (!oid.equals(at.getSyntaxOID())) continue;
                    int msgID = 3277469;
                    String message = MessageHandler.getMessage(msgID, syntax.getSyntaxName(), at.getNameOrOID());
                    unacceptableReasons.add(message);
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(AttributeSyntaxCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        AttributeSyntax existingSyntax = this.syntaxes.get(configuration.dn());
        if (!configuration.isEnabled()) {
            if (existingSyntax != null) {
                DirectoryServer.deregisterAttributeSyntax(existingSyntax);
                AttributeSyntax syntax = this.syntaxes.remove(configuration.dn());
                if (syntax != null) {
                    syntax.finalizeSyntax();
                }
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        String className = configuration.getSyntaxClass();
        if (existingSyntax != null) {
            if (!className.equals(existingSyntax.getClass().getName())) {
                adminActionRequired = true;
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        AttributeSyntax syntax = null;
        try {
            syntax = this.loadSyntax(className, configuration, true);
            try {
                DirectoryServer.registerAttributeSyntax(syntax, false);
                this.syntaxes.put(configuration.dn(), syntax);
            }
            catch (DirectoryException de) {
                int msgID = 3276987;
                String message = MessageHandler.getMessage(msgID, String.valueOf(configuration.dn()), de.getErrorMessage());
                messages.add(message);
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
            }
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessage());
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private AttributeSyntax loadSyntax(String className, AttributeSyntaxCfg configuration, boolean initialize) throws InitializationException {
        try {
            AttributeSyntaxCfgDefn definition = AttributeSyntaxCfgDefn.getInstance();
            ClassPropertyDefinition propertyDefinition = definition.getSyntaxClassPropertyDefinition();
            Class<AttributeSyntax> syntaxClass = propertyDefinition.loadClass(className, AttributeSyntax.class);
            AttributeSyntax syntax = syntaxClass.newInstance();
            if (initialize) {
                Method method = syntax.getClass().getMethod("initializeSyntax", configuration.definition().getServerConfigurationClass());
                method.invoke((Object)syntax, configuration);
            } else {
                Method method = syntax.getClass().getMethod("isConfigurationAcceptable", AttributeSyntaxCfg.class, List.class);
                ArrayList unacceptableReasons = new ArrayList();
                Boolean acceptable = (Boolean)method.invoke((Object)syntax, configuration, unacceptableReasons);
                if (!acceptable.booleanValue()) {
                    StringBuilder buffer = new StringBuilder();
                    if (!unacceptableReasons.isEmpty()) {
                        Iterator iterator = unacceptableReasons.iterator();
                        buffer.append((String)iterator.next());
                        while (iterator.hasNext()) {
                            buffer.append(".  ");
                            buffer.append((String)iterator.next());
                        }
                    }
                    int msgID = 3343019;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(configuration.dn()), buffer.toString());
                    throw new InitializationException(msgID, message);
                }
            }
            return syntax;
        }
        catch (Exception e) {
            int msgID = 3408058;
            String message = MessageHandler.getMessage(msgID, className, String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(msgID, message, e);
        }
    }
}

