/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.AccessControlHandlerCfgDefn;
import org.opends.server.admin.std.server.AccessControlHandlerCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.AccessControlHandler;
import org.opends.server.api.AlertGenerator;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DefaultAccessControlHandler;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AccessControlConfigManager
implements AlertGenerator,
ConfigurationChangeListener<AccessControlHandlerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.core.AccessControlConfigManager";
    private static AccessControlConfigManager instance = null;
    private AtomicReference<AccessControlHandler> accessControlHandler = new AtomicReference<DefaultAccessControlHandler>(new DefaultAccessControlHandler());
    private AccessControlHandlerCfg currentConfiguration = null;

    private AccessControlConfigManager() {
    }

    public static AccessControlConfigManager getInstance() {
        if (instance == null) {
            instance = new AccessControlConfigManager();
        }
        return instance;
    }

    public boolean isAccessControlEnabled() {
        return this.currentConfiguration.isEnabled();
    }

    public AccessControlHandler getAccessControlHandler() {
        return this.accessControlHandler.get();
    }

    public void initializeAccessControl() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        AccessControlHandlerCfg accessControlConfiguration = rootConfiguration.getAccessControlHandler();
        accessControlConfiguration.addChangeListener(this);
        this.updateConfiguration(accessControlConfiguration);
    }

    private void updateConfiguration(AccessControlHandlerCfg newConfiguration) throws ConfigException, InitializationException {
        DN configEntryDN = newConfiguration.dn();
        String newHandlerClass = null;
        if (this.currentConfiguration == null) {
            newHandlerClass = newConfiguration.isEnabled() ? newConfiguration.getAclHandlerClass() : DefaultAccessControlHandler.class.getName();
        } else {
            boolean enabledOld = this.currentConfiguration.isEnabled();
            boolean enabledNew = newConfiguration.isEnabled();
            if (!enabledOld && enabledNew) {
                newHandlerClass = newConfiguration.getAclHandlerClass();
            } else if (enabledOld && !enabledNew) {
                newHandlerClass = DefaultAccessControlHandler.class.getName();
            } else if (enabledNew) {
                newHandlerClass = newConfiguration.getAclHandlerClass();
            }
        }
        if (newHandlerClass != null) {
            AccessControlHandler newHandler;
            try {
                if (newConfiguration.isEnabled()) {
                    newHandler = this.loadHandler(newHandlerClass, newConfiguration, true);
                } else {
                    newHandler = new DefaultAccessControlHandler();
                    newHandler.initializeAccessControlHandler(null);
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                int msgID = 3473941;
                String message = MessageHandler.getMessage(msgID, newHandlerClass, String.valueOf(configEntryDN.toString()), StaticUtils.stackTraceToSingleLineString(e));
                throw new InitializationException(msgID, message, e);
            }
            AccessControlHandler oldHandler = this.accessControlHandler.getAndSet(newHandler);
            if (oldHandler != null) {
                oldHandler.finalizeAccessControlHandler();
            }
            if (newHandlerClass.equals(DefaultAccessControlHandler.class.getName())) {
                int msgID = 3277325;
                String message = MessageHandler.getMessage(msgID);
                ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                if (this.currentConfiguration != null) {
                    DirectoryServer.sendAlertNotification(this, "org.opends.server.AccessControlDisabled", msgID, message);
                }
            } else {
                int msgID = 3605006;
                String message = MessageHandler.getMessage(msgID, newHandlerClass);
                ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.NOTICE, message, msgID);
                if (this.currentConfiguration != null) {
                    DirectoryServer.sendAlertNotification(this, "org.opends.server.AccessControlEnabled", msgID, message);
                }
            }
        }
        this.currentConfiguration = newConfiguration;
    }

    @Override
    public boolean isConfigurationChangeAcceptable(AccessControlHandlerCfg configuration, List<String> unacceptableReasons) {
        try {
            if (configuration.isEnabled()) {
                this.loadHandler(configuration.getAclHandlerClass(), configuration, false);
            }
        }
        catch (InitializationException e) {
            unacceptableReasons.add(e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(AccessControlHandlerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        ArrayList<String> messages = new ArrayList<String>();
        try {
            this.updateConfiguration(configuration);
        }
        catch (ConfigException e) {
            messages.add(e.getMessage());
            resultCode = ResultCode.CONSTRAINT_VIOLATION;
        }
        catch (InitializationException e) {
            messages.add(e.getMessage());
            resultCode = DirectoryServer.getServerErrorResultCode();
        }
        return new ConfigChangeResult(resultCode, false, messages);
    }

    @Override
    public DN getComponentEntryDN() {
        return this.currentConfiguration.dn();
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public LinkedHashMap<String, String> getAlerts() {
        LinkedHashMap<String, String> alerts = new LinkedHashMap<String, String>();
        alerts.put("org.opends.server.AccessControlDisabled", "This alert type will be used to notify administrators that the access control handler has been disabled.");
        alerts.put("org.opends.server.AccessControlEnabled", "This alert type will be used to notify administrators that the access control handler has been enabled.");
        return alerts;
    }

    private AccessControlHandler<? extends AccessControlHandlerCfg> loadHandler(String className, AccessControlHandlerCfg configuration, boolean initialize) throws InitializationException {
        try {
            AccessControlHandlerCfgDefn definition = AccessControlHandlerCfgDefn.getInstance();
            ClassPropertyDefinition propertyDefinition = definition.getAclHandlerClassPropertyDefinition();
            Class<AccessControlHandler> providerClass = propertyDefinition.loadClass(className, AccessControlHandler.class);
            AccessControlHandler provider = providerClass.newInstance();
            if (configuration != null) {
                Method method = provider.getClass().getMethod("initializeAccessControlHandler", configuration.definition().getServerConfigurationClass());
                method.invoke((Object)provider, configuration);
            } else {
                Method method = provider.getClass().getMethod("isConfigurationAcceptable", AccessControlHandlerCfg.class, List.class);
                ArrayList unacceptableReasons = new ArrayList();
                Boolean acceptable = (Boolean)method.invoke((Object)provider, configuration, unacceptableReasons);
                if (!acceptable.booleanValue()) {
                    StringBuilder buffer = new StringBuilder();
                    if (!unacceptableReasons.isEmpty()) {
                        Iterator iterator = unacceptableReasons.iterator();
                        buffer.append((String)iterator.next());
                        while (iterator.hasNext()) {
                            buffer.append(".  ");
                            buffer.append((String)iterator.next());
                        }
                    }
                    int msgID = 3343017;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(configuration.dn()), buffer.toString());
                    throw new InitializationException(msgID, message);
                }
            }
            return provider;
        }
        catch (Exception e) {
            int msgID = 3473941;
            String message = MessageHandler.getMessage(msgID, className, String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(msgID, message, e);
        }
    }
}

