/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.util.ArrayList;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Enumerated;
import org.opends.server.protocols.asn1.ASN1Integer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.LDAPException;
import org.opends.server.util.StaticUtils;

public class VLVResponseControl
extends Control {
    private ByteString contextID;
    private int contentCount;
    private int targetPosition;
    private int vlvResultCode;

    public VLVResponseControl(int targetPosition, int contentCount, int vlvResultCode) {
        this(targetPosition, contentCount, vlvResultCode, null);
    }

    public VLVResponseControl(int targetPosition, int contentCount, int vlvResultCode, ByteString contextID) {
        super("2.16.840.1.113730.3.4.10", false, VLVResponseControl.encodeControlValue(targetPosition, contentCount, vlvResultCode, contextID));
        this.targetPosition = targetPosition;
        this.contentCount = contentCount;
        this.vlvResultCode = vlvResultCode;
        this.contextID = contextID;
    }

    private VLVResponseControl(String oid, boolean isCritical, ASN1OctetString controlValue, int targetPosition, int contentCount, int vlvResultCode, ByteString contextID) {
        super(oid, isCritical, controlValue);
        this.targetPosition = targetPosition;
        this.contentCount = contentCount;
        this.vlvResultCode = vlvResultCode;
        this.contextID = contextID;
    }

    public int getTargetPosition() {
        return this.targetPosition;
    }

    public int getContentCount() {
        return this.contentCount;
    }

    public int getVLVResultCode() {
        return this.vlvResultCode;
    }

    public ByteString getContextID() {
        return this.contextID;
    }

    private static ASN1OctetString encodeControlValue(int targetPosition, int contentCount, int vlvResultCode, ByteString contextID) {
        ArrayList<ASN1Element> vlvElements = new ArrayList<ASN1Element>(4);
        vlvElements.add(new ASN1Integer(targetPosition));
        vlvElements.add(new ASN1Integer(contentCount));
        vlvElements.add(new ASN1Enumerated(vlvResultCode));
        if (contextID != null) {
            vlvElements.add(contextID.toASN1OctetString());
        }
        return new ASN1OctetString(new ASN1Sequence(vlvElements).encode());
    }

    public static VLVResponseControl decodeControl(Control control) throws LDAPException {
        ASN1OctetString controlValue = control.getValue();
        if (controlValue == null) {
            int msgID = 2097573;
            String message = MessageHandler.getMessage(msgID);
            throw new LDAPException(2, msgID, message);
        }
        try {
            ASN1Sequence vlvSequence = ASN1Sequence.decodeAsSequence(controlValue.value());
            ArrayList<ASN1Element> elements = vlvSequence.elements();
            if (elements.size() < 3 || elements.size() > 4) {
                int msgID = 2097574;
                String message = MessageHandler.getMessage(msgID, elements.size());
                throw new LDAPException(2, msgID, message);
            }
            int targetPosition = elements.get(0).decodeAsInteger().intValue();
            int contentCount = elements.get(1).decodeAsInteger().intValue();
            int vlvResultCode = elements.get(2).decodeAsEnumerated().intValue();
            ASN1OctetString contextID = null;
            if (elements.size() == 4) {
                contextID = elements.get(3).decodeAsOctetString();
            }
            return new VLVResponseControl(control.getOID(), control.isCritical(), controlValue, targetPosition, contentCount, vlvResultCode, contextID);
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (Exception e) {
            int msgID = 2097575;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new LDAPException(2, msgID, message, e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("VLVResponseControl(targetPosition=");
        buffer.append(this.targetPosition);
        buffer.append(", contentCount=");
        buffer.append(this.contentCount);
        buffer.append(", vlvResultCode=");
        buffer.append(this.vlvResultCode);
        if (this.contextID != null) {
            buffer.append(", contextID=");
            buffer.append(this.contextID);
        }
        buffer.append(")");
    }
}

