/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.util.ArrayList;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Integer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.LDAPException;
import org.opends.server.util.StaticUtils;

public class VLVRequestControl
extends Control {
    public static final byte TYPE_TARGET_BYOFFSET = -96;
    public static final byte TYPE_TARGET_GREATERTHANOREQUAL = -127;
    private byte targetType;
    private ByteString contextID;
    private ByteString greaterThanOrEqual;
    private int afterCount;
    private int beforeCount;
    private int contentCount;
    private int offset;

    public VLVRequestControl(int beforeCount, int afterCount, int offset, int contentCount) {
        this(beforeCount, afterCount, offset, contentCount, null);
    }

    public VLVRequestControl(int beforeCount, int afterCount, int offset, int contentCount, ByteString contextID) {
        super("2.16.840.1.113730.3.4.9", false, VLVRequestControl.encodeControlValue(beforeCount, afterCount, offset, contentCount, contextID));
        this.beforeCount = beforeCount;
        this.afterCount = afterCount;
        this.offset = offset;
        this.contentCount = contentCount;
        this.contextID = contextID;
        this.targetType = (byte)-96;
    }

    public VLVRequestControl(int beforeCount, int afterCount, ByteString greaterThanOrEqual) {
        this(beforeCount, afterCount, greaterThanOrEqual, null);
    }

    public VLVRequestControl(int beforeCount, int afterCount, ByteString greaterThanOrEqual, ByteString contextID) {
        super("2.16.840.1.113730.3.4.9", false, VLVRequestControl.encodeControlValue(beforeCount, afterCount, greaterThanOrEqual, contextID));
        this.beforeCount = beforeCount;
        this.afterCount = afterCount;
        this.greaterThanOrEqual = greaterThanOrEqual;
        this.contextID = contextID;
        this.targetType = (byte)-127;
    }

    private VLVRequestControl(String oid, boolean isCritical, ASN1OctetString controlValue, int beforeCount, int afterCount, byte targetType, int offset, int contentCount, ByteString greaterThanOrEqual, ByteString contextID) {
        super(oid, isCritical, controlValue);
        this.beforeCount = beforeCount;
        this.afterCount = afterCount;
        this.targetType = targetType;
        this.offset = offset;
        this.contentCount = contentCount;
        this.greaterThanOrEqual = greaterThanOrEqual;
        this.contextID = contextID;
    }

    public int getBeforeCount() {
        return this.beforeCount;
    }

    public int getAfterCount() {
        return this.afterCount;
    }

    public byte getTargetType() {
        return this.targetType;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getContentCount() {
        return this.contentCount;
    }

    public ByteString getGreaterThanOrEqualAssertion() {
        return this.greaterThanOrEqual;
    }

    public ByteString getContextID() {
        return this.contextID;
    }

    private static ASN1OctetString encodeControlValue(int beforeCount, int afterCount, int offset, int contentCount, ByteString contextID) {
        ArrayList<ASN1Element> vlvElements = new ArrayList<ASN1Element>(4);
        vlvElements.add(new ASN1Integer(beforeCount));
        vlvElements.add(new ASN1Integer(afterCount));
        ArrayList<ASN1Element> targetElements = new ArrayList<ASN1Element>(2);
        targetElements.add(new ASN1Integer(offset));
        targetElements.add(new ASN1Integer(contentCount));
        vlvElements.add(new ASN1Sequence(-96, targetElements));
        if (contextID != null) {
            vlvElements.add(contextID.toASN1OctetString());
        }
        return new ASN1OctetString(new ASN1Sequence(vlvElements).encode());
    }

    private static ASN1OctetString encodeControlValue(int beforeCount, int afterCount, ByteString greaterThanOrEqual, ByteString contextID) {
        ArrayList<ASN1Element> vlvElements = new ArrayList<ASN1Element>(4);
        vlvElements.add(new ASN1Integer(beforeCount));
        vlvElements.add(new ASN1Integer(afterCount));
        vlvElements.add(new ASN1OctetString(-127, greaterThanOrEqual.value()));
        if (contextID != null) {
            vlvElements.add(contextID.toASN1OctetString());
        }
        return new ASN1OctetString(new ASN1Sequence(vlvElements).encode());
    }

    public static VLVRequestControl decodeControl(Control control) throws LDAPException {
        ASN1OctetString controlValue = control.getValue();
        if (controlValue == null) {
            int msgID = 2097569;
            String message = MessageHandler.getMessage(msgID);
            throw new LDAPException(2, msgID, message);
        }
        try {
            ASN1Sequence vlvSequence = ASN1Sequence.decodeAsSequence(controlValue.value());
            ArrayList<ASN1Element> elements = vlvSequence.elements();
            if (elements.size() < 3 || elements.size() > 4) {
                int msgID = 2097570;
                String message = MessageHandler.getMessage(msgID, elements.size());
                throw new LDAPException(2, msgID, message);
            }
            int beforeCount = elements.get(0).decodeAsInteger().intValue();
            int afterCount = elements.get(1).decodeAsInteger().intValue();
            ASN1Element targetElement = elements.get(2);
            int offset = 0;
            int contentCount = 0;
            ASN1OctetString greaterThanOrEqual = null;
            byte targetType = targetElement.getType();
            switch (targetType) {
                case -96: {
                    ArrayList<ASN1Element> targetElements = targetElement.decodeAsSequence().elements();
                    offset = targetElements.get(0).decodeAsInteger().intValue();
                    contentCount = targetElements.get(1).decodeAsInteger().intValue();
                    break;
                }
                case -127: {
                    greaterThanOrEqual = targetElement.decodeAsOctetString();
                    break;
                }
                default: {
                    int msgID = 2097571;
                    String message = MessageHandler.getMessage(msgID, StaticUtils.byteToHex(targetType));
                    throw new LDAPException(2, msgID, message);
                }
            }
            ASN1OctetString contextID = null;
            if (elements.size() == 4) {
                contextID = elements.get(3).decodeAsOctetString();
            }
            return new VLVRequestControl(control.getOID(), control.isCritical(), controlValue, beforeCount, afterCount, targetType, offset, contentCount, greaterThanOrEqual, contextID);
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (Exception e) {
            int msgID = 2097572;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new LDAPException(2, msgID, message, e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("VLVRequestControl(beforeCount=");
        buffer.append(this.beforeCount);
        buffer.append(", afterCount=");
        buffer.append(this.afterCount);
        if (this.targetType == -96) {
            buffer.append(", offset=");
            buffer.append(this.offset);
            buffer.append(", contentCount=");
            buffer.append(this.contentCount);
        } else {
            buffer.append(", greaterThanOrEqual=");
            buffer.append(this.greaterThanOrEqual);
        }
        if (this.contextID != null) {
            buffer.append(", contextID=");
            buffer.append(this.contextID);
        }
        buffer.append(")");
    }
}

