/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDAPException;
import org.opends.server.types.LockManager;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

public class ProxiedAuthV1Control
extends Control {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ASN1OctetString rawAuthorizationDN;
    private DN authorizationDN;

    public ProxiedAuthV1Control(ASN1OctetString rawAuthorizationDN) {
        super("2.16.840.1.113730.3.4.12", true, ProxiedAuthV1Control.encodeValue(rawAuthorizationDN));
        this.rawAuthorizationDN = rawAuthorizationDN;
        this.authorizationDN = null;
    }

    public ProxiedAuthV1Control(DN authorizationDN) {
        super("2.16.840.1.113730.3.4.12", true, ProxiedAuthV1Control.encodeValue(new ASN1OctetString(authorizationDN.toString())));
        this.authorizationDN = authorizationDN;
        this.rawAuthorizationDN = new ASN1OctetString(authorizationDN.toString());
    }

    private ProxiedAuthV1Control(String oid, boolean isCritical, ASN1OctetString controlValue, ASN1OctetString rawAuthorizationDN) {
        super(oid, isCritical, controlValue);
        this.rawAuthorizationDN = rawAuthorizationDN;
        this.authorizationDN = null;
    }

    private static ASN1OctetString encodeValue(ASN1OctetString rawAuthorizationDN) {
        Validator.ensureNotNull(rawAuthorizationDN);
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(1);
        elements.add(rawAuthorizationDN);
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public static ProxiedAuthV1Control decodeControl(Control control) throws LDAPException {
        ASN1OctetString rawAuthorizationDN;
        Validator.ensureNotNull(control);
        if (!control.isCritical()) {
            int msgID = 2294148;
            String message = MessageHandler.getMessage(msgID);
            throw new LDAPException(2, msgID, message);
        }
        if (!control.hasValue()) {
            int msgID = 2294053;
            String message = MessageHandler.getMessage(msgID);
            throw new LDAPException(2, msgID, message);
        }
        try {
            ArrayList<ASN1Element> elements = ASN1Sequence.decodeAsSequence(control.getValue().value()).elements();
            if (elements.size() != 1) {
                int msgID = 2294054;
                String message = MessageHandler.getMessage(msgID, elements.size());
                throw new LDAPException(2, msgID, message);
            }
            rawAuthorizationDN = elements.get(0).decodeAsOctetString();
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2294055;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new LDAPException(2, msgID, message, e);
        }
        return new ProxiedAuthV1Control(control.getOID(), control.isCritical(), control.getValue(), rawAuthorizationDN);
    }

    public ASN1OctetString getRawAuthorizationDN() {
        return this.rawAuthorizationDN;
    }

    public void setRawAuthorizationDN(ASN1OctetString rawAuthorizationDN) {
        this.rawAuthorizationDN = rawAuthorizationDN;
        this.setValue(ProxiedAuthV1Control.encodeValue(rawAuthorizationDN));
        this.authorizationDN = null;
    }

    public DN getAuthorizationDN() throws DirectoryException {
        if (this.authorizationDN == null) {
            this.authorizationDN = DN.decode(this.rawAuthorizationDN);
        }
        return this.authorizationDN;
    }

    public void setAuthorizationDN(DN authorizationDN) {
        Validator.ensureNotNull(authorizationDN);
        this.authorizationDN = authorizationDN;
        this.rawAuthorizationDN = new ASN1OctetString(authorizationDN.toString());
        this.setValue(ProxiedAuthV1Control.encodeValue(this.rawAuthorizationDN));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getAuthorizationEntry() throws DirectoryException {
        DN authzDN = this.getAuthorizationDN();
        if (authzDN.isNullDN()) {
            return null;
        }
        DN actualDN = DirectoryServer.getActualRootBindDN(authzDN);
        if (actualDN != null) {
            authzDN = actualDN;
        }
        Lock entryLock = null;
        for (int i = 0; i < 3 && (entryLock = LockManager.lockRead(authzDN)) == null; ++i) {
        }
        if (entryLock == null) {
            int msgID = 2294131;
            String message = MessageHandler.getMessage(msgID, String.valueOf(authzDN));
            throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, message, msgID);
        }
        try {
            Entry userEntry = DirectoryServer.getEntry(authzDN);
            if (userEntry == null) {
                int msgID = 2294056;
                String message = MessageHandler.getMessage(msgID, String.valueOf(authzDN));
                throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, message, msgID);
            }
            PasswordPolicyState pwpState = new PasswordPolicyState(userEntry, false, false);
            if (pwpState.isDisabled() || pwpState.isAccountExpired() || pwpState.lockedDueToFailures() || pwpState.lockedDueToIdleInterval() || pwpState.lockedDueToMaximumResetAge() || pwpState.isPasswordExpired()) {
                int msgID = 2294132;
                String message = MessageHandler.getMessage(msgID, String.valueOf(authzDN));
                throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, message, msgID);
            }
            Entry entry = userEntry;
            return entry;
        }
        finally {
            LockManager.unlock(authzDN, entryLock);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ProxiedAuthorizationV1Control(authorizationDN=\"");
        this.rawAuthorizationDN.toString(buffer);
        buffer.append("\")");
    }
}

