/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AttributeType;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.LDAPException;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetEffectiveRights
extends Control {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DN authzDN = null;
    private List<AttributeType> attrs = null;

    public GetEffectiveRights() {
        super("1.3.6.1.4.1.42.2.27.9.5.2", true, null);
    }

    public GetEffectiveRights(ASN1OctetString val, DN authzDN, List<AttributeType> attrs) {
        super("1.3.6.1.4.1.42.2.27.9.5.2", true, val);
        this.authzDN = authzDN;
        this.attrs = attrs;
    }

    public DN getAuthzDN() {
        return this.authzDN;
    }

    public List<AttributeType> getAttributes() {
        return this.attrs;
    }

    private static List<AttributeType> decodeAttributeSequence(ASN1Element attributeElement) throws ASN1Exception {
        LinkedList<AttributeType> attributeList = new LinkedList<AttributeType>();
        ArrayList<ASN1Element> attrElems = attributeElement.decodeAsSequence().elements();
        int numAttrElements = attrElems.size();
        for (int i = 0; i < numAttrElements; ++i) {
            ASN1OctetString tmp = attrElems.get(i).decodeAsOctetString();
            AttributeType attributeType = DirectoryServer.getAttributeType(tmp.toString());
            if (attributeType == null) {
                attributeType = DirectoryServer.getDefaultAttributeType(tmp.toString());
            }
            attributeList.add(attributeType);
        }
        return attributeList;
    }

    private static GetEffectiveRights decodeValueSequence(ASN1OctetString val) throws LDAPException {
        DN authzDN;
        List<AttributeType> attrs = null;
        String authzIDString = "";
        try {
            String lowerAuthzIDString;
            ASN1Element sequence = ASN1Element.decode(val.value());
            ArrayList<ASN1Element> elements = sequence.decodeAsSequence().elements();
            ASN1OctetString authzID = elements.get(0).decodeAsOctetString();
            if (elements.size() == 2) {
                attrs = GetEffectiveRights.decodeAttributeSequence(elements.get(1));
            }
            if (!(lowerAuthzIDString = StaticUtils.toLowerCase(authzIDString = authzID.stringValue())).startsWith("dn:")) {
                int msgID = 2097576;
                String message = MessageHandler.getMessage(msgID, authzID);
                throw new LDAPException(2, msgID, message);
            }
            authzDN = DN.decode(authzIDString.substring(3));
        }
        catch (ASN1Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2097577;
            String message = MessageHandler.getMessage(msgID, e.getMessage());
            throw new LDAPException(2, msgID, message);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            int msgID = 2097578;
            String message = MessageHandler.getMessage(msgID, authzIDString.substring(3), de.getErrorMessage());
            throw new LDAPException(2, msgID, message);
        }
        return new GetEffectiveRights(val, authzDN, attrs);
    }

    public static GetEffectiveRights decodeControl(Control control) throws LDAPException {
        Validator.ensureNotNull(control);
        ASN1OctetString value = control.getValue();
        if (value == null) {
            return new GetEffectiveRights();
        }
        return GetEffectiveRights.decodeValueSequence(value);
    }
}

