/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.LDAPException;

public class AuthorizationIdentityResponseControl
extends Control {
    private String authorizationID;

    public AuthorizationIdentityResponseControl() {
        super("2.16.840.1.113730.3.4.15", false, new ASN1OctetString());
    }

    public AuthorizationIdentityResponseControl(String authorizationID) {
        super("2.16.840.1.113730.3.4.15", false, AuthorizationIdentityResponseControl.encodeValue(authorizationID));
        this.authorizationID = authorizationID;
    }

    public AuthorizationIdentityResponseControl(DN authorizationDN) {
        super("2.16.840.1.113730.3.4.15", false, AuthorizationIdentityResponseControl.encodeValue(authorizationDN));
        this.authorizationID = authorizationDN == null ? "dn:" : "dn:" + authorizationDN.toString();
    }

    public AuthorizationIdentityResponseControl(String oid, boolean isCritical, String authorizationID) {
        super(oid, isCritical, AuthorizationIdentityResponseControl.encodeValue(authorizationID));
        this.authorizationID = authorizationID;
    }

    public AuthorizationIdentityResponseControl(String oid, boolean isCritical, DN authorizationDN) {
        super(oid, isCritical, AuthorizationIdentityResponseControl.encodeValue(authorizationDN));
        this.authorizationID = authorizationDN == null ? "dn:" : "dn:" + authorizationDN.toString();
    }

    private AuthorizationIdentityResponseControl(String oid, boolean isCritical, String authorizationID, ASN1OctetString encodedValue) {
        super(oid, isCritical, encodedValue);
        this.authorizationID = authorizationID;
    }

    private static ASN1OctetString encodeValue(String authorizationID) {
        return new ASN1OctetString(authorizationID);
    }

    private static ASN1OctetString encodeValue(DN authorizationDN) {
        if (authorizationDN == null) {
            return new ASN1OctetString("dn:");
        }
        return new ASN1OctetString("dn:" + authorizationDN.toString());
    }

    public static AuthorizationIdentityResponseControl decodeControl(Control control) throws LDAPException {
        if (!control.hasValue()) {
            int msgID = 2294073;
            String message = MessageHandler.getMessage(msgID);
            throw new LDAPException(2, msgID, message);
        }
        return new AuthorizationIdentityResponseControl(control.getOID(), control.isCritical(), control.getValue().stringValue(), control.getValue());
    }

    public String getAuthorizationID() {
        return this.authorizationID;
    }

    public void setAuthorizationID(String authorizationID) {
        this.authorizationID = authorizationID;
        this.setValue(AuthorizationIdentityResponseControl.encodeValue(authorizationID));
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("AuthorizationIdentityResponseControl(authzID=\"");
        buffer.append(this.authorizationID);
        buffer.append("\")");
    }
}

