/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.util.ArrayList;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Boolean;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1Integer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.types.Control;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.util.StaticUtils;

public class AccountUsableResponseControl
extends Control {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final byte TYPE_SECONDS_BEFORE_EXPIRATION = -128;
    public static final byte TYPE_MORE_INFO = -95;
    public static final byte TYPE_INACTIVE = -128;
    public static final byte TYPE_RESET = -127;
    public static final byte TYPE_EXPIRED = -126;
    public static final byte TYPE_REMAINING_GRACE_LOGINS = -125;
    public static final byte TYPE_SECONDS_BEFORE_UNLOCK = -124;
    private boolean isUsable;
    private boolean isExpired;
    private boolean isInactive;
    private boolean isLocked;
    private boolean isReset;
    private int remainingGraceLogins;
    private int secondsBeforeExpiration;
    private int secondsBeforeUnlock;

    public AccountUsableResponseControl(int secondsBeforeExpiration) {
        super("1.3.6.1.4.1.42.2.27.9.5.8", false, AccountUsableResponseControl.encodeValue(secondsBeforeExpiration));
        this.secondsBeforeExpiration = secondsBeforeExpiration;
        this.isUsable = true;
        this.isInactive = false;
        this.isReset = false;
        this.isExpired = false;
        this.remainingGraceLogins = -1;
        this.isLocked = false;
        this.secondsBeforeUnlock = 0;
    }

    public AccountUsableResponseControl(String oid, boolean isCritical, int secondsBeforeExpiration) {
        super(oid, isCritical, AccountUsableResponseControl.encodeValue(secondsBeforeExpiration));
        this.secondsBeforeExpiration = secondsBeforeExpiration;
        this.isUsable = true;
        this.isInactive = false;
        this.isReset = false;
        this.isExpired = false;
        this.remainingGraceLogins = -1;
        this.isLocked = false;
        this.secondsBeforeUnlock = 0;
    }

    public AccountUsableResponseControl(boolean isInactive, boolean isReset, boolean isExpired, int remainingGraceLogins, boolean isLocked, int secondsBeforeUnlock) {
        super("1.3.6.1.4.1.42.2.27.9.5.8", false, AccountUsableResponseControl.encodeValue(isInactive, isReset, isExpired, remainingGraceLogins, isLocked, secondsBeforeUnlock));
        this.isInactive = isInactive;
        this.isReset = isReset;
        this.isExpired = isExpired;
        this.remainingGraceLogins = remainingGraceLogins;
        this.isLocked = isLocked;
        this.secondsBeforeUnlock = secondsBeforeUnlock;
        this.isUsable = false;
        this.secondsBeforeExpiration = -1;
    }

    public AccountUsableResponseControl(String oid, boolean isCritical, boolean isInactive, boolean isReset, boolean isExpired, int remainingGraceLogins, boolean isLocked, int secondsBeforeUnlock) {
        super(oid, isCritical, AccountUsableResponseControl.encodeValue(isInactive, isReset, isExpired, remainingGraceLogins, isLocked, secondsBeforeUnlock));
        this.isInactive = isInactive;
        this.isReset = isReset;
        this.isExpired = isExpired;
        this.remainingGraceLogins = remainingGraceLogins;
        this.isLocked = isLocked;
        this.secondsBeforeUnlock = secondsBeforeUnlock;
        this.isUsable = false;
        this.secondsBeforeExpiration = -1;
    }

    private AccountUsableResponseControl(String oid, boolean isCritical, boolean isAvailable, int secondsBeforeExpiration, boolean isInactive, boolean isReset, boolean isExpired, int remainingGraceLogins, boolean isLocked, int secondsBeforeUnlock, ASN1OctetString encodedValue) {
        super(oid, isCritical, encodedValue);
        this.isUsable = isAvailable;
        this.secondsBeforeExpiration = secondsBeforeExpiration;
        this.isInactive = isInactive;
        this.isReset = isReset;
        this.isExpired = isExpired;
        this.remainingGraceLogins = remainingGraceLogins;
        this.isLocked = isLocked;
        this.secondsBeforeUnlock = secondsBeforeUnlock;
    }

    private static ASN1OctetString encodeValue(int secondsBeforeExpiration) {
        ASN1Integer sbeInteger = new ASN1Integer(-128, secondsBeforeExpiration);
        return new ASN1OctetString(sbeInteger.encode());
    }

    private static ASN1OctetString encodeValue(boolean isInactive, boolean isReset, boolean isExpired, int remainingGraceLogins, boolean isLocked, int secondsBeforeUnlock) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(5);
        if (isInactive) {
            elements.add(new ASN1Boolean(-128, true));
        }
        if (isReset) {
            elements.add(new ASN1Boolean(-127, true));
        }
        if (isExpired) {
            elements.add(new ASN1Boolean(-126, true));
            if (remainingGraceLogins >= 0) {
                elements.add(new ASN1Integer(-125, remainingGraceLogins));
            }
        }
        if (isLocked) {
            elements.add(new ASN1Integer(-124, secondsBeforeUnlock));
        }
        ASN1Sequence moreInfoSequence = new ASN1Sequence(-95, elements);
        return new ASN1OctetString(moreInfoSequence.encode());
    }

    public static AccountUsableResponseControl decodeControl(Control control) throws LDAPException {
        ASN1OctetString controlValue = control.getValue();
        if (controlValue == null) {
            int msgID = 2359672;
            String message = MessageHandler.getMessage(msgID);
            throw new LDAPException(2, msgID, message);
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(controlValue.value());
            switch (valueElement.getType()) {
                case -128: {
                    int secondsBeforeExpiration = valueElement.decodeAsInteger().intValue();
                    return new AccountUsableResponseControl(control.getOID(), control.isCritical(), true, secondsBeforeExpiration, false, false, false, -1, false, 0, controlValue);
                }
                case -95: {
                    boolean isInactive = false;
                    boolean isReset = false;
                    boolean isExpired = false;
                    boolean isLocked = false;
                    int remainingGraceLogins = -1;
                    int secondsBeforeUnlock = 0;
                    block15: for (ASN1Element e : valueElement.decodeAsSequence().elements()) {
                        switch (e.getType()) {
                            case -128: {
                                isInactive = e.decodeAsBoolean().booleanValue();
                                continue block15;
                            }
                            case -127: {
                                isReset = e.decodeAsBoolean().booleanValue();
                                continue block15;
                            }
                            case -126: {
                                isExpired = e.decodeAsBoolean().booleanValue();
                                continue block15;
                            }
                            case -125: {
                                remainingGraceLogins = e.decodeAsInteger().intValue();
                                continue block15;
                            }
                            case -124: {
                                isLocked = true;
                                secondsBeforeUnlock = e.decodeAsInteger().intValue();
                                continue block15;
                            }
                        }
                        int msgID = 2359673;
                        String message = MessageHandler.getMessage(msgID, StaticUtils.byteToHex(e.getType()));
                        throw new LDAPException(2, msgID, message);
                    }
                    return new AccountUsableResponseControl(control.getOID(), control.isCritical(), false, -1, isInactive, isReset, isExpired, remainingGraceLogins, isLocked, secondsBeforeUnlock, controlValue);
                }
            }
            int msgID = 2359674;
            String message = MessageHandler.getMessage(msgID, StaticUtils.byteToHex(valueElement.getType()));
            throw new LDAPException(2, msgID, message);
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (ASN1Exception ae) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ae);
            }
            int msgID = 2359675;
            String message = MessageHandler.getMessage(msgID, ae.getMessage());
            throw new LDAPException(2, msgID, message);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2359675;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new LDAPException(2, msgID, message);
        }
    }

    public boolean isUsable() {
        return this.isUsable;
    }

    public int getSecondsBeforeExpiration() {
        return this.secondsBeforeExpiration;
    }

    public boolean isInactive() {
        return this.isInactive;
    }

    public boolean isReset() {
        return this.isReset;
    }

    public boolean isExpired() {
        return this.isExpired;
    }

    public int getRemainingGraceLogins() {
        return this.remainingGraceLogins;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public int getSecondsBeforeUnlock() {
        return this.secondsBeforeUnlock;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("AccountUsableResponseControl(isUsable=");
        buffer.append(this.isUsable);
        if (this.isUsable) {
            buffer.append(",secondsBeforeExpiration=");
            buffer.append(this.secondsBeforeExpiration);
        } else {
            buffer.append(",isInactive=");
            buffer.append(this.isInactive);
            buffer.append(",isReset=");
            buffer.append(this.isReset);
            buffer.append(",isExpired=");
            buffer.append(this.isExpired);
            buffer.append(",remainingGraceLogins=");
            buffer.append(this.remainingGraceLogins);
            buffer.append(",isLocked=");
            buffer.append(this.isLocked);
            buffer.append(",secondsBeforeUnlock=");
            buffer.append(this.secondsBeforeUnlock);
        }
        buffer.append(")");
    }
}

