/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.config;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanParameterInfo;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigConstants;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiChoiceConfigAttribute
extends ConfigAttribute {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private List<String> activeValues;
    private List<String> pendingValues;
    private Set<String> allowedValues;

    public MultiChoiceConfigAttribute(String name, String description, boolean isRequired, boolean isMultiValued, boolean requiresAdminAction, Set<String> allowedValues) {
        super(name, description, isRequired, isMultiValued, requiresAdminAction);
        this.allowedValues = allowedValues;
        this.activeValues = new ArrayList<String>();
        this.pendingValues = this.activeValues;
    }

    public MultiChoiceConfigAttribute(String name, String description, boolean isRequired, boolean isMultiValued, boolean requiresAdminAction, Set<String> allowedValues, String value) {
        super(name, description, isRequired, isMultiValued, requiresAdminAction, MultiChoiceConfigAttribute.getValueSet(value));
        this.allowedValues = allowedValues;
        if (value == null) {
            this.activeValues = new ArrayList<String>();
        } else {
            this.activeValues = new ArrayList<String>(1);
            this.activeValues.add(value);
        }
        this.pendingValues = this.activeValues;
    }

    public MultiChoiceConfigAttribute(String name, String description, boolean isRequired, boolean isMultiValued, boolean requiresAdminAction, Set<String> allowedValues, List<String> values) {
        super(name, description, isRequired, isMultiValued, requiresAdminAction, MultiChoiceConfigAttribute.getValueSet(values));
        this.allowedValues = allowedValues;
        if (values == null) {
            this.activeValues = new ArrayList<String>();
            this.pendingValues = this.activeValues;
        } else {
            this.activeValues = values;
            this.pendingValues = this.activeValues;
        }
    }

    public MultiChoiceConfigAttribute(String name, String description, boolean isRequired, boolean isMultiValued, boolean requiresAdminAction, Set<String> allowedValues, List<String> activeValues, List<String> pendingValues) {
        super(name, description, isRequired, isMultiValued, requiresAdminAction, MultiChoiceConfigAttribute.getValueSet(activeValues), pendingValues != null, MultiChoiceConfigAttribute.getValueSet(pendingValues));
        this.allowedValues = allowedValues;
        this.activeValues = activeValues == null ? new ArrayList<String>() : activeValues;
        this.pendingValues = pendingValues == null ? this.activeValues : pendingValues;
    }

    @Override
    public String getDataType() {
        return "MultiChoice";
    }

    @Override
    public AttributeSyntax getSyntax() {
        return DirectoryServer.getDefaultStringSyntax();
    }

    public String activeValue() throws ConfigException {
        if (this.activeValues == null || this.activeValues.isEmpty()) {
            int msgID = 0x33000F;
            String message = MessageHandler.getMessage(msgID, this.getName());
            throw new ConfigException(msgID, message);
        }
        if (this.activeValues.size() > 1) {
            int msgID = 0x330010;
            String message = MessageHandler.getMessage(msgID, this.getName());
            throw new ConfigException(msgID, message);
        }
        return this.activeValues.get(0);
    }

    public List<String> activeValues() {
        return this.activeValues;
    }

    public String pendingValue() throws ConfigException {
        if (!this.hasPendingValues()) {
            return this.activeValue();
        }
        if (this.pendingValues == null || this.pendingValues.isEmpty()) {
            int msgID = 0x33000F;
            String message = MessageHandler.getMessage(msgID, this.getName());
            throw new ConfigException(msgID, message);
        }
        if (this.pendingValues.size() > 1) {
            int msgID = 0x330010;
            String message = MessageHandler.getMessage(msgID, this.getName());
            throw new ConfigException(msgID, message);
        }
        return this.pendingValues.get(0);
    }

    public List<String> pendingValues() {
        if (!this.hasPendingValues()) {
            return this.activeValues;
        }
        return this.pendingValues;
    }

    public Set<String> allowedValues() {
        return this.allowedValues;
    }

    public void setValue(String value) throws ConfigException {
        if (value == null || value.length() == 0) {
            int msgID = 0x330011;
            String message = MessageHandler.getMessage(msgID, this.getName());
            throw new ConfigException(msgID, message);
        }
        if (!this.allowedValues.contains(value.toLowerCase())) {
            int msgID = 3342354;
            String message = MessageHandler.getMessage(msgID, value, this.getName());
            throw new ConfigException(msgID, message);
        }
        if (this.requiresAdminAction()) {
            this.pendingValues = new ArrayList<String>(1);
            this.pendingValues.add(value);
            this.setPendingValues(MultiChoiceConfigAttribute.getValueSet(value));
        } else {
            this.activeValues.clear();
            this.activeValues.add(value);
            this.pendingValues = this.activeValues;
            this.setActiveValues(MultiChoiceConfigAttribute.getValueSet(value));
        }
    }

    public void setValues(List<String> values) throws ConfigException {
        if (values == null || values.isEmpty()) {
            if (this.isRequired()) {
                int msgID = 0x330001;
                String message = MessageHandler.getMessage(msgID, this.getName());
                throw new ConfigException(msgID, message);
            }
            if (this.requiresAdminAction()) {
                this.setPendingValues(new LinkedHashSet<AttributeValue>(0));
                this.pendingValues = new ArrayList<String>();
            } else {
                this.setActiveValues(new LinkedHashSet<AttributeValue>(0));
                this.activeValues.clear();
            }
        }
        int numValues = values.size();
        if (!this.isMultiValued() && numValues > 1) {
            int msgID = 0x330003;
            String message = MessageHandler.getMessage(msgID, this.getName());
            throw new ConfigException(msgID, message);
        }
        LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>(numValues);
        for (String value : values) {
            if (value == null || value.length() == 0) {
                int msgID = 0x330011;
                String message = MessageHandler.getMessage(msgID, this.getName());
                throw new ConfigException(msgID, message);
            }
            if (!this.allowedValues.contains(value.toLowerCase())) {
                int msgID = 3342354;
                String message = MessageHandler.getMessage(msgID, value, this.getName());
                throw new ConfigException(msgID, message);
            }
            AttributeValue attrValue = new AttributeValue(new ASN1OctetString(value), (ByteString)new ASN1OctetString(value));
            if (valueSet.contains(attrValue)) {
                int msgID = 0x330005;
                String message = MessageHandler.getMessage(msgID, this.getName(), value);
                throw new ConfigException(msgID, message);
            }
            valueSet.add(attrValue);
        }
        if (this.requiresAdminAction()) {
            this.pendingValues = values;
            this.setPendingValues(valueSet);
        } else {
            this.activeValues = values;
            this.pendingValues = this.activeValues;
            this.setActiveValues(valueSet);
        }
    }

    private static LinkedHashSet<AttributeValue> getValueSet(String value) {
        LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>(1);
        valueSet.add(new AttributeValue(new ASN1OctetString(value), (ByteString)new ASN1OctetString(value)));
        return valueSet;
    }

    private static LinkedHashSet<AttributeValue> getValueSet(List<String> values) {
        if (values == null) {
            return null;
        }
        LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>(values.size());
        for (String value : values) {
            valueSet.add(new AttributeValue(new ASN1OctetString(value), (ByteString)new ASN1OctetString(value)));
        }
        return valueSet;
    }

    @Override
    public void applyPendingValues() {
        if (!this.hasPendingValues()) {
            return;
        }
        super.applyPendingValues();
        this.activeValues = this.pendingValues;
    }

    @Override
    public boolean valueIsAcceptable(AttributeValue value, StringBuilder rejectReason) {
        String stringValue;
        if (value == null || (stringValue = value.getStringValue()).length() == 0) {
            rejectReason.append(MessageHandler.getMessage(0x330011, this.getName()));
            return false;
        }
        if (!this.allowedValues.contains(stringValue.toLowerCase())) {
            rejectReason.append(MessageHandler.getMessage(3342354, stringValue, this.getName()));
            return false;
        }
        return true;
    }

    @Override
    public LinkedHashSet<AttributeValue> stringsToValues(List<String> valueStrings, boolean allowFailures) throws ConfigException {
        if (valueStrings == null || valueStrings.isEmpty()) {
            if (this.isRequired()) {
                int msgID = 0x330001;
                String message = MessageHandler.getMessage(msgID, this.getName());
                throw new ConfigException(msgID, message);
            }
            return new LinkedHashSet<AttributeValue>();
        }
        int numValues = valueStrings.size();
        if (!this.isMultiValued() && numValues > 1) {
            int msgID = 0x330003;
            String message = MessageHandler.getMessage(msgID, this.getName());
            throw new ConfigException(msgID, message);
        }
        LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>(numValues);
        for (String valueString : valueStrings) {
            String message;
            int msgID;
            if (valueString == null || valueString.length() == 0) {
                msgID = 0x330011;
                message = MessageHandler.getMessage(msgID, this.getName());
                if (allowFailures) {
                    ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, message, msgID);
                    continue;
                }
                throw new ConfigException(msgID, message);
            }
            if (!this.allowedValues.contains(valueString.toLowerCase())) {
                msgID = 3342354;
                message = MessageHandler.getMessage(msgID, valueString, this.getName());
                if (allowFailures) {
                    ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, message, msgID);
                    continue;
                }
                throw new ConfigException(msgID, message);
            }
            valueSet.add(new AttributeValue(new ASN1OctetString(valueString), (ByteString)new ASN1OctetString(valueString)));
        }
        if (this.isRequired() && valueSet.isEmpty()) {
            int msgID = 0x330001;
            String message = MessageHandler.getMessage(msgID, this.getName());
            throw new ConfigException(msgID, message);
        }
        return valueSet;
    }

    @Override
    public List<String> activeValuesToStrings() {
        return this.activeValues;
    }

    @Override
    public List<String> pendingValuesToStrings() {
        if (this.hasPendingValues()) {
            return this.pendingValues;
        }
        return null;
    }

    @Override
    public ConfigAttribute getConfigAttribute(List<Attribute> attributeList) throws ConfigException {
        ArrayList<String> activeValues = null;
        ArrayList<String> pendingValues = null;
        for (Attribute a : attributeList) {
            String lowerValue;
            String message;
            int numValues;
            String message2;
            int msgID;
            LinkedHashSet<AttributeValue> values;
            if (a.hasOptions()) {
                if (a.hasOption("pending")) {
                    if (pendingValues != null) {
                        int msgID2 = 0x330040;
                        String message3 = MessageHandler.getMessage(msgID2, a.getName());
                        throw new ConfigException(msgID2, message3);
                    }
                    values = a.getValues();
                    if (values.isEmpty()) {
                        if (this.isRequired()) {
                            msgID = 0x330001;
                            message2 = MessageHandler.getMessage(msgID, a.getName());
                            throw new ConfigException(msgID, message2);
                        }
                        pendingValues = new ArrayList(0);
                        continue;
                    }
                    numValues = values.size();
                    if (numValues > 1 && !this.isMultiValued()) {
                        int msgID3 = 0x330003;
                        message = MessageHandler.getMessage(msgID3, a.getName());
                        throw new ConfigException(msgID3, message);
                    }
                    pendingValues = new ArrayList(numValues);
                    for (AttributeValue v : values) {
                        lowerValue = v.getStringValue().toLowerCase();
                        if (!this.allowedValues.contains(lowerValue)) {
                            int msgID4 = 3342354;
                            String message4 = MessageHandler.getMessage(msgID4, v.getStringValue(), a.getName());
                            throw new ConfigException(msgID4, message4);
                        }
                        pendingValues.add(v.getStringValue());
                    }
                    continue;
                }
                int msgID5 = 3342366;
                String message5 = MessageHandler.getMessage(msgID5, a.getName());
                throw new ConfigException(msgID5, message5);
            }
            if (activeValues != null) {
                int msgID6 = 3342401;
                String message6 = MessageHandler.getMessage(msgID6, a.getName());
                throw new ConfigException(msgID6, message6);
            }
            values = a.getValues();
            if (values.isEmpty()) {
                if (this.isRequired()) {
                    msgID = 0x330001;
                    message2 = MessageHandler.getMessage(msgID, a.getName());
                    throw new ConfigException(msgID, message2);
                }
                activeValues = new ArrayList<String>(0);
                continue;
            }
            numValues = values.size();
            if (numValues > 1 && !this.isMultiValued()) {
                int msgID7 = 0x330003;
                message = MessageHandler.getMessage(msgID7, a.getName());
                throw new ConfigException(msgID7, message);
            }
            activeValues = new ArrayList(numValues);
            for (AttributeValue v : values) {
                lowerValue = v.getStringValue().toLowerCase();
                if (!this.allowedValues.contains(lowerValue)) {
                    int msgID8 = 3342354;
                    String message7 = MessageHandler.getMessage(msgID8, v.getStringValue(), a.getName());
                    throw new ConfigException(msgID8, message7);
                }
                activeValues.add(v.getStringValue());
            }
        }
        if (activeValues == null) {
            int msgID = 3342402;
            String message = MessageHandler.getMessage(msgID, this.getName());
            throw new ConfigException(msgID, message);
        }
        if (pendingValues == null) {
            pendingValues = activeValues;
        }
        return new MultiChoiceConfigAttribute(this.getName(), this.getDescription(), this.isRequired(), this.isMultiValued(), this.requiresAdminAction(), this.allowedValues, activeValues, pendingValues);
    }

    private javax.management.Attribute _toJMXAttribute(boolean pending) {
        String name;
        List<String> requestedValues;
        if (pending) {
            requestedValues = this.pendingValues;
            name = this.getName() + ";" + "pending";
        } else {
            requestedValues = this.activeValues;
            name = this.getName();
        }
        if (this.isMultiValued()) {
            String[] values = new String[requestedValues.size()];
            requestedValues.toArray(values);
            return new javax.management.Attribute(name, values);
        }
        if (requestedValues.isEmpty()) {
            return null;
        }
        return new javax.management.Attribute(name, requestedValues.get(0));
    }

    @Override
    public javax.management.Attribute toJMXAttribute() {
        return this._toJMXAttribute(false);
    }

    @Override
    public javax.management.Attribute toJMXAttributePending() {
        return this._toJMXAttribute(true);
    }

    @Override
    public void toJMXAttribute(AttributeList attributeList) {
        if (this.activeValues.size() > 0) {
            if (this.isMultiValued()) {
                String[] values = new String[this.activeValues.size()];
                this.activeValues.toArray(values);
                attributeList.add(new javax.management.Attribute(this.getName(), values));
            } else {
                attributeList.add(new javax.management.Attribute(this.getName(), this.activeValues.get(0)));
            }
        } else if (this.isMultiValued()) {
            attributeList.add(new javax.management.Attribute(this.getName(), new String[0]));
        } else {
            attributeList.add(new javax.management.Attribute(this.getName(), null));
        }
        if (this.requiresAdminAction() && this.pendingValues != null && this.pendingValues != this.activeValues) {
            String name = this.getName() + ";" + "pending";
            if (this.isMultiValued()) {
                String[] values = new String[this.pendingValues.size()];
                this.pendingValues.toArray(values);
                attributeList.add(new javax.management.Attribute(name, values));
            } else if (!this.pendingValues.isEmpty()) {
                attributeList.add(new javax.management.Attribute(name, this.pendingValues.get(0)));
            }
        }
    }

    @Override
    public void toJMXAttributeInfo(List<MBeanAttributeInfo> attributeInfoList) {
        if (this.isMultiValued()) {
            attributeInfoList.add(new MBeanAttributeInfo(this.getName(), ConfigConstants.JMX_TYPE_STRING_ARRAY, this.getDescription(), true, true, false));
        } else {
            attributeInfoList.add(new MBeanAttributeInfo(this.getName(), String.class.getName(), this.getDescription(), true, true, false));
        }
        if (this.requiresAdminAction()) {
            String name = this.getName() + ";" + "pending";
            if (this.isMultiValued()) {
                attributeInfoList.add(new MBeanAttributeInfo(name, ConfigConstants.JMX_TYPE_STRING_ARRAY, this.getDescription(), true, false, false));
            } else {
                attributeInfoList.add(new MBeanAttributeInfo(name, String.class.getName(), this.getDescription(), true, false, false));
            }
        }
    }

    @Override
    public MBeanParameterInfo toJMXParameterInfo() {
        if (this.isMultiValued()) {
            return new MBeanParameterInfo(this.getName(), ConfigConstants.JMX_TYPE_STRING_ARRAY, this.getDescription());
        }
        return new MBeanParameterInfo(this.getName(), String.class.getName(), this.getDescription());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setValue(javax.management.Attribute jmxAttribute) throws ConfigException {
        Object value = jmxAttribute.getValue();
        if (value instanceof String) {
            this.setValue((String)value);
            return;
        }
        if (!value.getClass().isArray()) {
            int msgID = 3342406;
            String message = MessageHandler.getMessage(msgID, String.valueOf(value), this.getName(), value.getClass().getName());
            throw new ConfigException(msgID, message);
        }
        String componentType = value.getClass().getComponentType().getName();
        int length = Array.getLength(value);
        if (!componentType.equals(String.class.getName())) {
            int msgID = 3342407;
            String message = MessageHandler.getMessage(msgID, componentType);
            throw new ConfigException(msgID, message);
        }
        try {
            ArrayList<String> values = new ArrayList<String>(length);
            int i = 0;
            while (true) {
                if (i >= length) {
                    this.setValues(values);
                    return;
                }
                values.add((String)Array.get(value, i));
                ++i;
            }
        }
        catch (ConfigException ce) {
            if (!DebugLogger.debugEnabled()) throw ce;
            TRACER.debugCaught(DebugLogLevel.ERROR, ce);
            throw ce;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 3342405;
            String message = MessageHandler.getMessage(msgID, this.getName(), String.valueOf(value), String.valueOf(e));
            throw new ConfigException(msgID, message, e);
        }
    }

    @Override
    public ConfigAttribute duplicate() {
        return new MultiChoiceConfigAttribute(this.getName(), this.getDescription(), this.isRequired(), this.isMultiValued(), this.requiresAdminAction(), this.allowedValues, this.activeValues, this.pendingValues);
    }
}

