/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TaskState {
    UNSCHEDULED,
    DISABLED,
    WAITING_ON_START_TIME,
    WAITING_ON_DEPENDENCY,
    RUNNING,
    COMPLETED_SUCCESSFULLY,
    COMPLETED_WITH_ERRORS,
    STOPPED_BY_SHUTDOWN,
    STOPPED_BY_ERROR,
    STOPPED_BY_ADMINISTRATOR,
    CANCELED_BEFORE_STARTING;


    public static boolean isPending(TaskState taskState) {
        switch (taskState) {
            case UNSCHEDULED: 
            case WAITING_ON_START_TIME: 
            case WAITING_ON_DEPENDENCY: {
                return true;
            }
        }
        return false;
    }

    public static boolean isRunning(TaskState taskState) {
        switch (taskState) {
            case RUNNING: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDone(TaskState taskState) {
        switch (taskState) {
            case UNSCHEDULED: 
            case WAITING_ON_START_TIME: 
            case WAITING_ON_DEPENDENCY: 
            case RUNNING: {
                return false;
            }
        }
        return true;
    }

    public static boolean isSuccessful(TaskState taskState) {
        switch (taskState) {
            case WAITING_ON_START_TIME: 
            case WAITING_ON_DEPENDENCY: 
            case RUNNING: {
                return false;
            }
        }
        return true;
    }

    public static TaskState fromString(String s) {
        String lowerString = s.toLowerCase();
        if (lowerString.equals("unscheduled")) {
            return UNSCHEDULED;
        }
        if (lowerString.equals("disabled")) {
            return DISABLED;
        }
        if (lowerString.equals("waiting_on_start_time")) {
            return WAITING_ON_START_TIME;
        }
        if (lowerString.equals("waiting_on_dependency")) {
            return WAITING_ON_DEPENDENCY;
        }
        if (lowerString.equals("running")) {
            return RUNNING;
        }
        if (lowerString.equals("completed_successfully")) {
            return COMPLETED_SUCCESSFULLY;
        }
        if (lowerString.equals("completed_with_errors")) {
            return COMPLETED_WITH_ERRORS;
        }
        if (lowerString.equals("stopped_by_shutdown")) {
            return STOPPED_BY_SHUTDOWN;
        }
        if (lowerString.equals("stopped_by_error")) {
            return STOPPED_BY_ERROR;
        }
        if (lowerString.equals("stopped_by_administrator")) {
            return STOPPED_BY_ADMINISTRATOR;
        }
        if (lowerString.equals("canceled_before_starting")) {
            return CANCELED_BEFORE_STARTING;
        }
        return null;
    }
}

