/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.task;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.DirectoryThread;
import org.opends.server.backends.task.RecurringTask;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskBackend;
import org.opends.server.backends.task.TaskState;
import org.opends.server.backends.task.TaskThread;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LockManager;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskScheduler
extends DirectoryThread
implements AlertGenerator {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.backends.task.TaskScheduler";
    private static long MAX_SLEEP_TIME = 5000L;
    private boolean isRunning;
    private boolean stopRequested;
    private Entry recurringTaskParentEntry;
    private Entry scheduledTaskParentEntry;
    private Entry taskRootEntry;
    private HashMap<String, RecurringTask> recurringTasks;
    private HashMap<String, Task> tasks;
    private HashMap<String, TaskThread> activeThreads;
    private int nextThreadID;
    private LinkedList<TaskThread> idleThreads;
    private ReentrantLock schedulerLock;
    private TaskBackend taskBackend;
    private Thread schedulerThread;
    private TreeSet<Task> completedTasks;
    private TreeSet<Task> pendingTasks;
    private TreeSet<Task> runningTasks;

    public TaskScheduler(TaskBackend taskBackend) throws InitializationException {
        super("Task Scheduler Thread");
        this.taskBackend = taskBackend;
        this.schedulerLock = new ReentrantLock();
        this.isRunning = false;
        this.stopRequested = false;
        this.schedulerThread = null;
        this.nextThreadID = 1;
        this.recurringTasks = new HashMap();
        this.tasks = new HashMap();
        this.activeThreads = new HashMap();
        this.idleThreads = new LinkedList();
        this.completedTasks = new TreeSet();
        this.pendingTasks = new TreeSet();
        this.runningTasks = new TreeSet();
        this.taskRootEntry = null;
        this.recurringTaskParentEntry = null;
        this.scheduledTaskParentEntry = null;
        DirectoryServer.registerAlertGenerator(this);
        this.initializeTasksFromBackingFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecurringTask(RecurringTask recurringTask, boolean scheduleIteration) throws DirectoryException {
        this.schedulerLock.lock();
        try {
            Task task;
            String id = recurringTask.getRecurringTaskID();
            if (this.recurringTasks.containsKey(id)) {
                int msgID = 9699461;
                String message = MessageHandler.getMessage(msgID, String.valueOf(id));
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, message, msgID);
            }
            this.recurringTasks.put(id, recurringTask);
            if (scheduleIteration && (task = recurringTask.scheduleNextIteration()) != null) {
                this.scheduleTask(task, false);
            }
            this.writeState();
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecurringTask removeRecurringTask(String recurringTaskID) throws DirectoryException {
        this.schedulerLock.lock();
        try {
            for (Task t : this.tasks.values()) {
                if (t.getRecurringTaskID() == null || !t.getRecurringTaskID().equals(recurringTaskID) || TaskState.isDone(t.getTaskState())) continue;
                int msgID = 9699488;
                String message = MessageHandler.getMessage(msgID, String.valueOf(recurringTaskID), String.valueOf(t.getTaskID()));
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
            }
            RecurringTask recurringTask = this.recurringTasks.remove(recurringTaskID);
            this.writeState();
            RecurringTask recurringTask2 = recurringTask;
            return recurringTask2;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTask(Task task, boolean writeState) throws DirectoryException {
        this.schedulerLock.lock();
        try {
            String id = task.getTaskID();
            if (this.tasks.containsKey(id)) {
                int msgID = 9699462;
                String message = MessageHandler.getMessage(msgID, String.valueOf(id));
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, message, msgID);
            }
            this.tasks.put(id, task);
            TaskState state = this.shouldStart(task);
            task.setTaskState(state);
            if (state == TaskState.RUNNING) {
                TaskThread taskThread;
                if (this.idleThreads.isEmpty()) {
                    taskThread = new TaskThread(this, this.nextThreadID++);
                    taskThread.start();
                } else {
                    taskThread = this.idleThreads.removeFirst();
                }
                this.runningTasks.add(task);
                this.activeThreads.put(task.getTaskID(), taskThread);
                taskThread.setTask(task);
            } else {
                this.pendingTasks.add(task);
            }
            if (writeState) {
                this.writeState();
            }
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task cancelTask(String taskID) {
        this.schedulerLock.lock();
        try {
            Task t = this.tasks.get(taskID);
            if (t == null) {
                Task task = null;
                return task;
            }
            if (TaskState.isPending(t.getTaskState())) {
                this.pendingTasks.remove(t);
                t.setTaskState(TaskState.CANCELED_BEFORE_STARTING);
                this.addCompletedTask(t);
                this.writeState();
            }
            Task task = t;
            return task;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    public Task removePendingTask(String taskID) throws DirectoryException {
        this.schedulerLock.lock();
        try {
            Task t = this.tasks.get(taskID);
            if (t == null) {
                int msgID = 9699489;
                String message = MessageHandler.getMessage(msgID, String.valueOf(taskID));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID);
            }
            if (TaskState.isPending(t.getTaskState())) {
                this.tasks.remove(taskID);
                this.pendingTasks.remove(t);
                this.writeState();
                Task msgID = t;
                return msgID;
            }
            int msgID = 9699490;
            String message = MessageHandler.getMessage(msgID, String.valueOf(taskID));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    public Task removeCompletedTask(String taskID) throws DirectoryException {
        this.schedulerLock.lock();
        try {
            Iterator<Task> iterator = this.completedTasks.iterator();
            while (iterator.hasNext()) {
                Task t = iterator.next();
                if (!t.getTaskID().equals(taskID)) continue;
                iterator.remove();
                this.tasks.remove(taskID);
                this.writeState();
                Task task = t;
                return task;
            }
            int msgID = 9699491;
            String message = MessageHandler.getMessage(msgID, String.valueOf(taskID));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID);
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean threadDone(TaskThread taskThread, Task completedTask) {
        this.schedulerLock.lock();
        try {
            this.addCompletedTask(completedTask);
            String taskID = completedTask.getTaskID();
            if (this.activeThreads.remove(taskID) == null) {
                boolean bl = false;
                return bl;
            }
            String recurringTaskID = completedTask.getRecurringTaskID();
            if (recurringTaskID != null) {
                RecurringTask recurringTask = this.recurringTasks.get(recurringTaskID);
                if (recurringTask == null) {
                    int msgID = 9699463;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(taskID), String.valueOf(recurringTaskID));
                    ErrorLogger.logError(ErrorLogCategory.TASK, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                    DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotFindRecurringTask", msgID, message);
                } else {
                    Task newIteration = recurringTask.scheduleNextIteration();
                    if (newIteration != null) {
                        try {
                            this.scheduleTask(newIteration, false);
                        }
                        catch (DirectoryException de) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, de);
                            }
                            int msgID = 9699464;
                            String message = MessageHandler.getMessage(msgID, recurringTaskID, de.getErrorMessage());
                            ErrorLogger.logError(ErrorLogCategory.TASK, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                            DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotScheduleRecurringIteration", msgID, message);
                        }
                    }
                }
            }
            this.writeState();
            if (this.isRunning) {
                this.idleThreads.add(taskThread);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompletedTask(Task completedTask) {
        this.schedulerLock.lock();
        try {
            this.completedTasks.add(completedTask);
            this.runningTasks.remove(completedTask);
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    public void stopScheduler() {
        block6: {
            block5: {
                this.stopRequested = true;
                try {
                    this.schedulerThread.interrupt();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block5;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            try {
                this.schedulerThread.join();
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block6;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        this.pendingTasks.clear();
        this.runningTasks.clear();
        this.completedTasks.clear();
        this.tasks.clear();
        for (TaskThread thread : this.idleThreads) {
            int msgID = 0x90009C;
            String message = MessageHandler.getMessage(msgID);
            thread.interruptTask(TaskState.STOPPED_BY_SHUTDOWN, message, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptRunningTasks(TaskState interruptState, String interruptReason, boolean waitForStop) {
        LinkedList<TaskThread> threadList = new LinkedList<TaskThread>();
        this.schedulerLock.lock();
        try {
            threadList.addAll(this.activeThreads.values());
        }
        finally {
            this.schedulerLock.unlock();
        }
        for (TaskThread t : threadList) {
            try {
                t.interruptTask(interruptState, interruptReason, true);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        if (waitForStop) {
            for (TaskThread t : threadList) {
                try {
                    t.join();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block19: {
            this.isRunning = true;
            this.schedulerThread = TaskScheduler.currentThread();
            block8: while (true) {
                while (!this.stopRequested) {
                    this.schedulerLock.lock();
                    boolean writeState = false;
                    long sleepTime = MAX_SLEEP_TIME;
                    try {
                        Iterator<Task> iterator = this.pendingTasks.iterator();
                        while (iterator.hasNext()) {
                            Task t = iterator.next();
                            TaskState state = this.shouldStart(t);
                            if (state == TaskState.RUNNING) {
                                TaskThread taskThread;
                                if (this.idleThreads.isEmpty()) {
                                    taskThread = new TaskThread(this, this.nextThreadID++);
                                    taskThread.start();
                                } else {
                                    taskThread = this.idleThreads.removeFirst();
                                }
                                this.runningTasks.add(t);
                                this.activeThreads.put(t.getTaskID(), taskThread);
                                taskThread.setTask(t);
                                iterator.remove();
                                writeState = true;
                            } else if (state == TaskState.WAITING_ON_START_TIME) {
                                long waitTime = t.getScheduledStartTime() - TimeThread.getTime();
                                sleepTime = Math.min(sleepTime, waitTime);
                            }
                            if (state == t.getTaskState()) continue;
                            t.setTaskState(state);
                            writeState = true;
                        }
                        long oldestRetainedCompletionTime = TimeThread.getTime() - this.taskBackend.getRetentionTime();
                        iterator = this.completedTasks.iterator();
                        while (iterator.hasNext()) {
                            Task t = iterator.next();
                            if (t.getCompletionTime() >= oldestRetainedCompletionTime) continue;
                            iterator.remove();
                            writeState = true;
                        }
                        if (writeState) {
                            this.writeState();
                        }
                    }
                    finally {
                        this.schedulerLock.unlock();
                    }
                    try {
                        if (sleepTime <= 0L) continue block8;
                        Thread.sleep(sleepTime);
                        continue block8;
                    }
                    catch (InterruptedException ie) {
                    }
                }
                break block19;
                {
                    continue block8;
                    break;
                }
                break;
            }
            finally {
                this.isRunning = false;
            }
        }
    }

    private TaskState shouldStart(Task task) {
        if (!this.isRunning) {
            return TaskState.UNSCHEDULED;
        }
        if (task.getScheduledStartTime() > TimeThread.getTime()) {
            return TaskState.WAITING_ON_START_TIME;
        }
        LinkedList<String> dependencyIDs = task.getDependencyIDs();
        if (dependencyIDs != null) {
            for (String dependencyID : task.getDependencyIDs()) {
                Task t = this.tasks.get(dependencyID);
                if (t == null || TaskState.isDone(t.getTaskState())) continue;
                return TaskState.WAITING_ON_DEPENDENCY;
            }
        }
        return TaskState.RUNNING;
    }

    private void initializeTasksFromBackingFile() throws InitializationException {
        String backingFilePath = this.taskBackend.getTaskBackingFile();
        try {
            File backingFile = StaticUtils.getFileForPath(backingFilePath);
            if (!backingFile.exists()) {
                this.createNewTaskBackingFile();
                return;
            }
            LDIFImportConfig importConfig = new LDIFImportConfig(backingFilePath);
            LDIFReader ldifReader = new LDIFReader(importConfig);
            this.taskRootEntry = null;
            this.recurringTaskParentEntry = null;
            this.scheduledTaskParentEntry = null;
            while (true) {
                String message;
                String message2;
                Entry entry;
                try {
                    entry = ldifReader.readEntry();
                }
                catch (LDIFException le) {
                    String message3;
                    block24: {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, le);
                        }
                        if (le.canContinueReading()) {
                            int msgID = 9699465;
                            message3 = MessageHandler.getMessage(msgID, backingFilePath, le.getLineNumber(), le.getMessage());
                            ErrorLogger.logError(ErrorLogCategory.TASK, ErrorLogSeverity.SEVERE_ERROR, message3, msgID);
                            continue;
                        }
                        try {
                            ldifReader.close();
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) break block24;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                    int msgID = 9765002;
                    message3 = MessageHandler.getMessage(msgID, backingFilePath, le.getLineNumber(), le.getMessage());
                    throw new InitializationException(msgID, message3);
                }
                if (entry == null) break;
                DN entryDN = entry.getDN();
                if (entryDN.equals(this.taskBackend.getTaskRootDN())) {
                    this.taskRootEntry = entry;
                    continue;
                }
                if (entryDN.equals(this.taskBackend.getRecurringTasksParentDN())) {
                    this.recurringTaskParentEntry = entry;
                    continue;
                }
                if (entryDN.equals(this.taskBackend.getScheduledTasksParentDN())) {
                    this.scheduledTaskParentEntry = entry;
                    continue;
                }
                DN parentDN = entryDN.getParentDNInSuffix();
                if (parentDN == null) {
                    int msgID = 9699467;
                    message2 = MessageHandler.getMessage(msgID, String.valueOf(entryDN), String.valueOf(this.taskBackend.getTaskRootDN()));
                    ErrorLogger.logError(ErrorLogCategory.TASK, ErrorLogSeverity.SEVERE_ERROR, message2, msgID);
                    continue;
                }
                if (parentDN.equals(this.taskBackend.getRecurringTasksParentDN())) {
                    try {
                        RecurringTask recurringTask = this.entryToRecurringTask(entry);
                        this.addRecurringTask(recurringTask, false);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        int msgID = 9699468;
                        message = MessageHandler.getMessage(msgID, String.valueOf(entryDN), de.getErrorMessage());
                        ErrorLogger.logError(ErrorLogCategory.TASK, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                    }
                    continue;
                }
                if (parentDN.equals(this.taskBackend.getScheduledTasksParentDN())) {
                    try {
                        Task task = this.entryToScheduledTask(entry, null);
                        if (TaskState.isDone(task.getTaskState())) {
                            this.completedTasks.add(task);
                            continue;
                        }
                        this.scheduleTask(task, false);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        int msgID = 9699469;
                        message = MessageHandler.getMessage(msgID, String.valueOf(entryDN), de.getErrorMessage());
                        ErrorLogger.logError(ErrorLogCategory.TASK, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                    }
                    continue;
                }
                int msgID = 9699470;
                message2 = MessageHandler.getMessage(msgID, String.valueOf(entryDN), backingFilePath);
                ErrorLogger.logError(ErrorLogCategory.TASK, ErrorLogSeverity.SEVERE_ERROR, message2, msgID);
            }
            ldifReader.close();
        }
        catch (IOException ioe) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ioe);
            }
            int msgID = 9699471;
            String message = MessageHandler.getMessage(msgID, String.valueOf(backingFilePath), StaticUtils.stackTraceToSingleLineString(ioe));
            throw new InitializationException(msgID, message, ioe);
        }
    }

    private void createNewTaskBackingFile() throws InitializationException {
        String backingFile = this.taskBackend.getTaskBackingFile();
        LDIFExportConfig exportConfig = new LDIFExportConfig(backingFile, ExistingFileBehavior.OVERWRITE);
        try {
            LDIFWriter writer = new LDIFWriter(exportConfig);
            writer.writeComment(MessageHandler.getMessage(9437316), 80);
            this.taskRootEntry = StaticUtils.createEntry(this.taskBackend.getTaskRootDN());
            writer.writeEntry(this.taskRootEntry);
            this.scheduledTaskParentEntry = StaticUtils.createEntry(this.taskBackend.getScheduledTasksParentDN());
            writer.writeEntry(this.scheduledTaskParentEntry);
            this.recurringTaskParentEntry = StaticUtils.createEntry(this.taskBackend.getRecurringTasksParentDN());
            writer.writeEntry(this.recurringTaskParentEntry);
            writer.close();
        }
        catch (IOException ioe) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ioe);
            }
            int msgID = 0x940090;
            String message = MessageHandler.getMessage(msgID, backingFile, StaticUtils.stackTraceToSingleLineString(ioe));
            throw new InitializationException(msgID, message, ioe);
        }
        catch (LDIFException le) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, le);
            }
            int msgID = 0x940090;
            String message = MessageHandler.getMessage(msgID, backingFile, le.getMessage());
            throw new InitializationException(msgID, message, le);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeState() {
        String backingFilePath = this.taskBackend.getTaskBackingFile();
        String tmpFilePath = backingFilePath + ".tmp";
        LDIFExportConfig exportConfig = new LDIFExportConfig(tmpFilePath, ExistingFileBehavior.OVERWRITE);
        this.schedulerLock.lock();
        try {
            File saveFile;
            block24: {
                LDIFWriter writer = new LDIFWriter(exportConfig);
                writer.writeComment(MessageHandler.getMessage(9437316), 80);
                writer.writeEntry(this.taskRootEntry);
                writer.writeEntry(this.scheduledTaskParentEntry);
                writer.writeEntry(this.recurringTaskParentEntry);
                for (RecurringTask recurringTask : this.recurringTasks.values()) {
                    writer.writeEntry(recurringTask.getRecurringTaskEntry());
                }
                for (Task task : this.tasks.values()) {
                    writer.writeEntry(task.getTaskEntry());
                }
                writer.close();
                saveFile = StaticUtils.getFileForPath(backingFilePath + ".save");
                try {
                    if (saveFile.exists()) {
                        saveFile.delete();
                    }
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block24;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            File backingFile = StaticUtils.getFileForPath(backingFilePath);
            try {
                if (backingFile.exists()) {
                    backingFile.renameTo(saveFile);
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                int msgID = 9568408;
                String message = MessageHandler.getMessage(msgID, String.valueOf(backingFilePath), String.valueOf(saveFile.getAbsolutePath()), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(ErrorLogCategory.TASK, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotRenameCurrentTaskFile", msgID, message);
            }
            File tmpFile = StaticUtils.getFileForPath(tmpFilePath);
            try {
                tmpFile.renameTo(backingFile);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                int msgID = 0x940099;
                String message = MessageHandler.getMessage(msgID, String.valueOf(tmpFilePath), String.valueOf(backingFilePath), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(ErrorLogCategory.TASK, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotRenameNewTaskFile", msgID, message);
            }
        }
        catch (IOException ioe) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ioe);
            }
            int msgID = 9699482;
            String message = MessageHandler.getMessage(msgID, tmpFilePath, StaticUtils.stackTraceToSingleLineString(ioe));
            ErrorLogger.logError(ErrorLogCategory.TASK, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotWriteTaskFile", msgID, message);
        }
        catch (LDIFException le) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, le);
            }
            int msgID = 9699482;
            String message = MessageHandler.getMessage(msgID, tmpFilePath, le.getMessage());
            ErrorLogger.logError(ErrorLogCategory.TASK, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotWriteTaskFile", msgID, message);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 9699482;
            String message = MessageHandler.getMessage(msgID, tmpFilePath, StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(ErrorLogCategory.TASK, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotWriteTaskFile", msgID, message);
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEntryCount() {
        this.schedulerLock.lock();
        try {
            long l = this.tasks.size() + this.recurringTasks.size() + 3;
            return l;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    public TaskBackend getTaskBackend() {
        return this.taskBackend;
    }

    public Entry getTaskRootEntry() {
        return this.taskRootEntry.duplicate(true);
    }

    public Entry getScheduledTaskParentEntry() {
        return this.scheduledTaskParentEntry.duplicate(true);
    }

    public Entry getRecurringTaskParentEntry() {
        return this.recurringTaskParentEntry.duplicate(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task getScheduledTask(String taskID) {
        this.schedulerLock.lock();
        try {
            Task task = this.tasks.get(taskID);
            return task;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task getScheduledTask(DN taskEntryDN) {
        this.schedulerLock.lock();
        try {
            for (Task t : this.tasks.values()) {
                if (!taskEntryDN.equals(t.getTaskEntry().getDN())) continue;
                Task task = t;
                return task;
            }
            Task task = null;
            return task;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    boolean holdsSchedulerLock() {
        return this.schedulerLock.isHeldByCurrentThread();
    }

    Lock writeLockEntry(DN entryDN) {
        Lock lock = LockManager.lockWrite(entryDN);
        while (lock == null) {
            lock = LockManager.lockWrite(entryDN);
        }
        return lock;
    }

    Lock readLockEntry(DN entryDN) throws DirectoryException {
        Lock lock = LockManager.lockRead(entryDN);
        for (int i = 0; lock == null && i < 4; ++i) {
            lock = LockManager.lockRead(entryDN);
        }
        if (lock == null) {
            int msgID = 9764919;
            String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
        }
        return lock;
    }

    void unlockEntry(DN entryDN, Lock lock) {
        LockManager.unlock(entryDN, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getScheduledTaskEntry(DN scheduledTaskEntryDN) {
        this.schedulerLock.lock();
        try {
            for (Task task : this.tasks.values()) {
                Entry taskEntry = task.getTaskEntry();
                if (!scheduledTaskEntryDN.equals(taskEntry.getDN())) continue;
                Entry entry = taskEntry.duplicate(true);
                return entry;
            }
            Entry entry = null;
            return entry;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean searchScheduledTasks(SearchOperation searchOperation) throws DirectoryException {
        SearchFilter filter = searchOperation.getFilter();
        this.schedulerLock.lock();
        try {
            for (Task t : this.tasks.values()) {
                DN taskEntryDN = t.getTaskEntryDN();
                Lock lock = this.readLockEntry(taskEntryDN);
                try {
                    Entry e = t.getTaskEntry().duplicate(true);
                    if (!filter.matchesEntry(e) || searchOperation.returnEntry(e, null)) continue;
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.unlockEntry(taskEntryDN, lock);
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecurringTask getRecurringTask(String recurringTaskID) {
        this.schedulerLock.lock();
        try {
            RecurringTask recurringTask = this.recurringTasks.get(recurringTaskID);
            return recurringTask;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecurringTask getRecurringTask(DN recurringTaskEntryDN) {
        this.schedulerLock.lock();
        try {
            for (RecurringTask rt : this.recurringTasks.values()) {
                if (!recurringTaskEntryDN.equals(rt.getRecurringTaskEntry().getDN())) continue;
                RecurringTask recurringTask = rt;
                return recurringTask;
            }
            RecurringTask recurringTask = null;
            return recurringTask;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getRecurringTaskEntry(DN recurringTaskEntryDN) {
        this.schedulerLock.lock();
        try {
            for (RecurringTask recurringTask : this.recurringTasks.values()) {
                Entry recurringTaskEntry = recurringTask.getRecurringTaskEntry();
                if (!recurringTaskEntryDN.equals(recurringTaskEntry.getDN())) continue;
                Entry entry = recurringTaskEntry.duplicate(true);
                return entry;
            }
            Entry entry = null;
            return entry;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean searchRecurringTasks(SearchOperation searchOperation) throws DirectoryException {
        SearchFilter filter = searchOperation.getFilter();
        this.schedulerLock.lock();
        try {
            for (RecurringTask rt : this.recurringTasks.values()) {
                DN recurringTaskEntryDN = rt.getRecurringTaskEntryDN();
                Lock lock = this.readLockEntry(recurringTaskEntryDN);
                try {
                    Entry e = rt.getRecurringTaskEntry().duplicate(true);
                    if (!filter.matchesEntry(e) || searchOperation.returnEntry(e, null)) continue;
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.unlockEntry(recurringTaskEntryDN, lock);
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    public Task entryToScheduledTask(Entry entry, Operation operation) throws DirectoryException {
        Task task;
        Class<?> taskClass;
        List<Attribute> attrList;
        AttributeType attrType = DirectoryServer.getAttributeType("ds-task-class-name".toLowerCase());
        if (attrType == null) {
            attrType = DirectoryServer.getDefaultAttributeType("ds-task-class-name");
        }
        if ((attrList = entry.getAttribute(attrType)) == null || attrList.isEmpty()) {
            int msgID = 9699473;
            String message = MessageHandler.getMessage(msgID, "ds-task-id");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
        }
        if (attrList.size() > 1) {
            int msgID = 9699474;
            String message = MessageHandler.getMessage(msgID, "ds-task-id");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
        }
        Attribute attr = attrList.get(0);
        LinkedHashSet<AttributeValue> values = attr.getValues();
        if (values == null || values.isEmpty()) {
            int msgID = 9699475;
            String message = MessageHandler.getMessage(msgID, "ds-task-id");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
        }
        Iterator iterator = values.iterator();
        AttributeValue value = (AttributeValue)iterator.next();
        if (iterator.hasNext()) {
            int msgID = 0x940094;
            String message = MessageHandler.getMessage(msgID, "ds-task-id");
            throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, message, msgID);
        }
        String taskClassName = value.getStringValue();
        if (!DirectoryServer.getAllowedTasks().contains(taskClassName)) {
            int msgID = 9699626;
            String message = MessageHandler.getMessage(msgID, taskClassName);
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
        }
        try {
            taskClass = DirectoryServer.loadClass(taskClassName);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 9699477;
            String message = MessageHandler.getMessage(msgID, String.valueOf(taskClassName), "ds-task-class-name", StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
        }
        try {
            task = (Task)taskClass.newInstance();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 9699478;
            String message = MessageHandler.getMessage(msgID, String.valueOf(taskClassName));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
        }
        try {
            task.initializeTaskInternal(this, entry);
        }
        catch (InitializationException ie) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ie);
            }
            int msgID = 9699479;
            String message = MessageHandler.getMessage(msgID, String.valueOf(taskClassName), ie.getMessage());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
        }
        catch (Exception e) {
            int msgID = 9699479;
            String message = MessageHandler.getMessage(msgID, String.valueOf(taskClassName), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
        }
        task.setOperation(operation);
        task.initializeTask();
        task.setOperation(null);
        return task;
    }

    public RecurringTask entryToRecurringTask(Entry entry) throws DirectoryException {
        return new RecurringTask(this, entry);
    }

    @Override
    public DN getComponentEntryDN() {
        return this.taskBackend.getConfigEntryDN();
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public LinkedHashMap<String, String> getAlerts() {
        LinkedHashMap<String, String> alerts = new LinkedHashMap<String, String>();
        alerts.put("org.opends.server.CannotFindRecurringTask", "This alert type will be used to notify administrators if the Directory Server is unable to locate a recurring task definition in order to schedule the next iteration once the previous iteration has completed.");
        alerts.put("org.opends.server.CannotScheduleRecurringIteration", "This alert type will be used to notify administrators if the Directory Server is unable to schedule an iteration of a recurring task.");
        alerts.put("org.opends.server.CannotRenameCurrentTaskFile", "This alert type will be used to notify administrators if the Directory Server is unable to rename the current tasks backing file in the process of trying to write an updated version.");
        alerts.put("org.opends.server.CannotRenameNewTaskFile", "This alert type will be used to notify administrators if the Directory Server is unable to rename the new tasks backing file into place.");
        alerts.put("org.opends.server.CannotWriteTaskFile", "This alert type will be used to notify administrators if the Directory Server is unable to write an updated tasks backing file for some reason.");
        return alerts;
    }
}

