/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.task;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskScheduler;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class RecurringTask {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DN recurringTaskEntryDN;
    private Entry recurringTaskEntry;
    private String recurringTaskID;
    private String taskClassName;
    private TaskScheduler taskScheduler;

    public RecurringTask(TaskScheduler taskScheduler, Entry recurringTaskEntry) throws DirectoryException {
        Task task;
        Class<?> taskClass;
        List<Attribute> attrList;
        this.taskScheduler = taskScheduler;
        this.recurringTaskEntry = recurringTaskEntry;
        this.recurringTaskEntryDN = recurringTaskEntry.getDN();
        AttributeType attrType = DirectoryServer.getAttributeType("ds-recurring-task-id".toLowerCase());
        if (attrType == null) {
            attrType = DirectoryServer.getDefaultAttributeType("ds-recurring-task-id");
        }
        if ((attrList = recurringTaskEntry.getAttribute(attrType)) == null || attrList.isEmpty()) {
            int msgID = 9699428;
            String message = MessageHandler.getMessage(msgID, "ds-recurring-task-id");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
        }
        if (attrList.size() > 1) {
            int msgID = 9699429;
            String message = MessageHandler.getMessage(msgID, "ds-recurring-task-id");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
        }
        Attribute attr = attrList.get(0);
        LinkedHashSet<AttributeValue> values = attr.getValues();
        if (values == null || values.isEmpty()) {
            int msgID = 9699430;
            String message = MessageHandler.getMessage(msgID, "ds-recurring-task-id");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
        }
        Iterator iterator = values.iterator();
        AttributeValue value = (AttributeValue)iterator.next();
        if (iterator.hasNext()) {
            int msgID = 9699431;
            String message = MessageHandler.getMessage(msgID, "ds-recurring-task-id");
            throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, message, msgID);
        }
        this.recurringTaskID = value.getStringValue();
        attrType = DirectoryServer.getAttributeType("ds-recurring-task-class-name".toLowerCase());
        if (attrType == null) {
            attrType = DirectoryServer.getDefaultAttributeType("ds-recurring-task-class-name");
        }
        if ((attrList = recurringTaskEntry.getAttribute(attrType)) == null || attrList.isEmpty()) {
            int msgID = 9699432;
            String message = MessageHandler.getMessage(msgID, "ds-recurring-task-class-name");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
        }
        if (attrList.size() > 0) {
            int msgID = 9699433;
            String message = MessageHandler.getMessage(msgID, "ds-recurring-task-class-name");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
        }
        attr = attrList.get(0);
        values = attr.getValues();
        if (values == null || values.isEmpty()) {
            int msgID = 9699434;
            String message = MessageHandler.getMessage(msgID, "ds-recurring-task-class-name");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
        }
        iterator = values.iterator();
        value = (AttributeValue)iterator.next();
        if (iterator.hasNext()) {
            int msgID = 9699435;
            String message = MessageHandler.getMessage(msgID, "ds-recurring-task-class-name");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
        }
        this.taskClassName = value.getStringValue();
        try {
            taskClass = DirectoryServer.loadClass(this.taskClassName);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 9699436;
            String message = MessageHandler.getMessage(msgID, String.valueOf(this.taskClassName), "ds-recurring-task-class-name", StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID, e);
        }
        try {
            task = (Task)taskClass.newInstance();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 9699437;
            String message = MessageHandler.getMessage(msgID, String.valueOf(this.taskClassName), Task.class.getName());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID, e);
        }
        try {
            task.initializeTaskInternal(taskScheduler, recurringTaskEntry);
        }
        catch (InitializationException ie) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ie);
            }
            int msgID = 9699438;
            String message = MessageHandler.getMessage(msgID, String.valueOf(this.taskClassName), ie.getMessage());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, ie);
        }
        task.initializeTask();
    }

    public String getRecurringTaskID() {
        return this.recurringTaskID;
    }

    public DN getRecurringTaskEntryDN() {
        return this.recurringTaskEntryDN;
    }

    public Entry getRecurringTaskEntry() {
        return this.recurringTaskEntry;
    }

    public String getTaskClassName() {
        return this.taskClassName;
    }

    public Task scheduleNextIteration() {
        return null;
    }
}

