/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.VLVJEIndexCfg;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.backends.jeb.DatabaseContainer;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.ID2Entry;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.JebFormat;
import org.opends.server.backends.jeb.SortValuesSet;
import org.opends.server.backends.jeb.State;
import org.opends.server.backends.jeb.VLVKeyComparator;
import org.opends.server.config.ConfigException;
import org.opends.server.controls.ServerSideSortRequestControl;
import org.opends.server.controls.VLVRequestControl;
import org.opends.server.controls.VLVResponseControl;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.Modification;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.types.SortKey;
import org.opends.server.types.SortOrder;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VLVIndex
extends DatabaseContainer
implements ConfigurationChangeListener<VLVJEIndexCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public VLVKeyComparator comparator;
    private int sortedSetCapacity = 4000;
    private AtomicInteger count;
    private State state;
    private boolean trusted = false;
    private boolean rebuildRunning = false;
    private VLVJEIndexCfg config;
    private ID2Entry id2entry;
    private DN baseDN;
    private SearchFilter filter;
    private SearchScope scope;
    public SortOrder sortOrder;

    public VLVIndex(VLVJEIndexCfg config, State state, Environment env, EntryContainer entryContainer) throws DatabaseException, ConfigException {
        super(entryContainer.getDatabasePrefix() + "_vlv." + config.getVLVIndexName(), env, entryContainer);
        this.config = config;
        this.baseDN = config.getVLVIndexBaseDN();
        this.scope = SearchScope.valueOf(config.getVLVIndexScope().name());
        this.sortedSetCapacity = config.getVLVIndexMaximumBlockSize();
        this.id2entry = entryContainer.getID2Entry();
        try {
            this.filter = SearchFilter.createFilterFromString(config.getVLVIndexFilter());
        }
        catch (Exception e) {
            int msgID = 8650913;
            String msg = MessageHandler.getMessage(msgID, config.getVLVIndexFilter(), this.name, StaticUtils.stackTraceToSingleLineString(e));
            throw new ConfigException(msgID, msg);
        }
        String[] sortAttrs = config.getVLVIndexSortOrder().split(" ");
        SortKey[] sortKeys = new SortKey[sortAttrs.length];
        OrderingMatchingRule[] orderingRules = new OrderingMatchingRule[sortAttrs.length];
        boolean[] ascending = new boolean[sortAttrs.length];
        for (int i = 0; i < sortAttrs.length; ++i) {
            try {
                if (sortAttrs[i].startsWith("-")) {
                    ascending[i] = false;
                    sortAttrs[i] = sortAttrs[i].substring(1);
                } else {
                    ascending[i] = true;
                    if (sortAttrs[i].startsWith("+")) {
                        sortAttrs[i] = sortAttrs[i].substring(1);
                    }
                }
            }
            catch (Exception e) {
                int msgID = 8650912;
                String msg = MessageHandler.getMessage(msgID, sortKeys[i], this.name);
                throw new ConfigException(msgID, msg);
            }
            AttributeType attrType = DirectoryServer.getAttributeType(sortAttrs[i].toLowerCase());
            if (attrType == null) {
                int msgID = 8650912;
                String msg = MessageHandler.getMessage(msgID, sortKeys[i], this.name);
                throw new ConfigException(msgID, msg);
            }
            sortKeys[i] = new SortKey(attrType, ascending[i]);
            orderingRules[i] = attrType.getOrderingMatchingRule();
        }
        this.sortOrder = new SortOrder(sortKeys);
        this.comparator = new VLVKeyComparator(orderingRules, ascending);
        DatabaseConfig dbNodupsConfig = new DatabaseConfig();
        if (env.getConfig().getReadOnly()) {
            dbNodupsConfig.setReadOnly(true);
            dbNodupsConfig.setAllowCreate(false);
            dbNodupsConfig.setTransactional(false);
        } else if (!env.getConfig().getTransactional()) {
            dbNodupsConfig.setAllowCreate(true);
            dbNodupsConfig.setTransactional(false);
            dbNodupsConfig.setDeferredWrite(true);
        } else {
            dbNodupsConfig.setAllowCreate(true);
            dbNodupsConfig.setTransactional(true);
        }
        this.dbConfig = dbNodupsConfig;
        this.dbConfig.setOverrideBtreeComparator(true);
        this.dbConfig.setBtreeComparator((Comparator)this.comparator);
        this.state = state;
        this.trusted = state.getIndexTrustState(null, this);
        if (!this.trusted && entryContainer.getEntryCount() <= 0L) {
            this.setTrusted(null, true);
        }
        if (!this.trusted) {
            int msgID = 8847510;
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, msgID, this.name);
        }
        this.count = new AtomicInteger(0);
        this.config.addChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws DatabaseException {
        super.open();
        DatabaseEntry key = new DatabaseEntry();
        LockMode lockMode = LockMode.RMW;
        DatabaseEntry data = new DatabaseEntry();
        Cursor cursor = this.openCursor(null, CursorConfig.READ_COMMITTED);
        try {
            OperationStatus status = cursor.getFirst(key, data, lockMode);
            while (status == OperationStatus.SUCCESS) {
                this.count.getAndAdd(SortValuesSet.getEncodedSize(data.getData(), 0));
                status = cursor.getNext(key, data, lockMode);
            }
        }
        finally {
            cursor.close();
        }
    }

    @Override
    public void close() throws DatabaseException {
        super.close();
        this.config.removeChangeListener(this);
    }

    public boolean addEntry(Transaction txn, EntryID entryID, Entry entry) throws DatabaseException, DirectoryException, JebException {
        DN entryDN = entry.getDN();
        if (entryDN.matchesBaseAndScope(this.baseDN, this.scope) && this.filter.matchesEntry(entry)) {
            return this.insertValues(txn, entryID.longValue(), entry);
        }
        return false;
    }

    public boolean removeEntry(Transaction txn, EntryID entryID, Entry entry) throws DatabaseException, DirectoryException, JebException {
        DN entryDN = entry.getDN();
        if (entryDN.matchesBaseAndScope(this.baseDN, this.scope) && this.filter.matchesEntry(entry)) {
            return this.removeValues(txn, entryID.longValue(), entry);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean modifyEntry(Transaction txn, EntryID entryID, Entry oldEntry, Entry newEntry, List<Modification> mods) throws DatabaseException, DirectoryException, JebException {
        DN oldEntryDN = oldEntry.getDN();
        DN newEntryDN = newEntry.getDN();
        if (oldEntryDN.matchesBaseAndScope(this.baseDN, this.scope) && this.filter.matchesEntry(oldEntry)) {
            SortKey[] sortKeys;
            if (!newEntryDN.matchesBaseAndScope(this.baseDN, this.scope) || !this.filter.matchesEntry(newEntry)) return this.removeValues(txn, entryID.longValue(), oldEntry);
            boolean sortAttributeModified = false;
            for (SortKey sortKey : sortKeys = this.sortOrder.getSortKeys()) {
                for (Modification mod : mods) {
                    if (!mod.getAttribute().getAttributeType().equals(sortKey.getAttributeType())) continue;
                    sortAttributeModified = true;
                    break;
                }
                if (sortAttributeModified) break;
            }
            if (!sortAttributeModified) return true;
            boolean success = this.removeValues(txn, entryID.longValue(), oldEntry);
            return success &= this.insertValues(txn, entryID.longValue(), newEntry);
        }
        if (!newEntryDN.matchesBaseAndScope(this.baseDN, this.scope) || !this.filter.matchesEntry(newEntry)) return true;
        return this.insertValues(txn, entryID.longValue(), newEntry);
    }

    public boolean putSortValuesSet(Transaction txn, SortValuesSet sortValuesSet) throws JebException, DatabaseException, DirectoryException {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        byte[] after = sortValuesSet.toDatabase();
        key.setData(sortValuesSet.getKeyBytes());
        data.setData(after);
        return this.put(txn, key, data) == OperationStatus.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortValuesSet getSortValuesSet(Transaction txn, long entryID, AttributeValue[] values) throws DatabaseException, DirectoryException {
        SortValuesSet sortValuesSet = null;
        DatabaseEntry key = new DatabaseEntry();
        LockMode lockMode = LockMode.DEFAULT;
        DatabaseEntry data = new DatabaseEntry();
        Cursor cursor = this.openCursor(txn, CursorConfig.READ_COMMITTED);
        try {
            key.setData(this.encodeKey(entryID, values));
            OperationStatus status = cursor.getSearchKeyRange(key, data, lockMode);
            if (status != OperationStatus.SUCCESS) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugVerbose("No sort values set exist in VLV vlvIndex %s. Creating unbound set.", this.config.getVLVIndexName());
                }
                sortValuesSet = new SortValuesSet(this, this.id2entry);
            } else {
                if (DebugLogger.debugEnabled()) {
                    StringBuilder searchKeyHex = new StringBuilder();
                    StaticUtils.byteArrayToHexPlusAscii(searchKeyHex, key.getData(), 4);
                    StringBuilder foundKeyHex = new StringBuilder();
                    StaticUtils.byteArrayToHexPlusAscii(foundKeyHex, key.getData(), 4);
                    TRACER.debugVerbose("Retrieved a sort values set in VLV vlvIndex %s\nSearch Key:%s\nFound Key:%s\n", this.config.getVLVIndexName(), searchKeyHex, foundKeyHex);
                }
                sortValuesSet = new SortValuesSet(key.getData(), data.getData(), this, this.id2entry);
            }
        }
        finally {
            cursor.close();
        }
        return sortValuesSet;
    }

    public boolean containsValues(Transaction txn, long entryID, AttributeValue[] values) throws JebException, DatabaseException, DirectoryException {
        SortValuesSet valuesSet = this.getSortValuesSet(txn, entryID, values);
        int pos = valuesSet.binarySearch(entryID, values);
        return pos >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertValues(Transaction txn, long entryID, Entry entry) throws JebException, DatabaseException, DirectoryException {
        SortValuesSet sortValuesSet;
        OperationStatus status;
        AttributeValue[] values = this.getSortValues(entry);
        DatabaseEntry key = new DatabaseEntry();
        LockMode lockMode = LockMode.RMW;
        DatabaseEntry data = new DatabaseEntry();
        boolean success = true;
        Cursor cursor = this.openCursor(txn, CursorConfig.READ_COMMITTED);
        try {
            key.setData(this.encodeKey(entryID, values));
            status = cursor.getSearchKeyRange(key, data, lockMode);
        }
        finally {
            cursor.close();
        }
        if (status != OperationStatus.SUCCESS) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("No sort values set exist in VLV vlvIndex %s. Creating unbound set.", this.config.getVLVIndexName());
            }
            sortValuesSet = new SortValuesSet(this, this.id2entry);
            key.setData(new byte[0]);
        } else {
            if (DebugLogger.debugEnabled()) {
                StringBuilder searchKeyHex = new StringBuilder();
                StaticUtils.byteArrayToHexPlusAscii(searchKeyHex, key.getData(), 4);
                StringBuilder foundKeyHex = new StringBuilder();
                StaticUtils.byteArrayToHexPlusAscii(foundKeyHex, key.getData(), 4);
                TRACER.debugVerbose("Retrieved a sort values set in VLV vlvIndex %s\nSearch Key:%s\nFound Key:%s\n", this.config.getVLVIndexName(), searchKeyHex, foundKeyHex);
            }
            sortValuesSet = new SortValuesSet(key.getData(), data.getData(), this, this.id2entry);
        }
        success = sortValuesSet.add(entryID, values);
        int newSize = sortValuesSet.size();
        if (newSize >= this.sortedSetCapacity) {
            SortValuesSet splitSortValuesSet = sortValuesSet.split(newSize / 2);
            byte[] splitAfter = splitSortValuesSet.toDatabase();
            key.setData(splitSortValuesSet.getKeyBytes());
            data.setData(splitAfter);
            this.put(txn, key, data);
            byte[] after = sortValuesSet.toDatabase();
            key.setData(sortValuesSet.getKeyBytes());
            data.setData(after);
            this.put(txn, key, data);
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("SortValuesSet with key %s has reached the entry size of %d. Spliting into two sets with  keys %s and %s.", splitSortValuesSet.getKeySortValues(), newSize, sortValuesSet.getKeySortValues(), splitSortValuesSet.getKeySortValues());
            }
        } else {
            byte[] after = sortValuesSet.toDatabase();
            data.setData(after);
            this.put(txn, key, data);
        }
        if (success) {
            this.count.getAndIncrement();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeValues(Transaction txn, long entryID, Entry entry) throws JebException, DatabaseException, DirectoryException {
        OperationStatus status;
        AttributeValue[] values = this.getSortValues(entry);
        DatabaseEntry key = new DatabaseEntry();
        LockMode lockMode = LockMode.RMW;
        DatabaseEntry data = new DatabaseEntry();
        Cursor cursor = this.openCursor(txn, CursorConfig.READ_COMMITTED);
        try {
            key.setData(this.encodeKey(entryID, values));
            status = cursor.getSearchKeyRange(key, data, lockMode);
        }
        finally {
            cursor.close();
        }
        if (status == OperationStatus.SUCCESS) {
            if (DebugLogger.debugEnabled()) {
                StringBuilder searchKeyHex = new StringBuilder();
                StaticUtils.byteArrayToHexPlusAscii(searchKeyHex, key.getData(), 4);
                StringBuilder foundKeyHex = new StringBuilder();
                StaticUtils.byteArrayToHexPlusAscii(foundKeyHex, key.getData(), 4);
                TRACER.debugVerbose("Retrieved a sort values set in VLV vlvIndex %s\nSearch Key:%s\nFound Key:%s\n", this.config.getVLVIndexName(), searchKeyHex, foundKeyHex);
            }
            SortValuesSet sortValuesSet = new SortValuesSet(key.getData(), data.getData(), this, this.id2entry);
            boolean success = sortValuesSet.remove(entryID, values);
            byte[] after = sortValuesSet.toDatabase();
            data.setData(after);
            this.put(txn, key, data);
            if (success) {
                this.count.getAndDecrement();
            }
            return success;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public EntryIDSet evaluate(Transaction txn, SearchOperation searchOperation, ServerSideSortRequestControl sortControl, VLVRequestControl vlvRequest, StringBuilder debugBuilder) throws DirectoryException, DatabaseException, JebException {
        if (!this.trusted || this.rebuildRunning) {
            return null;
        }
        if (!searchOperation.getBaseDN().equals(this.baseDN)) {
            return null;
        }
        if (!searchOperation.getScope().equals((Object)this.scope)) {
            return null;
        }
        if (!searchOperation.getFilter().equals(this.filter)) {
            return null;
        }
        if (!sortControl.getSortOrder().equals(this.sortOrder)) {
            return null;
        }
        if (debugBuilder != null) {
            debugBuilder.append("vlv=");
            debugBuilder.append("[INDEX:");
            debugBuilder.append(this.name.replace(this.entryContainer.getDatabasePrefix() + "_", ""));
            debugBuilder.append("]");
        }
        selectedIDs = new long[]{};
        if (vlvRequest != null) {
            currentCount = this.count.get();
            beforeCount = vlvRequest.getBeforeCount();
            afterCount = vlvRequest.getAfterCount();
            if (vlvRequest.getTargetType() == -96) {
                targetOffset = vlvRequest.getOffset();
                if (targetOffset < 0) {
                    searchOperation.addResponseControl(new VLVResponseControl(targetOffset, currentCount, 61));
                    msgID = 8585357;
                    message = MessageHandler.getMessage(msgID);
                    throw new DirectoryException(ResultCode.VIRTUAL_LIST_VIEW_ERROR, message, msgID);
                }
                if (targetOffset == 0) {
                    targetOffset = 1;
                }
                if ((startPos = (listOffset = targetOffset - 1) - beforeCount) < 0) {
                    startPos = 0;
                    beforeCount = listOffset;
                } else if (startPos >= currentCount) {
                    targetOffset = currentCount + 1;
                    listOffset = currentCount;
                    startPos = listOffset - beforeCount;
                    afterCount = 0;
                }
                count = 1 + beforeCount + afterCount;
                selectedIDs = new long[count];
                key = new DatabaseEntry();
                lockMode = LockMode.DEFAULT;
                data = new DatabaseEntry();
                cursor = this.openCursor(txn, CursorConfig.READ_COMMITTED);
                try {
                    cursorCount = 0;
                    selectedPos = 0;
                    status = cursor.getFirst(key, data, lockMode);
                    while (status == OperationStatus.SUCCESS) {
                        if (DebugLogger.debugEnabled()) {
                            searchKeyHex = new StringBuilder();
                            StaticUtils.byteArrayToHexPlusAscii(searchKeyHex, key.getData(), 4);
                            foundKeyHex = new StringBuilder();
                            StaticUtils.byteArrayToHexPlusAscii(foundKeyHex, key.getData(), 4);
                            VLVIndex.TRACER.debugVerbose("Retrieved a sort values set in VLV vlvIndex %s\nSearch Key:%s\nFound Key:%s\n", new Object[]{this.config.getVLVIndexName(), searchKeyHex, foundKeyHex});
                        }
                        IDs = SortValuesSet.getEncodedIDs(data.getData(), 0);
                        for (i = startPos + selectedPos - cursorCount; i < IDs.length && selectedPos < count; ++i, ++selectedPos) {
                            selectedIDs[selectedPos] = IDs[i];
                        }
                        cursorCount += IDs.length;
                        status = cursor.getNext(key, data, lockMode);
                    }
                    if (selectedPos < count) {
                        newIDArray = new long[selectedPos];
                        System.arraycopy(selectedIDs, 0, newIDArray, 0, selectedPos);
                        selectedIDs = newIDArray;
                    }
                    searchOperation.addResponseControl(new VLVResponseControl(targetOffset, currentCount, 0));
                    if (debugBuilder == null) ** GOTO lbl195
                    debugBuilder.append("[COUNT:");
                    debugBuilder.append(cursorCount);
                    debugBuilder.append("]");
                }
                finally {
                    cursor.close();
                }
            } else {
                targetOffset = 0;
                includedBeforeCount = 0;
                includedAfterCount = 0;
                idList = new LinkedList<EntryID>();
                key = new DatabaseEntry();
                lockMode = LockMode.DEFAULT;
                data = new DatabaseEntry();
                cursor = this.openCursor(txn, CursorConfig.READ_COMMITTED);
                try {
                    vBytes = vlvRequest.getGreaterThanOrEqualAssertion().value();
                    vLength = ASN1Element.encodeLength(vBytes.length);
                    keyBytes = new byte[vBytes.length + vLength.length];
                    System.arraycopy(vLength, 0, keyBytes, 0, vLength.length);
                    System.arraycopy(vBytes, 0, keyBytes, vLength.length, vBytes.length);
                    key.setData(keyBytes);
                    status = cursor.getSearchKeyRange(key, data, lockMode);
                    if (status != OperationStatus.SUCCESS) ** GOTO lbl195
                    if (DebugLogger.debugEnabled()) {
                        searchKeyHex = new StringBuilder();
                        StaticUtils.byteArrayToHexPlusAscii(searchKeyHex, key.getData(), 4);
                        foundKeyHex = new StringBuilder();
                        StaticUtils.byteArrayToHexPlusAscii(foundKeyHex, key.getData(), 4);
                        VLVIndex.TRACER.debugVerbose("Retrieved a sort values set in VLV vlvIndex %s\nSearch Key:%s\nFound Key:%s\n", new Object[]{this.config.getVLVIndexName(), searchKeyHex, foundKeyHex});
                    }
                    if ((adjustedTargetOffset = (sortValuesSet = new SortValuesSet(key.getData(), data.getData(), this, this.id2entry)).binarySearch(-1L, assertionValue = new AttributeValue[]{new AttributeValue(this.sortOrder.getSortKeys()[0].getAttributeType(), vlvRequest.getGreaterThanOrEqualAssertion())})) < 0) {
                        adjustedTargetOffset = -(adjustedTargetOffset + 1);
                    }
                    targetOffset = adjustedTargetOffset;
                    lastOffset = adjustedTargetOffset - 1;
                    lastIDs = sortValuesSet.getEntryIDs();
                    while (true) lbl-1000:
                    // 4 sources

                    {
                        for (i = lastOffset; i >= 0 && includedBeforeCount < beforeCount; ++includedBeforeCount, --i) {
                            idList.addFirst(new EntryID(lastIDs[i]));
                        }
                        status = cursor.getPrev(key, data, lockMode);
                        if (status != OperationStatus.SUCCESS) break;
                        if (includedBeforeCount < beforeCount) {
                            lastIDs = SortValuesSet.getEncodedIDs(data.getData(), 0);
                            lastOffset = lastIDs.length - 1;
                            targetOffset += lastIDs.length;
                            ** continue;
                        }
                        targetOffset += SortValuesSet.getEncodedSize(data.getData(), 0);
                    }
                    key.setData(sortValuesSet.getKeyBytes());
                    cursor.getSearchKey(key, data, lockMode);
                    lastOffset = adjustedTargetOffset;
                    lastIDs = sortValuesSet.getEntryIDs();
                    afterIDCount = 0;
                    while (true) {
                        for (i = lastOffset; i < lastIDs.length && includedAfterCount < afterCount + 1; ++includedAfterCount, ++i) {
                            idList.addLast(new EntryID(lastIDs[i]));
                        }
                        if (includedAfterCount >= afterCount + 1 || (status = cursor.getNext(key, data, lockMode)) != OperationStatus.SUCCESS) break;
                        lastIDs = SortValuesSet.getEncodedIDs(data.getData(), 0);
                        lastOffset = 0;
                        afterIDCount += lastIDs.length;
                    }
                    selectedIDs = new long[idList.size()];
                    idIterator = idList.iterator();
                    for (i = 0; i < selectedIDs.length; ++i) {
                        selectedIDs[i] = ((EntryID)idIterator.next()).longValue();
                    }
                    searchOperation.addResponseControl(new VLVResponseControl(targetOffset + 1, currentCount, 0));
                    if (debugBuilder == null) ** GOTO lbl195
                    debugBuilder.append("[COUNT:");
                    debugBuilder.append(targetOffset + afterIDCount + 1);
                    debugBuilder.append("]");
                }
                finally {
                    cursor.close();
                }
            }
        } else {
            idSets = new LinkedList<long[]>();
            currentCount = 0;
            key = new DatabaseEntry();
            lockMode = LockMode.RMW;
            data = new DatabaseEntry();
            cursor = this.openCursor(txn, CursorConfig.READ_COMMITTED);
            try {
                status = cursor.getFirst(key, data, lockMode);
                while (status == OperationStatus.SUCCESS) {
                    if (DebugLogger.debugEnabled()) {
                        searchKeyHex = new StringBuilder();
                        StaticUtils.byteArrayToHexPlusAscii(searchKeyHex, key.getData(), 4);
                        foundKeyHex = new StringBuilder();
                        StaticUtils.byteArrayToHexPlusAscii(foundKeyHex, key.getData(), 4);
                        VLVIndex.TRACER.debugVerbose("Retrieved a sort values set in VLV vlvIndex %s\nSearch Key:%s\nFound Key:%s\n", new Object[]{this.config.getVLVIndexName(), searchKeyHex, foundKeyHex});
                    }
                    ids = SortValuesSet.getEncodedIDs(data.getData(), 0);
                    idSets.add(ids);
                    currentCount += ids.length;
                    status = cursor.getNext(key, data, lockMode);
                }
            }
            finally {
                cursor.close();
            }
            selectedIDs = new long[currentCount];
            pos = 0;
            for (long[] id : idSets) {
                System.arraycopy(id, 0, selectedIDs, pos, id.length);
                pos += id.length;
            }
            if (debugBuilder != null) {
                debugBuilder.append("[COUNT:");
                debugBuilder.append(currentCount);
                debugBuilder.append("]");
            }
        }
lbl195:
        // 8 sources

        return new EntryIDSet(selectedIDs, 0, selectedIDs.length);
    }

    public synchronized void setTrusted(Transaction txn, boolean trusted) throws DatabaseException {
        this.trusted = trusted;
        this.state.putIndexTrustState(txn, this, trusted);
    }

    public synchronized void setRebuildStatus(boolean rebuildRunning) {
        this.rebuildRunning = rebuildRunning;
    }

    AttributeValue[] getSortValues(Entry entry) {
        SortKey[] sortKeys = this.sortOrder.getSortKeys();
        AttributeValue[] values = new AttributeValue[sortKeys.length];
        for (int i = 0; i < sortKeys.length; ++i) {
            SortKey sortKey = sortKeys[i];
            AttributeType attrType = sortKey.getAttributeType();
            List<Attribute> attrList = entry.getAttribute(attrType);
            if (attrList == null) continue;
            AttributeValue sortValue = null;
            for (Attribute a : attrList) {
                for (AttributeValue v : a.getValues()) {
                    if (sortValue == null) {
                        sortValue = v;
                        continue;
                    }
                    if (sortKey.compareValues(v, sortValue) >= 0) continue;
                    sortValue = v;
                }
            }
            values[i] = sortValue;
        }
        return values;
    }

    byte[] encodeKey(long entryID, AttributeValue[] values) throws DirectoryException {
        int totalValueBytes = 0;
        LinkedList<byte[]> valueBytes = new LinkedList<byte[]>();
        for (AttributeValue v : values) {
            byte[] vBytes = v == null ? new byte[]{} : v.getNormalizedValueBytes();
            byte[] vLength = ASN1Element.encodeLength(vBytes.length);
            valueBytes.add(vLength);
            valueBytes.add(vBytes);
            totalValueBytes += vLength.length + vBytes.length;
        }
        byte[] entryIDBytes = JebFormat.entryIDToDatabase(entryID);
        byte[] attrBytes = new byte[entryIDBytes.length + totalValueBytes];
        int pos = 0;
        for (byte[] b : valueBytes) {
            System.arraycopy(b, 0, attrBytes, pos, b.length);
            pos += b.length;
        }
        System.arraycopy(entryIDBytes, 0, attrBytes, pos, entryIDBytes.length);
        return attrBytes;
    }

    public int getSortedSetCapacity() {
        return this.sortedSetCapacity;
    }

    public boolean shouldInclude(Entry entry) throws DirectoryException {
        DN entryDN = entry.getDN();
        return entryDN.matchesBaseAndScope(this.baseDN, this.scope) && this.filter.matchesEntry(entry);
    }

    @Override
    public synchronized boolean isConfigurationChangeAcceptable(VLVJEIndexCfg cfg, List<String> unacceptableReasons) {
        try {
            this.filter = SearchFilter.createFilterFromString(this.config.getVLVIndexFilter());
        }
        catch (Exception e) {
            int msgID = 8650913;
            String msg = MessageHandler.getMessage(msgID, this.config.getVLVIndexFilter(), this.name, StaticUtils.stackTraceToSingleLineString(e));
            unacceptableReasons.add(msg);
            return false;
        }
        String[] sortAttrs = this.config.getVLVIndexSortOrder().split(" ");
        SortKey[] sortKeys = new SortKey[sortAttrs.length];
        OrderingMatchingRule[] orderingRules = new OrderingMatchingRule[sortAttrs.length];
        boolean[] ascending = new boolean[sortAttrs.length];
        for (int i = 0; i < sortAttrs.length; ++i) {
            try {
                if (sortAttrs[i].startsWith("-")) {
                    ascending[i] = false;
                    sortAttrs[i] = sortAttrs[i].substring(1);
                } else {
                    ascending[i] = true;
                    if (sortAttrs[i].startsWith("+")) {
                        sortAttrs[i] = sortAttrs[i].substring(1);
                    }
                }
            }
            catch (Exception e) {
                int msgID = 8650912;
                String msg = MessageHandler.getMessage(msgID, sortKeys[i], this.name);
                unacceptableReasons.add(msg);
                return false;
            }
            AttributeType attrType = DirectoryServer.getAttributeType(sortAttrs[i].toLowerCase());
            if (attrType == null) {
                int msgID = 8650912;
                String msg = MessageHandler.getMessage(msgID, sortKeys[i], this.name);
                unacceptableReasons.add(msg);
                return false;
            }
            sortKeys[i] = new SortKey(attrType, ascending[i]);
            orderingRules[i] = attrType.getOrderingMatchingRule();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ConfigChangeResult applyConfigurationChange(VLVJEIndexCfg cfg) {
        ArrayList<String> messages;
        boolean adminActionRequired;
        ResultCode resultCode;
        block28: {
            block25: {
                resultCode = ResultCode.SUCCESS;
                adminActionRequired = false;
                messages = new ArrayList<String>();
                if (!this.config.getVLVIndexBaseDN().equals(cfg.getVLVIndexBaseDN())) {
                    this.baseDN = cfg.getVLVIndexBaseDN();
                    adminActionRequired = true;
                }
                if (!this.config.getVLVIndexScope().equals((Object)cfg.getVLVIndexScope())) {
                    this.scope = SearchScope.valueOf(cfg.getVLVIndexScope().name());
                    adminActionRequired = true;
                }
                if (this.config.getVLVIndexMaximumBlockSize() != cfg.getVLVIndexMaximumBlockSize()) {
                    this.sortedSetCapacity = cfg.getVLVIndexMaximumBlockSize();
                    if (this.config.getVLVIndexMaximumBlockSize() < cfg.getVLVIndexMaximumBlockSize()) {
                        adminActionRequired = true;
                    }
                }
                if (!this.config.getVLVIndexFilter().equals(cfg.getVLVIndexFilter())) {
                    try {
                        this.filter = SearchFilter.createFilterFromString(cfg.getVLVIndexFilter());
                        adminActionRequired = true;
                    }
                    catch (Exception e) {
                        int msgID = 8650913;
                        String msg = MessageHandler.getMessage(msgID, this.config.getVLVIndexFilter(), this.name, StaticUtils.stackTraceToSingleLineString(e));
                        messages.add(msg);
                        if (resultCode != ResultCode.SUCCESS) break block25;
                        resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
                    }
                }
            }
            if (!this.config.getVLVIndexSortOrder().equals(cfg.getVLVIndexMaximumBlockSize())) {
                String[] sortAttrs = cfg.getVLVIndexSortOrder().split(" ");
                SortKey[] sortKeys = new SortKey[sortAttrs.length];
                OrderingMatchingRule[] orderingRules = new OrderingMatchingRule[sortAttrs.length];
                boolean[] ascending = new boolean[sortAttrs.length];
                for (int i = 0; i < sortAttrs.length; ++i) {
                    String msg;
                    int msgID;
                    block26: {
                        try {
                            if (sortAttrs[i].startsWith("-")) {
                                ascending[i] = false;
                                sortAttrs[i] = sortAttrs[i].substring(1);
                            } else {
                                ascending[i] = true;
                                if (sortAttrs[i].startsWith("+")) {
                                    sortAttrs[i] = sortAttrs[i].substring(1);
                                }
                            }
                        }
                        catch (Exception e) {
                            msgID = 8650912;
                            msg = MessageHandler.getMessage(msgID, sortKeys[i], this.name);
                            messages.add(msg);
                            if (resultCode != ResultCode.SUCCESS) break block26;
                            resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
                        }
                    }
                    AttributeType attrType = DirectoryServer.getAttributeType(sortAttrs[i].toLowerCase());
                    if (attrType == null) {
                        msgID = 8650912;
                        msg = MessageHandler.getMessage(msgID, sortKeys[i], this.name);
                        messages.add(msg);
                        if (resultCode == ResultCode.SUCCESS) {
                            resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
                        }
                    }
                    sortKeys[i] = new SortKey(attrType, ascending[i]);
                    orderingRules[i] = attrType.getOrderingMatchingRule();
                }
                this.sortOrder = new SortOrder(sortKeys);
                this.comparator = new VLVKeyComparator(orderingRules, ascending);
                this.entryContainer.exclusiveLock.lock();
                try {
                    this.close();
                    this.dbConfig.setBtreeComparator((Comparator)this.comparator);
                    this.open();
                }
                catch (DatabaseException de) {
                    messages.add(StaticUtils.stackTraceToSingleLineString(de));
                    if (resultCode == ResultCode.SUCCESS) {
                        resultCode = DirectoryServer.getServerErrorResultCode();
                    }
                }
                finally {
                    this.entryContainer.exclusiveLock.unlock();
                }
                adminActionRequired = true;
            }
            if (adminActionRequired) {
                this.trusted = false;
                int msgID = 8847510;
                String message = MessageHandler.getMessage(msgID, this.name);
                messages.add(message);
                try {
                    this.state.putIndexTrustState(null, this, false);
                }
                catch (DatabaseException de) {
                    messages.add(StaticUtils.stackTraceToSingleLineString(de));
                    if (resultCode != ResultCode.SUCCESS) break block28;
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
            }
        }
        this.config = cfg;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

