/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.util.ArrayList;
import java.util.zip.DataFormatException;
import org.opends.server.backends.jeb.DataConfig;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1Integer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.types.CryptoManager;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.EntryEncodeConfig;
import org.opends.server.types.LDAPException;

public class JebFormat {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final byte FORMAT_VERSION = 1;
    public static final byte TAG_DATABASE_ENTRY = 96;
    public static final byte TAG_DIRECTORY_SERVER_ENTRY = 97;
    private static EntryEncodeConfig encodeConfig = new EntryEncodeConfig();

    public static byte[] decodeDatabaseEntry(byte[] bytes) throws ASN1Exception, DataFormatException {
        byte[] uncompressedBytes;
        byte[] encodedBytes = new byte[bytes.length - 1];
        System.arraycopy(bytes, 1, encodedBytes, 0, encodedBytes.length);
        ArrayList<ASN1Element> elements = ASN1Sequence.decodeAsSequence(encodedBytes).elements();
        int uncompressedSize = ((ASN1Element)elements.get(0)).decodeAsInteger().intValue();
        byte[] dataBytes = ((ASN1Element)elements.get(1)).decodeAsOctetString().value();
        if (uncompressedSize == 0) {
            uncompressedBytes = dataBytes;
        } else {
            CryptoManager cryptoManager = DirectoryServer.getCryptoManager();
            uncompressedBytes = new byte[uncompressedSize];
            cryptoManager.uncompress(dataBytes, uncompressedBytes);
        }
        return uncompressedBytes;
    }

    public static Entry entryFromDatabase(byte[] bytes) throws DirectoryException, ASN1Exception, LDAPException, DataFormatException {
        byte[] uncompressedBytes = JebFormat.decodeDatabaseEntry(bytes);
        return JebFormat.decodeDirectoryServerEntry(uncompressedBytes);
    }

    private static Entry decodeDirectoryServerEntry(byte[] bytes) throws DirectoryException, ASN1Exception, LDAPException {
        return Entry.decode(bytes);
    }

    public static byte[] encodeDatabaseEntry(byte[] bytes, DataConfig dataConfig) {
        byte[] compressedBuffer;
        int compressedSize;
        int uncompressedSize = 0;
        CryptoManager cryptoManager = DirectoryServer.getCryptoManager();
        if (dataConfig.isCompressed() && cryptoManager != null && (compressedSize = cryptoManager.compress(bytes, compressedBuffer = new byte[bytes.length])) != -1) {
            uncompressedSize = bytes.length;
            bytes = new byte[compressedSize];
            System.arraycopy(compressedBuffer, 0, bytes, 0, compressedSize);
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Compression %d/%d%n", compressedSize, uncompressedSize);
            }
        }
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
        elements.add(new ASN1Integer(uncompressedSize));
        elements.add(new ASN1OctetString(bytes));
        byte[] asn1Sequence = new ASN1Sequence(96, elements).encode();
        byte[] encodedBytes = new byte[asn1Sequence.length + 1];
        encodedBytes[0] = 1;
        System.arraycopy(asn1Sequence, 0, encodedBytes, 1, asn1Sequence.length);
        return encodedBytes;
    }

    public static byte[] entryToDatabase(Entry entry, DataConfig dataConfig) throws DirectoryException {
        byte[] uncompressedBytes = JebFormat.encodeDirectoryServerEntry(entry);
        return JebFormat.encodeDatabaseEntry(uncompressedBytes, dataConfig);
    }

    public static byte[] entryToDatabase(Entry entry) throws DirectoryException {
        return JebFormat.entryToDatabase(entry, new DataConfig());
    }

    private static byte[] encodeDirectoryServerEntry(Entry entry) throws DirectoryException {
        return entry.encode(encodeConfig);
    }

    public static long entryIDFromDatabase(byte[] bytes) {
        long v = 0L;
        for (int i = 0; i < 8; ++i) {
            v <<= 8;
            v |= (long)(bytes[i] & 0xFF);
        }
        return v;
    }

    public static long[] entryIDListFromDatabase(byte[] bytes) {
        if (bytes == null) {
            return new long[0];
        }
        if (bytes.length == 0) {
            return null;
        }
        byte[] decodedBytes = bytes;
        int count = decodedBytes.length / 8;
        long[] entryIDList = new long[count];
        int pos = 0;
        for (int i = 0; i < count; ++i) {
            long v = 0L;
            v |= ((long)decodedBytes[pos++] & 0xFFL) << 56;
            v |= ((long)decodedBytes[pos++] & 0xFFL) << 48;
            v |= ((long)decodedBytes[pos++] & 0xFFL) << 40;
            v |= ((long)decodedBytes[pos++] & 0xFFL) << 32;
            v |= ((long)decodedBytes[pos++] & 0xFFL) << 24;
            v |= ((long)decodedBytes[pos++] & 0xFFL) << 16;
            v |= ((long)decodedBytes[pos++] & 0xFFL) << 8;
            entryIDList[i] = v |= (long)decodedBytes[pos++] & 0xFFL;
        }
        return entryIDList;
    }

    public static byte[] entryIDToDatabase(long id) {
        byte[] bytes = new byte[8];
        long v = id;
        for (int i = 7; i >= 0; --i) {
            bytes[i] = (byte)(v & 0xFFL);
            v >>>= 8;
        }
        return bytes;
    }

    public static byte[] entryIDListToDatabase(long[] entryIDArray) {
        if (entryIDArray == null) {
            return new byte[0];
        }
        if (entryIDArray.length == 0) {
            return null;
        }
        byte[] bytes = new byte[8 * entryIDArray.length];
        int pos = 0;
        for (int i = 0; i < entryIDArray.length; ++i) {
            long v = entryIDArray[i];
            bytes[pos++] = (byte)(v >>> 56 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 48 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 40 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 32 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 24 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 16 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 8 & 0xFFL);
            bytes[pos++] = (byte)(v & 0xFFL);
        }
        return bytes;
    }

    public static byte getEntryVersion(byte[] bytes) {
        return bytes[0];
    }
}

