/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Transaction;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.opends.server.api.DirectoryThread;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.AttributeIndexBuilder;
import org.opends.server.backends.jeb.DN2URI;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.ID2Entry;
import org.opends.server.backends.jeb.ImportContext;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.IndexBuilder;
import org.opends.server.backends.jeb.VLVIndex;
import org.opends.server.backends.jeb.VLVIndexBuilder;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.Entry;

public class ImportThread
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ImportContext importContext;
    private EntryContainer entryContainer;
    private ID2Entry id2entry;
    private DN2URI dn2uri;
    private ArrayList<IndexBuilder> builders = new ArrayList();
    private BlockingQueue<Entry> queue;
    private int importedCount = 0;
    private int entryInsertCount = 0;
    private boolean stopRequested = false;

    public ImportThread(ImportContext importContext, int threadNumber) {
        super("Import Worker Thread " + threadNumber);
        this.importContext = importContext;
        this.entryContainer = importContext.getEntryContainer();
        this.queue = importContext.getQueue();
        this.id2entry = this.entryContainer.getID2Entry();
        this.dn2uri = this.entryContainer.getDN2URI();
    }

    public int getImportedCount() {
        return this.importedCount;
    }

    public void stopProcessing() {
        this.stopRequested = true;
    }

    public void run() {
        int nIndexes = 0;
        nIndexes += 2;
        for (AttributeIndex attrIndex : this.entryContainer.getAttributeIndexes()) {
            if (attrIndex.equalityIndex != null) {
                ++nIndexes;
            }
            if (attrIndex.presenceIndex != null) {
                ++nIndexes;
            }
            if (attrIndex.substringIndex != null) {
                ++nIndexes;
            }
            if (attrIndex.orderingIndex != null) {
                ++nIndexes;
            }
            if (attrIndex.approximateIndex == null) continue;
            ++nIndexes;
        }
        long indexBufferSize = this.importContext.getBufferSize() / (long)(nIndexes += this.entryContainer.getVLVIndexes().size());
        for (AttributeIndex attrIndex : this.entryContainer.getAttributeIndexes()) {
            AttributeIndexBuilder attributeIndexBuilder;
            int indexEntryLimit = this.importContext.getConfig().getBackendIndexEntryLimit();
            if (attrIndex.getConfiguration().getIndexEntryLimit() != null) {
                indexEntryLimit = attrIndex.getConfiguration().getIndexEntryLimit();
            }
            if (attrIndex.equalityIndex != null) {
                attributeIndexBuilder = new AttributeIndexBuilder(this.importContext, attrIndex.equalityIndex, indexEntryLimit, indexBufferSize);
                this.builders.add(attributeIndexBuilder);
            }
            if (attrIndex.presenceIndex != null) {
                attributeIndexBuilder = new AttributeIndexBuilder(this.importContext, attrIndex.presenceIndex, indexEntryLimit, indexBufferSize);
                this.builders.add(attributeIndexBuilder);
            }
            if (attrIndex.substringIndex != null) {
                attributeIndexBuilder = new AttributeIndexBuilder(this.importContext, attrIndex.substringIndex, indexEntryLimit, indexBufferSize);
                this.builders.add(attributeIndexBuilder);
            }
            if (attrIndex.orderingIndex != null) {
                attributeIndexBuilder = new AttributeIndexBuilder(this.importContext, attrIndex.orderingIndex, indexEntryLimit, indexBufferSize);
                this.builders.add(attributeIndexBuilder);
            }
            if (attrIndex.approximateIndex == null) continue;
            attributeIndexBuilder = new AttributeIndexBuilder(this.importContext, attrIndex.approximateIndex, indexEntryLimit, indexBufferSize);
            this.builders.add(attributeIndexBuilder);
        }
        for (VLVIndex vlvIndex : this.entryContainer.getVLVIndexes()) {
            VLVIndexBuilder vlvIndexBuilder = new VLVIndexBuilder(this.importContext, vlvIndex, indexBufferSize);
            this.builders.add(vlvIndexBuilder);
        }
        Index id2Children = this.entryContainer.getID2Children();
        AttributeIndexBuilder attributeIndexBuilder = new AttributeIndexBuilder(this.importContext, id2Children, this.importContext.getConfig().getBackendIndexEntryLimit(), indexBufferSize);
        this.builders.add(attributeIndexBuilder);
        Index id2Subtree = this.entryContainer.getID2Subtree();
        attributeIndexBuilder = new AttributeIndexBuilder(this.importContext, id2Subtree, this.importContext.getConfig().getBackendIndexEntryLimit(), indexBufferSize);
        this.builders.add(attributeIndexBuilder);
        for (IndexBuilder b : this.builders) {
            b.startProcessing();
        }
        try {
            do {
                Entry entry;
                try {
                    entry = this.queue.poll(1000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    continue;
                }
                if (entry == null) continue;
                Transaction txn = null;
                Entry existingEntry = null;
                EntryID entryID = null;
                if (entry.getAttachment() instanceof Entry) {
                    existingEntry = (Entry)entry.getAttachment();
                    entryID = (EntryID)existingEntry.getAttachment();
                    this.dn2uri.replaceEntry(txn, existingEntry, entry);
                } else {
                    existingEntry = null;
                    ArrayList ids = (ArrayList)entry.getAttachment();
                    entryID = (EntryID)ids.get(0);
                    ++this.entryInsertCount;
                    this.dn2uri.addEntry(txn, entry);
                }
                this.id2entry.put(txn, entryID, entry);
                for (IndexBuilder b : this.builders) {
                    b.processEntry(existingEntry, entry, entryID);
                }
                ++this.importedCount;
            } while (!this.stopRequested);
            for (IndexBuilder b : this.builders) {
                b.stopProcessing();
            }
            this.importContext.incrEntryInsertCount(this.entryInsertCount);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new RuntimeException(e);
        }
    }
}

