/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.Transaction;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.opends.server.admin.std.server.JEBackendCfg;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.DN2ID;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.ID2Entry;
import org.opends.server.backends.jeb.ImportContext;
import org.opends.server.backends.jeb.ImportThread;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.IndexMergeThread;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.RootContainer;
import org.opends.server.backends.jeb.VLVIndex;
import org.opends.server.backends.jeb.VLVIndexMergeThread;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LDIFImportResult;
import org.opends.server.types.ResultCode;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.StaticUtils;

public class ImportJob
implements Thread.UncaughtExceptionHandler {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private JEBackendCfg config;
    private RootContainer rootContainer;
    private LDIFImportConfig ldifImportConfig;
    private LDIFReader reader;
    private HashMap<DN, ImportContext> importMap = new HashMap();
    private int importedCount;
    private int migratedCount;
    int mergePassNumber = 1;
    private long progressInterval = 10000L;
    private Timer timer;
    private int entriesProcessed;
    private int importPassSize;
    private CopyOnWriteArrayList<ImportThread> threads;

    public ImportJob(LDIFImportConfig ldifImportConfig) {
        this.ldifImportConfig = ldifImportConfig;
        this.threads = new CopyOnWriteArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDIFImportResult importLDIF(RootContainer rootContainer) throws DatabaseException, IOException, JebException, DirectoryException, ConfigException {
        long startTime;
        String message;
        int msgID;
        this.reader = new LDIFReader(this.ldifImportConfig);
        this.rootContainer = rootContainer;
        this.config = rootContainer.getConfiguration();
        this.mergePassNumber = 1;
        this.entriesProcessed = 0;
        this.importPassSize = this.config.getBackendImportPassSize();
        if (this.importPassSize <= 0) {
            this.importPassSize = Integer.MAX_VALUE;
        }
        try {
            int importThreadCount = this.config.getBackendImportThreadCount();
            long bufferSize = this.config.getBackendImportBufferSize() / (long)(importThreadCount * rootContainer.getBaseDNs().size());
            msgID = 8388697;
            message = MessageHandler.getMessage(msgID, importThreadCount);
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message, msgID);
            if (DebugLogger.debugEnabled()) {
                msgID = 8388698;
                message = MessageHandler.getMessage(msgID, bufferSize);
                TRACER.debugInfo(message);
                msgID = 0x800077;
                message = MessageHandler.getMessage(msgID, rootContainer.getEnvironmentConfig().toString());
                TRACER.debugInfo(message);
            }
            for (EntryContainer entryContainer : rootContainer.getEntryContainers()) {
                ImportContext importContext = this.getImportContext(entryContainer, bufferSize);
                if (importContext == null) continue;
                this.importMap.put(entryContainer.getBaseDN(), importContext);
            }
            startTime = System.currentTimeMillis();
            File tempDir = StaticUtils.getFileForPath(this.config.getBackendImportTempDirectory());
            if (!tempDir.exists() && !tempDir.mkdir()) {
                msgID = 8650907;
                String msg = MessageHandler.getMessage(msgID, tempDir);
                throw new IOException(msg);
            }
            if (tempDir.listFiles() != null) {
                for (File f : tempDir.listFiles()) {
                    f.delete();
                }
            }
            this.startWorkerThreads();
            try {
                this.importedCount = 0;
                this.migratedCount = 0;
                this.migrateExistingEntries();
                this.processLDIF();
                this.migrateExcludedEntries();
                Object var15_15 = null;
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                this.merge(false);
                tempDir.delete();
                for (ImportContext importContext : this.importMap.values()) {
                    EntryContainer unregEC;
                    DN baseDN = importContext.getBaseDN();
                    EntryContainer srcEntryContainer = importContext.getSrcEntryContainer();
                    if (srcEntryContainer == null) continue;
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("Deleteing old entry container for base DN %s and renaming temp entry container", baseDN);
                    }
                    if ((unregEC = rootContainer.unregisterEntryContainer(baseDN)) != srcEntryContainer) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugInfo("Current entry container used for base DN %s is not the same as the source entry container used during the migration process.", baseDN);
                        }
                        rootContainer.registerEntryContainer(baseDN, unregEC);
                        continue;
                    }
                    srcEntryContainer.exclusiveLock.lock();
                    srcEntryContainer.delete();
                    srcEntryContainer.exclusiveLock.unlock();
                    EntryContainer newEC = importContext.getEntryContainer();
                    newEC.exclusiveLock.lock();
                    newEC.setDatabasePrefix(baseDN.toNormalizedString());
                    newEC.exclusiveLock.unlock();
                    rootContainer.registerEntryContainer(baseDN, newEC);
                }
                throw throwable;
            }
            this.merge(false);
            tempDir.delete();
            for (ImportContext importContext : this.importMap.values()) {
                EntryContainer unregEC;
                DN baseDN = importContext.getBaseDN();
                EntryContainer srcEntryContainer = importContext.getSrcEntryContainer();
                if (srcEntryContainer == null) continue;
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Deleteing old entry container for base DN %s and renaming temp entry container", baseDN);
                }
                if ((unregEC = rootContainer.unregisterEntryContainer(baseDN)) != srcEntryContainer) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("Current entry container used for base DN %s is not the same as the source entry container used during the migration process.", baseDN);
                    }
                    rootContainer.registerEntryContainer(baseDN, unregEC);
                    continue;
                }
                srcEntryContainer.exclusiveLock.lock();
                srcEntryContainer.delete();
                srcEntryContainer.exclusiveLock.unlock();
                EntryContainer newEC = importContext.getEntryContainer();
                newEC.exclusiveLock.lock();
                newEC.setDatabasePrefix(baseDN.toNormalizedString());
                newEC.exclusiveLock.unlock();
                rootContainer.registerEntryContainer(baseDN, newEC);
            }
        }
        finally {
            this.reader.close();
        }
        long finishTime = System.currentTimeMillis();
        long importTime = finishTime - startTime;
        float rate = 0.0f;
        if (importTime > 0L) {
            rate = 1000.0f * (float)this.importedCount / (float)importTime;
        }
        msgID = 8388702;
        message = MessageHandler.getMessage(msgID, this.reader.getEntriesRead(), this.importedCount - this.migratedCount, this.reader.getEntriesIgnored(), this.reader.getEntriesRejected(), this.migratedCount, importTime / 1000L, Float.valueOf(rate));
        ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message, msgID);
        msgID = 8388703;
        message = MessageHandler.getMessage(msgID, this.getEntryLimitExceededCount());
        ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message, msgID);
        return new LDIFImportResult(this.reader.getEntriesRead(), this.reader.getEntriesRejected(), this.reader.getEntriesIgnored());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void merge(boolean moreData) throws DatabaseException {
        this.stopWorkerThreads();
        try {
            String message;
            int msgID;
            if (moreData) {
                msgID = 8388729;
                String message2 = MessageHandler.getMessage(msgID, this.mergePassNumber++);
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message2, msgID);
            } else {
                msgID = 8388730;
                String message2 = MessageHandler.getMessage(msgID);
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message2, msgID);
            }
            long mergeStartTime = System.currentTimeMillis();
            ArrayList<IndexMergeThread> mergers = new ArrayList<IndexMergeThread>();
            ArrayList<VLVIndexMergeThread> vlvIndexMergeThreads = new ArrayList<VLVIndexMergeThread>();
            for (ImportContext importContext : this.importMap.values()) {
                EntryContainer entryContainer = importContext.getEntryContainer();
                for (AttributeIndex attrIndex : entryContainer.getAttributeIndexes()) {
                    IndexMergeThread indexMergeThread;
                    Index index;
                    int indexEntryLimit = this.config.getBackendIndexEntryLimit();
                    if (attrIndex.getConfiguration().getIndexEntryLimit() != null) {
                        indexEntryLimit = attrIndex.getConfiguration().getIndexEntryLimit();
                    }
                    if (attrIndex.equalityIndex != null) {
                        index = attrIndex.equalityIndex;
                        indexMergeThread = new IndexMergeThread(this.config, this.ldifImportConfig, index, indexEntryLimit);
                        mergers.add(indexMergeThread);
                    }
                    if (attrIndex.presenceIndex != null) {
                        index = attrIndex.presenceIndex;
                        indexMergeThread = new IndexMergeThread(this.config, this.ldifImportConfig, index, indexEntryLimit);
                        mergers.add(indexMergeThread);
                    }
                    if (attrIndex.substringIndex != null) {
                        index = attrIndex.substringIndex;
                        indexMergeThread = new IndexMergeThread(this.config, this.ldifImportConfig, index, indexEntryLimit);
                        mergers.add(indexMergeThread);
                    }
                    if (attrIndex.orderingIndex != null) {
                        index = attrIndex.orderingIndex;
                        indexMergeThread = new IndexMergeThread(this.config, this.ldifImportConfig, index, indexEntryLimit);
                        mergers.add(indexMergeThread);
                    }
                    if (attrIndex.approximateIndex == null) continue;
                    index = attrIndex.approximateIndex;
                    indexMergeThread = new IndexMergeThread(this.config, this.ldifImportConfig, index, indexEntryLimit);
                    mergers.add(indexMergeThread);
                }
                for (VLVIndex vlvIndex : entryContainer.getVLVIndexes()) {
                    VLVIndexMergeThread vlvIndexMergeThread = new VLVIndexMergeThread(this.config, this.ldifImportConfig, vlvIndex);
                    vlvIndexMergeThread.setUncaughtExceptionHandler(this);
                    vlvIndexMergeThreads.add(vlvIndexMergeThread);
                }
                Index id2Children = entryContainer.getID2Children();
                IndexMergeThread indexMergeThread = new IndexMergeThread(this.config, this.ldifImportConfig, id2Children, this.config.getBackendIndexEntryLimit());
                mergers.add(indexMergeThread);
                Index id2Subtree = entryContainer.getID2Subtree();
                indexMergeThread = new IndexMergeThread(this.config, this.ldifImportConfig, id2Subtree, this.config.getBackendIndexEntryLimit());
                mergers.add(indexMergeThread);
            }
            for (IndexMergeThread indexMergeThread : mergers) {
                indexMergeThread.start();
            }
            for (VLVIndexMergeThread vLVIndexMergeThread : vlvIndexMergeThreads) {
                vLVIndexMergeThread.start();
            }
            for (IndexMergeThread indexMergeThread : mergers) {
                try {
                    indexMergeThread.join();
                }
                catch (InterruptedException e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            for (VLVIndexMergeThread vLVIndexMergeThread : vlvIndexMergeThreads) {
                try {
                    vLVIndexMergeThread.join();
                }
                catch (InterruptedException e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            long mergeEndTime = System.currentTimeMillis();
            if (moreData) {
                int msgID2 = 8388731;
                message = MessageHandler.getMessage(msgID2, (mergeEndTime - mergeStartTime) / 1000L);
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message, msgID2);
            } else {
                int msgID3 = 8388732;
                message = MessageHandler.getMessage(msgID3, (mergeEndTime - mergeStartTime) / 1000L);
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message, msgID3);
            }
        }
        finally {
            if (moreData) {
                this.startWorkerThreads();
            }
        }
    }

    private void startWorkerThreads() throws DatabaseException {
        int importThreadCount = this.config.getBackendImportThreadCount();
        for (ImportContext ic : this.importMap.values()) {
            for (int i = 0; i < importThreadCount; ++i) {
                ImportThread t = new ImportThread(ic, i);
                t.setUncaughtExceptionHandler(this);
                this.threads.add(t);
                t.start();
            }
        }
        this.timer = new Timer();
        ProgressTask progressTask = new ProgressTask();
        this.timer.scheduleAtFixedRate((TimerTask)progressTask, this.progressInterval, this.progressInterval);
    }

    private void stopWorkerThreads() {
        if (this.threads.size() > 0) {
            for (ImportContext ic : this.importMap.values()) {
                while (ic.getQueue().size() > 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {}
                }
            }
        }
        for (ImportThread t : this.threads) {
            t.stopProcessing();
        }
        for (ImportThread t : this.threads) {
            try {
                t.join();
                this.importedCount += t.getImportedCount();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.timer.cancel();
    }

    private void processLDIF() throws JebException, DatabaseException, IOException {
        int msgID = 8388766;
        String message = MessageHandler.getMessage(msgID);
        ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message, msgID);
        while (true) {
            if (this.threads.size() <= 0) {
                msgID = 8650906;
                message = MessageHandler.getMessage(msgID);
                throw new JebException(msgID, message);
            }
            try {
                Entry entry = this.reader.readEntry();
                if (entry == null) {
                    msgID = 8388767;
                    message = MessageHandler.getMessage(msgID);
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message, msgID);
                    break;
                }
                ImportContext importContext = this.getImportConfig(entry.getDN());
                this.processEntry(importContext, entry);
                ++this.entriesProcessed;
                if (this.entriesProcessed < this.importPassSize) continue;
                this.merge(false);
                this.entriesProcessed = 0;
            }
            catch (LDIFException e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            catch (DirectoryException e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateExistingEntries() throws JebException, DatabaseException, DirectoryException {
        for (ImportContext importContext : this.importMap.values()) {
            EntryContainer srcEntryContainer = importContext.getSrcEntryContainer();
            if (srcEntryContainer == null || importContext.getIncludeBranches().isEmpty()) continue;
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            LockMode lockMode = LockMode.DEFAULT;
            int msgID = 8388765;
            String message = MessageHandler.getMessage(msgID, "existing", importContext.getBaseDN());
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message, msgID);
            Cursor cursor = srcEntryContainer.getDN2ID().openCursor(null, CursorConfig.READ_COMMITTED);
            try {
                OperationStatus status = cursor.getFirst(key, data, lockMode);
                while (status == OperationStatus.SUCCESS) {
                    if (this.threads.size() <= 0) {
                        msgID = 8650906;
                        message = MessageHandler.getMessage(msgID);
                        throw new JebException(msgID, message);
                    }
                    DN dn = DN.decode(new ASN1OctetString(key.getData()));
                    if (!importContext.getIncludeBranches().contains(dn)) {
                        EntryID id = new EntryID(data);
                        Entry entry = srcEntryContainer.getID2Entry().get(null, id);
                        this.processEntry(importContext, entry);
                        ++this.entriesProcessed;
                        ++this.migratedCount;
                        if (this.entriesProcessed >= this.importPassSize) {
                            this.merge(true);
                            this.entriesProcessed = 0;
                        }
                        status = cursor.getNext(key, data, lockMode);
                        continue;
                    }
                    byte[] begin = StaticUtils.getBytes("," + dn.toNormalizedString());
                    begin[0] = (byte)(begin[0] + 1);
                    key.setData(begin);
                    status = cursor.getSearchKeyRange(key, data, lockMode);
                }
            }
            finally {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateExcludedEntries() throws JebException, DatabaseException {
        for (ImportContext importContext : this.importMap.values()) {
            EntryContainer srcEntryContainer = importContext.getSrcEntryContainer();
            if (srcEntryContainer == null || importContext.getExcludeBranches().isEmpty()) continue;
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            LockMode lockMode = LockMode.DEFAULT;
            int msgID = 8388765;
            String message = MessageHandler.getMessage(msgID, "excluded", importContext.getBaseDN());
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message, msgID);
            Cursor cursor = srcEntryContainer.getDN2ID().openCursor(null, CursorConfig.READ_COMMITTED);
            Comparator<byte[]> dn2idComparator = srcEntryContainer.getDN2ID().getComparator();
            try {
                for (DN excludedDN : importContext.getExcludeBranches()) {
                    byte[] suffix = StaticUtils.getBytes(excludedDN.toNormalizedString());
                    key.setData(suffix);
                    OperationStatus status = cursor.getSearchKeyRange(key, data, lockMode);
                    if (status != OperationStatus.SUCCESS || !Arrays.equals(key.getData(), suffix)) continue;
                    byte[] end = StaticUtils.getBytes("," + excludedDN.toNormalizedString());
                    end[0] = (byte)(end[0] + 1);
                    while (status == OperationStatus.SUCCESS && dn2idComparator.compare(key.getData(), end) < 0) {
                        if (this.threads.size() <= 0) {
                            msgID = 8650906;
                            message = MessageHandler.getMessage(msgID);
                            throw new JebException(msgID, message);
                        }
                        EntryID id = new EntryID(data);
                        Entry entry = srcEntryContainer.getID2Entry().get(null, id);
                        this.processEntry(importContext, entry);
                        ++this.entriesProcessed;
                        ++this.migratedCount;
                        if (this.entriesProcessed >= this.importPassSize) {
                            this.merge(true);
                            this.entriesProcessed = 0;
                        }
                        status = cursor.getNext(key, data, lockMode);
                    }
                }
            }
            finally {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEntry(ImportContext importContext, Entry entry) throws JebException, DatabaseException {
        DN entryDN = entry.getDN();
        LDIFImportConfig ldifImportConfig = importContext.getLDIFImportConfig();
        Transaction txn = null;
        if (ldifImportConfig.appendToExistingData()) {
            txn = importContext.getEntryContainer().beginTransaction();
        }
        DN2ID dn2id = importContext.getEntryContainer().getDN2ID();
        ID2Entry id2entry = importContext.getEntryContainer().getID2Entry();
        try {
            block22: {
                ArrayList<Object> IDs;
                EntryID entryID = dn2id.get(txn, entryDN);
                if (entryID != null) {
                    if (ldifImportConfig.appendToExistingData() && ldifImportConfig.replaceExistingEntries()) {
                        Entry oldEntry = id2entry.get(txn, entryID);
                        oldEntry.setAttachment(entryID);
                        entry.setAttachment(oldEntry);
                        try {
                            importContext.getQueue().put(entry);
                        }
                        catch (InterruptedException e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            break block22;
                        }
                    }
                    int msgID = 8519724;
                    String msg = MessageHandler.getMessage(msgID);
                    importContext.getLDIFReader().rejectLastEntry(msg);
                    return;
                }
                EntryID parentID = null;
                DN parentDN = importContext.getEntryContainer().getParentWithinBase(entryDN);
                if (parentDN != null && (parentID = dn2id.get(txn, parentDN)) == null) {
                    int msgID = 8585259;
                    String msg = MessageHandler.getMessage(msgID, parentDN.toString());
                    importContext.getLDIFReader().rejectLastEntry(msg);
                    return;
                }
                entryID = this.rootContainer.getNextEntryID();
                dn2id.insert(txn, entryDN, entryID);
                if (parentDN != null && importContext.getParentDN() != null && parentDN.equals(importContext.getParentDN())) {
                    IDs = new ArrayList<EntryID>(importContext.getIDs());
                    IDs.set(0, entryID);
                } else {
                    IDs = new ArrayList<EntryID>(entryDN.getNumComponents());
                    IDs.add(entryID);
                    if (parentID != null) {
                        IDs.add(parentID);
                        EntryContainer ec = importContext.getEntryContainer();
                        DN dn = ec.getParentWithinBase(parentDN);
                        while (dn != null) {
                            EntryID nodeID = dn2id.get(txn, dn);
                            IDs.add(nodeID);
                            dn = ec.getParentWithinBase(dn);
                        }
                    }
                }
                importContext.setParentDN(parentDN);
                importContext.setIDs(IDs);
                entry.setAttachment(IDs);
                try {
                    while (!importContext.getQueue().offer(entry, 1000L, TimeUnit.MILLISECONDS)) {
                        if (this.threads.size() > 0) continue;
                        return;
                    }
                }
                catch (InterruptedException e) {
                    if (!DebugLogger.debugEnabled()) break block22;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            if (txn != null) {
                importContext.getEntryContainer();
                EntryContainer.transactionCommit(txn);
                txn = null;
            }
        }
        finally {
            if (txn != null) {
                importContext.getEntryContainer();
                EntryContainer.transactionAbort(txn);
            }
        }
    }

    private int getEntryLimitExceededCount() {
        int count = 0;
        for (ImportContext ic : this.importMap.values()) {
            count += ic.getEntryContainer().getEntryLimitExceededCount();
        }
        return count;
    }

    public void uncaughtException(Thread t, Throwable e) {
        this.threads.remove(t);
        int msgID = 8650905;
        String msg = MessageHandler.getMessage(msgID, t.getName(), StaticUtils.stackTraceToSingleLineString(e.getCause()));
        ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, msg, msgID);
    }

    private ImportContext getImportConfig(DN dn) throws DirectoryException {
        ImportContext importContext = null;
        DN nodeDN = dn;
        while (importContext == null && nodeDN != null) {
            importContext = this.importMap.get(nodeDN);
            if (importContext != null) continue;
            nodeDN = nodeDN.getParentDNInSuffix();
        }
        if (nodeDN == null) {
            String message = MessageHandler.getMessage(8585217, String.valueOf(dn));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, 8585217);
        }
        return importContext;
    }

    private ImportContext getImportContext(EntryContainer entryContainer, long bufferSize) throws DatabaseException, JebException, ConfigException {
        DN baseDN = entryContainer.getBaseDN();
        EntryContainer srcEntryContainer = null;
        ArrayList<DN> includeBranches = new ArrayList<DN>();
        ArrayList<DN> excludeBranches = new ArrayList<DN>();
        if (!this.ldifImportConfig.appendToExistingData() && !this.ldifImportConfig.clearBackend()) {
            for (DN dn : this.ldifImportConfig.getExcludeBranches()) {
                if (baseDN.equals(dn)) {
                    return null;
                }
                if (!baseDN.isAncestorOf(dn)) continue;
                excludeBranches.add(dn);
            }
            if (!this.ldifImportConfig.getIncludeBranches().isEmpty()) {
                for (DN dn : this.ldifImportConfig.getIncludeBranches()) {
                    if (!baseDN.isAncestorOf(dn)) continue;
                    includeBranches.add(dn);
                }
                if (includeBranches.isEmpty()) {
                    return null;
                }
                Iterator includeBranchIterator = includeBranches.iterator();
                while (includeBranchIterator.hasNext()) {
                    DN includeDN = (DN)includeBranchIterator.next();
                    boolean keep = true;
                    for (DN dn : includeBranches) {
                        if (dn.equals(includeDN) || !dn.isAncestorOf(includeDN)) continue;
                        keep = false;
                        break;
                    }
                    if (keep) continue;
                    includeBranchIterator.remove();
                }
                Iterator excludeBranchIterator = excludeBranches.iterator();
                while (excludeBranchIterator.hasNext()) {
                    DN excludeDN = (DN)excludeBranchIterator.next();
                    boolean keep = false;
                    for (DN includeDN : includeBranches) {
                        if (!includeDN.isAncestorOf(excludeDN)) continue;
                        keep = true;
                        break;
                    }
                    if (keep) continue;
                    excludeBranchIterator.remove();
                }
                if (includeBranches.size() == 1 && excludeBranches.size() == 0 && ((DN)includeBranches.get(0)).equals(baseDN)) {
                    entryContainer.exclusiveLock.lock();
                    entryContainer.clear();
                    entryContainer.exclusiveLock.unlock();
                } else {
                    srcEntryContainer = entryContainer;
                    entryContainer = this.rootContainer.openEntryContainer(baseDN, baseDN.toNormalizedString() + "_importTmp");
                }
            }
        }
        ImportContext importContext = new ImportContext();
        importContext.setBufferSize(bufferSize);
        importContext.setConfig(this.config);
        importContext.setLDIFImportConfig(this.ldifImportConfig);
        importContext.setLDIFReader(this.reader);
        importContext.setBaseDN(baseDN);
        importContext.setEntryContainer(entryContainer);
        importContext.setSrcEntryContainer(srcEntryContainer);
        importContext.setBufferSize(bufferSize);
        LinkedBlockingQueue<Entry> queue = new LinkedBlockingQueue<Entry>(this.config.getBackendImportQueueSize());
        importContext.setQueue(queue);
        importContext.setIncludeBranches(includeBranches);
        importContext.setExcludeBranches(excludeBranches);
        return importContext;
    }

    class ProgressTask
    extends TimerTask {
        private long previousCount = 0L;
        private long previousTime = System.currentTimeMillis();
        private EnvironmentStats prevEnvStats;
        private static final int bytesPerMegabyte = 0x100000;

        public ProgressTask() throws DatabaseException {
            this.prevEnvStats = ImportJob.this.rootContainer.getEnvironmentStats(new StatsConfig());
        }

        public void run() {
            long latestCount = ImportJob.this.reader.getEntriesRead() + (long)ImportJob.this.migratedCount;
            long deltaCount = latestCount - this.previousCount;
            long latestTime = System.currentTimeMillis();
            long deltaTime = latestTime - this.previousTime;
            if (deltaTime == 0L) {
                return;
            }
            long numRead = ImportJob.this.reader.getEntriesRead();
            long numIgnored = ImportJob.this.reader.getEntriesIgnored();
            long numRejected = ImportJob.this.reader.getEntriesRejected();
            float rate = 1000.0f * (float)deltaCount / (float)deltaTime;
            int msgID = 0x800060;
            String message = MessageHandler.getMessage(msgID, numRead, numIgnored, numRejected, ImportJob.this.migratedCount, Float.valueOf(rate));
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message, msgID);
            try {
                Runtime runtime = Runtime.getRuntime();
                long freeMemory = runtime.freeMemory() / 0x100000L;
                EnvironmentStats envStats = ImportJob.this.rootContainer.getEnvironmentStats(new StatsConfig());
                long nCacheMiss = envStats.getNCacheMiss() - this.prevEnvStats.getNCacheMiss();
                float cacheMissRate = 0.0f;
                if (deltaCount > 0L) {
                    cacheMissRate = (float)nCacheMiss / (float)deltaCount;
                }
                msgID = 8388705;
                message = MessageHandler.getMessage(msgID, freeMemory, Float.valueOf(cacheMissRate));
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message, msgID);
                this.prevEnvStats = envStats;
            }
            catch (DatabaseException e) {
                // empty catch block
            }
            this.previousCount = latestCount;
            this.previousTime = latestTime;
        }
    }
}

