/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Transaction;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.Indexer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqualityIndexer
extends Indexer {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final Comparator<byte[]> comparator = new AttributeIndex.KeyComparator();
    private AttributeType attributeType;

    public EqualityIndexer(AttributeType attributeType) {
        this.attributeType = attributeType;
    }

    public String toString() {
        return this.attributeType.getNameOrOID() + ".equality";
    }

    @Override
    public Comparator<byte[]> getComparator() {
        return comparator;
    }

    @Override
    public void indexEntry(Transaction txn, Entry entry, Set<ASN1OctetString> keys) throws DatabaseException {
        List<Attribute> attrList = entry.getAttribute(this.attributeType);
        if (attrList != null) {
            this.indexAttribute(attrList, keys);
        }
    }

    @Override
    public void replaceEntry(Transaction txn, Entry oldEntry, Entry newEntry, Set<ASN1OctetString> addKeys, Set<ASN1OctetString> delKeys) throws DatabaseException {
        List<Attribute> attrList = oldEntry.getAttribute(this.attributeType);
        HashSet<ASN1OctetString> oldSet = new HashSet<ASN1OctetString>();
        this.indexAttribute(attrList, oldSet);
        attrList = newEntry.getAttribute(this.attributeType);
        HashSet<ASN1OctetString> newSet = new HashSet<ASN1OctetString>();
        this.indexAttribute(attrList, newSet);
        HashSet<ASN1OctetString> removeSet = new HashSet<ASN1OctetString>(oldSet);
        removeSet.removeAll(newSet);
        for (ASN1OctetString k : removeSet) {
            delKeys.add(k);
        }
        HashSet<ASN1OctetString> addSet = new HashSet<ASN1OctetString>(newSet);
        addSet.removeAll(oldSet);
        for (ASN1OctetString k : addSet) {
            addKeys.add(k);
        }
    }

    @Override
    public void modifyEntry(Transaction txn, Entry oldEntry, Entry newEntry, List<Modification> mods, Set<ASN1OctetString> addKeys, Set<ASN1OctetString> delKeys) throws DatabaseException {
        List<Attribute> beforeList = oldEntry.getAttribute(this.attributeType);
        List<Attribute> afterList = newEntry.getAttribute(this.attributeType);
        boolean hasOptions = false;
        if (beforeList != null) {
            for (Attribute a : beforeList) {
                if (!a.hasOptions()) continue;
                hasOptions = true;
                break;
            }
        }
        if (afterList != null) {
            for (Attribute a : afterList) {
                if (!a.hasOptions()) continue;
                hasOptions = true;
                break;
            }
        }
        boolean hasOnlySimpleMods = true;
        ArrayList<Modification> simpleMods = new ArrayList<Modification>();
        block10: for (Modification mod : mods) {
            Attribute modAttr = mod.getAttribute();
            AttributeType modAttrType = modAttr.getAttributeType();
            if (!modAttrType.equals(this.attributeType)) continue;
            if (modAttr.hasOptions()) {
                hasOptions = true;
            }
            switch (mod.getModificationType()) {
                case ADD: {
                    simpleMods.add(mod);
                    continue block10;
                }
                case DELETE: {
                    if (!modAttr.hasValue()) {
                        hasOnlySimpleMods = false;
                        continue block10;
                    }
                    simpleMods.add(mod);
                    continue block10;
                }
            }
            hasOnlySimpleMods = false;
        }
        if (hasOnlySimpleMods && !hasOptions) {
            block11: for (Modification mod : simpleMods) {
                LinkedHashSet<AttributeValue> values = mod.getAttribute().getValues();
                HashSet<ASN1OctetString> keys = new HashSet<ASN1OctetString>(values.size());
                this.indexValues(values, keys);
                switch (mod.getModificationType()) {
                    case ADD: {
                        for (ASN1OctetString key : keys) {
                            if (delKeys.contains(key)) {
                                delKeys.remove(key);
                                continue;
                            }
                            addKeys.add(key);
                        }
                        continue block11;
                    }
                    case DELETE: {
                        for (ASN1OctetString key : keys) {
                            if (addKeys.contains(key)) {
                                addKeys.remove(key);
                                continue;
                            }
                            delKeys.add(key);
                        }
                        break;
                    }
                }
            }
        } else {
            HashSet<ASN1OctetString> oldSet = new HashSet<ASN1OctetString>();
            this.indexAttribute(beforeList, oldSet);
            HashSet<ASN1OctetString> newSet = new HashSet<ASN1OctetString>();
            this.indexAttribute(afterList, newSet);
            HashSet<ASN1OctetString> removeSet = new HashSet<ASN1OctetString>(oldSet);
            removeSet.removeAll(newSet);
            delKeys.addAll(removeSet);
            HashSet<ASN1OctetString> addSet = new HashSet<ASN1OctetString>(newSet);
            addSet.removeAll(oldSet);
            addKeys.addAll(addSet);
        }
    }

    private void indexValues(Set<AttributeValue> values, Set<ASN1OctetString> keys) {
        if (values == null) {
            return;
        }
        for (AttributeValue value : values) {
            try {
                byte[] keyBytes = value.getNormalizedValue().value();
                keys.add(new ASN1OctetString(keyBytes));
            }
            catch (DirectoryException e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    private void indexAttribute(List<Attribute> attrList, Set<ASN1OctetString> keys) {
        if (attrList == null) {
            return;
        }
        for (Attribute attr : attrList) {
            this.indexValues(attr.getValues(), keys);
        }
    }
}

