/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.io.File;
import java.io.FilenameFilter;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DebugLogLevel;

public class EnvManager {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final FilenameFilter jeAllFilesFilter = new FilenameFilter(){

        public boolean accept(File d, String name) {
            return name.endsWith(".jdb") || name.endsWith(".del") || name.equals("je.lck");
        }
    };

    public static void createHomeDir(String homeDir) throws JebException {
        File dir = new File(homeDir);
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                String message = MessageHandler.getMessage(8650761, homeDir);
                throw new JebException(8650761, message);
            }
            EnvManager.removeFiles(homeDir);
        } else {
            try {
                dir.mkdir();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                String message = MessageHandler.getMessage(8650759, e.getMessage());
                throw new JebException(8650759, message, e);
            }
        }
    }

    public static void removeFiles(String homeDir) throws JebException {
        File dir = new File(homeDir);
        if (!dir.isDirectory()) {
            String message = MessageHandler.getMessage(8650761, homeDir);
            throw new JebException(8650761, message);
        }
        try {
            File[] jdbFiles;
            for (File f : jdbFiles = dir.listFiles(jeAllFilesFilter)) {
                f.delete();
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            String message = MessageHandler.getMessage(0x840008, e.getMessage());
            throw new JebException(0x840008, message, e);
        }
    }
}

