/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.PreloadConfig;
import com.sleepycat.je.PreloadStats;
import com.sleepycat.je.Transaction;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;

public abstract class DatabaseContainer {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    protected EntryContainer entryContainer;
    protected DatabaseConfig dbConfig;
    protected String name;
    private Environment env;
    private CopyOnWriteArrayList<Database> databases;
    private ThreadLocal<Database> threadLocalDatabase = new ThreadLocal();

    protected DatabaseContainer(String name, Environment env, EntryContainer entryContainer) throws DatabaseException {
        this.env = env;
        this.entryContainer = entryContainer;
        this.databases = new CopyOnWriteArrayList();
        this.name = name;
    }

    private Database openDatabase() throws DatabaseException {
        Database database;
        if (this.dbConfig.getTransactional()) {
            Transaction txn = this.entryContainer.beginTransaction();
            try {
                database = this.env.openDatabase(txn, this.name, this.dbConfig);
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugVerbose("JE database %s opened with %d records. txnid=%d", database.getDatabaseName(), database.count(), txn.getId());
                }
                EntryContainer.transactionCommit(txn);
            }
            catch (DatabaseException e) {
                EntryContainer.transactionAbort(txn);
                throw e;
            }
        } else {
            database = this.env.openDatabase(null, this.name, this.dbConfig);
            if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("JE database %s opened with %d records. txnid=none", database.getDatabaseName(), database.count());
            }
        }
        return database;
    }

    private Database getDatabase() throws DatabaseException {
        Database database = this.threadLocalDatabase.get();
        if (database == null) {
            database = this.openDatabase();
            this.databases.add(database);
            this.threadLocalDatabase.set(database);
        }
        return database;
    }

    public void open() throws DatabaseException {
        this.getDatabase();
    }

    synchronized void close() throws DatabaseException {
        for (Database database : this.databases) {
            if (database.getConfig().getDeferredWrite()) {
                database.sync();
            }
            database.close();
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Closed database %s (%d handles)", this.name, this.databases.size());
        }
        this.databases.clear();
        this.threadLocalDatabase = new ThreadLocal();
    }

    protected OperationStatus put(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        Database database = this.getDatabase();
        OperationStatus status = database.put(txn, key, data);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugJEAccess(DebugLogLevel.VERBOSE, status, database, txn, key, data);
        }
        return status;
    }

    protected OperationStatus read(Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        Database database = this.getDatabase();
        OperationStatus status = database.get(txn, key, data, lockMode);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugJEAccess(DebugLogLevel.VERBOSE, status, database, txn, key, data);
        }
        return status;
    }

    protected OperationStatus insert(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        Database database = this.getDatabase();
        OperationStatus status = database.putNoOverwrite(txn, key, data);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugJEAccess(DebugLogLevel.VERBOSE, status, database, txn, key, data);
        }
        return status;
    }

    protected OperationStatus delete(Transaction txn, DatabaseEntry key) throws DatabaseException {
        Database database = this.getDatabase();
        OperationStatus status = database.delete(txn, key);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugJEAccess(DebugLogLevel.VERBOSE, status, database, txn, key, null);
        }
        return status;
    }

    public Cursor openCursor(Transaction txn, CursorConfig cursorConfig) throws DatabaseException {
        Database database = this.getDatabase();
        return database.openCursor(txn, cursorConfig);
    }

    public long getRecordCount() throws DatabaseException {
        Database database = this.getDatabase();
        long count = database.count();
        if (DebugLogger.debugEnabled()) {
            TRACER.debugJEAccess(DebugLogLevel.VERBOSE, OperationStatus.SUCCESS, database, null, null, null);
        }
        return count;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public PreloadStats preload(PreloadConfig config) throws DatabaseException {
        return this.getDatabase().preload(config);
    }

    void setName(String name) {
        this.name = name;
    }
}

