/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.RootDSEBackendCfg;
import org.opends.server.api.Backend;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.ByteString;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.CancelledOperationException;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LDIFImportResult;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootDSEBackend
extends Backend
implements ConfigurationChangeListener<RootDSEBackendCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ArrayList<Attribute> staticDSEAttributes;
    private ArrayList<Attribute> userDefinedAttributes;
    private boolean showAllAttributes;
    private ConcurrentHashMap<DN, Backend> subordinateBaseDNs;
    private HashMap<ObjectClass, String> dseObjectClasses;
    private RootDSEBackendCfg currentConfig;
    private DN configEntryDN;
    private DN rootDSEDN;
    private DN[] baseDNs;
    private HashSet<String> supportedControls;
    private HashSet<String> supportedFeatures;

    @Override
    public void configureBackend(Configuration config) throws ConfigException {
        Validator.ensureNotNull(config);
        Validator.ensureTrue(config instanceof RootDSEBackendCfg);
        this.currentConfig = (RootDSEBackendCfg)config;
        this.configEntryDN = config.dn();
    }

    @Override
    public void initializeBackend() throws ConfigException, InitializationException {
        ConfigEntry configEntry = DirectoryServer.getConfigEntry(this.configEntryDN);
        if (configEntry == null) {
            int msgID = 9764866;
            String message = MessageHandler.getMessage(msgID);
            throw new ConfigException(msgID, message);
        }
        this.userDefinedAttributes = new ArrayList();
        for (List<Attribute> attrs : configEntry.getEntry().getUserAttributes().values()) {
            for (Attribute a : attrs) {
                if (this.isDSEConfigAttribute(a)) continue;
                this.userDefinedAttributes.add(a);
            }
        }
        for (List<Attribute> attrs : configEntry.getEntry().getOperationalAttributes().values()) {
            for (Attribute a : attrs) {
                if (this.isDSEConfigAttribute(a)) continue;
                this.userDefinedAttributes.add(a);
            }
        }
        this.rootDSEDN = DN.nullDN();
        this.baseDNs = new DN[]{this.rootDSEDN};
        try {
            SortedSet<DN> subDNs = this.currentConfig.getSubordinateBaseDN();
            if (subDNs.isEmpty()) {
                this.subordinateBaseDNs = null;
            } else {
                this.subordinateBaseDNs = new ConcurrentHashMap();
                for (DN baseDN : subDNs) {
                    Backend backend = DirectoryServer.getBackend(baseDN);
                    if (backend == null) {
                        int msgID = 9568260;
                        String message = MessageHandler.getMessage(msgID, String.valueOf(baseDN));
                        ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                        continue;
                    }
                    this.subordinateBaseDNs.put(baseDN, backend);
                }
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 9568261;
            String message = MessageHandler.getMessage(msgID, StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(msgID, message, e);
        }
        this.showAllAttributes = this.currentConfig.isShowAllAttributes();
        this.staticDSEAttributes = new ArrayList();
        this.staticDSEAttributes.add(this.createAttribute("vendorName", "vendorname", "Sun Microsystems, Inc."));
        this.staticDSEAttributes.add(this.createAttribute("vendorVersion", "vendorversion", DirectoryServer.getVersionString()));
        this.dseObjectClasses = new HashMap(2);
        ObjectClass topOC = DirectoryServer.getObjectClass("top");
        if (topOC == null) {
            topOC = DirectoryServer.getDefaultObjectClass("top");
        }
        this.dseObjectClasses.put(topOC, "top");
        ObjectClass rootDSEOC = DirectoryServer.getObjectClass("ds-root-dse");
        if (rootDSEOC == null) {
            rootDSEOC = DirectoryServer.getDefaultObjectClass("ds-root-dse");
        }
        this.dseObjectClasses.put(rootDSEOC, "ds-root-dse");
        this.supportedControls = new HashSet(0);
        this.supportedFeatures = new HashSet(0);
        this.setBackendID("rootdse");
        this.currentConfig.addChangeListener(this);
    }

    @Override
    public void finalizeBackend() {
        this.currentConfig.removeChangeListener(this);
    }

    private boolean isDSEConfigAttribute(Attribute attribute) {
        AttributeType attrType = attribute.getAttributeType();
        return attrType.hasName("ds-cfg-subordinate-base-dn".toLowerCase()) || attrType.hasName("ds-cfg-show-all-attributes".toLowerCase()) || attrType.hasName("cn");
    }

    @Override
    public DN[] getBaseDNs() {
        return this.baseDNs;
    }

    @Override
    public synchronized long getEntryCount() {
        return 1L;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public Entry getEntry(DN entryDN) throws DirectoryException {
        if (entryDN == null || entryDN.isNullDN()) {
            return this.getRootDSE();
        }
        int msgID = 9502726;
        String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN));
        ErrorLogger.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.MILD_WARNING, message, msgID);
        if (this.subordinateBaseDNs != null) {
            for (Backend b : this.subordinateBaseDNs.values()) {
                if (!b.handlesEntry(entryDN)) continue;
                return b.getEntry(entryDN);
            }
        }
        return null;
    }

    public Entry getRootDSE() {
        List<Object> attrs;
        AttributeType type;
        HashMap<AttributeType, List<Attribute>> dseUserAttrs = new HashMap<AttributeType, List<Attribute>>();
        HashMap<AttributeType, List<Attribute>> dseOperationalAttrs = new HashMap<AttributeType, List<Attribute>>();
        Attribute publicNamingContextAttr = this.createDNAttribute("namingContexts", "namingcontexts", DirectoryServer.getPublicNamingContexts().keySet());
        ArrayList<Attribute> publicNamingContextAttrs = new ArrayList<Attribute>(1);
        publicNamingContextAttrs.add(publicNamingContextAttr);
        if (this.showAllAttributes || !publicNamingContextAttr.getAttributeType().isOperational()) {
            dseUserAttrs.put(publicNamingContextAttr.getAttributeType(), publicNamingContextAttrs);
        } else {
            dseOperationalAttrs.put(publicNamingContextAttr.getAttributeType(), publicNamingContextAttrs);
        }
        Attribute privateNamingContextAttr = this.createDNAttribute("ds-private-naming-contexts", "ds-private-naming-contexts", DirectoryServer.getPrivateNamingContexts().keySet());
        ArrayList<Attribute> privateNamingContextAttrs = new ArrayList<Attribute>(1);
        privateNamingContextAttrs.add(privateNamingContextAttr);
        if (this.showAllAttributes || !privateNamingContextAttr.getAttributeType().isOperational()) {
            dseUserAttrs.put(privateNamingContextAttr.getAttributeType(), privateNamingContextAttrs);
        } else {
            dseOperationalAttrs.put(privateNamingContextAttr.getAttributeType(), privateNamingContextAttrs);
        }
        Attribute supportedControlAttr = this.createAttribute("supportedControl", "supportedcontrol", DirectoryServer.getSupportedControls());
        ArrayList<Attribute> supportedControlAttrs = new ArrayList<Attribute>(1);
        supportedControlAttrs.add(supportedControlAttr);
        if (this.showAllAttributes || !supportedControlAttr.getAttributeType().isOperational()) {
            dseUserAttrs.put(supportedControlAttr.getAttributeType(), supportedControlAttrs);
        } else {
            dseOperationalAttrs.put(supportedControlAttr.getAttributeType(), supportedControlAttrs);
        }
        Attribute supportedExtensionAttr = this.createAttribute("supportedExtension", "supportedextension", DirectoryServer.getSupportedExtensions().keySet());
        ArrayList<Attribute> supportedExtensionAttrs = new ArrayList<Attribute>(1);
        supportedExtensionAttrs.add(supportedExtensionAttr);
        if (this.showAllAttributes || !supportedExtensionAttr.getAttributeType().isOperational()) {
            dseUserAttrs.put(supportedExtensionAttr.getAttributeType(), supportedExtensionAttrs);
        } else {
            dseOperationalAttrs.put(supportedExtensionAttr.getAttributeType(), supportedExtensionAttrs);
        }
        Attribute supportedFeatureAttr = this.createAttribute("supportedFeatures", "supportedfeatures", DirectoryServer.getSupportedFeatures());
        ArrayList<Attribute> supportedFeatureAttrs = new ArrayList<Attribute>(1);
        supportedFeatureAttrs.add(supportedFeatureAttr);
        if (this.showAllAttributes || !supportedFeatureAttr.getAttributeType().isOperational()) {
            dseUserAttrs.put(supportedFeatureAttr.getAttributeType(), supportedFeatureAttrs);
        } else {
            dseOperationalAttrs.put(supportedFeatureAttr.getAttributeType(), supportedFeatureAttrs);
        }
        Attribute supportedSASLMechAttr = this.createAttribute("supportedSASLMechanisms", "supportedsaslmechanisms", DirectoryServer.getSupportedSASLMechanisms().keySet());
        ArrayList<Attribute> supportedSASLMechAttrs = new ArrayList<Attribute>(1);
        supportedSASLMechAttrs.add(supportedSASLMechAttr);
        if (this.showAllAttributes || !supportedSASLMechAttr.getAttributeType().isOperational()) {
            dseUserAttrs.put(supportedSASLMechAttr.getAttributeType(), supportedSASLMechAttrs);
        } else {
            dseOperationalAttrs.put(supportedSASLMechAttr.getAttributeType(), supportedSASLMechAttrs);
        }
        Set authPWSchemes = DirectoryServer.getAuthPasswordStorageSchemes().keySet();
        if (!authPWSchemes.isEmpty()) {
            Attribute supportedAuthPWSchemesAttr = this.createAttribute("supportedAuthPasswordSchemes", "supportedauthpasswordschemes", authPWSchemes);
            ArrayList<Attribute> supportedAuthPWSchemesAttrs = new ArrayList<Attribute>(1);
            supportedAuthPWSchemesAttrs.add(supportedAuthPWSchemesAttr);
            if (this.showAllAttributes || !supportedSASLMechAttr.getAttributeType().isOperational()) {
                dseUserAttrs.put(supportedAuthPWSchemesAttr.getAttributeType(), supportedAuthPWSchemesAttrs);
            } else {
                dseOperationalAttrs.put(supportedAuthPWSchemesAttr.getAttributeType(), supportedAuthPWSchemesAttrs);
            }
        }
        for (Attribute a : this.staticDSEAttributes) {
            type = a.getAttributeType();
            if (type.isOperational() && !this.showAllAttributes) {
                attrs = (List)dseOperationalAttrs.get(type);
                if (attrs == null) {
                    attrs = new ArrayList();
                    attrs.add(a);
                    dseOperationalAttrs.put(type, attrs);
                    continue;
                }
                attrs.add(a);
                continue;
            }
            attrs = (ArrayList<Attribute>)dseUserAttrs.get(type);
            if (attrs == null) {
                attrs = new ArrayList<Attribute>();
                attrs.add(a);
                dseUserAttrs.put(type, attrs);
                continue;
            }
            attrs.add(a);
        }
        for (Attribute a : this.userDefinedAttributes) {
            type = a.getAttributeType();
            if (type.isOperational() && !this.showAllAttributes) {
                attrs = dseOperationalAttrs.get(type);
                if (attrs == null) {
                    attrs = new ArrayList();
                    attrs.add(a);
                    dseOperationalAttrs.put(type, attrs);
                    continue;
                }
                attrs.add(a);
                continue;
            }
            attrs = dseUserAttrs.get(type);
            if (attrs == null) {
                attrs = new ArrayList();
                attrs.add(a);
                dseUserAttrs.put(type, attrs);
                continue;
            }
            attrs.add(a);
        }
        Entry e = new Entry(this.rootDSEDN, this.dseObjectClasses, dseUserAttrs, dseOperationalAttrs);
        e.processVirtualAttributes();
        return e;
    }

    private Attribute createAttribute(String name, String lowerName, String value) {
        AttributeType type = DirectoryServer.getAttributeType(lowerName);
        if (type == null) {
            type = DirectoryServer.getDefaultAttributeType(name);
        }
        LinkedHashSet<AttributeValue> attrValues = new LinkedHashSet<AttributeValue>(1);
        attrValues.add(new AttributeValue(type, (ByteString)new ASN1OctetString(value)));
        return new Attribute(type, name, attrValues);
    }

    private Attribute createDNAttribute(String name, String lowerName, Collection<DN> values) {
        AttributeType type = DirectoryServer.getAttributeType(lowerName);
        if (type == null) {
            type = DirectoryServer.getDefaultAttributeType(name);
        }
        LinkedHashSet<AttributeValue> attrValues = new LinkedHashSet<AttributeValue>();
        for (DN dn : values) {
            attrValues.add(new AttributeValue(type, (ByteString)new ASN1OctetString(dn.toString())));
        }
        return new Attribute(type, name, attrValues);
    }

    private Attribute createAttribute(String name, String lowerName, Collection<String> values) {
        AttributeType type = DirectoryServer.getAttributeType(lowerName);
        if (type == null) {
            type = DirectoryServer.getDefaultAttributeType(name);
        }
        LinkedHashSet<AttributeValue> attrValues = new LinkedHashSet<AttributeValue>();
        for (String s : values) {
            attrValues.add(new AttributeValue(type, (ByteString)new ASN1OctetString(s)));
        }
        return new Attribute(type, name, attrValues);
    }

    @Override
    public boolean entryExists(DN entryDN) throws DirectoryException {
        if (entryDN.isNullDN()) {
            return true;
        }
        Map<DN, Backend> baseMap = this.subordinateBaseDNs == null ? DirectoryServer.getPublicNamingContexts() : this.subordinateBaseDNs;
        for (DN baseDN : baseMap.keySet()) {
            Backend b;
            if (!entryDN.isDescendantOf(baseDN) || !(b = baseMap.get(baseDN)).entryExists(entryDN)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addEntry(Entry entry, AddOperation addOperation) throws DirectoryException {
        int msgID = 9633799;
        String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public void deleteEntry(DN entryDN, DeleteOperation deleteOperation) throws DirectoryException {
        int msgID = 9633800;
        String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public void replaceEntry(Entry entry, ModifyOperation modifyOperation) throws DirectoryException {
        int msgID = 0x930009;
        String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), String.valueOf(this.configEntryDN));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public void renameEntry(DN currentDN, Entry entry, ModifyDNOperation modifyDNOperation) throws DirectoryException {
        int msgID = 9633802;
        String message = MessageHandler.getMessage(msgID, String.valueOf(currentDN));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void search(SearchOperation searchOperation) throws DirectoryException, CancelledOperationException {
        DN baseDN = searchOperation.getBaseDN();
        if (!baseDN.isNullDN()) {
            int msgID = 9633803;
            String message = MessageHandler.getMessage(msgID, searchOperation.getConnectionID(), searchOperation.getOperationID(), String.valueOf(baseDN));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
        }
        SearchFilter filter = searchOperation.getFilter();
        switch (searchOperation.getScope()) {
            case BASE_OBJECT: {
                Entry dseEntry = this.getRootDSE();
                if (!filter.matchesEntry(dseEntry)) return;
                searchOperation.returnEntry(dseEntry, null);
                return;
            }
            case SINGLE_LEVEL: {
                Map<DN, Backend> baseMap = this.subordinateBaseDNs == null ? DirectoryServer.getPublicNamingContexts() : this.subordinateBaseDNs;
                for (DN subBase : baseMap.keySet()) {
                    CancelRequest cancelRequest = searchOperation.getCancelRequest();
                    if (cancelRequest != null) {
                        throw new CancelledOperationException(CancelResult.CANCELED);
                    }
                    Backend b = baseMap.get(subBase);
                    Entry subBaseEntry = b.getEntry(subBase);
                    if (subBaseEntry == null || !filter.matchesEntry(subBaseEntry)) continue;
                    searchOperation.returnEntry(subBaseEntry, null);
                }
                return;
            }
            case WHOLE_SUBTREE: 
            case SUBORDINATE_SUBTREE: {
                Map<DN, Backend> baseMap = this.subordinateBaseDNs == null ? DirectoryServer.getPublicNamingContexts() : this.subordinateBaseDNs;
                try {
                    for (DN subBase : baseMap.keySet()) {
                        CancelRequest cancelRequest = searchOperation.getCancelRequest();
                        if (cancelRequest != null) {
                            throw new CancelledOperationException(CancelResult.CANCELED);
                        }
                        Backend b = baseMap.get(subBase);
                        searchOperation.setBaseDN(subBase);
                        try {
                            b.search(searchOperation);
                        }
                        catch (DirectoryException de) {
                            if (de.getResultCode() == ResultCode.NO_SUCH_OBJECT) continue;
                            throw de;
                            return;
                        }
                    }
                }
                catch (DirectoryException de) {
                    if (!DebugLogger.debugEnabled()) throw de;
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    throw de;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    int msgID = 9699340;
                    String message = MessageHandler.getMessage(msgID, searchOperation.getConnectionID(), searchOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(e));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
                }
                finally {
                    searchOperation.setBaseDN(this.rootDSEDN);
                }
            }
            default: {
                int msgID = 9699341;
                String message = MessageHandler.getMessage(msgID, searchOperation.getConnectionID(), searchOperation.getOperationID(), String.valueOf((Object)searchOperation.getScope()));
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, msgID);
            }
        }
    }

    public HashSet<String> getSupportedControls() {
        return this.supportedControls;
    }

    public HashSet<String> getSupportedFeatures() {
        return this.supportedFeatures;
    }

    @Override
    public boolean supportsLDIFExport() {
        return true;
    }

    @Override
    public void exportLDIF(LDIFExportConfig exportConfig) throws DirectoryException {
        LDIFWriter ldifWriter;
        try {
            ldifWriter = new LDIFWriter(exportConfig);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 9699342;
            String message = MessageHandler.getMessage(msgID, StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
        }
        try {
            ldifWriter.writeEntry(this.getRootDSE());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 9699343;
            String message = MessageHandler.getMessage(msgID, StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
        }
        finally {
            block14: {
                try {
                    ldifWriter.close();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block14;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }

    @Override
    public boolean supportsLDIFImport() {
        return false;
    }

    @Override
    public LDIFImportResult importLDIF(LDIFImportConfig importConfig) throws DirectoryException {
        int msgID = 9699344;
        String message = MessageHandler.getMessage(msgID);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public boolean supportsBackup() {
        return false;
    }

    @Override
    public boolean supportsBackup(BackupConfig backupConfig, StringBuilder unsupportedReason) {
        return false;
    }

    @Override
    public void createBackup(BackupConfig backupConfig) throws DirectoryException {
        int msgID = 9699345;
        String message = MessageHandler.getMessage(msgID);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public void removeBackup(BackupDirectory backupDirectory, String backupID) throws DirectoryException {
        int msgID = 9699345;
        String message = MessageHandler.getMessage(msgID);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public boolean supportsRestore() {
        return false;
    }

    @Override
    public void restoreBackup(RestoreConfig restoreConfig) throws DirectoryException {
        int msgID = 9699345;
        String message = MessageHandler.getMessage(msgID);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public boolean isConfigurationAcceptable(Configuration configuration, List<String> unacceptableReasons) {
        RootDSEBackendCfg config = (RootDSEBackendCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(RootDSEBackendCfg cfg, List<String> unacceptableReasons) {
        boolean configIsAcceptable = true;
        try {
            SortedSet<DN> subDNs = cfg.getSubordinateBaseDN();
            if (!subDNs.isEmpty()) {
                for (DN baseDN : subDNs) {
                    Backend backend = DirectoryServer.getBackend(baseDN);
                    if (backend != null) continue;
                    int msgID = 9568260;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(baseDN));
                    unacceptableReasons.add(message);
                    configIsAcceptable = false;
                }
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 9568261;
            String message = MessageHandler.getMessage(msgID, StaticUtils.stackTraceToSingleLineString(e));
            unacceptableReasons.add(message);
            configIsAcceptable = false;
        }
        return configIsAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(RootDSEBackendCfg cfg) {
        ConcurrentHashMap<DN, Backend> subBases;
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        try {
            SortedSet<DN> subDNs = cfg.getSubordinateBaseDN();
            if (subDNs.isEmpty()) {
                subBases = null;
            } else {
                subBases = new ConcurrentHashMap<DN, Backend>();
                for (DN baseDN : subDNs) {
                    Backend backend = DirectoryServer.getBackend(baseDN);
                    if (backend == null) {
                        int msgID = 9568260;
                        String message = MessageHandler.getMessage(msgID, String.valueOf(baseDN));
                        messages.add(message);
                        if (resultCode != ResultCode.SUCCESS) continue;
                        resultCode = DirectoryServer.getServerErrorResultCode();
                        continue;
                    }
                    subBases.put(baseDN, backend);
                }
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 9568261;
            String message = MessageHandler.getMessage(msgID, StaticUtils.stackTraceToSingleLineString(e));
            messages.add(message);
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            subBases = null;
        }
        boolean newShowAll = cfg.isShowAllAttributes();
        ArrayList<Attribute> userAttrs = new ArrayList<Attribute>();
        try {
            ConfigEntry configEntry = DirectoryServer.getConfigEntry(this.configEntryDN);
            for (List<Attribute> attrs : configEntry.getEntry().getUserAttributes().values()) {
                for (Attribute a : attrs) {
                    if (this.isDSEConfigAttribute(a)) continue;
                    userAttrs.add(a);
                }
            }
            for (List<Attribute> attrs : configEntry.getEntry().getOperationalAttributes().values()) {
                for (Attribute a : attrs) {
                    if (this.isDSEConfigAttribute(a)) continue;
                    userAttrs.add(a);
                }
            }
        }
        catch (ConfigException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 3407979;
            messages.add(MessageHandler.getMessage(msgID, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(e)));
            resultCode = DirectoryServer.getServerErrorResultCode();
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.subordinateBaseDNs = subBases;
            if (this.subordinateBaseDNs == null) {
                int msgID = 9437202;
                String message = MessageHandler.getMessage(msgID);
                messages.add(message);
            } else {
                StringBuilder basesStr = new StringBuilder();
                for (DN dn : this.subordinateBaseDNs.keySet()) {
                    if (basesStr.length() > 0) {
                        basesStr.append(", ");
                    } else {
                        basesStr.append("{ ");
                    }
                    basesStr.append(dn);
                }
                basesStr.append(" }");
                int msgID = 9437203;
                String message = MessageHandler.getMessage(msgID, basesStr.toString());
                messages.add(message);
            }
            if (this.showAllAttributes != newShowAll) {
                this.showAllAttributes = newShowAll;
                int msgID = 0x90009F;
                String message = MessageHandler.getMessage(msgID, "ds-cfg-show-all-attributes", this.showAllAttributes);
                messages.add(message);
            }
            this.userDefinedAttributes = userAttrs;
            int msgID = 9437204;
            String message = MessageHandler.getMessage(msgID);
            messages.add(message);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

