/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LDIFImportResult;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.RDN;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorBackend
extends Backend
implements ConfigurationChangeListener<BackendCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ArrayList<Attribute> userDefinedAttributes;
    private HashMap<ObjectClass, String> monitorObjectClasses;
    private DN configEntryDN;
    private BackendCfg currentConfig;
    private DN baseMonitorDN;
    private DN[] baseDNs;
    private HashSet<String> supportedControls;
    private HashSet<String> supportedFeatures;

    @Override
    public void configureBackend(Configuration config) throws ConfigException {
        Validator.ensureNotNull(config);
        Validator.ensureTrue(config instanceof BackendCfg);
        BackendCfg cfg = (BackendCfg)config;
        ConfigEntry configEntry = DirectoryServer.getConfigEntry(cfg.dn());
        if (configEntry == null) {
            int msgID = 9699349;
            String message = MessageHandler.getMessage(msgID);
            throw new ConfigException(msgID, message);
        }
        this.configEntryDN = configEntry.getDN();
        this.userDefinedAttributes = new ArrayList();
        for (List<Attribute> attrs : configEntry.getEntry().getUserAttributes().values()) {
            for (Attribute a : attrs) {
                if (this.isMonitorConfigAttribute(a)) continue;
                this.userDefinedAttributes.add(a);
            }
        }
        for (List<Attribute> attrs : configEntry.getEntry().getOperationalAttributes().values()) {
            for (Attribute a : attrs) {
                if (this.isMonitorConfigAttribute(a)) continue;
                this.userDefinedAttributes.add(a);
            }
        }
        this.monitorObjectClasses = new LinkedHashMap<ObjectClass, String>(2);
        ObjectClass topOC = DirectoryServer.getObjectClass("top", true);
        this.monitorObjectClasses.put(topOC, "top");
        ObjectClass monitorOC = DirectoryServer.getObjectClass("ds-monitor-entry", true);
        this.monitorObjectClasses.put(monitorOC, "ds-monitor-entry");
        this.supportedControls = new HashSet(0);
        this.supportedFeatures = new HashSet(0);
        try {
            this.baseMonitorDN = DN.decode("cn=monitor");
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 9699350;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new ConfigException(msgID, message, e);
        }
        this.baseDNs = new DN[]{this.baseMonitorDN};
        this.currentConfig = cfg;
    }

    @Override
    public void initializeBackend() throws ConfigException, InitializationException {
        this.currentConfig.addChangeListener(this);
        try {
            DirectoryServer.registerBaseDN(this.baseMonitorDN, this, true, false);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 9765074;
            String message = MessageHandler.getMessage(msgID, this.baseMonitorDN.toString(), StaticUtils.getExceptionMessage(e));
            throw new InitializationException(msgID, message, e);
        }
    }

    @Override
    public void finalizeBackend() {
        block2: {
            this.currentConfig.removeChangeListener(this);
            try {
                DirectoryServer.deregisterBaseDN(this.baseMonitorDN, false);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block2;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    private boolean isMonitorConfigAttribute(Attribute attribute) {
        AttributeType attrType = attribute.getAttributeType();
        return attrType.hasName("cn") || attrType.hasName("ds-cfg-backend-enabled".toLowerCase()) || attrType.hasName("ds-cfg-backend-class".toLowerCase()) || attrType.hasName("ds-cfg-backend-base-dn".toLowerCase()) || attrType.hasName("ds-cfg-backend-id".toLowerCase()) || attrType.hasName("ds-cfg-backend-writability-mode".toLowerCase());
    }

    @Override
    public DN[] getBaseDNs() {
        return this.baseDNs;
    }

    @Override
    public long getEntryCount() {
        return DirectoryServer.getMonitorProviders().size() + 1;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public Entry getEntry(DN entryDN) throws DirectoryException {
        if (entryDN == null) {
            int msgID = 9633824;
            String message = MessageHandler.getMessage(msgID);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
        }
        if (entryDN.equals(this.baseMonitorDN)) {
            return this.getBaseMonitorEntry();
        }
        DN parentDN = entryDN.getParentDNInSuffix();
        if (parentDN == null || !parentDN.equals(this.baseMonitorDN)) {
            if (this.baseMonitorDN.isAncestorOf(entryDN)) {
                int msgID = 9633825;
                String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN), String.valueOf(this.baseMonitorDN));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID, this.baseMonitorDN, null);
            }
            int msgID = 9633826;
            String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN), String.valueOf(this.baseMonitorDN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID);
        }
        RDN entryRDN = entryDN.getRDN();
        if (entryRDN.isMultiValued()) {
            int msgID = 9633827;
            String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID, this.baseMonitorDN, null);
        }
        String rdnValue = entryRDN.getAttributeValue(0).getStringValue();
        MonitorProvider<? extends MonitorProviderCfg> monitorProvider = DirectoryServer.getMonitorProvider(rdnValue.toLowerCase());
        if (monitorProvider == null) {
            int msgID = 9633828;
            String message = MessageHandler.getMessage(msgID, String.valueOf(rdnValue));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID, this.baseMonitorDN, null);
        }
        return this.getMonitorEntry(entryDN, monitorProvider);
    }

    @Override
    public boolean entryExists(DN entryDN) throws DirectoryException {
        if (entryDN.equals(this.baseMonitorDN)) {
            return true;
        }
        DN parentDN = entryDN.getParentDNInSuffix();
        if (parentDN == null || !parentDN.equals(this.baseMonitorDN)) {
            return false;
        }
        RDN rdn = entryDN.getRDN();
        if (rdn.isMultiValued()) {
            return false;
        }
        String rdnValue = rdn.getAttributeValue(0).getStringValue();
        MonitorProvider<? extends MonitorProviderCfg> monitorProvider = DirectoryServer.getMonitorProvider(StaticUtils.toLowerCase(rdnValue));
        return monitorProvider != null;
    }

    public Entry getBaseMonitorEntry() {
        LinkedHashMap<ObjectClass, String> monitorClasses = new LinkedHashMap<ObjectClass, String>(3);
        monitorClasses.putAll(this.monitorObjectClasses);
        ObjectClass extensibleObjectOC = DirectoryServer.getObjectClass("extensibleobject", true);
        monitorClasses.put(extensibleObjectOC, "extensibleObject");
        LinkedHashMap<AttributeType, List<Attribute>> monitorUserAttrs = new LinkedHashMap<AttributeType, List<Attribute>>();
        LinkedHashMap<AttributeType, List<Attribute>> monitorOperationalAttrs = new LinkedHashMap<AttributeType, List<Attribute>>();
        Attribute cnAttr = this.createAttribute("cn", "cn", "monitor");
        ArrayList<Attribute> cnList = new ArrayList<Attribute>(1);
        cnList.add(cnAttr);
        monitorUserAttrs.put(cnAttr.getAttributeType(), cnList);
        Attribute productNameAttr = this.createAttribute("productName", "productname", "OpenDS Directory Server");
        ArrayList<Attribute> productNameList = new ArrayList<Attribute>(1);
        productNameList.add(productNameAttr);
        monitorUserAttrs.put(productNameAttr.getAttributeType(), productNameList);
        Attribute vendorNameAttr = this.createAttribute("vendorName", "vendorname", "Sun Microsystems, Inc.");
        ArrayList<Attribute> vendorNameList = new ArrayList<Attribute>(1);
        vendorNameList.add(vendorNameAttr);
        monitorUserAttrs.put(vendorNameAttr.getAttributeType(), vendorNameList);
        Attribute versionAttr = this.createAttribute("vendorVersion", "vendorversion", DirectoryServer.getVersionString());
        ArrayList<Attribute> versionList = new ArrayList<Attribute>(1);
        versionList.add(versionAttr);
        monitorUserAttrs.put(versionAttr.getAttributeType(), versionList);
        Attribute startTimeAttr = this.createAttribute("startTime", "starttime", DirectoryServer.getStartTimeUTC());
        ArrayList<Attribute> startTimeList = new ArrayList<Attribute>(1);
        startTimeList.add(startTimeAttr);
        monitorUserAttrs.put(startTimeAttr.getAttributeType(), startTimeList);
        Attribute currentTimeAttr = this.createAttribute("currentTime", "currenttime", TimeThread.getGMTTime());
        ArrayList<Attribute> currentTimeList = new ArrayList<Attribute>(1);
        currentTimeList.add(currentTimeAttr);
        monitorUserAttrs.put(currentTimeAttr.getAttributeType(), currentTimeList);
        long upSeconds = (System.currentTimeMillis() - DirectoryServer.getStartTime()) / 1000L;
        long upDays = upSeconds / 86400L;
        long upHours = (upSeconds %= 86400L) / 3600L;
        long upMinutes = (upSeconds %= 3600L) / 60L;
        String upTimeStr = MessageHandler.getMessage(9437221, upDays, upHours, upMinutes, upSeconds %= 60L);
        Attribute upTimeAttr = this.createAttribute("upTime", "uptime", upTimeStr);
        ArrayList<Attribute> upTimeList = new ArrayList<Attribute>(1);
        upTimeList.add(upTimeAttr);
        monitorUserAttrs.put(upTimeAttr.getAttributeType(), upTimeList);
        long currentConns = DirectoryServer.getCurrentConnections();
        Attribute currentConnsAttr = this.createAttribute("currentConnections", "currentconnections", String.valueOf(currentConns));
        ArrayList<Attribute> currentConnsList = new ArrayList<Attribute>(1);
        currentConnsList.add(currentConnsAttr);
        monitorUserAttrs.put(currentConnsAttr.getAttributeType(), currentConnsList);
        long maxConns = DirectoryServer.getMaxConnections();
        Attribute maxConnsAttr = this.createAttribute("maxConnections", "maxconnections", String.valueOf(maxConns));
        ArrayList<Attribute> maxConnsList = new ArrayList<Attribute>(1);
        maxConnsList.add(maxConnsAttr);
        monitorUserAttrs.put(maxConnsAttr.getAttributeType(), maxConnsList);
        long totalConns = DirectoryServer.getTotalConnections();
        Attribute totalConnsAttr = this.createAttribute("totalConnections", "totalconnections", String.valueOf(totalConns));
        ArrayList<Attribute> totalConnsList = new ArrayList<Attribute>(1);
        totalConnsList.add(totalConnsAttr);
        monitorUserAttrs.put(totalConnsAttr.getAttributeType(), totalConnsList);
        for (Attribute a : this.userDefinedAttributes) {
            List<Attribute> attrs;
            AttributeType type = a.getAttributeType();
            if (type.isOperational()) {
                attrs = (ArrayList<Attribute>)((HashMap)monitorOperationalAttrs).get(type);
                if (attrs == null) {
                    attrs = new ArrayList<Attribute>();
                    attrs.add(a);
                    monitorOperationalAttrs.put(type, attrs);
                    continue;
                }
                attrs.add(a);
                continue;
            }
            attrs = (List)((HashMap)monitorUserAttrs).get(type);
            if (attrs == null) {
                attrs = new ArrayList();
                attrs.add(a);
                monitorUserAttrs.put(type, attrs);
                continue;
            }
            attrs.add(a);
        }
        Entry e = new Entry(this.baseMonitorDN, monitorClasses, monitorUserAttrs, monitorOperationalAttrs);
        e.processVirtualAttributes();
        return e;
    }

    private Entry getMonitorEntry(DN entryDN, MonitorProvider<? extends MonitorProviderCfg> monitorProvider) {
        LinkedHashMap<ObjectClass, String> monitorClasses = new LinkedHashMap<ObjectClass, String>(3);
        monitorClasses.putAll(this.monitorObjectClasses);
        ObjectClass monitorOC = monitorProvider.getMonitorObjectClass();
        monitorClasses.put(monitorOC, monitorOC.getPrimaryName());
        List<Attribute> monitorAttrs = monitorProvider.getMonitorData();
        LinkedHashMap<AttributeType, List<Attribute>> attrMap = new LinkedHashMap<AttributeType, List<Attribute>>(monitorAttrs.size() + 1);
        RDN entryRDN = entryDN.getRDN();
        AttributeType rdnType = entryRDN.getAttributeType(0);
        AttributeValue rdnValue = entryRDN.getAttributeValue(0);
        LinkedHashSet<AttributeValue> rdnValues = new LinkedHashSet<AttributeValue>(1);
        rdnValues.add(rdnValue);
        Attribute rdnAttr = new Attribute(rdnType, entryRDN.getAttributeName(0), rdnValues);
        ArrayList<Attribute> rdnList = new ArrayList<Attribute>(1);
        rdnList.add(rdnAttr);
        attrMap.put(rdnType, rdnList);
        for (Attribute a : monitorAttrs) {
            AttributeType type = a.getAttributeType();
            ArrayList<Attribute> attrs = (ArrayList<Attribute>)((HashMap)attrMap).get(type);
            if (attrs == null) {
                attrs = new ArrayList<Attribute>();
                attrs.add(a);
                attrMap.put(type, attrs);
                continue;
            }
            attrs.add(a);
        }
        Entry e = new Entry(entryDN, monitorClasses, attrMap, new HashMap<AttributeType, List<Attribute>>(0));
        e.processVirtualAttributes();
        return e;
    }

    private Attribute createAttribute(String name, String lowerName, String value) {
        AttributeType type = DirectoryServer.getAttributeType(lowerName);
        if (type == null) {
            type = DirectoryServer.getDefaultAttributeType(name);
        }
        LinkedHashSet<AttributeValue> attrValues = new LinkedHashSet<AttributeValue>(1);
        attrValues.add(new AttributeValue(type, (ByteString)new ASN1OctetString(value)));
        return new Attribute(type, name, attrValues);
    }

    @Override
    public void addEntry(Entry entry, AddOperation addOperation) throws DirectoryException {
        int msgID = 9633815;
        String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public void deleteEntry(DN entryDN, DeleteOperation deleteOperation) throws DirectoryException {
        int msgID = 9633816;
        String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public void replaceEntry(Entry entry, ModifyOperation modifyOperation) throws DirectoryException {
        int msgID = 9633817;
        String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), String.valueOf(this.configEntryDN));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public void renameEntry(DN currentDN, Entry entry, ModifyDNOperation modifyDNOperation) throws DirectoryException {
        int msgID = 9633818;
        String message = MessageHandler.getMessage(msgID, String.valueOf(currentDN));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public void search(SearchOperation searchOperation) throws DirectoryException {
        DN baseDN = searchOperation.getBaseDN();
        Entry baseEntry = this.getEntry(baseDN);
        SearchScope scope = searchOperation.getScope();
        SearchFilter filter = searchOperation.getFilter();
        if (this.baseMonitorDN.equals(baseDN)) {
            if (scope == SearchScope.BASE_OBJECT || scope == SearchScope.WHOLE_SUBTREE) {
                if (filter.matchesEntry(baseEntry)) {
                    searchOperation.returnEntry(baseEntry, null);
                }
                if (scope == SearchScope.BASE_OBJECT) {
                    return;
                }
            }
            for (MonitorProvider<? extends MonitorProviderCfg> monitorProvider : DirectoryServer.getMonitorProviders().values()) {
                DN providerDN = DirectoryServer.getMonitorProviderDN(monitorProvider);
                Entry monitorEntry = this.getMonitorEntry(providerDN, monitorProvider);
                if (!filter.matchesEntry(monitorEntry)) continue;
                searchOperation.returnEntry(monitorEntry, null);
            }
        } else if ((scope == SearchScope.BASE_OBJECT || scope == SearchScope.WHOLE_SUBTREE) && filter.matchesEntry(baseEntry)) {
            searchOperation.returnEntry(baseEntry, null);
        }
    }

    public HashSet<String> getSupportedControls() {
        return this.supportedControls;
    }

    public HashSet<String> getSupportedFeatures() {
        return this.supportedFeatures;
    }

    @Override
    public boolean supportsLDIFExport() {
        return false;
    }

    @Override
    public void exportLDIF(LDIFExportConfig exportConfig) throws DirectoryException {
        block12: {
            LDIFWriter ldifWriter;
            try {
                ldifWriter = new LDIFWriter(exportConfig);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                int msgID = 9699342;
                String message = MessageHandler.getMessage(msgID, StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
            }
            try {
                ldifWriter.writeEntry(this.getBaseMonitorEntry());
            }
            catch (Exception e) {
                block11: {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    try {
                        ldifWriter.close();
                    }
                    catch (Exception e2) {
                        if (!DebugLogger.debugEnabled()) break block11;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                    }
                }
                int msgID = 9699355;
                String message = MessageHandler.getMessage(msgID, StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
            }
            for (MonitorProvider<? extends MonitorProviderCfg> monitorProvider : DirectoryServer.getMonitorProviders().values()) {
            }
            try {
                ldifWriter.close();
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block12;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    @Override
    public boolean supportsLDIFImport() {
        return false;
    }

    @Override
    public LDIFImportResult importLDIF(LDIFImportConfig importConfig) throws DirectoryException {
        int msgID = 9699357;
        String message = MessageHandler.getMessage(msgID);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public boolean supportsBackup() {
        return false;
    }

    @Override
    public boolean supportsBackup(BackupConfig backupConfig, StringBuilder unsupportedReason) {
        return false;
    }

    @Override
    public void createBackup(BackupConfig backupConfig) throws DirectoryException {
        int msgID = 9699358;
        String message = MessageHandler.getMessage(msgID);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public void removeBackup(BackupDirectory backupDirectory, String backupID) throws DirectoryException {
        int msgID = 9699358;
        String message = MessageHandler.getMessage(msgID);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public boolean supportsRestore() {
        return false;
    }

    @Override
    public void restoreBackup(RestoreConfig restoreConfig) throws DirectoryException {
        int msgID = 9699358;
        String message = MessageHandler.getMessage(msgID);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(BackendCfg backendCfg, List<String> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(BackendCfg backendCfg) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        ArrayList<Attribute> userAttrs = new ArrayList<Attribute>();
        try {
            ConfigEntry configEntry = DirectoryServer.getConfigEntry(this.configEntryDN);
            for (List<Attribute> attrs : configEntry.getEntry().getUserAttributes().values()) {
                for (Attribute a : attrs) {
                    if (this.isMonitorConfigAttribute(a)) continue;
                    userAttrs.add(a);
                }
            }
            for (List<Attribute> attrs : configEntry.getEntry().getOperationalAttributes().values()) {
                for (Attribute a : attrs) {
                    if (this.isMonitorConfigAttribute(a)) continue;
                    userAttrs.add(a);
                }
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 3407979;
            messages.add(MessageHandler.getMessage(msgID, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(e)));
            resultCode = DirectoryServer.getServerErrorResultCode();
        }
        this.userDefinedAttributes = userAttrs;
        int msgID = 9437215;
        String message = MessageHandler.getMessage(msgID);
        messages.add(message);
        this.currentConfig = backendCfg;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

