/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.api.Backend;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LDIFImportResult;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryBackend
extends Backend {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DN[] baseDNs;
    private HashMap<DN, HashSet<DN>> childDNs;
    private HashSet<DN> baseDNSet;
    private HashSet<String> supportedControls;
    private HashSet<String> supportedFeatures;
    private LinkedHashMap<DN, Entry> entryMap;

    public void setBaseDNs(DN[] baseDNs) {
        this.baseDNs = baseDNs;
    }

    @Override
    public void configureBackend(Configuration config) throws ConfigException {
        if (config != null) {
            Validator.ensureTrue(config instanceof BackendCfg);
            BackendCfg cfg = (BackendCfg)config;
            DN[] baseDNs = new DN[cfg.getBackendBaseDN().size()];
            cfg.getBackendBaseDN().toArray(baseDNs);
            this.setBaseDNs(baseDNs);
        }
    }

    @Override
    public synchronized void initializeBackend() throws ConfigException, InitializationException {
        if (this.baseDNs == null || this.baseDNs.length != 1) {
            int msgID = 9699520;
            String message = MessageHandler.getMessage(msgID);
            throw new ConfigException(msgID, message);
        }
        this.baseDNSet = new HashSet();
        for (DN dn : this.baseDNs) {
            this.baseDNSet.add(dn);
        }
        this.entryMap = new LinkedHashMap();
        this.childDNs = new HashMap();
        this.supportedControls = new HashSet();
        this.supportedControls.add("1.2.840.113556.1.4.805");
        this.supportedFeatures = new HashSet();
        for (DN dn : this.baseDNs) {
            try {
                DirectoryServer.registerBaseDN(dn, this, false, false);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                int msgID = 9765074;
                String message = MessageHandler.getMessage(msgID, dn.toString(), StaticUtils.getExceptionMessage(e));
                throw new InitializationException(msgID, message, e);
            }
        }
    }

    public synchronized void clearMemoryBackend() {
        this.entryMap.clear();
        this.childDNs.clear();
    }

    @Override
    public synchronized void finalizeBackend() {
        this.clearMemoryBackend();
        for (DN dn : this.baseDNs) {
            try {
                DirectoryServer.deregisterBaseDN(dn, false);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    @Override
    public DN[] getBaseDNs() {
        return this.baseDNs;
    }

    @Override
    public synchronized long getEntryCount() {
        if (this.entryMap != null) {
            return this.entryMap.size();
        }
        return -1L;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public synchronized Entry getEntry(DN entryDN) {
        Entry entry = this.entryMap.get(entryDN);
        if (entry != null) {
            entry = entry.duplicate(true);
        }
        return entry;
    }

    @Override
    public synchronized boolean entryExists(DN entryDN) {
        return this.entryMap.containsKey(entryDN);
    }

    @Override
    public synchronized void addEntry(Entry entry, AddOperation addOperation) throws DirectoryException {
        Entry e = entry.duplicate(false);
        DN entryDN = e.getDN();
        if (this.entryMap.containsKey(entryDN)) {
            int msgID = 9699521;
            String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, message, msgID);
        }
        if (this.baseDNSet.contains(entryDN)) {
            this.entryMap.put(entryDN, e);
            return;
        }
        DN parentDN = entryDN.getParentDNInSuffix();
        if (parentDN == null) {
            int msgID = 9699522;
            String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID);
        }
        if (!this.entryMap.containsKey(parentDN)) {
            int msgID = 9699523;
            String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN), String.valueOf(parentDN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID);
        }
        this.entryMap.put(entryDN, e);
        HashSet<DN> children = this.childDNs.get(parentDN);
        if (children == null) {
            children = new HashSet();
            this.childDNs.put(parentDN, children);
        }
        children.add(entryDN);
    }

    @Override
    public synchronized void deleteEntry(DN entryDN, DeleteOperation deleteOperation) throws DirectoryException {
        HashSet<DN> parentsChildren;
        if (!this.entryMap.containsKey(entryDN)) {
            int msgID = 9699524;
            String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID);
        }
        boolean subtreeDelete = false;
        if (deleteOperation != null) {
            for (Control c : deleteOperation.getRequestControls()) {
                if (!c.getOID().equals("1.2.840.113556.1.4.805")) continue;
                subtreeDelete = true;
            }
        }
        HashSet<DN> children = this.childDNs.get(entryDN);
        if (subtreeDelete) {
            if (children != null) {
                HashSet<DN> childrenCopy = new HashSet<DN>(children);
                for (DN childDN : childrenCopy) {
                    try {
                        this.deleteEntry(childDN, null);
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
        } else if (children != null && !children.isEmpty()) {
            int msgID = 9699525;
            String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.NOT_ALLOWED_ON_NONLEAF, message, msgID);
        }
        this.childDNs.remove(entryDN);
        this.entryMap.remove(entryDN);
        DN parentDN = entryDN.getParentDNInSuffix();
        if (parentDN != null && (parentsChildren = this.childDNs.get(parentDN)) != null) {
            parentsChildren.remove(entryDN);
            if (parentsChildren.isEmpty()) {
                this.childDNs.remove(parentDN);
            }
        }
    }

    @Override
    public synchronized void replaceEntry(Entry entry, ModifyOperation modifyOperation) throws DirectoryException {
        Entry e = entry.duplicate(false);
        DN entryDN = e.getDN();
        if (!this.entryMap.containsKey(entryDN)) {
            int msgID = 9699524;
            String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID);
        }
        this.entryMap.put(entryDN, e);
    }

    @Override
    public synchronized void renameEntry(DN currentDN, Entry entry, ModifyDNOperation modifyDNOperation) throws DirectoryException {
        Entry e = entry.duplicate(false);
        if (!this.entryMap.containsKey(currentDN)) {
            int msgID = 9699524;
            String message = MessageHandler.getMessage(msgID, String.valueOf(currentDN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID);
        }
        HashSet<DN> children = this.childDNs.get(currentDN);
        if (children != null) {
            if (children.isEmpty()) {
                this.childDNs.remove(currentDN);
            } else {
                int msgID = 9699533;
                String message = MessageHandler.getMessage(msgID, String.valueOf(currentDN));
                throw new DirectoryException(ResultCode.NOT_ALLOWED_ON_NONLEAF, message, msgID);
            }
        }
        if (this.entryMap.containsKey(e.getDN())) {
            int msgID = 9699521;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e.getDN()));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID);
        }
        boolean matchFound = false;
        for (DN dn : this.baseDNs) {
            if (!dn.isAncestorOf(e.getDN())) continue;
            matchFound = true;
            break;
        }
        if (!matchFound) {
            int msgID = 9699534;
            String message = MessageHandler.getMessage(msgID, String.valueOf(currentDN));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
        }
        DN parentDN = e.getDN().getParentDNInSuffix();
        if (parentDN == null || !this.entryMap.containsKey(parentDN)) {
            int msgID = 9699535;
            String message = MessageHandler.getMessage(msgID, String.valueOf(currentDN), String.valueOf(parentDN));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
        }
        this.deleteEntry(currentDN, null);
        this.addEntry(e, null);
    }

    @Override
    public synchronized void search(SearchOperation searchOperation) throws DirectoryException {
        DN baseDN = searchOperation.getBaseDN();
        SearchScope scope = searchOperation.getScope();
        SearchFilter filter = searchOperation.getFilter();
        Entry baseEntry = this.entryMap.get(baseDN);
        if (baseEntry == null && this.handlesEntry(baseDN)) {
            DN matchedDN;
            for (matchedDN = baseDN.getParentDNInSuffix(); matchedDN != null && !this.entryMap.containsKey(matchedDN); matchedDN = matchedDN.getParentDNInSuffix()) {
            }
            int msgID = 9699524;
            String message = MessageHandler.getMessage(msgID, String.valueOf(baseDN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID, matchedDN, null);
        }
        if (baseEntry != null) {
            baseEntry = baseEntry.duplicate(true);
        }
        if (scope == SearchScope.BASE_OBJECT) {
            if (filter.matchesEntry(baseEntry)) {
                searchOperation.returnEntry(baseEntry, new LinkedList<Control>());
            }
        } else {
            for (Entry e : this.entryMap.values()) {
                if (!(e = e.duplicate(true)).matchesBaseAndScope(baseDN, scope) || !filter.matchesEntry(e)) continue;
                searchOperation.returnEntry(e, new LinkedList<Control>());
            }
        }
    }

    public HashSet<String> getSupportedControls() {
        return this.supportedControls;
    }

    public HashSet<String> getSupportedFeatures() {
        return this.supportedFeatures;
    }

    @Override
    public boolean supportsLDIFExport() {
        return true;
    }

    @Override
    public synchronized void exportLDIF(LDIFExportConfig exportConfig) throws DirectoryException {
        LDIFWriter ldifWriter;
        try {
            ldifWriter = new LDIFWriter(exportConfig);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 9699527;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
        }
        DN entryDN = null;
        try {
            for (Entry entry : this.entryMap.values()) {
                entryDN = entry.getDN();
                ldifWriter.writeEntry(entry);
            }
        }
        catch (Exception e) {
            int msgID = 9699528;
            String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN), String.valueOf(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
        }
        finally {
            block14: {
                try {
                    ldifWriter.close();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block14;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }

    @Override
    public boolean supportsLDIFImport() {
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized LDIFImportResult importLDIF(LDIFImportConfig importConfig) throws DirectoryException {
        this.clearMemoryBackend();
        try {
            reader = new LDIFReader(importConfig);
        }
        catch (Exception e) {
            msgID = 9699529;
            message = MessageHandler.getMessage(msgID, new Object[]{String.valueOf(e)});
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
        }
        try {
            while (true) lbl-1000:
            // 4 sources

            {
                e = null;
                try {
                    e = reader.readEntry();
                    if (e == null) {
                        ** break;
                    }
                }
                catch (LDIFException le) {
                    if (le.canContinueReading()) continue;
                    msgID = 9699530;
                    message = MessageHandler.getMessage(msgID, new Object[]{String.valueOf(e)});
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, le);
                }
                try {
                    this.addEntry((Entry)e, null);
                }
                catch (DirectoryException de) {
                    reader.rejectLastEntry(de.getErrorMessage());
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
lbl29:
            // 1 sources

            e = new LDIFImportResult(reader.getEntriesRead(), reader.getEntriesRejected(), reader.getEntriesIgnored());
            return e;
        }
        catch (DirectoryException de) {
            throw de;
        }
        catch (Exception e) {
            msgID = 9699531;
            message = MessageHandler.getMessage(msgID, new Object[]{String.valueOf(e)});
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, e);
        }
        finally {
            reader.close();
        }
    }

    @Override
    public boolean supportsBackup() {
        return false;
    }

    @Override
    public boolean supportsBackup(BackupConfig backupConfig, StringBuilder unsupportedReason) {
        return false;
    }

    @Override
    public void createBackup(BackupConfig backupConfig) throws DirectoryException {
        int msgID = 9699532;
        String message = MessageHandler.getMessage(msgID);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public void removeBackup(BackupDirectory backupDirectory, String backupID) throws DirectoryException {
        int msgID = 9699532;
        String message = MessageHandler.getMessage(msgID);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public boolean supportsRestore() {
        return false;
    }

    @Override
    public void restoreBackup(RestoreConfig restoreConfig) throws DirectoryException {
        int msgID = 9699532;
        String message = MessageHandler.getMessage(msgID);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }
}

