/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.BackupBackendCfg;
import org.opends.server.api.Backend;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.schema.BooleanSyntax;
import org.opends.server.schema.GeneralizedTimeSyntax;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.BackupInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LDIFImportResult;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.RDN;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackupBackend
extends Backend
implements ConfigurationChangeListener<BackupBackendCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private BackupBackendCfg currentConfig;
    private DN backupBaseDN;
    private DN[] baseDNs;
    private Entry backupBaseEntry;
    private HashSet<String> supportedControls;
    private HashSet<String> supportedFeatures;
    private LinkedHashSet<File> backupDirectories;

    @Override
    public void configureBackend(Configuration config) throws ConfigException {
        if (config == null) {
            int msgID = 9699499;
            String message = MessageHandler.getMessage(msgID);
            throw new ConfigException(msgID, message);
        }
        Validator.ensureTrue(config instanceof BackupBackendCfg);
        this.currentConfig = (BackupBackendCfg)config;
    }

    @Override
    public void initializeBackend() throws ConfigException, InitializationException {
        try {
            this.backupBaseDN = DN.decode("cn=backups");
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 9699500;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new InitializationException(msgID, message, e);
        }
        this.baseDNs = new DN[]{this.backupBaseDN};
        SortedSet<String> values = this.currentConfig.getBackupDirectory();
        this.backupDirectories = new LinkedHashSet(values.size());
        for (String s : values) {
            this.backupDirectories.add(StaticUtils.getFileForPath(s));
        }
        LinkedHashMap<ObjectClass, String> objectClasses = new LinkedHashMap<ObjectClass, String>(2);
        objectClasses.put(DirectoryServer.getTopObjectClass(), "top");
        ObjectClass untypedOC = DirectoryServer.getObjectClass("untypedobject", true);
        objectClasses.put(untypedOC, "untypedObject");
        LinkedHashMap<AttributeType, List<Attribute>> opAttrs = new LinkedHashMap<AttributeType, List<Attribute>>(0);
        LinkedHashMap<AttributeType, List<Attribute>> userAttrs = new LinkedHashMap<AttributeType, List<Attribute>>(1);
        RDN rdn = this.backupBaseDN.getRDN();
        int numAVAs = rdn.getNumValues();
        for (int i = 0; i < numAVAs; ++i) {
            LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>(1);
            valueSet.add(rdn.getAttributeValue(i));
            AttributeType attrType = rdn.getAttributeType(i);
            ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
            attrList.add(new Attribute(attrType, attrType.getNameOrOID(), valueSet));
            userAttrs.put(attrType, attrList);
        }
        this.backupBaseEntry = new Entry(this.backupBaseDN, objectClasses, userAttrs, opAttrs);
        this.supportedControls = new HashSet(0);
        this.supportedFeatures = new HashSet(0);
        this.currentConfig.addBackupChangeListener(this);
        try {
            DirectoryServer.registerBaseDN(this.backupBaseDN, this, true, false);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 9765074;
            String message = MessageHandler.getMessage(msgID, this.backupBaseDN.toString(), StaticUtils.getExceptionMessage(e));
            throw new InitializationException(msgID, message, e);
        }
    }

    @Override
    public void finalizeBackend() {
        block2: {
            this.currentConfig.removeBackupChangeListener(this);
            try {
                DirectoryServer.deregisterBaseDN(this.backupBaseDN, false);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block2;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    @Override
    public DN[] getBaseDNs() {
        return this.baseDNs;
    }

    @Override
    public long getEntryCount() {
        int numEntries = 1;
        AttributeType backupPathType = DirectoryServer.getAttributeType("ds-backup-directory-path", true);
        for (File f : this.backupDirectories) {
            try {
                File descriptorFile = new File(f, "backup.info");
                if (!descriptorFile.exists()) continue;
                DN backupDirDN = BackupBackend.makeChildDN(this.backupBaseDN, backupPathType, f.getAbsolutePath());
                this.getBackupDirectoryEntry(backupDirDN);
                ++numEntries;
            }
            catch (Exception e) {}
        }
        return numEntries;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public Entry getEntry(DN entryDN) throws DirectoryException {
        if (entryDN == null) {
            int msgID = 9699503;
            String message = MessageHandler.getMessage(msgID);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
        }
        if (entryDN.equals(this.backupBaseDN)) {
            return this.backupBaseEntry.duplicate(true);
        }
        DN parentDN = entryDN.getParentDNInSuffix();
        if (parentDN == null) {
            int msgID = 9699504;
            String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID);
        }
        if (parentDN.equals(this.backupBaseDN)) {
            return this.getBackupDirectoryEntry(entryDN);
        }
        if (this.backupBaseDN.equals(parentDN.getParentDNInSuffix())) {
            return this.getBackupEntry(entryDN);
        }
        int msgID = 9699504;
        String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN));
        throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID, this.backupBaseDN, null);
    }

    private Entry getBackupDirectoryEntry(DN entryDN) throws DirectoryException {
        BackupDirectory backupDirectory;
        AttributeType t = DirectoryServer.getAttributeType("ds-backup-directory-path", true);
        AttributeValue v = entryDN.getRDN().getAttributeValue(t);
        if (v == null) {
            int msgID = 9699505;
            String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID, this.backupBaseDN, null);
        }
        try {
            backupDirectory = BackupDirectory.readBackupDirectoryDescriptor(v.getStringValue());
        }
        catch (ConfigException ce) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ce);
            }
            int msgID = 9699506;
            String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN), ce.getMessage());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 9699507;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
        }
        LinkedHashMap<ObjectClass, String> ocMap = new LinkedHashMap<ObjectClass, String>(2);
        ocMap.put(DirectoryServer.getTopObjectClass(), "top");
        ObjectClass backupDirOC = DirectoryServer.getObjectClass("ds-backup-directory", true);
        ocMap.put(backupDirOC, "ds-backup-directory");
        LinkedHashMap<AttributeType, List<Attribute>> opAttrs = new LinkedHashMap<AttributeType, List<Attribute>>(0);
        LinkedHashMap<AttributeType, List<Attribute>> userAttrs = new LinkedHashMap<AttributeType, List<Attribute>>(3);
        LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>(1);
        valueSet.add(v);
        ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
        attrList.add(new Attribute(t, t.getNameOrOID(), valueSet));
        userAttrs.put(t, attrList);
        t = DirectoryServer.getAttributeType("ds-backup-backend-dn", true);
        valueSet = new LinkedHashSet(1);
        valueSet.add(new AttributeValue(t, backupDirectory.getConfigEntryDN().toString()));
        attrList = new ArrayList(1);
        attrList.add(new Attribute(t, t.getNameOrOID(), valueSet));
        userAttrs.put(t, attrList);
        Entry e = new Entry(entryDN, ocMap, userAttrs, opAttrs);
        e.processVirtualAttributes();
        return e;
    }

    private Entry getBackupEntry(DN entryDN) throws DirectoryException {
        HashMap<String, String> properties;
        byte[] unsignedHash;
        byte[] signedHash;
        BackupDirectory backupDirectory;
        AttributeType idType = DirectoryServer.getAttributeType("ds-backup-id", true);
        AttributeValue idValue = entryDN.getRDN().getAttributeValue(idType);
        if (idValue == null) {
            int msgID = 9699508;
            String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
        }
        String backupID = idValue.getStringValue();
        DN parentDN = entryDN.getParentDNInSuffix();
        if (parentDN == null) {
            int msgID = 9699509;
            String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
        }
        AttributeType t = DirectoryServer.getAttributeType("ds-backup-directory-path", true);
        AttributeValue v = parentDN.getRDN().getAttributeValue(t);
        if (v == null) {
            int msgID = 9699510;
            String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
        }
        try {
            backupDirectory = BackupDirectory.readBackupDirectoryDescriptor(v.getStringValue());
        }
        catch (ConfigException ce) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ce);
            }
            int msgID = 9699506;
            String message = MessageHandler.getMessage(msgID, ce.getMessage());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 9699507;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID);
        }
        BackupInfo backupInfo = backupDirectory.getBackupInfo(backupID);
        if (backupInfo == null) {
            int msgID = 9699511;
            String message = MessageHandler.getMessage(msgID, backupID, backupDirectory.getPath());
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID, parentDN, null);
        }
        LinkedHashMap<ObjectClass, String> ocMap = new LinkedHashMap<ObjectClass, String>(3);
        ocMap.put(DirectoryServer.getTopObjectClass(), "top");
        ObjectClass oc = DirectoryServer.getObjectClass("ds-backup-info", true);
        ocMap.put(oc, "ds-backup-info");
        oc = DirectoryServer.getObjectClass("extensibleobject", true);
        ocMap.put(oc, "extensibleObject");
        LinkedHashMap<AttributeType, List<Attribute>> opAttrs = new LinkedHashMap<AttributeType, List<Attribute>>(0);
        LinkedHashMap<AttributeType, List<Attribute>> userAttrs = new LinkedHashMap<AttributeType, List<Attribute>>();
        LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>(1);
        valueSet.add(idValue);
        ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
        attrList.add(new Attribute(idType, idType.getNameOrOID(), valueSet));
        userAttrs.put(idType, attrList);
        backupInfo.getBackupDirectory();
        valueSet = new LinkedHashSet(1);
        valueSet.add(v);
        attrList = new ArrayList(1);
        attrList.add(new Attribute(t, t.getNameOrOID(), valueSet));
        userAttrs.put(t, attrList);
        Date backupDate = backupInfo.getBackupDate();
        if (backupDate != null) {
            t = DirectoryServer.getAttributeType("ds-backup-date", true);
            valueSet = new LinkedHashSet(1);
            valueSet.add(new AttributeValue(t, GeneralizedTimeSyntax.format(backupDate)));
            attrList = new ArrayList(1);
            attrList.add(new Attribute(t, t.getNameOrOID(), valueSet));
            userAttrs.put(t, attrList);
        }
        t = DirectoryServer.getAttributeType("ds-backup-compressed", true);
        valueSet = new LinkedHashSet(1);
        valueSet.add(BooleanSyntax.createBooleanValue(backupInfo.isCompressed()));
        attrList = new ArrayList(1);
        attrList.add(new Attribute(t, t.getNameOrOID(), valueSet));
        userAttrs.put(t, attrList);
        t = DirectoryServer.getAttributeType("ds-backup-encrypted", true);
        valueSet = new LinkedHashSet(1);
        valueSet.add(BooleanSyntax.createBooleanValue(backupInfo.isEncrypted()));
        attrList = new ArrayList(1);
        attrList.add(new Attribute(t, t.getNameOrOID(), valueSet));
        userAttrs.put(t, attrList);
        t = DirectoryServer.getAttributeType("ds-backup-incremental", true);
        valueSet = new LinkedHashSet(1);
        valueSet.add(BooleanSyntax.createBooleanValue(backupInfo.isIncremental()));
        attrList = new ArrayList(1);
        attrList.add(new Attribute(t, t.getNameOrOID(), valueSet));
        userAttrs.put(t, attrList);
        HashSet<String> dependencies = backupInfo.getDependencies();
        if (dependencies != null && !dependencies.isEmpty()) {
            t = DirectoryServer.getAttributeType("ds-backup-dependency", true);
            valueSet = new LinkedHashSet(dependencies.size());
            for (String s : dependencies) {
                valueSet.add(new AttributeValue(t, s));
            }
            attrList = new ArrayList(1);
            attrList.add(new Attribute(t, t.getNameOrOID(), valueSet));
            userAttrs.put(t, attrList);
        }
        if ((signedHash = backupInfo.getSignedHash()) != null) {
            t = DirectoryServer.getAttributeType("ds-backup-signed-hash", true);
            valueSet = new LinkedHashSet(1);
            valueSet.add(new AttributeValue(t, (ByteString)new ASN1OctetString(signedHash)));
            attrList = new ArrayList(1);
            attrList.add(new Attribute(t, t.getNameOrOID(), valueSet));
            userAttrs.put(t, attrList);
        }
        if ((unsignedHash = backupInfo.getUnsignedHash()) != null) {
            t = DirectoryServer.getAttributeType("ds-backup-unsigned-hash", true);
            valueSet = new LinkedHashSet(1);
            valueSet.add(new AttributeValue(t, (ByteString)new ASN1OctetString(unsignedHash)));
            attrList = new ArrayList(1);
            attrList.add(new Attribute(t, t.getNameOrOID(), valueSet));
            userAttrs.put(t, attrList);
        }
        if ((properties = backupInfo.getBackupProperties()) != null && !properties.isEmpty()) {
            for (Map.Entry<String, String> e : properties.entrySet()) {
                t = DirectoryServer.getAttributeType(StaticUtils.toLowerCase(e.getKey()), true);
                valueSet = new LinkedHashSet(1);
                valueSet.add(new AttributeValue(t, e.getValue()));
                attrList = new ArrayList(1);
                attrList.add(new Attribute(t, t.getNameOrOID(), valueSet));
                userAttrs.put(t, attrList);
            }
        }
        Entry e = new Entry(entryDN, ocMap, userAttrs, opAttrs);
        e.processVirtualAttributes();
        return e;
    }

    @Override
    public void addEntry(Entry entry, AddOperation addOperation) throws DirectoryException {
        int msgID = 9699512;
        String message = MessageHandler.getMessage(msgID);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public void deleteEntry(DN entryDN, DeleteOperation deleteOperation) throws DirectoryException {
        int msgID = 9699513;
        String message = MessageHandler.getMessage(msgID);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public void replaceEntry(Entry entry, ModifyOperation modifyOperation) throws DirectoryException {
        int msgID = 9699514;
        String message = MessageHandler.getMessage(msgID);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public void renameEntry(DN currentDN, Entry entry, ModifyDNOperation modifyDNOperation) throws DirectoryException {
        int msgID = 9699515;
        String message = MessageHandler.getMessage(msgID);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public void search(SearchOperation searchOperation) throws DirectoryException {
        DN baseDN = searchOperation.getBaseDN();
        Entry baseEntry = this.getEntry(baseDN);
        SearchScope scope = searchOperation.getScope();
        SearchFilter filter = searchOperation.getFilter();
        if (this.backupBaseDN.equals(baseDN)) {
            if ((scope == SearchScope.BASE_OBJECT || scope == SearchScope.WHOLE_SUBTREE) && filter.matchesEntry(baseEntry)) {
                searchOperation.returnEntry(baseEntry, null);
            }
            if (scope != SearchScope.BASE_OBJECT && !this.backupDirectories.isEmpty()) {
                AttributeType backupPathType = DirectoryServer.getAttributeType("ds-backup-directory-path", true);
                for (File f : this.backupDirectories) {
                    List<Attribute> attrList;
                    Entry backupDirEntry;
                    File descriptorFile = new File(f, "backup.info");
                    if (!descriptorFile.exists()) continue;
                    DN backupDirDN = BackupBackend.makeChildDN(this.backupBaseDN, backupPathType, f.getAbsolutePath());
                    try {
                        backupDirEntry = this.getBackupDirectoryEntry(backupDirDN);
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        continue;
                    }
                    if (filter.matchesEntry(backupDirEntry)) {
                        searchOperation.returnEntry(backupDirEntry, null);
                    }
                    if (scope == SearchScope.SINGLE_LEVEL || (attrList = backupDirEntry.getAttribute(backupPathType)) == null || attrList.isEmpty()) continue;
                    for (AttributeValue v : attrList.get(0).getValues()) {
                        try {
                            BackupDirectory backupDirectory = BackupDirectory.readBackupDirectoryDescriptor(v.getStringValue());
                            AttributeType idType = DirectoryServer.getAttributeType("ds-backup-id", true);
                            for (String backupID : backupDirectory.getBackups().keySet()) {
                                DN backupEntryDN = BackupBackend.makeChildDN(backupDirDN, idType, backupID);
                                Entry backupEntry = this.getBackupEntry(backupEntryDN);
                                if (!filter.matchesEntry(backupEntry)) continue;
                                searchOperation.returnEntry(backupEntry, null);
                            }
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) continue;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                }
            }
        } else {
            DN parentDN = baseDN.getParentDNInSuffix();
            if (this.backupBaseDN.equals(parentDN)) {
                AttributeType t;
                List<Attribute> attrList;
                Entry backupDirEntry = this.getBackupDirectoryEntry(baseDN);
                if ((scope == SearchScope.BASE_OBJECT || scope == SearchScope.WHOLE_SUBTREE) && filter.matchesEntry(backupDirEntry)) {
                    searchOperation.returnEntry(backupDirEntry, null);
                }
                if (scope != SearchScope.BASE_OBJECT && (attrList = backupDirEntry.getAttribute(t = DirectoryServer.getAttributeType("ds-backup-directory-path", true))) != null && !attrList.isEmpty()) {
                    for (AttributeValue v : attrList.get(0).getValues()) {
                        try {
                            BackupDirectory backupDirectory = BackupDirectory.readBackupDirectoryDescriptor(v.getStringValue());
                            AttributeType idType = DirectoryServer.getAttributeType("ds-backup-id", true);
                            for (String backupID : backupDirectory.getBackups().keySet()) {
                                DN backupEntryDN = BackupBackend.makeChildDN(baseDN, idType, backupID);
                                Entry backupEntry = this.getBackupEntry(backupEntryDN);
                                if (!filter.matchesEntry(backupEntry)) continue;
                                searchOperation.returnEntry(backupEntry, null);
                            }
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) continue;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                }
            } else {
                if (parentDN == null || !this.backupBaseDN.equals(parentDN.getParentDNInSuffix())) {
                    int msgID = 9699516;
                    String message = MessageHandler.getMessage(msgID);
                    throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID);
                }
                if (scope == SearchScope.BASE_OBJECT || scope == SearchScope.WHOLE_SUBTREE) {
                    Entry backupEntry = this.getBackupEntry(baseDN);
                    if (backupEntry == null) {
                        int msgID = 9699516;
                        String message = MessageHandler.getMessage(msgID);
                        throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID);
                    }
                    if (filter.matchesEntry(backupEntry)) {
                        searchOperation.returnEntry(backupEntry, null);
                    }
                }
            }
        }
    }

    public HashSet<String> getSupportedControls() {
        return this.supportedControls;
    }

    public HashSet<String> getSupportedFeatures() {
        return this.supportedFeatures;
    }

    @Override
    public boolean supportsLDIFExport() {
        return false;
    }

    @Override
    public void exportLDIF(LDIFExportConfig exportConfig) throws DirectoryException {
        int msgID = 9699517;
        String message = MessageHandler.getMessage(msgID);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public boolean supportsLDIFImport() {
        return false;
    }

    @Override
    public LDIFImportResult importLDIF(LDIFImportConfig importConfig) throws DirectoryException {
        int msgID = 9699518;
        String message = MessageHandler.getMessage(msgID);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public boolean supportsBackup() {
        return false;
    }

    @Override
    public boolean supportsBackup(BackupConfig backupConfig, StringBuilder unsupportedReason) {
        return false;
    }

    @Override
    public void createBackup(BackupConfig backupConfig) throws DirectoryException {
        int msgID = 9699519;
        String message = MessageHandler.getMessage(msgID);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public void removeBackup(BackupDirectory backupDirectory, String backupID) throws DirectoryException {
        int msgID = 9699519;
        String message = MessageHandler.getMessage(msgID);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public boolean supportsRestore() {
        return false;
    }

    @Override
    public void restoreBackup(RestoreConfig restoreConfig) throws DirectoryException {
        int msgID = 9699519;
        String message = MessageHandler.getMessage(msgID);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(BackupBackendCfg cfg, List<String> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(BackupBackendCfg cfg) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        SortedSet<String> values = cfg.getBackupDirectory();
        this.backupDirectories = new LinkedHashSet(values.size());
        for (String s : values) {
            this.backupDirectories.add(StaticUtils.getFileForPath(s));
        }
        this.currentConfig = cfg;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    public static DN makeChildDN(DN parentDN, AttributeType rdnAttrType, String rdnStringValue) {
        AttributeValue attrValue = new AttributeValue(rdnAttrType, rdnStringValue);
        return parentDN.concat(RDN.create(rdnAttrType, attrValue));
    }
}

