/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.authorization.dseecompat.AciEvalContext;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.authorization.dseecompat.EnumBindRuleType;
import org.opends.server.authorization.dseecompat.EnumEvalResult;
import org.opends.server.authorization.dseecompat.GroupDN;
import org.opends.server.authorization.dseecompat.KeywordBindRule;
import org.opends.server.authorization.dseecompat.ParentInheritance;
import org.opends.server.authorization.dseecompat.UserDN;
import org.opends.server.core.DirectoryServer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDAPURL;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;

public class UserAttr
implements KeywordBindRule {
    private static SearchFilter filter;
    private String attrStr = null;
    private String attrVal = null;
    private UserAttrType userAttrType = null;
    private EnumBindRuleType type = null;
    private ParentInheritance parentInheritance = null;

    private UserAttr(String attrStr, String attrVal, UserAttrType userAttrType, EnumBindRuleType type) {
        this.attrStr = attrStr;
        this.attrVal = attrVal;
        this.userAttrType = userAttrType;
        this.type = type;
    }

    private UserAttr(UserAttrType userAttrType, EnumBindRuleType type, ParentInheritance parentInheritance) {
        this.userAttrType = userAttrType;
        this.type = type;
        this.parentInheritance = parentInheritance;
    }

    public static KeywordBindRule decode(String expression, EnumBindRuleType type) throws AciException {
        String[] vals = expression.split("#");
        if (vals.length != 2) {
            int msgID = 12714012;
            String message = MessageHandler.getMessage(msgID, expression);
            throw new AciException(msgID, message);
        }
        UserAttrType userAttrType = UserAttr.getType(vals[1]);
        switch (userAttrType) {
            case GROUPDN: 
            case USERDN: {
                ParentInheritance parentInheritance = new ParentInheritance(vals[0], false);
                return new UserAttr(userAttrType, type, parentInheritance);
            }
            case ROLEDN: {
                int msgID = 12714059;
                String message = MessageHandler.getMessage(msgID, expression);
                throw new AciException(msgID, message);
            }
        }
        return new UserAttr(vals[0], vals[1], userAttrType, type);
    }

    public EnumEvalResult evaluate(AciEvalContext evalCtx) {
        EnumEvalResult matched;
        evalCtx.useFullResourceEntry(true);
        switch (this.userAttrType) {
            case GROUPDN: 
            case USERDN: 
            case ROLEDN: {
                matched = this.evalDNKeywords(evalCtx);
                break;
            }
            case URL: {
                matched = this.evalURL(evalCtx);
                break;
            }
            default: {
                matched = this.evalVAL(evalCtx);
            }
        }
        evalCtx.useFullResourceEntry(false);
        return matched;
    }

    private EnumEvalResult evalVAL(AciEvalContext evalCtx) {
        InternalClientConnection conn;
        InternalSearchOperation op;
        LinkedList<SearchResultEntry> result;
        EnumEvalResult matched = EnumEvalResult.FALSE;
        boolean undefined = false;
        AttributeType attrType = DirectoryServer.getAttributeType(this.attrStr);
        if (attrType == null) {
            attrType = DirectoryServer.getDefaultAttributeType(this.attrStr);
        }
        if (!(result = (op = (conn = InternalClientConnection.getRootConnection()).processSearch(evalCtx.getClientDN(), SearchScope.BASE_OBJECT, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, filter, null)).getSearchEntries()).isEmpty()) {
            Entry e;
            AttributeValue val = new AttributeValue(attrType, this.attrVal);
            SearchResultEntry resultEntry = result.getFirst();
            if (resultEntry.hasValue(attrType, null, val) && (e = evalCtx.getResourceEntry()).hasValue(attrType, null, val)) {
                matched = EnumEvalResult.TRUE;
            }
        }
        return matched.getRet(this.type, undefined);
    }

    private static UserAttrType getType(String expr) throws AciException {
        UserAttrType userAttrType = expr.equalsIgnoreCase("userdn") ? UserAttrType.USERDN : (expr.equalsIgnoreCase("groupdn") ? UserAttrType.GROUPDN : (expr.equalsIgnoreCase("roledn") ? UserAttrType.ROLEDN : (expr.equalsIgnoreCase("ldapurl") ? UserAttrType.URL : UserAttrType.VALUE)));
        return userAttrType;
    }

    private EnumEvalResult evalURL(AciEvalContext evalCtx) {
        List<Attribute> attrs;
        EnumEvalResult matched = EnumEvalResult.FALSE;
        boolean undefined = false;
        AttributeType attrType = DirectoryServer.getAttributeType(this.attrStr);
        if (attrType == null) {
            attrType = DirectoryServer.getDefaultAttributeType(this.attrStr);
        }
        if (!(attrs = evalCtx.getResourceEntry().getAttribute(attrType)).isEmpty()) {
            for (Attribute a : attrs) {
                LinkedHashSet<AttributeValue> vals = a.getValues();
                for (AttributeValue v : vals) {
                    LDAPURL url;
                    String urlStr = v.getStringValue();
                    try {
                        url = LDAPURL.decode(urlStr, true);
                    }
                    catch (DirectoryException e) {
                        break;
                    }
                    matched = UserDN.evalURL(evalCtx, url);
                    if (matched == EnumEvalResult.FALSE) continue;
                    break;
                }
                if (matched == EnumEvalResult.TRUE) break;
                if (matched != EnumEvalResult.ERR) continue;
                undefined = true;
                break;
            }
        }
        return matched.getRet(this.type, undefined);
    }

    private EnumEvalResult evalDNKeywords(AciEvalContext evalCtx) {
        EnumEvalResult matched = EnumEvalResult.FALSE;
        boolean undefined = false;
        boolean stop = false;
        int numLevels = this.parentInheritance.getNumLevels();
        int[] levels = this.parentInheritance.getLevels();
        AttributeType attrType = this.parentInheritance.getAttributeType();
        DN baseDN = this.parentInheritance.getBaseDN();
        if (baseDN != null) {
            if (evalCtx.getResourceEntry().hasAttribute(attrType)) {
                matched = GroupDN.evaluate(evalCtx.getResourceEntry(), evalCtx, attrType, baseDN);
            }
        } else {
            for (int i = 0; i < numLevels && !stop; ++i) {
                Entry e;
                if (levels[i] == 0) {
                    if (evalCtx.isAddOperation()) {
                        undefined = true;
                        continue;
                    }
                    if (!evalCtx.getResourceEntry().hasAttribute(attrType) || !(matched = this.evalEntryAttr(evalCtx.getResourceEntry(), evalCtx, attrType)).equals((Object)EnumEvalResult.TRUE)) continue;
                    stop = true;
                    continue;
                }
                DN pDN = this.getDNParentLevel(levels[i], evalCtx.getResourceDN());
                if (pDN == null) continue;
                LinkedHashSet<String> reqAttrs = new LinkedHashSet<String>(1);
                reqAttrs.add(this.parentInheritance.getAttrTypeStr());
                InternalClientConnection conn = InternalClientConnection.getRootConnection();
                InternalSearchOperation op = conn.processSearch(pDN, SearchScope.BASE_OBJECT, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, filter, reqAttrs);
                LinkedList<SearchResultEntry> result = op.getSearchEntries();
                if (result.isEmpty() || !(e = (Entry)result.getFirst()).hasAttribute(attrType) || !(matched = this.evalEntryAttr(e, evalCtx, attrType)).equals((Object)EnumEvalResult.TRUE)) continue;
                stop = true;
            }
        }
        return matched.getRet(this.type, undefined);
    }

    private DN getDNParentLevel(int l, DN dn) {
        int rdns = dn.getNumComponents();
        if (l > rdns) {
            return null;
        }
        DN theDN = dn;
        for (int i = 0; i < l; ++i) {
            theDN = theDN.getParent();
        }
        return theDN;
    }

    private EnumEvalResult evalEntryAttr(Entry e, AciEvalContext evalCtx, AttributeType attributeType) {
        EnumEvalResult result = EnumEvalResult.FALSE;
        switch (this.userAttrType) {
            case USERDN: {
                result = UserDN.evaluate(e, evalCtx.getClientDN(), attributeType);
                break;
            }
            case GROUPDN: {
                result = GroupDN.evaluate(e, evalCtx, attributeType, null);
            }
        }
        return result;
    }

    static {
        try {
            filter = SearchFilter.createFilterFromString("(objectclass=*)");
        }
        catch (DirectoryException directoryException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum UserAttrType {
        USERDN,
        GROUPDN,
        ROLEDN,
        URL,
        VALUE;

    }
}

