/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.regex.Pattern;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.authorization.dseecompat.EnumTargetOperator;
import org.opends.server.authorization.dseecompat.PatternDN;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.LDAPURL;

public class Target {
    private EnumTargetOperator operator = EnumTargetOperator.EQUALITY;
    private boolean isPattern = false;
    private DN urlDN = null;
    private PatternDN patternDN = null;

    private Target(EnumTargetOperator operator, String target, DN aciDN) throws AciException {
        this.operator = operator;
        try {
            if (!target.equals("ldap:///") && !Pattern.matches("\\s*(ldap:///[^\\|]+)", target)) {
                int msgID = 12714024;
                String message = MessageHandler.getMessage(msgID, target);
                throw new AciException(msgID, message);
            }
            LDAPURL targetURL = LDAPURL.decode(target, false);
            if (targetURL.getRawBaseDN().indexOf("*") != -1) {
                this.isPattern = true;
                this.patternDN = PatternDN.decodeSuffix(targetURL.getRawBaseDN());
            } else {
                this.urlDN = targetURL.getBaseDN();
                if (!this.urlDN.isDescendantOf(aciDN)) {
                    int msgID = 12714025;
                    String message = MessageHandler.getMessage(msgID, this.urlDN.toNormalizedString(), aciDN.toNormalizedString());
                    throw new AciException(msgID, message);
                }
            }
        }
        catch (DirectoryException e) {
            int msgID = 12714024;
            String message = MessageHandler.getMessage(msgID, target);
            throw new AciException(msgID, message);
        }
    }

    public static Target decode(EnumTargetOperator operator, String expr, DN aciDN) throws AciException {
        return new Target(operator, expr, aciDN);
    }

    public EnumTargetOperator getOperator() {
        return this.operator;
    }

    public DN getDN() {
        return this.urlDN;
    }

    public boolean isPattern() {
        return this.isPattern;
    }

    public boolean matchesPattern(DN dn) {
        return this.patternDN.matchesDN(dn);
    }
}

