/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.regex.Pattern;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.authorization.dseecompat.EnumAccessType;
import org.opends.server.authorization.dseecompat.EnumRight;
import org.opends.server.messages.MessageHandler;

public class Permission {
    private EnumAccessType accessType = null;
    private int rights;
    private static final String separatorToken = ",";
    private static final String rightsRegex = "\\s*(\\w+)\\s*(,\\s*(\\w+)\\s*)*";

    private Permission(String accessType, String rights) throws AciException {
        String[] rightsStr;
        this.accessType = EnumAccessType.decode(accessType);
        if (this.accessType == null) {
            int msgID = 12713987;
            String message = MessageHandler.getMessage(msgID, accessType);
            throw new AciException(msgID, message);
        }
        if (!Pattern.matches(rightsRegex, rights)) {
            int msgID = 12713988;
            String message = MessageHandler.getMessage(msgID, rights);
            throw new AciException(msgID, message);
        }
        Pattern separatorPattern = Pattern.compile(separatorToken);
        for (String r : rightsStr = separatorPattern.split(rights.replaceAll("\\s", ""))) {
            EnumRight right = EnumRight.decode(r);
            if (right != null) {
                this.rights |= EnumRight.getMask(right);
                continue;
            }
            int msgID = 12713989;
            String message = MessageHandler.getMessage(msgID, rights);
            throw new AciException(msgID, message);
        }
    }

    public static Permission decode(String accessType, String rights) throws AciException {
        return new Permission(accessType, rights);
    }

    public boolean hasAccessType(EnumAccessType accessType) {
        return this.accessType == accessType;
    }

    public boolean hasRights(int rights) {
        return (this.rights & rights) != 0;
    }
}

