/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.ArrayList;
import java.util.List;
import org.opends.server.authorization.dseecompat.PatternRDN;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternDN {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    PatternRDN[] equality = null;
    PatternRDN[] subInitial = null;
    List<PatternRDN[]> subAnyElements = null;
    PatternRDN[] subFinal = null;
    boolean isSuffix = false;

    private PatternDN(PatternRDN[] equality) {
        this.equality = equality;
    }

    private PatternDN(PatternRDN[] subInitial, List<PatternRDN[]> subAnyElements, PatternRDN[] subFinal) {
        Validator.ensureNotNull(subAnyElements);
        this.subInitial = subInitial;
        this.subAnyElements = subAnyElements;
        this.subFinal = subFinal;
    }

    public boolean matchesDN(DN dn) {
        int pos;
        if (this.equality != null) {
            if (this.equality.length != dn.getNumComponents()) {
                return false;
            }
            for (int i = 0; i < dn.getNumComponents(); ++i) {
                if (this.equality[i].matchesRDN(dn.getRDN(i))) continue;
                return false;
            }
            return true;
        }
        int valueLength = dn.getNumComponents();
        if (this.subInitial != null) {
            int initialLength = this.subInitial.length;
            if (initialLength > valueLength) {
                return false;
            }
            for (pos = 0; pos < initialLength; ++pos) {
                if (this.subInitial[pos].matchesRDN(dn.getRDN(pos))) continue;
                return false;
            }
            ++pos;
        } else if (!this.isSuffix) {
            ++pos;
        }
        if (this.subAnyElements != null && !this.subAnyElements.isEmpty()) {
            for (PatternRDN[] element : this.subAnyElements) {
                int anyLength = element.length;
                int end = valueLength - anyLength;
                boolean match = false;
                while (pos < end) {
                    if (element[0].matchesRDN(dn.getRDN(pos))) {
                        boolean subMatch = true;
                        for (int i = 1; i < anyLength; ++i) {
                            if (element[i].matchesRDN(dn.getRDN(pos + i))) continue;
                            subMatch = false;
                            break;
                        }
                        if (subMatch) {
                            match = subMatch;
                            break;
                        }
                    }
                    ++pos;
                }
                if (match) {
                    pos += anyLength + 1;
                    continue;
                }
                return false;
            }
        }
        if (this.subFinal != null) {
            int finalLength = this.subFinal.length;
            if (valueLength - finalLength < pos) {
                return false;
            }
            pos = valueLength - finalLength;
            int i = 0;
            while (i < finalLength) {
                if (!this.subFinal[i].matchesRDN(dn.getRDN(pos))) {
                    return false;
                }
                ++i;
                ++pos;
            }
        }
        return pos <= valueLength;
    }

    public static PatternDN decodeSuffix(String pattern) throws DirectoryException {
        PatternDN patternDN = PatternDN.decode(pattern);
        if (patternDN.equality != null) {
            patternDN.subInitial = null;
            patternDN.subFinal = patternDN.equality;
            patternDN.subAnyElements = null;
            patternDN.equality = null;
        } else if (patternDN.subInitial != null) {
            patternDN.subAnyElements.add(0, patternDN.subInitial);
            patternDN.subInitial = null;
        }
        patternDN.isSuffix = true;
        return patternDN;
    }

    public static PatternDN decode(String dnString) throws DirectoryException {
        int from;
        ArrayList<Integer> doubleWildPos;
        ArrayList<PatternRDN> rdnComponents;
        block40: {
            rdnComponents = new ArrayList<PatternRDN>();
            doubleWildPos = new ArrayList<Integer>();
            if (dnString == null) {
                return new PatternDN(new PatternRDN[0]);
            }
            int length = dnString.length();
            if (length == 0) {
                return new PatternDN(new PatternRDN[0]);
            }
            int pos = 0;
            char c = dnString.charAt(pos);
            while (c == ' ') {
                if (++pos == length) {
                    return new PatternDN(new PatternRDN[0]);
                }
                c = dnString.charAt(pos);
            }
            block1: while (true) {
                int attributePos = ++pos;
                StringBuilder attributeName = new StringBuilder();
                pos = PatternDN.parseAttributePattern(dnString, pos, attributeName);
                String name = attributeName.toString();
                if (pos >= length) {
                    if (name.equals("*")) {
                        rdnComponents.add(new PatternRDN(name, null, dnString));
                        break block40;
                    }
                    if (name.equals("**")) {
                        doubleWildPos.add(rdnComponents.size());
                        break block40;
                    }
                    pos = attributePos - 1;
                    name = "*";
                    c = '=';
                } else {
                    c = dnString.charAt(pos);
                    while (c == ' ') {
                        if (++pos >= length) {
                            if (name.equals("*")) {
                                rdnComponents.add(new PatternRDN(name, null, dnString));
                                break block40;
                            }
                            if (name.equals("**")) {
                                doubleWildPos.add(rdnComponents.size());
                                break block40;
                            }
                            pos = attributePos - 1;
                            name = "*";
                            c = '=';
                            continue;
                        }
                        c = dnString.charAt(pos);
                    }
                }
                if (c == '=') {
                    ++pos;
                } else if (c == ',' || c == ';') {
                    if (name.equals("*")) {
                        rdnComponents.add(new PatternRDN(name, null, dnString));
                        continue;
                    }
                    if (name.equals("**")) {
                        doubleWildPos.add(rdnComponents.size());
                        ++pos;
                        continue;
                    }
                    pos = attributePos;
                    name = "*";
                } else {
                    int msgID = 6488100;
                    String message = MessageHandler.getMessage(msgID, dnString, attributeName.toString(), Character.valueOf(c));
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                }
                while (pos < length && dnString.charAt(pos) == ' ') {
                    ++pos;
                }
                if (pos >= length) {
                    ArrayList<ByteString> arrayList = new ArrayList<ByteString>(1);
                    arrayList.add(new ASN1OctetString());
                    rdnComponents.add(new PatternRDN(name, arrayList, dnString));
                    break block40;
                }
                ArrayList<ByteString> parsedValue = new ArrayList<ByteString>();
                PatternRDN rdn = new PatternRDN(name, parsedValue, dnString);
                for (pos = PatternDN.parseValuePattern(dnString, pos, parsedValue); pos < length && (c = dnString.charAt(pos)) == ' '; ++pos) {
                }
                if (pos >= length) {
                    rdnComponents.add(rdn);
                    break block40;
                }
                if (c == ',' || c == ';') {
                    rdnComponents.add(rdn);
                    ++pos;
                    continue;
                }
                if (c != '+') {
                    int msgID = 6488101;
                    String message = MessageHandler.getMessage(msgID, dnString, Character.valueOf(c), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                }
                do {
                    ++pos;
                    while (pos < length && dnString.charAt(pos) == ' ') {
                        ++pos;
                    }
                    attributeName = new StringBuilder();
                    if ((pos = PatternDN.parseAttributePattern(dnString, pos, attributeName)) >= length) {
                        int msgID = 6488099;
                        String message = MessageHandler.getMessage(msgID, dnString, attributeName.toString());
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                    }
                    name = attributeName.toString();
                    c = dnString.charAt(pos);
                    while (c == ' ') {
                        if (++pos >= length) {
                            int msgID = 6488099;
                            String message = MessageHandler.getMessage(msgID, dnString, name);
                            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                        }
                        c = dnString.charAt(pos);
                    }
                    if (c == '=') {
                        ++pos;
                    } else {
                        int msgID = 6488100;
                        String message = MessageHandler.getMessage(msgID, dnString, name, Character.valueOf(c));
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                    }
                    while (pos < length && (c = dnString.charAt(pos)) == ' ') {
                        ++pos;
                    }
                    if (pos >= length) {
                        ArrayList<ByteString> arrayList = new ArrayList<ByteString>(1);
                        arrayList.add(new ASN1OctetString());
                        rdn.addValue(name, arrayList, dnString);
                        rdnComponents.add(rdn);
                        continue block1;
                    }
                    parsedValue = new ArrayList();
                    rdn.addValue(name, parsedValue, dnString);
                    for (pos = PatternDN.parseValuePattern(dnString, pos, parsedValue); pos < length && (c = dnString.charAt(pos)) == ' '; ++pos) {
                    }
                    if (pos >= length) {
                        rdnComponents.add(rdn);
                        continue block1;
                    }
                    if (c != ',' && c != 59) continue;
                    rdnComponents.add(rdn);
                    ++pos;
                    continue block1;
                } while (c == 43);
                break;
            }
            int msgID = 6488101;
            String message = MessageHandler.getMessage(msgID, dnString, Character.valueOf(c), pos);
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
        }
        if (doubleWildPos.isEmpty()) {
            PatternRDN[] patterns = new PatternRDN[rdnComponents.size()];
            patterns = rdnComponents.toArray(patterns);
            return new PatternDN(patterns);
        }
        PatternRDN[] subInitial = null;
        PatternRDN[] subFinal = null;
        ArrayList<PatternRDN[]> subAnyElements = new ArrayList<PatternRDN[]>();
        int i = 0;
        int numComponents = rdnComponents.size();
        int to = (Integer)doubleWildPos.get(i);
        if (to != 0) {
            subInitial = new PatternRDN[to];
            subInitial = rdnComponents.subList(0, to).toArray(subInitial);
        }
        while (i < doubleWildPos.size() - 1) {
            from = (Integer)doubleWildPos.get(i);
            to = (Integer)doubleWildPos.get(i + 1);
            PatternRDN[] subAny = new PatternRDN[to - from];
            subAny = rdnComponents.subList(from, to).toArray(subAny);
            subAnyElements.add(subAny);
            ++i;
        }
        if (i < doubleWildPos.size() && (from = ((Integer)doubleWildPos.get(i)).intValue()) != numComponents) {
            subFinal = new PatternRDN[numComponents - from];
            subFinal = rdnComponents.subList(from, numComponents).toArray(subFinal);
        }
        return new PatternDN(subInitial, subAnyElements, subFinal);
    }

    static int parseAttributePattern(String dnString, int pos, StringBuilder attributeName) throws DirectoryException {
        int length = dnString.length();
        if (pos < length) {
            while (dnString.charAt(pos) == ' ') {
                if (++pos != length) continue;
                int msgID = 6488090;
                String message = MessageHandler.getMessage(msgID, dnString);
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
            }
        }
        boolean checkForOID = false;
        boolean endOfName = false;
        while (pos < length) {
            char c = dnString.charAt(pos);
            switch (c) {
                case ' ': {
                    endOfName = true;
                    break;
                }
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': {
                    int msgID = 6488092;
                    String message = MessageHandler.getMessage(msgID, dnString, Character.valueOf(c), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                }
                case '*': {
                    attributeName.append(c);
                    break;
                }
                case '+': {
                    int msgID = 6488092;
                    String message = MessageHandler.getMessage(msgID, dnString, Character.valueOf(c), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                }
                case ',': {
                    endOfName = true;
                    break;
                }
                case '-': {
                    if (attributeName.length() > 0) {
                        attributeName.append(c);
                        break;
                    }
                    int msgID = 6488094;
                    String message = MessageHandler.getMessage(msgID, dnString, Character.valueOf(c));
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                }
                case '.': {
                    attributeName.append(c);
                    checkForOID = true;
                    break;
                }
                case '/': {
                    int msgID = 6488092;
                    String message = MessageHandler.getMessage(msgID, dnString, Character.valueOf(c), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    attributeName.append(c);
                    break;
                }
                case ':': {
                    int msgID = 6488092;
                    String message = MessageHandler.getMessage(msgID, dnString, Character.valueOf(c), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                }
                case ';': {
                    endOfName = true;
                    break;
                }
                case '<': {
                    int msgID = 6488092;
                    String message = MessageHandler.getMessage(msgID, dnString, Character.valueOf(c), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                }
                case '=': {
                    endOfName = true;
                    break;
                }
                case '>': 
                case '?': 
                case '@': {
                    int msgID = 6488092;
                    String message = MessageHandler.getMessage(msgID, dnString, Character.valueOf(c), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': {
                    attributeName.append(c);
                    break;
                }
                case '[': 
                case '\\': 
                case ']': 
                case '^': {
                    int msgID = 6488092;
                    String message = MessageHandler.getMessage(msgID, dnString, Character.valueOf(c), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                }
                case '_': {
                    attributeName.append(c);
                    break;
                }
                case '`': {
                    int msgID = 6488092;
                    String message = MessageHandler.getMessage(msgID, dnString, Character.valueOf(c), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    attributeName.append(c);
                    break;
                }
                default: {
                    int msgID = 6488092;
                    String message = MessageHandler.getMessage(msgID, dnString, Character.valueOf(c), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                }
            }
            if (endOfName) break;
            ++pos;
        }
        if (attributeName.length() == 0) {
            int msgID = 6488097;
            String message = MessageHandler.getMessage(msgID, dnString);
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
        }
        if (checkForOID) {
            boolean validOID = true;
            int namePos = 0;
            int nameLength = attributeName.length();
            char ch = attributeName.charAt(0);
            if (ch == 'o' || ch == 'O') {
                if (nameLength <= 4) {
                    validOID = false;
                } else {
                    ch = attributeName.charAt(1);
                    if (!(ch != 'i' && ch != 'I' || (ch = attributeName.charAt(2)) != 'd' && ch != 'D' || attributeName.charAt(3) != '.')) {
                        attributeName.delete(0, 4);
                        nameLength -= 4;
                    } else {
                        validOID = false;
                    }
                }
            }
            while (validOID && namePos < nameLength) {
                if (StaticUtils.isDigit(ch = attributeName.charAt(namePos++))) {
                    while (validOID && namePos < nameLength && StaticUtils.isDigit(attributeName.charAt(namePos))) {
                        ++namePos;
                    }
                    if (namePos >= nameLength || attributeName.charAt(namePos) == '.') continue;
                    validOID = false;
                    continue;
                }
                if (ch == '.') {
                    if (namePos != 1 && attributeName.charAt(namePos - 2) != '.') continue;
                    validOID = false;
                    continue;
                }
                validOID = false;
            }
            if (validOID && attributeName.charAt(nameLength - 1) == '.') {
                validOID = false;
            }
            if (!validOID) {
                int msgID = 6488098;
                String message = MessageHandler.getMessage(msgID, dnString, attributeName.toString());
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
            }
        }
        return pos;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int parseValuePattern(String dnString, int pos, ArrayList<ByteString> attributeValues) throws DirectoryException {
        boolean escaped;
        StringBuilder hexChars;
        StringBuilder valueString;
        char c;
        int length;
        block36: {
            block37: {
                length = dnString.length();
                if (pos >= length) {
                    return pos;
                }
                if ((c = dnString.charAt(pos++)) == '#') {
                    StringBuilder hexString = new StringBuilder();
                    if (pos + 2 > length) {
                        int msgID = 6488102;
                        String message = MessageHandler.getMessage(msgID, dnString);
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                    }
                    for (int i = 0; i < 2; ++i) {
                        if (!StaticUtils.isHexDigit(c = dnString.charAt(pos++))) {
                            int msgID = 6488103;
                            String message = MessageHandler.getMessage(msgID, dnString, Character.valueOf(c));
                            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                        }
                        hexString.append(c);
                    }
                    while (pos < length) {
                        int msgID;
                        if (StaticUtils.isHexDigit(c = dnString.charAt(pos++))) {
                            hexString.append(c);
                            if (pos >= length) {
                                msgID = 6488102;
                                String message = MessageHandler.getMessage(msgID, dnString);
                                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                            }
                            if (!StaticUtils.isHexDigit(c = dnString.charAt(pos++))) {
                                msgID = 6488103;
                                String message = MessageHandler.getMessage(msgID, dnString, Character.valueOf(c));
                                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                            }
                            hexString.append(c);
                            continue;
                        }
                        if (c != ' ' && c != ',' && c != ';') {
                            msgID = 6488103;
                            String message = MessageHandler.getMessage(msgID, dnString, Character.valueOf(c));
                            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                        }
                        --pos;
                        break;
                    }
                    try {
                        byte[] bytes = StaticUtils.hexStringToByteArray(hexString.toString());
                        attributeValues.add(new ASN1OctetString(bytes));
                        return pos;
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        int msgID = 6488104;
                        String message = MessageHandler.getMessage(msgID, dnString, String.valueOf(e));
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                    }
                }
                if (c == '\"') break block37;
                valueString = new StringBuilder();
                hexChars = new StringBuilder();
                if (c == '\\') {
                    escaped = true;
                    break block36;
                } else if (c == '*') {
                    escaped = false;
                    attributeValues.add(new ASN1OctetString(valueString.toString()));
                    break block36;
                } else {
                    escaped = false;
                    valueString.append(c);
                }
                break block36;
            }
            boolean escaped2 = false;
            StringBuilder valueString2 = new StringBuilder();
            while (true) {
                if (pos >= length) {
                    int msgID = 6488105;
                    String message = MessageHandler.getMessage(msgID, dnString);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                }
                c = dnString.charAt(pos++);
                if (escaped2) {
                    valueString2.append(c);
                    escaped2 = false;
                    continue;
                }
                if (c == '\\') {
                    escaped2 = true;
                    continue;
                }
                if (c == '\"') {
                    attributeValues.add(new ASN1OctetString(valueString2.toString()));
                    return pos;
                }
                valueString2.append(c);
            }
        }
        while (true) {
            int msgID;
            if (pos >= length) {
                PatternDN.appendHexChars(dnString, valueString, hexChars);
                break;
            }
            c = dnString.charAt(pos++);
            if (escaped) {
                if (StaticUtils.isHexDigit(c)) {
                    char c2;
                    if (pos >= length) {
                        msgID = 6488106;
                        String message = MessageHandler.getMessage(msgID, dnString);
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                    }
                    if (!StaticUtils.isHexDigit(c2 = dnString.charAt(pos++))) {
                        int msgID2 = 6488106;
                        String message = MessageHandler.getMessage(msgID2, dnString);
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID2);
                    }
                    hexChars.append(c);
                    hexChars.append(c2);
                } else {
                    PatternDN.appendHexChars(dnString, valueString, hexChars);
                    valueString.append(c);
                }
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == ',' || c == ';') {
                PatternDN.appendHexChars(dnString, valueString, hexChars);
                --pos;
                break;
            }
            if (c == '+') {
                PatternDN.appendHexChars(dnString, valueString, hexChars);
                --pos;
                break;
            }
            if (c == '*') {
                PatternDN.appendHexChars(dnString, valueString, hexChars);
                if (valueString.length() == 0) {
                    msgID = 12714053;
                    String message = MessageHandler.getMessage(msgID, dnString);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                }
                attributeValues.add(new ASN1OctetString(valueString.toString()));
                valueString = new StringBuilder();
                hexChars = new StringBuilder();
                continue;
            }
            PatternDN.appendHexChars(dnString, valueString, hexChars);
            valueString.append(c);
        }
        if (pos > 2 && dnString.charAt(pos - 1) == ' ' && dnString.charAt(pos - 2) != '\\') {
            for (int lastPos = valueString.length() - 1; lastPos > 0 && valueString.charAt(lastPos) == ' '; --lastPos) {
                valueString.delete(lastPos, lastPos + 1);
            }
        }
        attributeValues.add(new ASN1OctetString(valueString.toString()));
        return pos;
    }

    private static void appendHexChars(String dnString, StringBuilder valueString, StringBuilder hexChars) throws DirectoryException {
        try {
            byte[] hexBytes = StaticUtils.hexStringToByteArray(hexChars.toString());
            valueString.append(new String(hexBytes, "UTF-8"));
            hexChars.delete(0, hexChars.length());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 6488104;
            String message = MessageHandler.getMessage(msgID, dnString, String.valueOf(e));
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
        }
    }
}

