/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.LDAPURL;

public class ParentInheritance {
    private static final int MAX_LEVELS = 10;
    private final String parentPat = "parent[";
    private final int[] levels = new int[10];
    private int numLevels;
    private AttributeType attributeType;
    private String attrTypeStr;
    private DN baseDN = null;

    ParentInheritance(String pattern, boolean skipParse) throws AciException {
        if (skipParse) {
            if (pattern.startsWith("parent[")) {
                int msgID = 12714035;
                String message = MessageHandler.getMessage(msgID, pattern);
                throw new AciException(msgID, message);
            }
            pattern = pattern.trim();
            Pattern pattern1 = Pattern.compile("((?i)[a-z\\d]{1}[[a-z]\\d-_.;]*(?-i)|\\*{1}|\\+{1})");
            Matcher matcher = pattern1.matcher(pattern);
            if (!matcher.find() || matcher.groupCount() != 1) {
                int msgID = 12714043;
                String message = MessageHandler.getMessage(msgID, pattern);
                throw new AciException(msgID, message);
            }
            this.attributeType = DirectoryServer.getAttributeType(pattern);
            if (this.attributeType == null) {
                this.attributeType = DirectoryServer.getDefaultAttributeType(pattern);
            }
            this.numLevels = 1;
            this.levels[0] = 0;
        } else {
            this.parse(pattern);
        }
    }

    private void parse(String pattern) throws AciException {
        if ((pattern = pattern.trim()).startsWith("parent[")) {
            this.numLevels = 0;
            this.levels[0] = 0;
            String p = pattern.substring("parent[".length());
            String[] toks = p.split("\\.");
            if (toks.length != 2) {
                int msgID = 12714014;
                String message = MessageHandler.getMessage(msgID, pattern);
                throw new AciException(msgID, message);
            }
            Pattern pattern1 = Pattern.compile("((?i)[a-z\\d]{1}[[a-z]\\d-_.;]*(?-i)|\\*{1}|\\+{1})");
            Matcher matcher = pattern1.matcher(toks[1]);
            if (!matcher.find() || matcher.groupCount() != 1) {
                int msgID = 12714043;
                String message = MessageHandler.getMessage(msgID, toks[1]);
                throw new AciException(msgID, message);
            }
            this.attributeType = DirectoryServer.getAttributeType(toks[1]);
            if (this.attributeType == null) {
                this.attributeType = DirectoryServer.getDefaultAttributeType(toks[1]);
            }
            this.attrTypeStr = toks[1];
            StringTokenizer tok = new StringTokenizer(toks[0], "],", false);
            while (tok.hasMoreTokens()) {
                String v = tok.nextToken();
                try {
                    if (this.numLevels < 10) {
                        this.levels[this.numLevels++] = Integer.decode(v);
                        continue;
                    }
                    int msgID = 12714015;
                    String message = MessageHandler.getMessage(msgID, pattern, Integer.toString(10));
                    throw new AciException(msgID, message);
                }
                catch (NumberFormatException ex) {
                    int msgID = 0xC20020;
                    String message = MessageHandler.getMessage(msgID, pattern);
                    throw new AciException(msgID, message);
                }
            }
        } else {
            this.attrTypeStr = pattern;
            if (pattern.startsWith("ldap:///")) {
                try {
                    LDAPURL url = LDAPURL.decode(pattern, true);
                    LinkedHashSet<String> attrs = url.getAttributes();
                    if (attrs.size() != 1) {
                        int msgID = 12714064;
                        String message = MessageHandler.getMessage(msgID, pattern);
                        throw new AciException(msgID, message);
                    }
                    this.baseDN = url.getBaseDN();
                    if (this.baseDN.isNullDN()) {
                        int msgID = 12714063;
                        String message = MessageHandler.getMessage(msgID, pattern);
                        throw new AciException(msgID, message);
                    }
                    this.attrTypeStr = (String)attrs.iterator().next();
                }
                catch (DirectoryException ex) {
                    int msgID = 12714062;
                    String message = MessageHandler.getMessage(msgID, ex.getErrorMessage());
                    throw new AciException(msgID, message);
                }
            }
            if ((this.attributeType = DirectoryServer.getAttributeType(this.attrTypeStr)) == null) {
                this.attributeType = DirectoryServer.getDefaultAttributeType(this.attrTypeStr);
            }
            this.numLevels = 1;
            this.levels[0] = 0;
        }
    }

    public int getNumLevels() {
        return this.numLevels;
    }

    public int[] getLevels() {
        int[] levelsCopy = new int[this.levels.length];
        System.arraycopy(this.levels, 0, levelsCopy, 0, this.levels.length);
        return levelsCopy;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public String getAttrTypeStr() {
        return this.attrTypeStr;
    }

    public DN getBaseDN() {
        return this.baseDN;
    }
}

