/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.net.InetAddress;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.opends.server.authorization.dseecompat.AciEvalContext;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.authorization.dseecompat.EnumBindRuleType;
import org.opends.server.authorization.dseecompat.EnumEvalResult;
import org.opends.server.authorization.dseecompat.KeywordBindRule;
import org.opends.server.authorization.dseecompat.PatternIP;
import org.opends.server.messages.MessageHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IP
implements KeywordBindRule {
    private static final String ipRegEx = "((?i)[\\.{1}[a-f]\\d:\\+{1}\\*/{1}\\t\\[{1}\\]{1}]+(?-i))";
    private List<PatternIP> patternIPList = null;
    private EnumBindRuleType type = null;

    private IP(List<PatternIP> patternIPList, EnumBindRuleType type) {
        this.patternIPList = patternIPList;
        this.type = type;
    }

    public static KeywordBindRule decode(String expr, EnumBindRuleType type) throws AciException {
        String[] ipStrs = expr.split("\\,", -1);
        LinkedList<PatternIP> patternIPList = new LinkedList<PatternIP>();
        for (String ipStr : ipStrs) {
            if (!Pattern.matches(ipRegEx, ipStr)) {
                int msgID = 12714005;
                String message = MessageHandler.getMessage(msgID, expr);
                throw new AciException(msgID, message);
            }
            PatternIP ipPattern = PatternIP.decode(ipStr);
            patternIPList.add(ipPattern);
        }
        return new IP(patternIPList, type);
    }

    @Override
    public EnumEvalResult evaluate(AciEvalContext evalCtx) {
        InetAddress remoteAddr = evalCtx.getRemoteAddress();
        return this.evaluate(remoteAddr);
    }

    EnumEvalResult evaluate(InetAddress addr) {
        EnumEvalResult matched = EnumEvalResult.FALSE;
        Iterator<PatternIP> it = this.patternIPList.iterator();
        while (it.hasNext() && matched != EnumEvalResult.TRUE && matched != EnumEvalResult.ERR) {
            PatternIP patternIP = it.next();
            matched = patternIP.evaluate(addr);
        }
        return matched.getRet(this.type, false);
    }
}

