/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.HashSet;
import org.opends.server.authorization.dseecompat.Aci;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.authorization.dseecompat.AciTargetMatchContext;
import org.opends.server.authorization.dseecompat.EnumTargetOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtOp {
    private HashSet<String> extOpOIDs = new HashSet();
    private EnumTargetOperator op = EnumTargetOperator.EQUALITY;

    private ExtOp(EnumTargetOperator op, HashSet<String> extOpOIDs) {
        this.extOpOIDs = extOpOIDs;
        this.op = op;
    }

    public static ExtOp decode(EnumTargetOperator operator, String expr) throws AciException {
        HashSet<String> extOpOIDs = Aci.decodeOID(expr, 12714079);
        return new ExtOp(operator, extOpOIDs);
    }

    public boolean isApplicable(AciTargetMatchContext matchCtx) {
        if (matchCtx.getExtOpOID() == null) {
            return false;
        }
        boolean ret = false;
        for (String oid : this.extOpOIDs) {
            if (!oid.equals("*") && !matchCtx.getExtOpOID().equals(oid)) continue;
            ret = true;
            break;
        }
        if (this.op.equals((Object)EnumTargetOperator.NOT_EQUALITY)) {
            ret = !ret;
        }
        return ret;
    }
}

