/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.GregorianCalendar;
import java.util.LinkedList;
import org.opends.server.authorization.dseecompat.AciEvalContext;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.authorization.dseecompat.EnumBindRuleType;
import org.opends.server.authorization.dseecompat.EnumDayOfWeek;
import org.opends.server.authorization.dseecompat.EnumEvalResult;
import org.opends.server.authorization.dseecompat.KeywordBindRule;
import org.opends.server.messages.MessageHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DayOfWeek
implements KeywordBindRule {
    LinkedList<EnumDayOfWeek> days = null;
    private EnumBindRuleType type = null;

    private DayOfWeek(LinkedList<EnumDayOfWeek> days, EnumBindRuleType type) {
        this.days = days;
        this.type = type;
    }

    public static KeywordBindRule decode(String expr, EnumBindRuleType type) throws AciException {
        LinkedList<EnumDayOfWeek> days = new LinkedList<EnumDayOfWeek>();
        String[] dayArray = expr.split(",", -1);
        int m = dayArray.length;
        for (int i = 0; i < m; ++i) {
            EnumDayOfWeek day = EnumDayOfWeek.createDayOfWeek(dayArray[i]);
            if (day == null) {
                int msgID = 12714008;
                String message = MessageHandler.getMessage(msgID, expr);
                throw new AciException(msgID, message);
            }
            days.add(day);
        }
        return new DayOfWeek(days, type);
    }

    @Override
    public EnumEvalResult evaluate(AciEvalContext evalCtx) {
        EnumEvalResult matched = EnumEvalResult.FALSE;
        GregorianCalendar calendar = new GregorianCalendar();
        EnumDayOfWeek dayofweek = EnumDayOfWeek.getDayOfWeek(calendar.get(7));
        if (this.days.contains((Object)dayofweek)) {
            matched = EnumEvalResult.TRUE;
        }
        return matched.getRet(this.type, false);
    }
}

