/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opends.server.authorization.dseecompat.AciEvalContext;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.authorization.dseecompat.AuthMethod;
import org.opends.server.authorization.dseecompat.DNS;
import org.opends.server.authorization.dseecompat.DayOfWeek;
import org.opends.server.authorization.dseecompat.EnumBindRuleKeyword;
import org.opends.server.authorization.dseecompat.EnumBindRuleType;
import org.opends.server.authorization.dseecompat.EnumBooleanTypes;
import org.opends.server.authorization.dseecompat.EnumEvalResult;
import org.opends.server.authorization.dseecompat.GroupDN;
import org.opends.server.authorization.dseecompat.IP;
import org.opends.server.authorization.dseecompat.KeywordBindRule;
import org.opends.server.authorization.dseecompat.TimeOfDay;
import org.opends.server.authorization.dseecompat.UserAttr;
import org.opends.server.authorization.dseecompat.UserDN;
import org.opends.server.messages.MessageHandler;

public class BindRule {
    private HashMap<String, KeywordBindRule> keywordRuleMap = new HashMap();
    private boolean negate = false;
    private BindRule left = null;
    private BindRule right = null;
    private EnumBooleanTypes booleanType = null;
    private EnumBindRuleKeyword keyword = null;
    private static final int keywordPos = 1;
    private static final int opPos = 2;
    private static final int expressionPos = 3;
    private static final int remainingOperandPos = 1;
    private static final int remainingBindrulePos = 2;
    private static final String opRegGroup = "([!=<>]+)";
    private static final String expressionRegex = "\"([^\"]+)\"\\s*";
    private static final String bindruleRegex = "^(\\w+)\\s*([!=<>]+)\\s*\"([^\"]+)\"\\s*";
    private static final String remainingBindruleRegex = "^\\s*(\\w+)\\s*(.*)$";

    private BindRule(EnumBindRuleKeyword keyword, KeywordBindRule rule) {
        this.keyword = keyword;
        this.keywordRuleMap.put(keyword.toString(), rule);
    }

    private BindRule(BindRule left, BindRule right, EnumBooleanTypes booleanType) {
        this.booleanType = booleanType;
        this.left = left;
        this.right = right;
    }

    public static BindRule decode(String input) throws AciException {
        if (input == null || input.length() == 0) {
            return null;
        }
        String bindruleStr = input.trim();
        char firstChar = bindruleStr.charAt(0);
        char[] bindruleArray = bindruleStr.toCharArray();
        if (firstChar == '(') {
            int currentPos;
            BindRule bindrule_1 = null;
            int numOpen = 0;
            int numClose = 0;
            for (currentPos = 0; currentPos < bindruleArray.length; ++currentPos) {
                if (bindruleArray[currentPos] == '(') {
                    ++numOpen;
                } else if (bindruleArray[currentPos] == ')') {
                    ++numClose;
                }
                if (numClose != numOpen) continue;
                String bindruleStr1 = bindruleStr.substring(1, currentPos);
                bindrule_1 = BindRule.decode(bindruleStr1);
                break;
            }
            if (numOpen > numClose) {
                int msgID = 12779526;
                String message = MessageHandler.getMessage(msgID, input);
                throw new AciException(msgID, message);
            }
            if (currentPos < bindruleArray.length - 1) {
                String remainingBindruleStr = bindruleStr.substring(currentPos + 1);
                return BindRule.createBindRule(bindrule_1, remainingBindruleStr);
            }
            return bindrule_1;
        }
        StringBuilder b = new StringBuilder(bindruleStr);
        boolean negate = BindRule.determineNegation(b);
        bindruleStr = b.toString();
        Pattern bindrulePattern = Pattern.compile(bindruleRegex);
        Matcher bindruleMatcher = bindrulePattern.matcher(bindruleStr);
        if (bindruleMatcher.find()) {
            int bindruleEndIndex = bindruleMatcher.end();
            BindRule bindrule_1 = BindRule.parseAndCreateBindrule(bindruleMatcher);
            bindrule_1.setNegate(negate);
            if (bindruleEndIndex < bindruleStr.length()) {
                String remainingBindruleStr = bindruleStr.substring(bindruleEndIndex);
                return BindRule.createBindRule(bindrule_1, remainingBindruleStr);
            }
            return bindrule_1;
        }
        int msgID = 12779527;
        String message = MessageHandler.getMessage(msgID, input);
        throw new AciException(msgID, message);
    }

    private static BindRule parseAndCreateBindrule(Matcher bindruleMatcher) throws AciException {
        String keywordStr = bindruleMatcher.group(1);
        String operatorStr = bindruleMatcher.group(2);
        String expression = bindruleMatcher.group(3);
        EnumBindRuleKeyword keyword = EnumBindRuleKeyword.createBindRuleKeyword(keywordStr);
        if (keyword == null) {
            int msgID = 12713992;
            String message = MessageHandler.getMessage(msgID, keywordStr);
            throw new AciException(msgID, message);
        }
        EnumBindRuleType operator = EnumBindRuleType.createBindruleOperand(operatorStr);
        if (operator == null) {
            int msgID = 12713993;
            String message = MessageHandler.getMessage(msgID, operatorStr);
            throw new AciException(msgID, message);
        }
        if (expression == null) {
            int msgID = 12713994;
            String message = MessageHandler.getMessage(msgID, operatorStr);
            throw new AciException(msgID, message);
        }
        BindRule.validateOperation(keyword, operator);
        KeywordBindRule rule = BindRule.decode(expression, keyword, operator);
        return new BindRule(keyword, rule);
    }

    private static BindRule createBindRule(BindRule bindrule, String remainingBindruleStr) throws AciException {
        Pattern remainingBindrulePattern = Pattern.compile(remainingBindruleRegex);
        Matcher remainingBindruleMatcher = remainingBindrulePattern.matcher(remainingBindruleStr);
        if (remainingBindruleMatcher.find()) {
            String remainingOperand = remainingBindruleMatcher.group(1);
            String remainingBindrule = remainingBindruleMatcher.group(2);
            EnumBooleanTypes operand = EnumBooleanTypes.createBindruleOperand(remainingOperand);
            if (operand == null || operand != EnumBooleanTypes.AND_BOOLEAN_TYPE && operand != EnumBooleanTypes.OR_BOOLEAN_TYPE) {
                int msgID = 12713995;
                String message = MessageHandler.getMessage(msgID, remainingOperand);
                throw new AciException(msgID, message);
            }
            StringBuilder ruleExpr = new StringBuilder(remainingBindrule);
            boolean negate = BindRule.determineNegation(ruleExpr);
            remainingBindrule = ruleExpr.toString();
            BindRule bindrule_2 = BindRule.decode(remainingBindrule);
            bindrule_2.setNegate(negate);
            return new BindRule(bindrule, bindrule_2, operand);
        }
        int msgID = 12779527;
        String message = MessageHandler.getMessage(msgID, remainingBindruleStr);
        throw new AciException(msgID, message);
    }

    private static boolean determineNegation(StringBuilder ruleExpr) {
        boolean negate = false;
        String ruleStr = ruleExpr.toString();
        while (ruleStr.regionMatches(true, 0, "not ", 0, 4)) {
            negate = !negate;
            ruleStr = ruleStr.substring(4);
        }
        ruleExpr.replace(0, ruleExpr.length(), ruleStr);
        return negate;
    }

    private void setNegate(boolean v) {
        this.negate = v;
    }

    private static void validateOperation(EnumBindRuleKeyword keyword, EnumBindRuleType op) throws AciException {
        switch (keyword) {
            case USERDN: 
            case ROLEDN: 
            case GROUPDN: 
            case IP: 
            case DNS: 
            case AUTHMETHOD: 
            case DAYOFWEEK: {
                if (op == EnumBindRuleType.EQUAL_BINDRULE_TYPE || op == EnumBindRuleType.NOT_EQUAL_BINDRULE_TYPE) break;
                int msgID = 0xC2000C;
                String message = MessageHandler.getMessage(msgID, keyword.toString(), op.toString());
                throw new AciException(msgID, message);
            }
        }
    }

    private static KeywordBindRule decode(String expr, EnumBindRuleKeyword keyword, EnumBindRuleType op) throws AciException {
        KeywordBindRule rule;
        switch (keyword) {
            case USERDN: {
                rule = UserDN.decode(expr, op);
                break;
            }
            case ROLEDN: {
                int msgID = 12714059;
                String message = MessageHandler.getMessage(msgID, expr);
                throw new AciException(msgID, message);
            }
            case GROUPDN: {
                rule = GroupDN.decode(expr, op);
                break;
            }
            case IP: {
                rule = IP.decode(expr, op);
                break;
            }
            case DNS: {
                rule = DNS.decode(expr, op);
                break;
            }
            case DAYOFWEEK: {
                rule = DayOfWeek.decode(expr, op);
                break;
            }
            case TIMEOFDAY: {
                rule = TimeOfDay.decode(expr, op);
                break;
            }
            case AUTHMETHOD: {
                rule = AuthMethod.decode(expr, op);
                break;
            }
            case USERATTR: {
                rule = UserAttr.decode(expr, op);
                break;
            }
            default: {
                int msgID = 12713992;
                String message = MessageHandler.getMessage(msgID, keyword.toString());
                throw new AciException(msgID, message);
            }
        }
        return rule;
    }

    private EnumEvalResult evalComplex(EnumEvalResult left, EnumEvalResult right) {
        EnumEvalResult ret = EnumEvalResult.FALSE;
        if (this.booleanType == EnumBooleanTypes.AND_BOOLEAN_TYPE) {
            if (left == EnumEvalResult.TRUE && right == EnumEvalResult.TRUE) {
                ret = EnumEvalResult.TRUE;
            }
        } else if (left == EnumEvalResult.TRUE || right == EnumEvalResult.TRUE) {
            ret = EnumEvalResult.TRUE;
        }
        return ret;
    }

    public EnumEvalResult evaluate(AciEvalContext evalCtx) {
        EnumEvalResult ret;
        if (this.booleanType == null) {
            KeywordBindRule rule = this.keywordRuleMap.get(this.keyword.toString());
            ret = rule.evaluate(evalCtx);
        } else {
            ret = this.evalComplex(this.left.evaluate(evalCtx), this.right.evaluate(evalCtx));
        }
        return EnumEvalResult.negateIfNeeded(ret, this.negate);
    }
}

