/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import org.opends.server.admin.std.server.WorkQueueCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkQueue<T extends WorkQueueCfg> {
    public abstract void initializeWorkQueue(T var1) throws ConfigException, InitializationException;

    public abstract void finalizeWorkQueue(String var1);

    public abstract void submitOperation(AbstractOperation var1) throws DirectoryException;

    public abstract boolean isIdle();

    public boolean waitUntilIdle(long timeLimit) {
        long stopWaitingTime = timeLimit <= 0L ? Long.MAX_VALUE : System.currentTimeMillis() + timeLimit;
        while (System.currentTimeMillis() < stopWaitingTime) {
            if (this.isIdle()) {
                return true;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException ie) {}
        }
        return false;
    }
}

