/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.DefaultBehaviorException;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.EnumPropertyDefinition;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.RelationOption;
import org.opends.server.admin.Tag;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.IllegalManagedObjectNameException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.RootDNCfgClient;
import org.opends.server.admin.std.client.RootDNUserCfgClient;
import org.opends.server.admin.std.meta.RootDNUserCfgDefn;
import org.opends.server.admin.std.server.RootDNCfg;
import org.opends.server.admin.std.server.RootDNUserCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.types.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RootDNCfgDefn
extends ManagedObjectDefinition<RootDNCfgClient, RootDNCfg> {
    private static final RootDNCfgDefn INSTANCE = new RootDNCfgDefn();
    private static final EnumPropertyDefinition<DefaultRootPrivilegeName> PD_DEFAULT_ROOT_PRIVILEGE_NAME;
    private static final InstantiableRelationDefinition<RootDNUserCfgClient, RootDNUserCfg> RD_ROOT_DN_USERS;

    public static RootDNCfgDefn getInstance() {
        return INSTANCE;
    }

    private RootDNCfgDefn() {
        super("root-dn", null);
    }

    @Override
    public RootDNCfgClient createClientConfiguration(ManagedObject<? extends RootDNCfgClient> impl) {
        return new RootDNCfgClientImpl(impl);
    }

    @Override
    public RootDNCfg createServerConfiguration(ServerManagedObject<? extends RootDNCfg> impl) {
        return new RootDNCfgServerImpl(impl);
    }

    @Override
    public Class<RootDNCfg> getServerConfigurationClass() {
        return RootDNCfg.class;
    }

    public EnumPropertyDefinition<DefaultRootPrivilegeName> getDefaultRootPrivilegeNamePropertyDefinition() {
        return PD_DEFAULT_ROOT_PRIVILEGE_NAME;
    }

    public InstantiableRelationDefinition<RootDNUserCfgClient, RootDNUserCfg> getRootDNUsersRelationDefinition() {
        return RD_ROOT_DN_USERS;
    }

    static {
        Object builder = EnumPropertyDefinition.createBuilder(INSTANCE, "default-root-privilege-name");
        ((PropertyDefinition.AbstractBuilder)builder).setOption(PropertyOption.MULTI_VALUED);
        ((PropertyDefinition.AbstractBuilder)builder).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "default-root-privilege-name"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("bypass-acl", "modify-acl", "config-read", "config-write", "ldif-import", "ldif-export", "backend-backup", "backend-restore", "server-shutdown", "server-restart", "disconnect-client", "cancel-request", "password-reset", "update-schema", "privilege-change", "unindexed-search");
        ((PropertyDefinition.AbstractBuilder)builder).setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(DefaultRootPrivilegeName.class);
        PD_DEFAULT_ROOT_PRIVILEGE_NAME = (EnumPropertyDefinition)((PropertyDefinition.AbstractBuilder)builder).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DEFAULT_ROOT_PRIVILEGE_NAME);
        builder = new InstantiableRelationDefinition.Builder<RootDNUserCfgClient, RootDNUserCfg>(INSTANCE, "root-dn-user", "root-dn-users", RootDNUserCfgDefn.getInstance());
        ((RelationDefinition.AbstractBuilder)builder).setOption(RelationOption.HIDDEN);
        RD_ROOT_DN_USERS = (InstantiableRelationDefinition)((RelationDefinition.AbstractBuilder)builder).getInstance();
        INSTANCE.registerRelationDefinition(RD_ROOT_DN_USERS);
        INSTANCE.registerTag(Tag.valueOf("core"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RootDNCfgServerImpl
    implements RootDNCfg {
        private ServerManagedObject<? extends RootDNCfg> impl;

        private RootDNCfgServerImpl(ServerManagedObject<? extends RootDNCfg> impl) {
            this.impl = impl;
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<RootDNCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<RootDNCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public SortedSet<DefaultRootPrivilegeName> getDefaultRootPrivilegeName() {
            return this.impl.getPropertyValues(INSTANCE.getDefaultRootPrivilegeNamePropertyDefinition());
        }

        @Override
        public String[] listRootDNUsers() {
            return this.impl.listChildren(INSTANCE.getRootDNUsersRelationDefinition());
        }

        @Override
        public RootDNUserCfg getRootDNUser(String name) throws ConfigException {
            return this.impl.getChild(INSTANCE.getRootDNUsersRelationDefinition(), name).getConfiguration();
        }

        @Override
        public void addRootDNUserAddListener(ConfigurationAddListener<RootDNUserCfg> listener) throws ConfigException {
            this.impl.registerAddListener(INSTANCE.getRootDNUsersRelationDefinition(), listener);
        }

        @Override
        public void removeRootDNUserAddListener(ConfigurationAddListener<RootDNUserCfg> listener) {
            this.impl.deregisterAddListener(INSTANCE.getRootDNUsersRelationDefinition(), listener);
        }

        @Override
        public void addRootDNUserDeleteListener(ConfigurationDeleteListener<RootDNUserCfg> listener) throws ConfigException {
            this.impl.registerDeleteListener(INSTANCE.getRootDNUsersRelationDefinition(), listener);
        }

        @Override
        public void removeRootDNUserDeleteListener(ConfigurationDeleteListener<RootDNUserCfg> listener) {
            this.impl.deregisterDeleteListener(INSTANCE.getRootDNUsersRelationDefinition(), listener);
        }

        @Override
        public ManagedObjectDefinition<? extends RootDNCfgClient, ? extends RootDNCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RootDNCfgClientImpl
    implements RootDNCfgClient {
        private ManagedObject<? extends RootDNCfgClient> impl;

        private RootDNCfgClientImpl(ManagedObject<? extends RootDNCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public SortedSet<DefaultRootPrivilegeName> getDefaultRootPrivilegeName() {
            return this.impl.getPropertyValues(INSTANCE.getDefaultRootPrivilegeNamePropertyDefinition());
        }

        @Override
        public void setDefaultRootPrivilegeName(Collection<DefaultRootPrivilegeName> values) {
            this.impl.setPropertyValues(INSTANCE.getDefaultRootPrivilegeNamePropertyDefinition(), values);
        }

        @Override
        public String[] listRootDNUsers() throws ConcurrentModificationException, AuthorizationException, CommunicationException {
            return this.impl.listChildren(INSTANCE.getRootDNUsersRelationDefinition());
        }

        @Override
        public RootDNUserCfgClient getRootDNUser(String name) throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, AuthorizationException, CommunicationException {
            return this.impl.getChild(INSTANCE.getRootDNUsersRelationDefinition(), name).getConfiguration();
        }

        public <M extends RootDNUserCfgClient> M createRootDNUser(ManagedObjectDefinition<M, ? extends RootDNUserCfg> d, String name, Collection<DefaultBehaviorException> exceptions) throws IllegalManagedObjectNameException {
            return (M)((RootDNUserCfgClient)this.impl.createChild(INSTANCE.getRootDNUsersRelationDefinition(), d, name, exceptions).getConfiguration());
        }

        @Override
        public void removeRootDNUser(String name) throws ManagedObjectNotFoundException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.removeChild(INSTANCE.getRootDNUsersRelationDefinition(), name);
        }

        @Override
        public ManagedObjectDefinition<? extends RootDNCfgClient, ? extends RootDNCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DefaultRootPrivilegeName {
        BACKEND_BACKUP("backend-backup"),
        BACKEND_RESTORE("backend-restore"),
        BYPASS_ACL("bypass-acl"),
        CANCEL_REQUEST("cancel-request"),
        CONFIG_READ("config-read"),
        CONFIG_WRITE("config-write"),
        DATA_SYNC("data-sync"),
        DISCONNECT_CLIENT("disconnect-client"),
        JMX_NOTIFY("jmx-notify"),
        JMX_READ("jmx-read"),
        JMX_WRITE("jmx-write"),
        LDIF_EXPORT("ldif-export"),
        LDIF_IMPORT("ldif-import"),
        MODIFY_ACL("modify-acl"),
        PASSWORD_RESET("password-reset"),
        PRIVILEGE_CHANGE("privilege-change"),
        PROXIED_AUTH("proxied-auth"),
        SERVER_RESTART("server-restart"),
        SERVER_SHUTDOWN("server-shutdown"),
        UNINDEXED_SEARCH("unindexed-search"),
        UPDATE_SCHEMA("update-schema");

        private final String name;

        private DefaultRootPrivilegeName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

