/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import java.net.InetAddress;
import java.util.Collection;
import java.util.SortedSet;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.AliasDefaultBehaviorProvider;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.DNPropertyDefinition;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.EnumPropertyDefinition;
import org.opends.server.admin.IPAddressMaskPropertyDefinition;
import org.opends.server.admin.IPAddressPropertyDefinition;
import org.opends.server.admin.IntegerPropertyDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.SizePropertyDefinition;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.Tag;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.LDAPConnectionHandlerCfgClient;
import org.opends.server.admin.std.meta.ConnectionHandlerCfgDefn;
import org.opends.server.admin.std.server.ConnectionHandlerCfg;
import org.opends.server.admin.std.server.LDAPConnectionHandlerCfg;
import org.opends.server.types.AddressMask;
import org.opends.server.types.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LDAPConnectionHandlerCfgDefn
extends ManagedObjectDefinition<LDAPConnectionHandlerCfgClient, LDAPConnectionHandlerCfg> {
    private static final LDAPConnectionHandlerCfgDefn INSTANCE = new LDAPConnectionHandlerCfgDefn();
    private static final IntegerPropertyDefinition PD_ACCEPT_BACKLOG;
    private static final BooleanPropertyDefinition PD_ALLOW_LDAP_V2;
    private static final BooleanPropertyDefinition PD_ALLOW_START_TLS;
    private static final BooleanPropertyDefinition PD_ALLOW_TCP_REUSE_ADDRESS;
    private static final ClassPropertyDefinition PD_JAVA_IMPLEMENTATION_CLASS;
    private static final BooleanPropertyDefinition PD_KEEP_STATS;
    private static final DNPropertyDefinition PD_KEY_MANAGER_PROVIDER_DN;
    private static final IPAddressPropertyDefinition PD_LISTEN_ADDRESSES;
    private static final IntegerPropertyDefinition PD_LISTEN_PORT;
    private static final SizePropertyDefinition PD_MAX_REQUEST_SIZE;
    private static final IntegerPropertyDefinition PD_NUM_REQUEST_HANDLERS;
    private static final BooleanPropertyDefinition PD_SEND_REJECTION_NOTICE;
    private static final StringPropertyDefinition PD_SSL_CERT_NICKNAME;
    private static final StringPropertyDefinition PD_SSL_CIPHER_SUITES;
    private static final EnumPropertyDefinition<SSLClientAuthPolicy> PD_SSL_CLIENT_AUTH_POLICY;
    private static final StringPropertyDefinition PD_SSL_PROTOCOLS;
    private static final DNPropertyDefinition PD_TRUST_MANAGER_PROVIDER_DN;
    private static final BooleanPropertyDefinition PD_USE_SSL;
    private static final BooleanPropertyDefinition PD_USE_TCP_KEEP_ALIVE;
    private static final BooleanPropertyDefinition PD_USE_TCP_NO_DELAY;

    public static LDAPConnectionHandlerCfgDefn getInstance() {
        return INSTANCE;
    }

    private LDAPConnectionHandlerCfgDefn() {
        super("ldap-connection-handler", ConnectionHandlerCfgDefn.getInstance());
    }

    @Override
    public LDAPConnectionHandlerCfgClient createClientConfiguration(ManagedObject<? extends LDAPConnectionHandlerCfgClient> impl) {
        return new LDAPConnectionHandlerCfgClientImpl(impl);
    }

    @Override
    public LDAPConnectionHandlerCfg createServerConfiguration(ServerManagedObject<? extends LDAPConnectionHandlerCfg> impl) {
        return new LDAPConnectionHandlerCfgServerImpl(impl);
    }

    @Override
    public Class<LDAPConnectionHandlerCfg> getServerConfigurationClass() {
        return LDAPConnectionHandlerCfg.class;
    }

    public IntegerPropertyDefinition getAcceptBacklogPropertyDefinition() {
        return PD_ACCEPT_BACKLOG;
    }

    public IPAddressMaskPropertyDefinition getAllowedClientsPropertyDefinition() {
        return ConnectionHandlerCfgDefn.getInstance().getAllowedClientsPropertyDefinition();
    }

    public BooleanPropertyDefinition getAllowLDAPV2PropertyDefinition() {
        return PD_ALLOW_LDAP_V2;
    }

    public BooleanPropertyDefinition getAllowStartTLSPropertyDefinition() {
        return PD_ALLOW_START_TLS;
    }

    public BooleanPropertyDefinition getAllowTCPReuseAddressPropertyDefinition() {
        return PD_ALLOW_TCP_REUSE_ADDRESS;
    }

    public IPAddressMaskPropertyDefinition getDeniedClientsPropertyDefinition() {
        return ConnectionHandlerCfgDefn.getInstance().getDeniedClientsPropertyDefinition();
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return ConnectionHandlerCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaImplementationClassPropertyDefinition() {
        return PD_JAVA_IMPLEMENTATION_CLASS;
    }

    public BooleanPropertyDefinition getKeepStatsPropertyDefinition() {
        return PD_KEEP_STATS;
    }

    public DNPropertyDefinition getKeyManagerProviderDNPropertyDefinition() {
        return PD_KEY_MANAGER_PROVIDER_DN;
    }

    public IPAddressPropertyDefinition getListenAddressesPropertyDefinition() {
        return PD_LISTEN_ADDRESSES;
    }

    public IntegerPropertyDefinition getListenPortPropertyDefinition() {
        return PD_LISTEN_PORT;
    }

    public SizePropertyDefinition getMaxRequestSizePropertyDefinition() {
        return PD_MAX_REQUEST_SIZE;
    }

    public IntegerPropertyDefinition getNumRequestHandlersPropertyDefinition() {
        return PD_NUM_REQUEST_HANDLERS;
    }

    public BooleanPropertyDefinition getSendRejectionNoticePropertyDefinition() {
        return PD_SEND_REJECTION_NOTICE;
    }

    public StringPropertyDefinition getSSLCertNicknamePropertyDefinition() {
        return PD_SSL_CERT_NICKNAME;
    }

    public StringPropertyDefinition getSSLCipherSuitesPropertyDefinition() {
        return PD_SSL_CIPHER_SUITES;
    }

    public EnumPropertyDefinition<SSLClientAuthPolicy> getSSLClientAuthPolicyPropertyDefinition() {
        return PD_SSL_CLIENT_AUTH_POLICY;
    }

    public StringPropertyDefinition getSSLProtocolsPropertyDefinition() {
        return PD_SSL_PROTOCOLS;
    }

    public DNPropertyDefinition getTrustManagerProviderDNPropertyDefinition() {
        return PD_TRUST_MANAGER_PROVIDER_DN;
    }

    public BooleanPropertyDefinition getUseSSLPropertyDefinition() {
        return PD_USE_SSL;
    }

    public BooleanPropertyDefinition getUseTCPKeepAlivePropertyDefinition() {
        return PD_USE_TCP_KEEP_ALIVE;
    }

    public BooleanPropertyDefinition getUseTCPNoDelayPropertyDefinition() {
        return PD_USE_TCP_NO_DELAY;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "accept-backlog");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "accept-backlog"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("128");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_ACCEPT_BACKLOG = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ACCEPT_BACKLOG);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "allow-ldap-v2");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "allow-ldap-v2"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_ALLOW_LDAP_V2 = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ALLOW_LDAP_V2);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "allow-start-tls");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "allow-start-tls"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_ALLOW_START_TLS = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ALLOW_START_TLS);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "allow-tcp-reuse-address");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "allow-tcp-reuse-address"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_ALLOW_TCP_REUSE_ADDRESS = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ALLOW_TCP_REUSE_ADDRESS);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-implementation-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-implementation-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.protocols.ldap.LDAPConnectionHandler");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.ConnectionHandler");
        PD_JAVA_IMPLEMENTATION_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_IMPLEMENTATION_CLASS);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "keep-stats");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "keep-stats"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_KEEP_STATS = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_KEEP_STATS);
        builder = DNPropertyDefinition.createBuilder(INSTANCE, "key-manager-provider-dn");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "key-manager-provider-dn"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((DNPropertyDefinition.Builder)builder).setBaseDN("cn=key manager providers,cn=config");
        PD_KEY_MANAGER_PROVIDER_DN = (DNPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_KEY_MANAGER_PROVIDER_DN);
        builder = IPAddressPropertyDefinition.createBuilder(INSTANCE, "listen-addresses");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "listen-addresses"));
        provider = new DefinedDefaultBehaviorProvider("0.0.0.0");
        builder.setDefaultBehaviorProvider(provider);
        PD_LISTEN_ADDRESSES = (IPAddressPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LISTEN_ADDRESSES);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "listen-port");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "listen-port"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(65535);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_LISTEN_PORT = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LISTEN_PORT);
        builder = SizePropertyDefinition.createBuilder(INSTANCE, "max-request-size");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "max-request-size"));
        provider = new DefinedDefaultBehaviorProvider("5mib");
        builder.setDefaultBehaviorProvider(provider);
        ((SizePropertyDefinition.Builder)builder).setUpperLimit("2147483647b");
        PD_MAX_REQUEST_SIZE = (SizePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MAX_REQUEST_SIZE);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "num-request-handlers");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "num-request-handlers"));
        provider = new DefinedDefaultBehaviorProvider("1");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_NUM_REQUEST_HANDLERS = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_NUM_REQUEST_HANDLERS);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "send-rejection-notice");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "send-rejection-notice"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_SEND_REJECTION_NOTICE = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SEND_REJECTION_NOTICE);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "ssl-cert-nickname");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "ssl-cert-nickname"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "ssl-cert-nickname"));
        PD_SSL_CERT_NICKNAME = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SSL_CERT_NICKNAME);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "ssl-cipher-suites");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "ssl-cipher-suites"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "ssl-cipher-suites"));
        PD_SSL_CIPHER_SUITES = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SSL_CIPHER_SUITES);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "ssl-client-auth-policy");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "ssl-client-auth-policy"));
        provider = new DefinedDefaultBehaviorProvider("optional");
        builder.setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(SSLClientAuthPolicy.class);
        PD_SSL_CLIENT_AUTH_POLICY = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SSL_CLIENT_AUTH_POLICY);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "ssl-protocols");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "ssl-protocols"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "ssl-protocols"));
        PD_SSL_PROTOCOLS = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SSL_PROTOCOLS);
        builder = DNPropertyDefinition.createBuilder(INSTANCE, "trust-manager-provider-dn");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "trust-manager-provider-dn"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((DNPropertyDefinition.Builder)builder).setBaseDN("cn=trust manager providers,cn=config");
        PD_TRUST_MANAGER_PROVIDER_DN = (DNPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_TRUST_MANAGER_PROVIDER_DN);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "use-ssl");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "use-ssl"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_USE_SSL = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_USE_SSL);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "use-tcp-keep-alive");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "use-tcp-keep-alive"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_USE_TCP_KEEP_ALIVE = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_USE_TCP_KEEP_ALIVE);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "use-tcp-no-delay");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "use-tcp-no-delay"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_USE_TCP_NO_DELAY = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_USE_TCP_NO_DELAY);
        INSTANCE.registerTag(Tag.valueOf("core"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LDAPConnectionHandlerCfgServerImpl
    implements LDAPConnectionHandlerCfg {
        private ServerManagedObject<? extends LDAPConnectionHandlerCfg> impl;

        private LDAPConnectionHandlerCfgServerImpl(ServerManagedObject<? extends LDAPConnectionHandlerCfg> impl) {
            this.impl = impl;
        }

        @Override
        public void addLDAPChangeListener(ConfigurationChangeListener<LDAPConnectionHandlerCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeLDAPChangeListener(ConfigurationChangeListener<LDAPConnectionHandlerCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<ConnectionHandlerCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<ConnectionHandlerCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public int getAcceptBacklog() {
            return this.impl.getPropertyValue(INSTANCE.getAcceptBacklogPropertyDefinition());
        }

        @Override
        public SortedSet<AddressMask> getAllowedClients() {
            return this.impl.getPropertyValues((PropertyDefinition)INSTANCE.getAllowedClientsPropertyDefinition());
        }

        @Override
        public boolean isAllowLDAPV2() {
            return this.impl.getPropertyValue(INSTANCE.getAllowLDAPV2PropertyDefinition());
        }

        @Override
        public boolean isAllowStartTLS() {
            return this.impl.getPropertyValue(INSTANCE.getAllowStartTLSPropertyDefinition());
        }

        @Override
        public boolean isAllowTCPReuseAddress() {
            return this.impl.getPropertyValue(INSTANCE.getAllowTCPReuseAddressPropertyDefinition());
        }

        @Override
        public SortedSet<AddressMask> getDeniedClients() {
            return this.impl.getPropertyValues((PropertyDefinition)INSTANCE.getDeniedClientsPropertyDefinition());
        }

        @Override
        public boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public String getJavaImplementationClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaImplementationClassPropertyDefinition());
        }

        @Override
        public boolean isKeepStats() {
            return this.impl.getPropertyValue(INSTANCE.getKeepStatsPropertyDefinition());
        }

        @Override
        public DN getKeyManagerProviderDN() {
            return this.impl.getPropertyValue(INSTANCE.getKeyManagerProviderDNPropertyDefinition());
        }

        @Override
        public SortedSet<InetAddress> getListenAddresses() {
            return this.impl.getPropertyValues((PropertyDefinition)INSTANCE.getListenAddressesPropertyDefinition());
        }

        @Override
        public int getListenPort() {
            return this.impl.getPropertyValue(INSTANCE.getListenPortPropertyDefinition());
        }

        @Override
        public long getMaxRequestSize() {
            return this.impl.getPropertyValue(INSTANCE.getMaxRequestSizePropertyDefinition());
        }

        @Override
        public int getNumRequestHandlers() {
            return this.impl.getPropertyValue(INSTANCE.getNumRequestHandlersPropertyDefinition());
        }

        @Override
        public boolean isSendRejectionNotice() {
            return this.impl.getPropertyValue(INSTANCE.getSendRejectionNoticePropertyDefinition());
        }

        @Override
        public String getSSLCertNickname() {
            return this.impl.getPropertyValue(INSTANCE.getSSLCertNicknamePropertyDefinition());
        }

        @Override
        public SortedSet<String> getSSLCipherSuites() {
            return this.impl.getPropertyValues((PropertyDefinition)INSTANCE.getSSLCipherSuitesPropertyDefinition());
        }

        @Override
        public SSLClientAuthPolicy getSSLClientAuthPolicy() {
            return this.impl.getPropertyValue(INSTANCE.getSSLClientAuthPolicyPropertyDefinition());
        }

        @Override
        public SortedSet<String> getSSLProtocols() {
            return this.impl.getPropertyValues((PropertyDefinition)INSTANCE.getSSLProtocolsPropertyDefinition());
        }

        @Override
        public DN getTrustManagerProviderDN() {
            return this.impl.getPropertyValue(INSTANCE.getTrustManagerProviderDNPropertyDefinition());
        }

        @Override
        public boolean isUseSSL() {
            return this.impl.getPropertyValue(INSTANCE.getUseSSLPropertyDefinition());
        }

        @Override
        public boolean isUseTCPKeepAlive() {
            return this.impl.getPropertyValue(INSTANCE.getUseTCPKeepAlivePropertyDefinition());
        }

        @Override
        public boolean isUseTCPNoDelay() {
            return this.impl.getPropertyValue(INSTANCE.getUseTCPNoDelayPropertyDefinition());
        }

        @Override
        public ManagedObjectDefinition<? extends LDAPConnectionHandlerCfgClient, ? extends LDAPConnectionHandlerCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LDAPConnectionHandlerCfgClientImpl
    implements LDAPConnectionHandlerCfgClient {
        private ManagedObject<? extends LDAPConnectionHandlerCfgClient> impl;

        private LDAPConnectionHandlerCfgClientImpl(ManagedObject<? extends LDAPConnectionHandlerCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public int getAcceptBacklog() {
            return this.impl.getPropertyValue(INSTANCE.getAcceptBacklogPropertyDefinition());
        }

        @Override
        public void setAcceptBacklog(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getAcceptBacklogPropertyDefinition(), value);
        }

        @Override
        public SortedSet<AddressMask> getAllowedClients() {
            return this.impl.getPropertyValues(INSTANCE.getAllowedClientsPropertyDefinition());
        }

        @Override
        public void setAllowedClients(Collection<AddressMask> values) {
            this.impl.setPropertyValues(INSTANCE.getAllowedClientsPropertyDefinition(), values);
        }

        @Override
        public boolean isAllowLDAPV2() {
            return this.impl.getPropertyValue(INSTANCE.getAllowLDAPV2PropertyDefinition());
        }

        @Override
        public void setAllowLDAPV2(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getAllowLDAPV2PropertyDefinition(), value);
        }

        @Override
        public boolean isAllowStartTLS() {
            return this.impl.getPropertyValue(INSTANCE.getAllowStartTLSPropertyDefinition());
        }

        @Override
        public void setAllowStartTLS(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getAllowStartTLSPropertyDefinition(), value);
        }

        @Override
        public boolean isAllowTCPReuseAddress() {
            return this.impl.getPropertyValue(INSTANCE.getAllowTCPReuseAddressPropertyDefinition());
        }

        @Override
        public void setAllowTCPReuseAddress(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getAllowTCPReuseAddressPropertyDefinition(), value);
        }

        @Override
        public SortedSet<AddressMask> getDeniedClients() {
            return this.impl.getPropertyValues(INSTANCE.getDeniedClientsPropertyDefinition());
        }

        @Override
        public void setDeniedClients(Collection<AddressMask> values) {
            this.impl.setPropertyValues(INSTANCE.getDeniedClientsPropertyDefinition(), values);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaImplementationClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaImplementationClassPropertyDefinition());
        }

        @Override
        public void setJavaImplementationClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaImplementationClassPropertyDefinition(), value);
        }

        @Override
        public boolean isKeepStats() {
            return this.impl.getPropertyValue(INSTANCE.getKeepStatsPropertyDefinition());
        }

        @Override
        public void setKeepStats(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getKeepStatsPropertyDefinition(), value);
        }

        @Override
        public DN getKeyManagerProviderDN() {
            return this.impl.getPropertyValue(INSTANCE.getKeyManagerProviderDNPropertyDefinition());
        }

        @Override
        public void setKeyManagerProviderDN(DN value) {
            this.impl.setPropertyValue(INSTANCE.getKeyManagerProviderDNPropertyDefinition(), value);
        }

        @Override
        public SortedSet<InetAddress> getListenAddresses() {
            return this.impl.getPropertyValues(INSTANCE.getListenAddressesPropertyDefinition());
        }

        @Override
        public void setListenAddresses(Collection<InetAddress> values) {
            this.impl.setPropertyValues(INSTANCE.getListenAddressesPropertyDefinition(), values);
        }

        @Override
        public Integer getListenPort() {
            return this.impl.getPropertyValue(INSTANCE.getListenPortPropertyDefinition());
        }

        @Override
        public void setListenPort(int value) {
            this.impl.setPropertyValue(INSTANCE.getListenPortPropertyDefinition(), value);
        }

        @Override
        public long getMaxRequestSize() {
            return this.impl.getPropertyValue(INSTANCE.getMaxRequestSizePropertyDefinition());
        }

        @Override
        public void setMaxRequestSize(Long value) {
            this.impl.setPropertyValue(INSTANCE.getMaxRequestSizePropertyDefinition(), value);
        }

        @Override
        public int getNumRequestHandlers() {
            return this.impl.getPropertyValue(INSTANCE.getNumRequestHandlersPropertyDefinition());
        }

        @Override
        public void setNumRequestHandlers(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getNumRequestHandlersPropertyDefinition(), value);
        }

        @Override
        public boolean isSendRejectionNotice() {
            return this.impl.getPropertyValue(INSTANCE.getSendRejectionNoticePropertyDefinition());
        }

        @Override
        public void setSendRejectionNotice(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getSendRejectionNoticePropertyDefinition(), value);
        }

        @Override
        public String getSSLCertNickname() {
            return this.impl.getPropertyValue(INSTANCE.getSSLCertNicknamePropertyDefinition());
        }

        @Override
        public void setSSLCertNickname(String value) {
            this.impl.setPropertyValue(INSTANCE.getSSLCertNicknamePropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getSSLCipherSuites() {
            return this.impl.getPropertyValues(INSTANCE.getSSLCipherSuitesPropertyDefinition());
        }

        @Override
        public void setSSLCipherSuites(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getSSLCipherSuitesPropertyDefinition(), values);
        }

        @Override
        public SSLClientAuthPolicy getSSLClientAuthPolicy() {
            return this.impl.getPropertyValue(INSTANCE.getSSLClientAuthPolicyPropertyDefinition());
        }

        @Override
        public void setSSLClientAuthPolicy(SSLClientAuthPolicy value) {
            this.impl.setPropertyValue(INSTANCE.getSSLClientAuthPolicyPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getSSLProtocols() {
            return this.impl.getPropertyValues(INSTANCE.getSSLProtocolsPropertyDefinition());
        }

        @Override
        public void setSSLProtocols(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getSSLProtocolsPropertyDefinition(), values);
        }

        @Override
        public DN getTrustManagerProviderDN() {
            return this.impl.getPropertyValue(INSTANCE.getTrustManagerProviderDNPropertyDefinition());
        }

        @Override
        public void setTrustManagerProviderDN(DN value) {
            this.impl.setPropertyValue(INSTANCE.getTrustManagerProviderDNPropertyDefinition(), value);
        }

        @Override
        public boolean isUseSSL() {
            return this.impl.getPropertyValue(INSTANCE.getUseSSLPropertyDefinition());
        }

        @Override
        public void setUseSSL(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getUseSSLPropertyDefinition(), value);
        }

        @Override
        public boolean isUseTCPKeepAlive() {
            return this.impl.getPropertyValue(INSTANCE.getUseTCPKeepAlivePropertyDefinition());
        }

        @Override
        public void setUseTCPKeepAlive(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getUseTCPKeepAlivePropertyDefinition(), value);
        }

        @Override
        public boolean isUseTCPNoDelay() {
            return this.impl.getPropertyValue(INSTANCE.getUseTCPNoDelayPropertyDefinition());
        }

        @Override
        public void setUseTCPNoDelay(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getUseTCPNoDelayPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends LDAPConnectionHandlerCfgClient, ? extends LDAPConnectionHandlerCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SSLClientAuthPolicy {
        DISABLED("disabled"),
        OPTIONAL("optional"),
        REQUIRED("required");

        private final String name;

        private SSLClientAuthPolicy(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

