/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.server;

import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.LDAPProfile;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.ManagedObjectPathSerializer;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.SingletonRelationDefinition;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.RDN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DNBuilder
implements ManagedObjectPathSerializer {
    private DN dn = DN.nullDN();
    private final LDAPProfile profile = LDAPProfile.getInstance();

    public static DN create(ManagedObjectPath<?, ?> path) {
        DNBuilder builder = new DNBuilder();
        path.serialize(builder);
        return builder.getInstance();
    }

    public static DN create(ManagedObjectPath<?, ?> path, RelationDefinition<?, ?> relation) {
        DNBuilder builder = new DNBuilder();
        path.serialize(builder);
        builder.appendManagedObjectPathElement(relation);
        return builder.getInstance();
    }

    @Override
    public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(InstantiableRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d, String name) {
        this.appendManagedObjectPathElement(r);
        String type = this.profile.getInstantiableRelationChildRDNType(r);
        AttributeType atype = DirectoryServer.getAttributeType(type.toLowerCase(), true);
        AttributeValue avalue = new AttributeValue(atype, name);
        this.dn = this.dn.concat(RDN.create(atype, avalue));
    }

    public void appendManagedObjectPathElement(RelationDefinition<?, ?> r) {
        try {
            DN localName = DN.decode(this.profile.getRelationRDNSequence(r));
            this.dn = this.dn.concat(localName);
        }
        catch (DirectoryException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(OptionalRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
        this.appendManagedObjectPathElement(r);
    }

    @Override
    public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(SingletonRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
        this.appendManagedObjectPathElement(r);
    }

    public DN getInstance() {
        return this.dn;
    }
}

