/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.server;

import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.server.ServerManagedObjectDecodingException;
import org.opends.server.config.ConfigException;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DN;
import org.opends.server.util.StaticUtils;

final class ConfigExceptionFactory {
    private static final ConfigExceptionFactory INSTANCE = new ConfigExceptionFactory();

    private ConfigExceptionFactory() {
    }

    public static ConfigExceptionFactory getInstance() {
        return INSTANCE;
    }

    public ConfigException createDecodingExceptionAdaptor(DN dn, DefinitionDecodingException e) {
        int msgID = 13893637;
        String message = MessageHandler.getMessage(msgID, String.valueOf(dn), StaticUtils.stackTraceToSingleLineString(e));
        return new ConfigException(msgID, message, e);
    }

    public ConfigException createDecodingExceptionAdaptor(ServerManagedObjectDecodingException e) {
        int msgID = 13893637;
        DN dn = e.getPartialManagedObject().getDN();
        String message = MessageHandler.getMessage(msgID, String.valueOf(dn), StaticUtils.stackTraceToSingleLineString(e));
        return new ConfigException(msgID, message, e);
    }

    public ConfigException createClassLoadingExceptionAdaptor(DN dn, String className, Exception e) {
        int msgID = 13893638;
        String message = MessageHandler.getMessage(msgID, String.valueOf(className), String.valueOf(dn), StaticUtils.stackTraceToSingleLineString(e));
        return new ConfigException(msgID, message, e);
    }
}

