/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client.cli;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.ADSContextException;
import org.opends.server.admin.client.cli.DsFrameworkCliParser;
import org.opends.server.admin.client.cli.DsFrameworkCliReturnCode;
import org.opends.server.admin.client.cli.DsFrameworkCliServerGroup;
import org.opends.server.admin.client.cli.DsFrameworkCliSubCommandGroup;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.ToolConstants;
import org.opends.server.tools.dsconfig.ArgumentExceptionFactory;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommand;
import org.opends.server.util.args.SubCommandArgumentParser;
import org.opends.server.util.table.TableBuilder;
import org.opends.server.util.table.TextTablePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DsFrameworkCliServer
implements DsFrameworkCliSubCommandGroup {
    private static final String DESCRIPTION_OPTIONS_TITLE = MessageHandler.getMessage(10487031);
    private static final String DESCRIPTION_OPTIONS_READ = MessageHandler.getMessage(10487032);
    private static final String DESCRIPTION_OPTIONS_WRITE = MessageHandler.getMessage(10487033);
    private static final String DESCRIPTION_OPTIONS_MANDATORY = MessageHandler.getMessage(10487034);
    private static final String DESCRIPTION_OPTIONS_SINGLE = MessageHandler.getMessage(10487035);
    private DsFrameworkCliParser argParser;
    private BooleanArgument verboseArg;
    private SubCommand registerServerSubCmd;
    private StringArgument registerServerServerIdArg;
    private StringArgument registerServerSetArg;
    private SubCommand unregisterServerSubCmd;
    private StringArgument unregisterServerServerIDArg;
    private SubCommand listServerPropertiesSubCmd;
    private SubCommand listServersSubCmd;
    private SubCommand getServerPropertiesSubCmd;
    private StringArgument getServerPropertiesServerIdArg;
    private SubCommand setServerPropertiesSubCmd;
    private StringArgument setServerPropertiesServerIdArg;
    private StringArgument setServerPropertiesSetArg;
    private HashMap<ADSContext.ServerProperty, Argument> serverProperties;
    private HashSet<ADSContext.ServerProperty> readonlyServerProperties;
    private HashSet<SubCommand> subCommands = new HashSet();
    private boolean isHidden;
    private String groupName;

    @Override
    public Set<SubCommand> getSubCommands() {
        return this.subCommands;
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public void initializeCliGroup(DsFrameworkCliParser argParser, BooleanArgument verboseArg) throws ArgumentException {
        this.verboseArg = verboseArg;
        this.isHidden = false;
        this.groupName = "server";
        this.argParser = argParser;
        this.listServerPropertiesSubCmd = new SubCommand((SubCommandArgumentParser)argParser, SubCommandNameEnum.LIST_SERVER_PROPERTIES.toString(), 0xD0003D, new Object[0]);
        this.subCommands.add(this.listServerPropertiesSubCmd);
        this.registerServerSubCmd = new SubCommand((SubCommandArgumentParser)argParser, SubCommandNameEnum.REGISTER_SERVER.toString(), 13631546, new Object[0]);
        this.subCommands.add(this.registerServerSubCmd);
        this.registerServerServerIdArg = new StringArgument("serverID", null, "serverID", false, true, "{serverID}", 13631553, new Object[0]);
        this.registerServerSubCmd.addArgument(this.registerServerServerIdArg);
        this.registerServerSetArg = new StringArgument("set", ToolConstants.OPTION_SHORT_SET, "set", false, true, true, "{PROP:VAL}", null, null, 0xA00440, new Object[0]);
        this.registerServerSubCmd.addArgument(this.registerServerSetArg);
        this.unregisterServerSubCmd = new SubCommand((SubCommandArgumentParser)argParser, SubCommandNameEnum.UNREGISTER_SERVER.toString(), 13631547, new Object[0]);
        this.subCommands.add(this.unregisterServerSubCmd);
        this.unregisterServerServerIDArg = new StringArgument("serverID", null, "serverID", false, true, "{serverID}", 13631553, new Object[0]);
        this.unregisterServerSubCmd.addArgument(this.unregisterServerServerIDArg);
        this.listServersSubCmd = new SubCommand((SubCommandArgumentParser)argParser, SubCommandNameEnum.LIST_SERVERS.toString(), 13631550, new Object[0]);
        this.subCommands.add(this.listServersSubCmd);
        this.getServerPropertiesSubCmd = new SubCommand((SubCommandArgumentParser)argParser, SubCommandNameEnum.GET_SERVER_PROPERTIES.toString(), 13631551, new Object[0]);
        this.subCommands.add(this.getServerPropertiesSubCmd);
        this.getServerPropertiesServerIdArg = new StringArgument("serverID", null, "serverID", false, true, "{serverID}", 13631553, new Object[0]);
        this.getServerPropertiesServerIdArg.setMultiValued(true);
        this.getServerPropertiesSubCmd.addArgument(this.getServerPropertiesServerIdArg);
        this.setServerPropertiesSubCmd = new SubCommand((SubCommandArgumentParser)argParser, SubCommandNameEnum.SET_SERVER_PROPERTIES.toString(), 0xD00040, new Object[0]);
        this.subCommands.add(this.setServerPropertiesSubCmd);
        this.setServerPropertiesServerIdArg = new StringArgument("serverID", null, "serverID", true, true, "{serverID}", 13631553, new Object[0]);
        this.setServerPropertiesSubCmd.addArgument(this.setServerPropertiesServerIdArg);
        this.setServerPropertiesSetArg = new StringArgument("set", ToolConstants.OPTION_SHORT_SET, "set", false, true, true, "{PROP:VAL}", null, null, 0xA00440, new Object[0]);
        this.setServerPropertiesSubCmd.addArgument(this.setServerPropertiesSetArg);
        this.serverProperties = new HashMap();
        this.readonlyServerProperties = new HashSet();
        ADSContext.ServerProperty prop = ADSContext.ServerProperty.ID;
        String attName = prop.getAttributeName();
        Argument arg = new StringArgument(attName, null, prop.getAttributeName(), false, false, true, "", null, null, -1, new Object[0]);
        this.serverProperties.put(prop, arg);
        prop = ADSContext.ServerProperty.HOST_NAME;
        attName = prop.getAttributeName();
        this.readonlyServerProperties.add(prop);
        arg = new StringArgument(attName, null, attName, true, false, true, "", "localhost", null, -1, new Object[0]);
        this.serverProperties.put(prop, arg);
        prop = ADSContext.ServerProperty.LDAP_PORT;
        attName = prop.getAttributeName();
        arg = new IntegerArgument(attName, null, attName, true, true, true, attName, 389, null, -1, new Object[0]);
        this.serverProperties.put(prop, arg);
        prop = ADSContext.ServerProperty.JMX_PORT;
        attName = prop.getAttributeName();
        arg = new IntegerArgument(attName, null, attName, false, true, attName, -1, new Object[0]);
        arg.setMultiValued(true);
        this.serverProperties.put(prop, arg);
        prop = ADSContext.ServerProperty.JMXS_PORT;
        attName = prop.getAttributeName();
        arg = new IntegerArgument(attName, null, attName, false, true, attName, -1, new Object[0]);
        arg.setMultiValued(true);
        this.serverProperties.put(prop, arg);
        prop = ADSContext.ServerProperty.LDAPS_PORT;
        attName = prop.getAttributeName();
        arg = new IntegerArgument(attName, null, attName, false, true, attName, -1, new Object[0]);
        arg.setMultiValued(true);
        this.serverProperties.put(prop, arg);
        prop = ADSContext.ServerProperty.CERTIFICATE;
        attName = prop.getAttributeName();
        arg = new StringArgument(attName, null, attName, false, false, true, attName, null, null, -1, new Object[0]);
        this.serverProperties.put(prop, arg);
        prop = ADSContext.ServerProperty.INSTANCE_PATH;
        attName = prop.getAttributeName();
        arg = new StringArgument(attName, null, attName, false, false, true, attName, null, null, -1, new Object[0]);
        this.serverProperties.put(prop, arg);
        prop = ADSContext.ServerProperty.DESCRIPTION;
        attName = prop.getAttributeName();
        arg = new StringArgument(attName, null, attName, false, false, true, attName, null, null, -1, new Object[0]);
        this.serverProperties.put(prop, arg);
        prop = ADSContext.ServerProperty.HOST_OS;
        attName = prop.getAttributeName();
        arg = new StringArgument(attName, null, attName, false, false, true, attName, null, null, -1, new Object[0]);
        this.serverProperties.put(prop, arg);
        prop = ADSContext.ServerProperty.LDAP_ENABLED;
        attName = prop.getAttributeName();
        arg = new BooleanArgument(attName, null, attName, -1, new Object[0]);
        arg.setDefaultValue("false");
        this.serverProperties.put(prop, arg);
        prop = ADSContext.ServerProperty.LDAPS_ENABLED;
        attName = prop.getAttributeName();
        arg = new BooleanArgument(attName, null, attName, -1, new Object[0]);
        arg.setDefaultValue("false");
        this.serverProperties.put(prop, arg);
        prop = ADSContext.ServerProperty.STARTTLS_ENABLED;
        attName = prop.getAttributeName();
        arg = new BooleanArgument(attName, null, attName, -1, new Object[0]);
        arg.setDefaultValue("false");
        this.serverProperties.put(prop, arg);
        prop = ADSContext.ServerProperty.JMX_ENABLED;
        attName = prop.getAttributeName();
        arg = new BooleanArgument(attName, null, attName, -1, new Object[0]);
        arg.setDefaultValue("false");
        this.serverProperties.put(prop, arg);
        prop = ADSContext.ServerProperty.JMXS_ENABLED;
        attName = prop.getAttributeName();
        arg = new BooleanArgument(attName, null, attName, -1, new Object[0]);
        arg.setDefaultValue("false");
        this.serverProperties.put(prop, arg);
        prop = ADSContext.ServerProperty.LOCATION;
        attName = prop.getAttributeName();
        arg = new StringArgument(attName, null, attName, false, false, true, attName, null, null, -1, new Object[0]);
        this.serverProperties.put(prop, arg);
        prop = ADSContext.ServerProperty.GROUPS;
        attName = prop.getAttributeName();
        arg = new StringArgument(attName, null, attName, false, true, true, attName, null, null, -1, new Object[0]);
        arg.setHidden(true);
        this.serverProperties.put(prop, arg);
    }

    @Override
    public boolean isSubCommand(SubCommand subCmd) {
        return SubCommandNameEnum.isSubCommand(subCmd.getName());
    }

    @Override
    public DsFrameworkCliReturnCode performSubCommand(SubCommand subCmd, OutputStream outStream, OutputStream errStream) throws ADSContextException, ArgumentException {
        ADSContext adsCtx = null;
        InitialContext ctx = null;
        DsFrameworkCliReturnCode returnCode = DsFrameworkCliReturnCode.ERROR_UNEXPECTED;
        try {
            if (subCmd.getName().equals(this.registerServerSubCmd.getName())) {
                Map<ADSContext.ServerProperty, Object> map = this.mapSetOptionsToMap(this.registerServerSetArg);
                String serverId = this.registerServerServerIdArg.isPresent() ? this.registerServerServerIdArg.getValue() : ADSContext.getServerIdFromServerProperties(map);
                map.put(ADSContext.ServerProperty.ID, serverId);
                ctx = this.argParser.getContext(outStream, errStream);
                if (ctx == null) {
                    return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                }
                adsCtx = new ADSContext((InitialLdapContext)ctx);
                adsCtx.registerServer(map);
                returnCode = DsFrameworkCliServerGroup.addServerTogroup(adsCtx, "all-servers", map);
            } else if (subCmd.getName().equals(this.unregisterServerSubCmd.getName())) {
                returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
                HashMap<ADSContext.ServerProperty, String> map = new HashMap<ADSContext.ServerProperty, String>();
                String serverId = null;
                serverId = this.unregisterServerServerIDArg.isPresent() ? this.unregisterServerServerIDArg.getValue() : ADSContext.getServerIdFromServerProperties(map);
                map.put(ADSContext.ServerProperty.ID, serverId);
                ctx = this.argParser.getContext(outStream, errStream);
                if (ctx == null) {
                    return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                }
                adsCtx = new ADSContext((InitialLdapContext)ctx);
                Set serverList = adsCtx.readServerRegistry();
                boolean found = false;
                Map serverProperties = null;
                for (Map elm : serverList) {
                    if (!serverId.equals(elm.get(ADSContext.ServerProperty.ID))) continue;
                    found = true;
                    serverProperties = elm;
                    break;
                }
                if (!found) {
                    throw new ADSContextException(ADSContextException.ErrorType.NOT_YET_REGISTERED);
                }
                Set groupList = (Set)serverProperties.get(ADSContext.ServerProperty.GROUPS);
                for (Object groupId : groupList.toArray()) {
                    DsFrameworkCliServerGroup.removeServerFromGroup(adsCtx, (String)groupId, serverId);
                }
                adsCtx.unregisterServer(map);
            } else if (subCmd.getName().equals(this.listServersSubCmd.getName())) {
                ctx = this.argParser.getContext(outStream, errStream);
                if (ctx == null) {
                    return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                }
                adsCtx = new ADSContext((InitialLdapContext)ctx);
                Set serverList = adsCtx.readServerRegistry();
                PrintStream out = new PrintStream(outStream);
                for (Map server : serverList) {
                    out.println(ADSContext.ServerProperty.ID.getAttributeName() + ": " + server.get(ADSContext.ServerProperty.ID));
                }
                returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
            } else if (subCmd.getName().equals(this.getServerPropertiesSubCmd.getName())) {
                ctx = this.argParser.getContext(outStream, errStream);
                if (ctx == null) {
                    return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                }
                adsCtx = new ADSContext((InitialLdapContext)ctx);
                Set adsServerList = adsCtx.readServerRegistry();
                LinkedList<String> userServerList = this.getServerPropertiesServerIdArg.getValues();
                PrintStream out = new PrintStream(outStream);
                for (Map server : adsServerList) {
                    String serverID = (String)server.get(ADSContext.ServerProperty.ID);
                    if (!userServerList.contains(serverID)) continue;
                    out.println(ADSContext.ServerProperty.ID.getAttributeName() + ": " + server.get(ADSContext.ServerProperty.ID));
                    for (ADSContext.ServerProperty sp : server.keySet()) {
                        if (sp.equals((Object)ADSContext.ServerProperty.ID)) continue;
                        out.println(sp.getAttributeName() + ": " + server.get(sp));
                    }
                    out.println();
                }
                returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
            } else if (subCmd.getName().equals(this.setServerPropertiesSubCmd.getName())) {
                Map<ADSContext.ServerProperty, Object> map = this.mapSetOptionsToMap(this.setServerPropertiesSetArg);
                String newServerId = (String)map.get(ADSContext.ServerProperty.ID);
                map.put(ADSContext.ServerProperty.ID, this.setServerPropertiesServerIdArg.getValue());
                ctx = this.argParser.getContext(outStream, errStream);
                if (ctx == null) {
                    return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                }
                adsCtx = new ADSContext((InitialLdapContext)ctx);
                adsCtx.updateServer(map, newServerId);
                returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
            } else if (subCmd.getName().equals(this.listServerPropertiesSubCmd.getName())) {
                PrintStream out = new PrintStream(outStream);
                out.println(DESCRIPTION_OPTIONS_TITLE);
                out.println();
                out.print(" r -- ");
                out.println(DESCRIPTION_OPTIONS_READ);
                out.print(" w -- ");
                out.println(DESCRIPTION_OPTIONS_WRITE);
                out.print(" m -- ");
                out.println(DESCRIPTION_OPTIONS_MANDATORY);
                out.print(" s -- ");
                out.println(DESCRIPTION_OPTIONS_SINGLE);
                out.println();
                TableBuilder table = new TableBuilder();
                table.appendHeading(MessageHandler.getMessage(10486779));
                table.appendHeading(MessageHandler.getMessage(10486782));
                table.appendHeading(MessageHandler.getMessage(10486781));
                table.appendHeading(MessageHandler.getMessage(10486975));
                for (ADSContext.ServerProperty serverProp : this.serverProperties.keySet()) {
                    if (this.serverProperties.get(serverProp).isHidden()) continue;
                    table.startRow();
                    table.appendCell(serverProp.getAttributeName());
                    table.appendCell(this.getPropertyOptionSummary(this.serverProperties.get(serverProp)));
                    table.appendCell(serverProp.getAttributeSyntax());
                    if (this.serverProperties.get(serverProp).getDefaultValue() != null) {
                        table.appendCell(this.serverProperties.get(serverProp).getDefaultValue());
                        continue;
                    }
                    table.appendCell("-");
                }
                TextTablePrinter printer = new TextTablePrinter(outStream);
                table.print(printer);
                returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
            } else {
                returnCode = DsFrameworkCliReturnCode.ERROR_UNEXPECTED;
            }
        }
        catch (ADSContextException e) {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException x) {
                    // empty catch block
                }
            }
            throw e;
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (NamingException x) {
                // empty catch block
            }
        }
        return returnCode;
    }

    private String getPropertyOptionSummary(Argument arg) {
        StringBuilder b = new StringBuilder();
        if (this.readonlyServerProperties.contains(ADSContext.getServerPropFromName((String)arg.getName()))) {
            b.append("r-");
        } else {
            b.append("rw");
        }
        if (arg.isRequired()) {
            b.append('m');
        } else {
            b.append('-');
        }
        if (arg.isMultiValued()) {
            b.append('-');
        } else {
            b.append('s');
        }
        return b.toString();
    }

    private Map<ADSContext.ServerProperty, Object> mapSetOptionsToMap(StringArgument propertySetArgument) throws ArgumentException {
        HashMap<ADSContext.ServerProperty, Object> map = new HashMap<ADSContext.ServerProperty, Object>();
        for (String m : propertySetArgument.getValues()) {
            String message;
            int sep = m.indexOf(58);
            if (sep < 0) {
                throw ArgumentExceptionFactory.missingSeparatorInPropertyArgument(m);
            }
            if (sep == 0) {
                throw ArgumentExceptionFactory.missingNameInPropertyArgument(m);
            }
            String propertyName = m.substring(0, sep);
            String value = m.substring(sep + 1, m.length());
            if (value.length() == 0) {
                throw ArgumentExceptionFactory.missingValueInPropertyArgument(m);
            }
            ADSContext.ServerProperty serverProperty = ADSContext.getServerPropFromName((String)propertyName);
            if (serverProperty == null) {
                int msgID = 10749116;
                message = MessageHandler.getMessage(msgID, propertyName);
                throw new ArgumentException(msgID, message);
            }
            if (this.serverProperties.get(serverProperty).isHidden()) {
                int msgID = 10749116;
                message = MessageHandler.getMessage(msgID, propertyName);
                throw new ArgumentException(msgID, message);
            }
            StringBuilder invalidReason = new StringBuilder();
            Argument arg = this.serverProperties.get(serverProperty);
            if (!arg.valueIsAcceptable(value, invalidReason)) {
                int msgID = 10749118;
                String message2 = MessageHandler.getMessage(msgID, propertyName, value);
                throw new ArgumentException(msgID, message2);
            }
            this.serverProperties.get(serverProperty).addValue(value);
            map.put(serverProperty, value);
        }
        for (ADSContext.ServerProperty s : ADSContext.ServerProperty.values()) {
            Argument arg = this.serverProperties.get(s);
            if (arg.isHidden() || map.containsKey(s) || !arg.isRequired()) continue;
            if (arg.getDefaultValue() == null) {
                int msgID = 10749117;
                String message = MessageHandler.getMessage(msgID, s.getAttributeName());
                throw new ArgumentException(msgID, message);
            }
            map.put(s, arg.getDefaultValue());
        }
        return map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SubCommandNameEnum {
        REGISTER_SERVER("register-server"),
        UNREGISTER_SERVER("unregister-server"),
        LIST_SERVERS("list-servers"),
        GET_SERVER_PROPERTIES("get-server-properties"),
        SET_SERVER_PROPERTIES("set-server-properties"),
        LIST_SERVER_PROPERTIES("list-server-properties");

        private final String name;
        private static final List<String> nameToSubCmdName;

        private SubCommandNameEnum(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static boolean isSubCommand(String name) {
            return nameToSubCmdName.contains(name);
        }

        static {
            nameToSubCmdName = new ArrayList<String>();
            for (SubCommandNameEnum subCmd : SubCommandNameEnum.values()) {
                nameToSubCmdName.add(subCmd.toString());
            }
        }
    }
}

