/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client.cli;

import java.util.HashMap;
import org.opends.admin.ads.ADSContextException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DsFrameworkCliReturnCode {
    SUCCESSFUL(0, 13631538),
    SUCCESSFUL_NOP(SUCCESSFUL.getReturnCode(), 0xD00033),
    CANNOT_INITIALIZE_ARGS(1, 13893684),
    ERROR_PARSING_ARGS(2, 13893684),
    CANNOT_CONNECT_TO_ADS(3, 13893684),
    MISSING_HOSTNAME(4, 13959203),
    NOVALID_HOSTNAME(5, 13959204),
    MISSING_IPATH(6, 13959205),
    NOVALID_IPATH(7, 13959206),
    ACCESS_PERMISSION(8, 13959207),
    ALREADY_REGISTERED(9, 13959208),
    BROKEN_INSTALL(10, 13959209),
    NOT_YET_REGISTERED(11, 13959210),
    MISSING_PORT(12, 13959211),
    NOVALID_PORT(13, 13959212),
    MISSING_NAME(14, 13959213),
    MISSING_ADMIN_UID(15, 13959214),
    MISSING_ADMIN_PASSWORD(16, 13959215),
    ERROR_UNEXPECTED(17, 13959216),
    CONFLICTING_ARGS(18, 13893684),
    SERVER_NOT_REGISTERED(19, 13959234);

    private final int returnCode;
    private final int messageId;
    private static boolean initialized;
    private static HashMap<ADSContextException.ErrorType, DsFrameworkCliReturnCode> adsErrorToReturnCode;

    private DsFrameworkCliReturnCode(int returnCode, int messageId) {
        this.returnCode = returnCode;
        this.messageId = messageId;
    }

    public int getMessageId() {
        return this.messageId;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    private static void registerAdsError() {
        adsErrorToReturnCode.put(ADSContextException.ErrorType.MISSING_HOSTNAME, MISSING_HOSTNAME);
        adsErrorToReturnCode.put(ADSContextException.ErrorType.NOVALID_HOSTNAME, NOVALID_HOSTNAME);
        adsErrorToReturnCode.put(ADSContextException.ErrorType.MISSING_IPATH, MISSING_IPATH);
        adsErrorToReturnCode.put(ADSContextException.ErrorType.NOVALID_IPATH, NOVALID_IPATH);
        adsErrorToReturnCode.put(ADSContextException.ErrorType.ACCESS_PERMISSION, ACCESS_PERMISSION);
        adsErrorToReturnCode.put(ADSContextException.ErrorType.ALREADY_REGISTERED, ALREADY_REGISTERED);
        adsErrorToReturnCode.put(ADSContextException.ErrorType.BROKEN_INSTALL, BROKEN_INSTALL);
        adsErrorToReturnCode.put(ADSContextException.ErrorType.UNEXPECTED_ADS_BACKEND_TYPE, BROKEN_INSTALL);
        adsErrorToReturnCode.put(ADSContextException.ErrorType.NOT_YET_REGISTERED, NOT_YET_REGISTERED);
        adsErrorToReturnCode.put(ADSContextException.ErrorType.MISSING_PORT, MISSING_PORT);
        adsErrorToReturnCode.put(ADSContextException.ErrorType.NOVALID_PORT, NOVALID_PORT);
        adsErrorToReturnCode.put(ADSContextException.ErrorType.MISSING_NAME, MISSING_NAME);
        adsErrorToReturnCode.put(ADSContextException.ErrorType.MISSING_ADMIN_UID, MISSING_ADMIN_UID);
        adsErrorToReturnCode.put(ADSContextException.ErrorType.MISSING_ADMIN_PASSWORD, MISSING_ADMIN_PASSWORD);
        adsErrorToReturnCode.put(ADSContextException.ErrorType.ERROR_UNEXPECTED, ERROR_UNEXPECTED);
    }

    public static DsFrameworkCliReturnCode getReturncodeFromAdsError(ADSContextException.ErrorType error) {
        if (!initialized) {
            DsFrameworkCliReturnCode.registerAdsError();
            initialized = true;
        }
        return adsErrorToReturnCode.get(error);
    }

    static {
        initialized = false;
        adsErrorToReturnCode = new HashMap();
    }
}

