/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.opends.server.admin.OperationsException;
import org.opends.server.admin.PropertyIsMandatoryException;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MissingMandatoryPropertiesException
extends OperationsException {
    private static final long serialVersionUID = 6342522125252055588L;
    private final Collection<PropertyIsMandatoryException> causes;

    public MissingMandatoryPropertiesException(Collection<PropertyIsMandatoryException> causes) {
        Validator.ensureNotNull(causes);
        Validator.ensureTrue(!causes.isEmpty());
        this.causes = new ArrayList<PropertyIsMandatoryException>(causes);
    }

    @Override
    public PropertyIsMandatoryException getCause() {
        return this.causes.iterator().next();
    }

    public Collection<PropertyIsMandatoryException> getCauses() {
        return Collections.unmodifiableCollection(this.causes);
    }

    @Override
    public String getMessage() {
        StringBuilder builder = new StringBuilder();
        builder.append("The following properties are mandatory: ");
        boolean isFirst = true;
        for (PropertyIsMandatoryException e : this.causes) {
            if (!isFirst) {
                builder.append(", ");
            }
            builder.append(e.getPropertyDefinition().getName());
            isFirst = false;
        }
        return builder.toString();
    }
}

